#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>

#include <linux/hdreg.h>

#define DISK_STRING "/dev/hd"

char * disk_type(unsigned char type)
{
	switch (type) {
		case 1: return "12-bit DOS";
		case 4:	return "16-bit DOS (<32M)";
		case 5: return "extended partition (don't use)";
		case 6: return "16-bit DOS (>=32M)";
		case 0x81: return "minix";
	}
	return NULL;
}

void fdisk(int disk_nr, int minor)
{
	char name[100], * type;
	char buffer[1024];
	struct partition * p;
	int fd;
	int i;

	sprintf(name,"%s%d",DISK_STRING,minor);
	if ((fd=open(name,O_RDONLY)) < 0) {
		fprintf(stderr,"Unable to open %s\n",name);
		exit(1);
	}
	if (1024 != read(fd,buffer,1024))
		return;
	p = (struct partition *) (buffer + 0x1be);
	for (i=0 ; i<4 ; p++,i++) {
		if (!p->nr_sects)
			continue;
		printf("%s%d: %6d blocks",DISK_STRING,minor+1+i,p->nr_sects>>1);
		if (p->boot_ind == 0x80)
			printf(" active");
		else if (p->boot_ind)
			printf(" active? (%02x) ",p->boot_ind);
		if (type = disk_type(p->sys_ind))
			printf(" %s\n",type);
		else
			printf(" unknown partition type 0x%02X\n",p->sys_ind);
	}
}
		

int main(int argc, char ** argv)
{
	fdisk(1,0);
	fdisk(2,5);
	return 0;
}
