/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Naoki Iwakami (NTT)                                                     */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Naoki Iwakami (NTT) on 1997-08-25,                                      */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/

/* 25-aug-97   NI   added parameters for bandwidth control */

#include "ntt_conf.h"

void ntt_cp_mdtbl(ntt_MODE_TABLE ltbl)
{
    ntt_SAMPF         = ltbl.sampf;
    ntt_N_FR          = ltbl.n_fr;
    ntt_BAND_EXP      = ltbl.band_exp;
    ntt_N_SHRT        = ltbl.n_shrt;
    ntt_N_MID         = ltbl.n_mid;
    ntt_GAIN_BITS     = ltbl.gain_bits;
    ntt_AMP_MAX       = ltbl.amp_max;
    ntt_SUB_GAIN_BITS = ltbl.sub_gain_bits;
    ntt_SUB_AMP_MAX   = ltbl.sub_amp_max;
    ntt_MU            = ltbl.mu;
    ntt_N_PR          = ltbl.n_pr;
    ntt_LSPCODEBOOK   = ltbl.lspcodebook;
    ntt_LSP_BIT0      = ltbl.lsp_bit0;
    ntt_LSP_BIT1      = ltbl.lsp_bit1;
    ntt_LSP_BIT2      = ltbl.lsp_bit2;
    ntt_LSP_SPLIT     = ltbl.lsp_split;
    ntt_FW_CB_NAME    = ltbl.fw_cb_name;
    ntt_FW_CB_NAME_S  = ltbl.fw_cb_name_s;
    ntt_FW_CB_NAME_M  = ltbl.fw_cb_name_m;
    ntt_FW_N_DIV      = ltbl.fw_n_div;
    ntt_FW_N_DIV_S    = ltbl.fw_n_div_s;
    ntt_FW_N_DIV_M    = ltbl.fw_n_div_m;
    ntt_FW_N_BIT      = ltbl.fw_n_bit;
    ntt_FW_N_BIT_S    = ltbl.fw_n_bit_s;
    ntt_FW_N_BIT_M    = ltbl.fw_n_bit_m;
    ntt_PIT_CB_NAME   = ltbl.pit_cb_name;
    ntt_BASF_BIT      = ltbl.basf_bit;
    ntt_N_CAN_P       = ltbl.n_can_p;
    ntt_PIT_N_BIT     = ltbl.pit_n_bit;
    ntt_PIT_CB_LEN    = ltbl.pit_cb_len;
    ntt_PGAIN_BIT     = ltbl.pgain_bit;
    ntt_PGAIN_MU      = ltbl.pgain_mu;
    ntt_CB_NAME0      = ltbl.cb_name0;
    ntt_CB_NAME1      = ltbl.cb_name1;
    ntt_CB_NAME0s      = ltbl.cb_name0s;
    ntt_CB_NAME1s      = ltbl.cb_name1s;
    ntt_CB_NAME0m      = ltbl.cb_name0m;
    ntt_CB_NAME1m      = ltbl.cb_name1m;
    ntt_N_CAN         = ltbl.n_can;
    ntt_N_CAN_S       = ltbl.n_can_s;
    ntt_N_CAN_M       = ltbl.n_can_m;
    ntt_BLIM_BITS_H   = ltbl.blim_bits_h;
    ntt_BLIM_BITS_L   = ltbl.blim_bits_l;
    ntt_CUT_M_H       = ltbl.cut_m_h;
    ntt_CUT_M_L       = ltbl.cut_m_l;
    ntt_BAND_UPPER    = ltbl.band_upper;
}
