/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  p_dictionary.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifndef P_DICTIONARY_H
#define P_DICTIONARY_H

#include <LEDA/pers_tree.h>


typedef NODE* p_dic_item;


#define PERS_DIC(keytype,inftype) name3(keytype,inftype,PERS_DIC)

#define p_dictionary(keytype,inftype) name3(keytype,inftype,p_dictionary)

#define p_dictionarydeclare2(keytype,inftype)\
\
struct PERS_DIC(keytype,inftype): public pers_rb_tree{\
\
keytype name2(keytype,X1);\
inftype name2(inftype,X2);\
\
void copy_key(GenPtr& x)   { x=Copy(ACCESS1(keytype,x)); }\
void copy_inf(GenPtr& x)   { x=Copy(ACCESS2(inftype,x)); }\
void clear_key(GenPtr& x)  { Clear(ACCESS1(keytype,x)); }\
void clear_inf(GenPtr& x)  { Clear(ACCESS2(inftype,x)); }\
void print_key(GenPtr& x)  { Print(ACCESS1(keytype,x)); }\
void print_inf(GenPtr& x)  { Print(ACCESS2(inftype,x),cout); }\
\
int  cmp_keys(GenPtr x, GenPtr y)\
             { return compare(ACCESS1(keytype,x), ACCESS1(keytype,y)); }\
\
version V;\
int count;\
\
public:\
\
 PERS_DIC(keytype,inftype)() { init_tree(); V = v_list->vl.first(); count=1;}\
 PERS_DIC(keytype,inftype)(V_LIST* vl,version v) { v_list=vl; V=v; count=1;}\
 void CLEAR() { if (--v_list->count==0) del_tree(); }\
~PERS_DIC(keytype,inftype)() { CLEAR(); }\
\
PERS_DIC(keytype,inftype)(const PERS_DIC(keytype,inftype)& D)\
{ v_list = D.v_list; v_list->count++; V = D.V; count = D.count; }\
\
PERS_DIC(keytype,inftype)& operator=(PERS_DIC(keytype,inftype)& D)\
{ CLEAR(); v_list = D.v_list; v_list->count++; V = D.V; count = D.count;\
  return *this; }\
\
keytype  key(NODE* p) { return ACCESS1(keytype,pers_rb_tree::key(p)); }\
inftype inf(NODE* p)  { return ACCESS2(inftype,pers_rb_tree::inf(p)); }\
\
NODE* locate(keytype k) { return pers_rb_tree::locate(Convert(k),V); }\
NODE* locate_pred(keytype k) { return pers_rb_tree::locate_pred(Convert(k),V); }\
NODE* lookup(keytype k) { return pers_rb_tree::lookup(Convert(k),V); }\
\
PERS_DIC(keytype,inftype)  insert(keytype k, inftype i)\
{ return PERS_DIC(keytype,inftype)(v_list,pers_rb_tree::insert(Convert(k),Convert(i),V)); }\
\
PERS_DIC(keytype,inftype)  del(keytype k)\
{ return PERS_DIC(keytype,inftype)(v_list,pers_rb_tree::del(Convert(k),V)); }\
\
PERS_DIC(keytype,inftype)  change_inf(NODE* p, inftype i)\
{ return PERS_DIC(keytype,inftype)(v_list,pers_rb_tree::change_inf(p,Convert(i),V)); }\
\
NODE* min()          { return pers_rb_tree::min(V); }\
NODE* max()          { return pers_rb_tree::max(V); }\
NODE* succ(NODE* p)  { return pers_rb_tree::succ(p,V); }\
NODE* pred(NODE* p)  { return pers_rb_tree::pred(p,V); }\
int   size()         { return pers_rb_tree::size(V); }\
void  print()        { pers_rb_tree::print(V); }\
void  draw(DRAW_NODE_FCT f, DRAW_EDGE_FCT g, double x0, double x1, double y, double dy)  { pers_rb_tree::draw(f,g,V,x0,x1,y,dy); }\
double get_version() { return ver_num(V); }\
\
};\
\
class p_dictionary(keytype,inftype) : public LEDA_SIMPLE{\
\
/*PERS_DIC(keytype,inftype)* ptr;*/\
\
PERS_DIC(keytype,inftype)* ptr() const\
                                 { return (PERS_DIC(keytype,inftype)*) PTR; }\
public:\
\
p_dictionary(keytype,inftype)()      { PTR = new PERS_DIC(keytype,inftype); }\
p_dictionary(keytype,inftype)(PERS_DIC(keytype,inftype)* p)\
{ PTR = (PERS_DIC(keytype,inftype)*)p; }\
\
void clear() { if (--(ptr()->count) == 0) delete ptr(); }\
\
~p_dictionary(keytype,inftype)()     { clear(); }\
\
\
p_dictionary(keytype,inftype)(p_dictionary(keytype,inftype)& p)\
{ PTR = p.ptr(); ptr()->count++; }\
\
p_dictionary(keytype,inftype)& operator=(const p_dictionary(keytype,inftype)& p)\
{ p.ptr()->count++;\
  if (--ptr()->count == 0)  delete ptr();\
  PTR = p.ptr();\
  return *this;\
}\
\
keytype  key(NODE* p)     { return ptr()->key(p); }\
inftype inf(NODE* p)     { return ptr()->inf(p); }\
\
NODE* locate(keytype k)      { return ptr()->locate(k); }\
NODE* locate_pred(keytype k) { return ptr()->locate_pred(k); }\
NODE* lookup(keytype k)      { return ptr()->lookup(k); }\
\
p_dictionary(keytype,inftype) insert(keytype k, inftype i)\
{ return new PERS_DIC(keytype,inftype)(ptr()->insert(k,i)); }\
\
p_dictionary(keytype,inftype) del(keytype k)\
{ return new PERS_DIC(keytype,inftype)(ptr()->del(k)); }\
\
p_dictionary(keytype,inftype) change_inf(NODE* p, inftype i)\
{ return new PERS_DIC(keytype,inftype)(ptr()->change_inf(p,i)); }\
\
int ref() { return ptr()->count; }\
\
NODE* min()         { return ptr()->min();     }\
NODE* max()         { return ptr()->max();     }\
\
NODE* succ(NODE* p)   { return ptr()->succ(p);   }\
NODE* succ(keytype k) { return locate(k); }\
NODE* pred(NODE* p)   { return ptr()->pred(p);   }\
NODE* pred(keytype k) { return locate_pred(k); }\
\
NODE* first_item()       { return ptr()->min();     }\
NODE* next_item(NODE* p) { return ptr()->succ(p);   }\
\
int   size()        { return ptr()->size();    }\
int   empty()       { return ptr()->size()==0; }\
\
void  print()       { ptr()->print(); }\
void  draw(DRAW_NODE_FCT f, DRAW_EDGE_FCT g, double x0, double x1, double y, double dy)  { ptr()->draw(f,g,x0,x1,y,dy); }\
\
friend p_dictionary(keytype,inftype)&  Access(const p_dictionary(keytype,inftype)&, const GenPtr& p) { return *(p_dictionary(keytype,inftype)*)&p; }\
friend GenPtr Copy(const p_dictionary(keytype,inftype)& D) { D.ptr()->count++;\
                                                             return D.PTR; }\
friend void Clear(p_dictionary(keytype,inftype)& D)      { D.clear(); }\
friend void Print(const p_dictionary(keytype,inftype)&, ostream& = cout) {}\
friend void Read(const p_dictionary(keytype,inftype)&, istream& = cin)   {}\
}; 

#endif
