#ifndef DLUDECOMP_H
#define DLUDECOMP_H
#pragma once 

/*
 *	Declarations for double precision LU Decomposition
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)DLUDecomp.h	2.2	9/18/89
 */

#include "DGEMatrix.h"

class DLUDecomp : DGEMatrix {
  fortran_int*		ipvt;	// Pivot indices
  fortran_int		info;
  fortran_int		the_order;

  DGEMatrix		copy()	{return DGEMatrix::copy();}
  double*		data()	{return DGEMatrix::data();}
protected:
  void			assertDefined();
  void			assertPivots();
  void			assertOrder(const DoubleVec& rhs);
public:
  DLUDecomp(const DGEMatrix&);
  ~DLUDecomp()	{delete ipvt;}

  unsigned			order() {return (unsigned)the_order;}

  // Matrix algebra declarations:
  friend double			determinant(const DLUDecomp&);
  friend DGEMatrix		inverse(const DLUDecomp&);
  friend DoubleVec		solve(const DLUDecomp&, const DoubleVec&);
};

#endif DLUDECOMP_H
