#ifndef RCOMPLEX_H
#define RCOMPLEX_H
#pragma once

/*
 *	Complex
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)RComplex.h	2.2	9/26/89
 */

/* Because there are so many variations of "Complex" types, this 
 * header file attempts to standardize what the other routines see.
 */

#include "vdefs.h"

#if NEEDS_OVERLOAD
overload	conj;
overload	real;
overload	imag;
overload	norm;
overload	arg;
#endif

#if defined(__GNUG__) || defined(__ATT__)
//	Define true if sizeof(Complex)==2*sizeof(double)
#define COMPLEX_PACKS 1
#endif

// Figure out which header file to use
#ifdef __GNUG__

#include <Complex.h>

#else

#ifdef __ATT2__
// The V2.0 version will work
#include <complex.h>
#else
// Use the modified local copy:
#include "complex.h"
#endif

#endif


#ifdef __GNUG__

// The GNU library uses a capital "C", and passes by
// reference.
#define DComplex Complex
typedef DComplex (*CmathFunTy)(const DComplex&);
typedef double (*CmathFunTy2)(const DComplex&);

#else

// The AT&T version uses a small "c", and passes by
// value, EXCEPT for real and imag!  why?!
#define DComplex complex
typedef DComplex (*CmathFunTy)(DComplex);
typedef double (*CmathFunTy2)(DComplex);

#endif

#ifdef __ATT1__
static /* cfront bug requires this */
#else
inline
#endif
double ABSOLUTE(DComplex& a) {return hypot(real(a), imag(a));}

#endif
