/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.math.BigDecimal;
import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Cast
extends Function {
    private Expression expr;
    private int currentType;

    public F_Cast(Expression exp, int curType, String newTypeName) {
        this.expr = exp;
        this.currentType = curType;
        this.returnType = this.getTypeBySQLName(newTypeName);
    }

    public F_Cast(Expression exp, int curType, int newType) {
        this.expr = exp;
        this.returnType = newType;
        this.currentType = curType;
    }

    public Object evaluate(Tuple t) {
        Object value = this.expr.evaluate(t);
        if (value != null) {
            return F_Cast.changeType(value, this.currentType, this.returnType);
        }
        return null;
    }

    public static Object changeType(Object value, int currentType, int returnType) {
        if (currentType == returnType) {
            return value;
        }
        try {
            if (currentType == 0) {
                currentType = F_Cast.findType(value);
            }
            if (returnType == Attribute.TYPE_INT) {
                if (value instanceof Integer) {
                    return value;
                }
                value = value instanceof Number ? new Integer(((Number)value).intValue()) : new Integer(Integer.parseInt(value.toString()));
            } else if (returnType == Attribute.TYPE_STRING) {
                value = value.toString();
            } else if (returnType == Attribute.TYPE_DOUBLE) {
                value = value instanceof Number ? new Double(((Number)value).doubleValue()) : new Double(Double.parseDouble(value.toString()));
            } else if (returnType == Attribute.TYPE_DECIMAL) {
                if (currentType == Attribute.TYPE_DOUBLE) {
                    value = new BigDecimal((Double)value);
                } else if (currentType == Attribute.TYPE_INT) {
                    value = new BigDecimal((Integer)value);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public static int findType(Object value) {
        return -1;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_STRING, Attribute.TYPE_INT, Attribute.TYPE_STRING};
    }

    public static String getFunctionName() {
        return "CAST";
    }

    public String toString(Relation relation) {
        return "CAST(" + this.expr.toString(relation) + " AS " + Attribute.getTypeName(this.returnType) + ")";
    }

    public int getTypeBySQLName(String SQLName) {
        String st = SQLName.toUpperCase();
        if (st.indexOf("VARCHAR") >= 0) {
            return Attribute.TYPE_STRING;
        }
        if (st.indexOf("CHAR") >= 0) {
            return Attribute.TYPE_STRING;
        }
        if (st.indexOf("INT") >= 0) {
            return Attribute.TYPE_INT;
        }
        if (st.indexOf("FLOAT") >= 0 || st.indexOf("REAL") >= 0) {
            return Attribute.TYPE_FLOAT;
        }
        if (st.indexOf("DOUBLE") >= 0) {
            return Attribute.TYPE_DOUBLE;
        }
        if (st.indexOf("DATE") >= 0) {
            return Attribute.TYPE_DATE;
        }
        if (st.indexOf("TIMESTAMP") >= 0) {
            return Attribute.TYPE_TIMESTAMP;
        }
        if (st.indexOf("TIME") >= 0) {
            return Attribute.TYPE_TIME;
        }
        return -1;
    }
}

