/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.util.ArrayList;
import java.util.Stack;
import unity.jdbc.UnityDriver;
import unity.query.LQNode;

public class MemoryManager {
    public static long getFreeMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.freeMemory();
    }

    public static long getTotalMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory();
    }

    public static long getMaxMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.maxMemory();
    }

    public static long getQueryMemory() {
        long freeMem = MemoryManager.getFreeMemory();
        if (UnityDriver.DEBUG) {
            System.out.println("Memory free in system: " + freeMem);
        }
        return (long)(0.5 * (double)freeMem);
    }

    public static void allocateQueryMemory(LQNode root, ArrayList localQueryRootNodes) {
        long memAvail = MemoryManager.getQueryMemory();
        if (UnityDriver.DEBUG) {
            System.out.println("Memory allocated to query: " + memAvail);
        }
        double FUDGE_FACTOR = 1.2;
        ArrayList<LQNode> joinNodes = new ArrayList<LQNode>();
        Stack<LQNode> opStack = new Stack<LQNode>();
        opStack.push(root);
        while (!opStack.empty()) {
            LQNode curNode = (LQNode)opStack.pop();
            if (localQueryRootNodes.contains(root)) continue;
            if (curNode.getType() == 207) {
                joinNodes.add(curNode);
            }
            int tupleSize = curNode.tupleSize();
            int numTuples = curNode.numTuples();
            long requestedMemorySize = (long)((double)(tupleSize * numTuples) * FUDGE_FACTOR);
            if (curNode.getType() == 4) {
                long memAllocated = (long)((double)memAvail * 0.2);
                if (requestedMemorySize < memAllocated) {
                    memAllocated = requestedMemorySize;
                    numTuples = (int)((double)numTuples * FUDGE_FACTOR);
                } else {
                    numTuples = (int)(memAllocated / (long)tupleSize);
                    if (numTuples < 1000) {
                        numTuples = 1000;
                    }
                }
                curNode.setMemorySizeTuples(numTuples);
                memAvail -= memAllocated;
            }
            int i = 0;
            while (i < curNode.getNumChildren()) {
                opStack.push(curNode.getChild(i));
                ++i;
            }
        }
        if (joinNodes.size() == 0) {
            return;
        }
        long memPerJoin = memAvail / (long)joinNodes.size();
        int i = 0;
        while (i < joinNodes.size()) {
            int numTuples;
            LQNode n = (LQNode)joinNodes.get(i);
            int tupleSize = n.getChild(0).tupleSize();
            long requestedMemorySize = (long)((double)(tupleSize * (numTuples = n.getChild(0).numTuples())) * FUDGE_FACTOR);
            if (requestedMemorySize > memPerJoin) {
                numTuples = (int)(memPerJoin / (long)tupleSize);
                if (numTuples < 1000) {
                    numTuples = 1000;
                }
            } else {
                numTuples = (int)((double)numTuples * FUDGE_FACTOR);
            }
            if (UnityDriver.DEBUG) {
                System.out.println("Join size in tuples: " + numTuples);
            }
            n.setMemorySizeTuples(numTuples);
            ++i;
        }
    }
}

