/*
 * Decompiled with CFR 0.152.
 */
package cc.gammasoft.date;

import cc.gammasoft.date.DateLabel;
import cc.gammasoft.date.DateModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DatePanel
extends JComponent
implements ChangeListener {
    private JPanel panelMain;
    private DateModel dateModel;
    private static final int PANEL_SIZE = 42;
    private Calendar[] values = new Calendar[42];
    private ArrayList calendarLabels = new ArrayList();
    private int selectionDrawType = 1;
    private Color highLightColor = Color.DARK_GRAY;

    DatePanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.panelMain = new JPanel();
        this.panelMain.setLayout(new GridLayout(6, 7));
        int i = 0;
        while (i < 42) {
            DateLabel label = new DateLabel();
            this.calendarLabels.add(label);
            this.panelMain.add(label);
            label.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent event) {
                    Calendar calendar = DatePanel.this.values[DatePanel.this.calendarLabels.indexOf(event.getSource())];
                    DatePanel.this.dateModel.setValue(calendar.get(1), calendar.get(2), calendar.get(5));
                }
            });
            ++i;
        }
        this.add(this.panelMain);
        this.panelMain.setBackground(Color.WHITE);
    }

    public void stateChanged(ChangeEvent e) {
        this.setView(this.dateModel.getValue());
    }

    public void setView(Calendar calendar) {
        Object newCalendar = null;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        int month = calendar.get(2);
        if (calendar.getMinimalDaysInFirstWeek() == 1) {
            calendar.set(4, 1);
        } else {
            calendar.set(4, 0);
        }
        calendar.set(7, calendar.getFirstDayOfWeek());
        int i = 0;
        while (i < 42) {
            DateLabel label = (DateLabel)this.calendarLabels.get(i);
            label.setValue(calendar);
            label.setDateSelectionShape(this.selectionDrawType);
            label.setHightLightColor(this.highLightColor);
            this.values[i] = (Calendar)calendar.clone();
            if (calendar.get(2) == month) {
                label.setCurrentMonthValue(true);
            } else {
                label.setCurrentMonthValue(false);
            }
            if (this.dateModel.getSelectedValues().size() != 0) {
                if (this.dateModel.getSelectedValues().contains(calendar)) {
                    label.setSelectedValue(true);
                } else {
                    label.setSelectedValue(false);
                }
            } else {
                label.setSelectedValue(false);
            }
            if (this.dateModel.getValue() != null && calendar.get(1) == this.dateModel.getValue().get(1) && calendar.get(2) == this.dateModel.getValue().get(2) && calendar.get(5) == this.dateModel.getValue().get(5)) {
                label.setCurrentValue(true);
            } else {
                label.setCurrentValue(false);
            }
            calendar.add(5, 1);
            ++i;
        }
        this.revalidate();
        this.repaint();
    }

    public void setDateModel(DateModel dateModel) {
        if (this.dateModel != null) {
            this.dateModel.removeChangeListener(this);
        }
        this.dateModel = dateModel;
        this.dateModel.addChangeListener(this);
    }

    public DateModel getDateModel() {
        return this.dateModel;
    }

    public ArrayList getCalendarLabels() {
        return this.calendarLabels;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setCurrentMonthFont(font);
        this.setPreviousNextMonthFont(font);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.setCurrentMonthForeground(c);
        this.setPreviousNextMonthForeground(c);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.setCurrentMonthBackground(c);
        this.setPreviousNextMonthBackground(c);
    }

    public void setCurrentMonthForeground(Color c) {
        Iterator it = this.calendarLabels.iterator();
        while (it.hasNext()) {
            DateLabel label = (DateLabel)it.next();
            label.setCurrentMonthForeground(c);
        }
        this.setView(this.dateModel.getValue());
    }

    public void setCurrentMonthBackground(Color c) {
        Iterator it = this.calendarLabels.iterator();
        while (it.hasNext()) {
            DateLabel label = (DateLabel)it.next();
            label.setCurrentMonthBackground(c);
        }
        this.setView(this.dateModel.getValue());
    }

    public void setCurrentMonthFont(Font f) {
        Iterator it = this.calendarLabels.iterator();
        while (it.hasNext()) {
            DateLabel label = (DateLabel)it.next();
            label.setCurrentMonthFont(f);
        }
        this.setView(this.dateModel.getValue());
    }

    public void setCurrentMonthBorder(Border b) {
        Iterator it = this.calendarLabels.iterator();
        while (it.hasNext()) {
            DateLabel label = (DateLabel)it.next();
            label.setCurrentMonthBorder(b);
        }
        this.setView(this.dateModel.getValue());
    }

    public void setPreviousNextMonthForeground(Color c) {
        Iterator it = this.calendarLabels.iterator();
        while (it.hasNext()) {
            DateLabel label = (DateLabel)it.next();
            label.setPreviousNextMonthForeground(c);
        }
        this.setView(this.dateModel.getValue());
    }

    public void setPreviousNextMonthBackground(Color c) {
        Iterator it = this.calendarLabels.iterator();
        while (it.hasNext()) {
            DateLabel label = (DateLabel)it.next();
            label.setPreviousNextMonthBackground(c);
        }
        this.setView(this.dateModel.getValue());
    }

    public void setPreviousNextMonthFont(Font f) {
        Iterator it = this.calendarLabels.iterator();
        while (it.hasNext()) {
            DateLabel label = (DateLabel)it.next();
            label.setPreviousNextMonthFont(f);
        }
        this.setView(this.dateModel.getValue());
    }

    public void setPreviousNextMonthBorder(Border b) {
        Iterator it = this.calendarLabels.iterator();
        while (it.hasNext()) {
            DateLabel label = (DateLabel)it.next();
            label.setPreviousNextMonthBorder(b);
        }
        this.setView(this.dateModel.getValue());
    }

    public void setDateSelectionShape(int type) {
        this.selectionDrawType = type;
        this.setView(this.dateModel.getValue());
    }

    public void setHightLightColor(Color color) {
        this.highLightColor = color;
        this.setView(this.dateModel.getValue());
    }
}

