#include "specsupport.h"
#include "specsupport.moc"
#include "kdevproject.h"
#include "kdevmakefrontend.h"
#include "distpart_widget.h"

#include <kdebug.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <qfile.h>
#include <qdir.h>
#include <qerrormessage.h>
#include <qregexp.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qgroupbox.h>
#include <qtabwidget.h>
#include <qmessagebox.h>

SpecSupport::SpecSupport(DistpartPart * part) : packageBase(part,"Rpm") {

    m_part = part;

    srcPackagePushButton = new QPushButton(i18n("Src Package"),area());
    buildAllPushButton = new QPushButton(i18n("Src/Binary Packages"),area());
    exportSPECPushButton = new QPushButton(i18n("Export SPEC File"),area());
    importSPECPushButton = new QPushButton(i18n("Import SPEC File"),area());



    connect(buildAllPushButton, SIGNAL(clicked()),
            this, SLOT(slotbuildAllPushButtonPressed()));
    connect(exportSPECPushButton, SIGNAL(clicked()),
            this, SLOT(slotexportSPECPushButtonPressed()));
    connect(importSPECPushButton, SIGNAL(clicked()),
            this, SLOT(slotimportSPECPushButtonPressed()));
    connect(srcPackagePushButton, SIGNAL(clicked()),
            this, SLOT(slotsrcPackagePushButtonPressed()));

    parseDotRpmmacros();
}

SpecSupport::~SpecSupport() {
}

//    QPushButton* buildAllPushButton;
void SpecSupport::slotbuildAllPushButtonPressed() {
    QMap<QString,QString>::Iterator it;
    QFile file1(dir + "/" + getAppSource());
    QFile file2(*(map.find("_sourcedir")) + "/" + getAppSource());
    if (!file2.exists()) {
	if (!file1.exists()) {
	    QMessageBox::critical(this,i18n("Error"),i18n("You need to create a source archive first!"));
	    return;
	}
	else
	    m_part->makeFrontend()->queueCommand(dir,"cd " + dir + " && cp " + getAppSource() + " " + *(map.find("_sourcedir")));
    }
    m_part->makeFrontend()->queueCommand(dir,"cd " + (((it = map.find("_specdir")) != map.end()) ? (*it) : dir) + " && rpmbuild -ba " + m_part->project()->projectName() + ".spec");
}

//    QPushButton* exportSPECPushButton;
void SpecSupport::slotexportSPECPushButtonPressed() {
    QMap<QString,QString>::Iterator it;
    QString specname = ((it = map.find("_specdir")) != map.end()) ? (*it) : (m_part->project()->projectDirectory());
    specname += ("/" + m_part->project()->projectName() + ".spec");
    QFile file(specname);

    if(file.open(IO_WriteOnly)) {
        QTextStream stream(&file);

        stream << "# This spec file was generated by Gideon" << "\n"
        << "# Please report any problem to KDevelop Team <kdevelop-devel@kdevelop.org>" << "\n"
        << "# Thanks to Matthias Saou for his explanations on http://freshrpms.net/docs/fight.html\n\n";

        stream << "Name: " << getAppName() << "\n";
        stream << "Version: " << getAppVersion() << "\n";
        stream << "Release: " << getAppRevision() << "\n";
        stream << "Vendor: " << getAppVendor() << "\n";
        stream << "Copyright: " << getAppLicense() << "\n";
        stream << "Summary: " << getAppSummary() << "\n";
        stream << "Group: " << getAppGroup() << "\n";
        stream << "Packager: " << getAppPackager() << "\n";
        stream << "BuildRoot: " << "%{_tmppath}/%{name}-root" << "\n";
        stream << "Source: " << getAppSource() << "\n";

        stream << "\n";
        stream << "%description\n";
        stream << getAppDescription()<< "\n";

        stream << "\n";
        stream << "%prep\n";
        stream << "%setup\n";
        stream << "CFLAGS=\"$RPM_OPT_FLAGS\" CXXFLAGS=\"$RPM_OPT_FLAGS\" ./configure \\" << "\n";
        stream << "--target=" << getAppArch() << "\n";

        stream << "\n";
        stream << "%build\n";
        stream << "%configure\n";
        stream << "make\n";

        stream << "\n";
        stream << "%install\n";
        stream << "rm -rf %{buildroot}\n";
        stream << "%makeinstall\n";

        stream << "\n";
        stream << "%clean\n";
        stream << "rm -rf %{buildroot}\n";

        stream << "\n";
        stream << "%post -p /sbin/ldconfig\n";

        stream << "%postun -p /sbin/ldconfig\n";

        stream << "%files\n";
        stream << "%defattr(-, root, root)\n";
        stream << "%doc AUTHORS COPYING ChangeLog NEWS README TODO\n";
        stream << "%{_bindir}/*\n";
        stream << "%{_libdir}/*.so.*\n";
        stream << "%{_datadir}/%{name}\n";
        stream << "%{_mandir}/man8/*\n";

        stream << "%changelog\n";
        stream << getAppChangelog() << "\n";


        file.close();
    } else {
        kdDebug() << "TODO : intercept write error in SpecSupport::slotexportSPECPushButtonPressed()";
    }
}

bool SpecSupport::getInfo(QString s, QString motif, void (packageBase::*func)(QString)) {
    QRegExp re(motif + "[ \t]*([^ \t].*[^ \t])[ \t]*");
    if (re.exactMatch(s)) {
        (this->*func)(re.cap(1));
        return true;
    } else return false;
}

//    QPushButton* importSPECPushButton;
void SpecSupport::slotimportSPECPushButtonPressed() {
    QFile file(KFileDialog::getOpenFileName(dir,"*.spec"));
    if(file.open(IO_ReadOnly)) {
        QTextStream stream(&file);

        while (!stream.atEnd()) {
            QString s = stream.readLine();
            if (getInfo(s,"Name:",&SpecSupport::setAppName));
            else if (getInfo(s,"Version:",&SpecSupport::setAppVersion));
            else if (getInfo(s,"Release:",&SpecSupport::setAppRevision));
            else if (getInfo(s,"Vendor:",&SpecSupport::setAppVendor));
            else if (getInfo(s,"Copyright:",&SpecSupport::setAppLicense));
            else if (getInfo(s,"Summary:",&SpecSupport::setAppSummary));
            else if (getInfo(s,"Group:",&SpecSupport::setAppGroup));
            else if (getInfo(s,"Packager:",&SpecSupport::setAppPackager));
            else if (s.startsWith("%description")) {
                QString desc;
                while (!stream.atEnd()) {
                    QString str = stream.readLine();
                    if (str.startsWith("%")) break;
                    else desc += str + "\n";
                }
                setAppDescription(desc);
            }
	    else if (s.startsWith("%changelog")) {
		QString change;
		while (!stream.atEnd()) {
		    QString str = stream.readLine();
		    if (str.startsWith("%")) break;
                    else change += str + "\n";
                }
		setAppChangelog(change);
            }
        }
    }
}

//    QPushButton* srcPackagePushButton;
void SpecSupport::slotsrcPackagePushButtonPressed() {
    QMap<QString,QString>::Iterator it;

    QFile file1(dir + "/" + getAppSource());
    QFile file2(*(map.find("_sourcedir")) + "/" + getAppSource());
    if (!file2.exists()) {
	if (!file1.exists()) {
	    QMessageBox::critical(this,i18n("Error"),i18n("You need to create a source archive first!"));
	    return;
	}
	else
	    m_part->makeFrontend()->queueCommand(dir,"cd " + dir + " && cp " + getAppSource() + " " + *(map.find("_sourcedir")));
    }
    m_part->makeFrontend()->queueCommand(dir,"cd " + (((it = map.find("_specdir")) != map.end()) ? (*it) : dir) + " && rpmbuild -bs " + m_part->project()->projectName() + ".spec");
}

void SpecSupport::parseDotRpmmacros() {
    QFile dotfile(QDir::homeDirPath() + "/.rpmmacros");

    if (!dotfile.open(IO_ReadOnly)) {
//        QErrorMessage * msg = new QErrorMessage(this);
//        msg->message("It seems you don't have a ~/.rpmmacros\nYou may experience problems building packages.\n");
//        msg->exec();
        return;
    }
    QTextStream stream(&dotfile);

    // Perhaps will it appear as a necessity to parse the global rpm config file?

    // Pre defined macros :
    map.insert("name",getAppName());

    // .rpmmacros parsing :
    while (!stream.atEnd()) {
        QString s = stream.readLine();
        QRegExp re("%([^ \t]*)[ \t][ \t]*([^\t]*)$");
        if(re.exactMatch(s)) {
            QRegExp subst("%\\{([^%]*)\\}");
            QString value = re.cap(2).stripWhiteSpace();

            while(subst.search(value) != -1) {
                value.replace(QRegExp("%\\{"+subst.cap(1)+"\\}"),*map.find(subst.cap(1)));
            }
            map.insert(re.cap(1),value);
        }
    }
    dotfile.close();

    // create directories if necessary :
    createRpmDirectoryFromMacro("_topdir");
    createRpmDirectoryFromMacro("_tmppath");
    createRpmDirectoryFromMacro("_builddir");
    createRpmDirectoryFromMacro("_rpmdir");
    createRpmDirectoryFromMacro("_sourcedir");
    createRpmDirectoryFromMacro("_specdir");
    createRpmDirectoryFromMacro("_srcrpmdir");
}

bool SpecSupport::createRpmDirectoryFromMacro(const QString & name) {
    QMap<QString,QString>::Iterator it;
    if((it = map.find(name)) != map.end()) {
        QDir dir(*it);
        if (!dir.exists()) return dir.mkdir(*it);
    }
    return false;
}
