DEFINITION MODULE VDIControls;


(*  Megamax-Modula 2 GEM-Library :  Die VDI Kontrollfunktionen
 *
 *  Autor: Manuel Chakravarty           Erstellt :  29.10.87
 *
 *  Version   2.2     V#0015
 *)
 
FROM    SYSTEM   IMPORT WORD;

FROM    GrafBase IMPORT Rectangle;
 
FROM    GEMEnv   IMPORT DeviceHandle;
 
 
PROCEDURE ClearWorkstation (handle: DeviceHandle);

        (*  Lscht den Arbeitsbereich oder lst zum Beispiel bei Druckern
         *  einen Seitenvorschub aus.
         *)
                
PROCEDURE UpdateWorkstation (handle: DeviceHandle);

        (*  Ist fr Bildschirmarbeitsstationen irrelevant, bei Arbeits-
         *  stationen, die die Ausgaben erst puffern (z.B.: Drucker)
         *  werden durch diesem Aufruf alle gepufferten Aktionen ausge-
         *  fhrt.
         *)

PROCEDURE LoadFonts (    handle: DeviceHandle;
                         select: WORD;
                     VAR loaded: CARDINAL);

        (*  Damit knnen gem der Datei 'ASSIGN.SYS' (gehrt zum optionalen
         *  GDOS) zustzliche Zeichenstze geladen werden.
         *  'loaded' gibt an, wieviele Zeichenstze nachgeladen wurden.
         *  'select' wird bisher nicht untersttzt.
         *  Im DEMO-Modul "TextDemo" finden Sie ein Beispiel, wie
         *  diese GDOS-Fonts benutzt werden.
         *)

PROCEDURE UnloadFonts (handle: DeviceHandle; select: WORD);

        (*  Die mit 'LoadFonts' nachgeladenen Zeichenstze werden
         *  wieder aus dem Speicher entfernt. Die Zeichenstze werden
         *  allerdings erst aus dem Speicher gelscht, nachdem sie
         *  von allen Arbeitsstationen freigegeben wurden.
         *)

PROCEDURE SetClipping (handle: DeviceHandle; frame: Rectangle);

        (*  Mit dieser Procedur kann man erreichen, da alle Ausgaben
         *  auerhalb eines bestimmten Rechteckbereichs ('frame') unter-
         *  drckt werden.
         *  Dabei ist zu beachten, da dies bei den Rasterkopierroutinen
         *  nur fr Speicherbereiche funktioniert, deren Startadresse mit
         *  'NIL' besetzt wurde. (siehe auch 'GEMRasters')
         *)
        
PROCEDURE DisableClipping (handle: DeviceHandle);

        (*  Hiernach werden alle Ausgaben wieder vollstndig durch-
         *  gefhrt.
         *)
        
END VDIControls.