 
 IMPLEMENTATION MODULE ALAP;
 (*$H+,Z+,S-,R-*)
 
 FROM SYSTEM IMPORT ADR, ASSEMBLER, BITNUM, BYTE, WORD, LONGWORD, ADDRESS, SHIFT;
 FROM GEMDOS IMPORT Super;
 FROM Storage IMPORT ALLOCATE;
 
 (* I/O-Routinen fr Testausgaben *)
 IMPORT InOut;
 
 CONST NMI_Mask = $0700;
 
((* alle Zeitwerte sind in s angegeben *)
(bitTime = 5 (* 4.34 *);
(byteTime = 39;
(IDGslottime = 200;
(maxIFGtime = 400; (* 200 ist fr ENQ->ACK offenbar zu klein. *)
(minIDGtime = 2*maxIFGtime;
 
 CONST CTLA = $FFFF8C81;
 
 (* -------------------------------------------------- *)
 
 PROCEDURE resetRx;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVEA.W #CTLA,A1
(; resetRx
(MOVE.B  #3,(A1)
(MOVE.B  #$D0,(A1)       ; disableRx
(MOVEQ   #2,D0
&flushFIFO:
(TST.B   2(A1)
(DBRA    D0,flushFIFO
(MOVE.B  #$30,(A1)       ; reset error
(MOVE.B  #$20,(A1)       ; enable IR on next Rx
(MOVE.B  #3,(A1)
(MOVE.B  #rxEnable,(A1)  ; enableRx
$END
"END resetRx;
"(*$L=*)
"
 
 CONST  rnda = 1664525;     (* Knuth S.102 Zeile 26 *)
'rndc = 117;         (* teilerfremd mit 2^32 fr max. Periode 2^32 *)
 
 PROCEDURE random;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; IN: D0.W max-Wert minus 1, OUT: D0.W 0..max-1
(MOVE.W  D0,-(A7)
(MOVE.L  seed,D0
(BNE     isInit
(; seek initialisieren
(MOVEM.L A0-A2,-(A7)
(MOVE    #17,-(A7)
(TRAP    #14
(ADD.L   D0,seed
(TRAP    #14
(ADDQ.L  #2,A7
(MOVEM.L (A7)+,A0-A2
(LSL.L   #8,D0
(ADD.L   D0,seed
&isInit:
(MOVE.L  D0,D1
(MOVE.L  D0,D2
(SWAP    D2
(MOVE.L  D3,-(A7)
(MOVE.L  #rnda,D3
(MULU    D3,D0
(MULU    D3,D2
(SWAP    D3
(MULU    D3,D1
(MOVE.L  (A7)+,D3
(SWAP    D1
(CLR.W   D1
(SWAP    D2
(CLR.W   D2
(ADD.L   D1,D0
(ADD.L   D2,D0
(ADDI.L  #rndc,D0
(MOVE.L  D0,seed
(MOVE.W  (A7)+,D1
(BEQ     rtn0
(MOVE.W  D0,D2
(CLR.W   D0
(SWAP    D0
(DIVU    D1,D0
(MOVE.W  D2,D0
(DIVU    D1,D0
(SWAP    D0
(RTS
&rtn0
(MOVEQ   #0,D0
$END
"END random;
"(*$L=*)
 
 PROCEDURE WriteFrame (REF packet: aPacket; no: CARDINAL);
"VAR n: CARDINAL;
"BEGIN
$FOR n:= 1 TO 5 DO
&IF n > packet.length THEN
(InOut.WriteString ('   ');
&ELSE
(InOut.WriteHex (LONG (packet.frame.rawData [n]), 3);
&END
$END;
$FOR n:= 6 TO no DO
&IF n <= packet.length THEN
(InOut.WriteHex (LONG (packet.frame.rawData [n]), 3);
(IF (ORD (packet.frame.rawData [n]) >= 32) AND
+(ORD (packet.frame.rawData [n]) < 128) THEN
*InOut.Write ('/');
*InOut.Write (CHAR(packet.frame.rawData [n]));
(END
&END
$END;
$InOut.WriteString (' ');
"END WriteFrame;
 
 PROCEDURE WriteStatus (status: FrameStatus);
"BEGIN
$CASE status OF
&|badframeCRC: InOut.WriteString ('>badframeCRC<')
&|badframeSize: InOut.WriteString ('>badframeSize<');
&|badframeType: InOut.WriteString ('>badframeType<')
&|overrunError: InOut.WriteString ('>overrunError<')
&|underrunError: InOut.WriteString ('>underrunError<')
&|lostAddress: InOut.WriteString ('>lost address<')
&|lapACKframe: InOut.WriteString ('>ACKframe<')
&|lapENQframe: InOut.WriteString ('>ENQframe<');
&|lapRTSframe: InOut.WriteString ('>RTSframe<');
&|lapCTSframe: InOut.WriteString ('>CTSframe<');
&|lapDATAframe: InOut.WriteString ('>DATAframe<');
&|noFrame: InOut.WriteString ('no frame!');
$ELSE
&InOut.WriteString ('unknown frame!');
$END;
"END WriteStatus;
 
 (* --------------------------- *)
 
 FORWARD AcquireAddress;
 FORWARD TransmitPacket;
 FORWARD TransmitFrame;
 FORWARD ReceiveFrame (VAR packet: ptrPacket): FrameStatus;
 FORWARD ReceiveLinkMgmt (VAR packet: ptrPacket): ReceiveStatus;
 FORWARD IR_Handler;
 FORWARD GetFrame;
 
 PROCEDURE NewPacketBuffer;
"VAR p, prev, last: ptrPacket; sr: CARDINAL;
"BEGIN
$ASSEMBLER
(MOVE    SR,sr(A6)
(MOVE    #$2500,SR
$END;
$NEW (p);
$IF p # NIL THEN
&IF packetBuffers = 0 THEN
(headPacket:= p;
(tailPacket:= p;
(last:= p
&ELSE
(prev:= headPacket;
(WHILE prev^.next # tailPacket DO
*prev:= prev^.next
(END;
(last:= prev^.next;
(prev^.next:= p
&END;
&INC (packetBuffers);
&WITH p^ DO
(next:= last;
(status:= undefined;
(no:= packetBuffers
&END;
$END;
$ASSEMBLER
(MOVE    sr(A6),SR
$END;
"END NewPacketBuffer;
 
 PROCEDURE ResetReceiveBuffer;
"BEGIN
$tailPacket:= headPacket
"END ResetReceiveBuffer;
 
 TABLE.W SCCInitData:
*$09C0, $0420, $0AE0, $0600, $077E, $0C06, $0D00, $0EC0,
*$03D0, $0B70, $0E21, $0560, $0F00, $0108,
*$0200 + ADR (IR_Vector) DIV 4, $0908, $0300+rxEnable, 0;
 
 (*$L-*)
 
 PROCEDURE Init;
"(* IN: D0.B: proposed address, 0 if none *)
"BEGIN
$ASSEMBLER
(MOVE.B  D0,myAddress
(CLR     backoff
(CLR.B   deferHistory
(CLR.B   collsnHistory
(
(JSR     NewPacketBuffer
(JSR     NewPacketBuffer
(JSR     NewPacketBuffer
$
(; Init Timer A
(MOVEA.W #$FA00,A0
(MOVE.B  #$00,$19(A0)    ; TACR: Timer Stop
(ANDI.B  #$DF,$13(A0)    ; IMRA: Mask Timer A IR
(ORI.B   #$20,$07(A0)    ; IERA: Enable Timer-A Pending Bit
(MOVE.B  #$DF,$0B(A0)    ; IPRA: Clear Timer-A Pending Bit
 
%; *** SCC initialisieren ***
%;
%; Die Clock an RTxCA ist 3.672 MHz, bentigte Baudrate ist 230400 Bit/s.
%; Dazu mte die Clock auf 1/16 geteilt werden.
%; Da fr Receive DPLL verwendet wird, und DPLL den 16fachen Clk
%; braucht, wird trotzdem kein Teiler verwendet. Stattdessen wird
%; ber den BRG geteilt.
%;
%; Der SCC arbeitet im Interrupt-Betrieb. Es wird der Non-Auto-Vektor-
%; Modus verwendet, auf Adr. $360. Der IR luft im Level 5.
%; Da nur eine einzige IR-Quelle benutzt wird (IR on 1st Rx Char or
%; special condition), wird die vector-includes-status-Option nicht
%; verwerdet.
%;
 
(; GIOffBit ($7F);
(MOVE.W  #$7F,-(A7)
(MOVE    #29,-(A7)
(TRAP    #14
(ADDQ.L  #4,A7
(
(MOVE.L  #IR_Handler,IR_Vector
(
(LEA     SCCInitData,A0
(MOVEA.W #CTLA,A1
$l1: MOVE.W  (A0)+,D0
(BEQ     e1
(MOVE.W  D0,D1
(LSR     #8,D1
(MOVE.B  D1,(A1)
(NOP
(MOVE.B  D0,(A1)
(BRA     l1
$e1:
(MOVE.B  myAddress,D0
(JSR     AcquireAddress
(
(CLR     deferCount
(CLR     collsnCount
(CLR     DataFramesOut
(CLR     RTSFramesOut
(CLR     CTSFramesOut
$END
"END Init;
 
 VAR acqFrame: aTxFrame;
 
 PROCEDURE AcquireAddress;
"(* IN: D0.B: proposed address, 0 if none *)
"BEGIN
$ASSEMBLER
(; *** choose address ***
(BSR     getNewAddress
(CLR     fAdrValid
(SUBQ    #2,A7
&acqlp2:
(CLR     fAdrInUse
(MOVE.W  #wksTries,(A7)
&acqlp:
(; TransmitPacket (myAddress, lapENQ, ENQframe.dataField, 0)
(LEA     acqFrame,A0
(MOVE.B  myAddress,D0
(MOVE.B  D0,aTxFrame.ctrl.dstAddr(A0)
(MOVE.B  D0,aTxFrame.ctrl.srcAddr(A0)
(MOVE.B  #lapENQ,aTxFrame.ctrl.lapType(A0)
(CLR.W   aTxFrame.dataCnt1(A0)
(CLR.W   aTxFrame.dataCnt2(A0)
(JSR     TransmitPacket
(CMPI    #transmitOK,D0
(BEQ     adrIsUsed
(TST     fAdrInUse
(BEQ     adrNotUsed
 adrIsUsed:
(MOVEQ   #0,D0
(BSR     getNewAddress
(BRA     acqlp2
 adrNotUsed:
(SUBQ    #1,(A7)
(BNE     acqlp
(ADDQ    #2,A7
(MOVE    #1,fAdrValid
(RTS
 
 getNewAddress:
(TST.B   D0
(BNE     takeIt
(MOVEQ   #127,D0
(JSR     random
(ADDQ    #1,D0
&takeIt:
(MOVE.B  D0,myAddress
(; setAddress
(MOVEA.W #CTLA,A1
(MOVE.B  #6,(A1)
(MOVE.B  myAddress,(A1)
$END;
"END AcquireAddress;
 
 PROCEDURE TransmitPacket;
"(* IN:  A0: ^aTxFrame
%OUT: D0.W TransmitStatus *)
 
"PROCEDURE BitCount;
$BEGIN
&ASSEMBLER
*; In: D0.B, Out: D1.W /D0-D2/
*MOVEQ   #0,D1
*MOVEQ   #7,D2
'l: LSR.B   #1,D0
*BCC     c
*ADDQ    #1,D1
'c: DBRA    D2,l
&END
$END BitCount;
"
"BEGIN (* TransmitPacket *)
$ASSEMBLER
(TST     fAdrInUse
(BEQ     notInUse
(MOVEQ   #dupAddress,D0
(RTS
&notInUse:
(MOVE.L  A0,-(A7)
(
(LEA     RTSframe,A1
(MOVE.B  aTxFrame.ctrl.dstAddr(A0),aTxFrame.ctrl.dstAddr(A1)
(MOVE.B  myAddress,aTxFrame.ctrl.srcAddr(A1)
(MOVE.B  #lapRTS,aTxFrame.ctrl.lapType(A1)
(CLR.W   aTxFrame.dataCnt1(A1)
(CLR.W   aTxFrame.dataCnt2(A1)
(
(MOVE.B  collsnHistory,D0
(BSR     BitCount
(CMPI    #2,D1
(BLS     c1
(
(; increase backoff because of too many collisions
(CLR.B   collsnHistory
(MOVE.W  backoff,D0
(BEQ     c2
(LSL     #1,D0
(CMPI    #16,D0
(BLS     c3
(MOVEQ   #16,D0
(BRA     c3
$c2: MOVEQ   #2,D0
$c3: MOVE    D0,backoff
(
$c1: MOVE.B  deferHistory,D0
(BSR     BitCount
(CMPI    #2,D1
(BCC     c4
(
(; decrease backoff if no defers recently
(CLR.B   deferHistory
(LSR.W   backoff
(
$c4: ; shift history data
(LSL     collsnHistory
(LSL     deferHistory
(
(CLR.W   deferTries
(CLR.W   collsnTries
(MOVE.W  backoff,lclbackoff
(
(MOVEA.W #CTLA,A1
(MOVEA.W #$FA00,A2
(
 again1: ; *** main loop ***
(
(; *** defer while there are other transmissions in progress ***
(
(; carrierSense?
(BTST    #4,CTLA
(BNE.W   noCarrier
(
(BRA     defer1
(
&defer2:
(ADDQ.W  #1,deferCount
(ADDQ.W  #1,deferTries
(CMPI.W  #maxDefers,deferTries
(BLS     defer1
(
(; *** Error: too many defers ***
(MOVE.W  #excessDefers,D0
(BRA.W   exit
(
&defer1:
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; defer
(CMPI    #2,lclbackoff
(BCC     c5
(MOVE    #2,lclbackoff
&c5:
(BSET    #0,deferHistory
(
(; wait for packet to pass
(; Delay: maxFrameSize * 1.5 * byteTime (39s) = maxFrameSize * 58.5 Zyklen
(MOVE    #maxFrameSize,D1
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #36,$1F(A2)     ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
(BRA     c6
$l6: BTST    #4,CTLA
(BNE     c7              ; kein Carrier mehr
(BTST    #5,$0B(A2)
(BEQ     c6
(MOVE.B  #$DF,$0B(A2)    ; time over: Clear Timer-A Pending Bit
$c6: DBRA    D1,l6
(
(; something is wrong: ResetRx
(JSR     resetRx
$c7: MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
&noCarrier:
(
(; resetMissingClock
(MOVE.B  #14,(A1)
(MOVE.B  #$41,(A1)
(
(; wait for min. IDG time after packet or idle line
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #minIDGtime DIV 4,$1F(A2)      ; Set Timer Count
(MOVE.B  #2,$19(A2)      ; TACR: Timer Start (Teiler: 1/10)
$l7: BTST    #4,CTLA
(BEQ     defer1          ; erneut Carrier aufgetreten
(BTST    #5,$0B(A2)      ; IPRA
(BEQ     l7
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; wait additional backoff time, deferring to others
(MOVE    lclbackoff,D0
(BEQ     n8
(ADDQ    #1,D0
(JSR     random
$n8: MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #IDGslottime DIV 4,$1F(A2)      ; Set Timer Count
(MOVE.B  #2,$19(A2)      ; TACR: Timer Start (Teiler: 1/10)
(BRA     c8
$l8: BTST    #4,CTLA
(BEQ     defer2          ; erneut Carrier aufgetreten
(BTST    #5,$0B(A2)      ; IPRA
(BEQ     l8
(MOVE.B  #$DF,$0B(A2)    ; time over: Clear Timer-A Pending Bit
$c8: DBRA    D0,l8
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; missing clock?
(MOVE.B  #10,(A1)
(TST.B   (A1)            ; RR10
(BMI     defer2
(
(; *** send RTS ***
(
(MOVE.L  (A7),A0
(CMPI.B  #lapENQ,aTxFrame.ctrl.lapType(A0)
(BEQ     sndENQ
(LEA     RTSframe,A0
 sndENQ: MOVE    SR,D2
(ORI     #NMI_Mask,SR
(ADDQ.W  #1,RTSFramesOut
(JSR     TransmitFrame
(
(; enableRx
(MOVE.B  #3,(A1)
(MOVE.B  #rxEnable,(A1)
(
(MOVE    #1,fCTSexpected
(MOVE    D2,SR
(; *** wait for CTS ***
(SUBQ.L  #4,A7
(MOVE.L  A7,(A3)+
(MOVEM.L A1/A2,-(A7)
(JSR     ReceiveFrame/
(MOVEM.L (A7)+,A1/A2
(ADDQ.L  #4,A7
(CLR     fCTSexpected
(
(TST     fAdrInUse
(BEQ     noDup
(
(; *** Error: duplicate address ***
(MOVE.W  #dupAddress,D0
(BRA.W   exit
(
 noDup:  MOVE.L  (A7),A0
(CMPI.B  #$FF,aTxFrame.ctrl.dstAddr(A0)
(BNE     chkCTS
(; broadcast-Transmit auswerten
(CMPI    #noFrame,D0
(BNE     error1
(BRA     send2
 chkCTS: CMPI    #lapCTSframe,D0
(BNE     error1
(CMPI.B  #lapENQ,aTxFrame.ctrl.lapType(A0)
(BEQ     error1
(
 send2:  ; *** eigentliches Paket senden ***
(MOVE    SR,D2
(BREAK ;ORI     #NMI_Mask,SR
(ADDQ.W  #1,DataFramesOut
(JSR     TransmitFrame
(
(; enableRx
(MOVE.B  #3,(A1)
(MOVE.B  #rxEnable,(A1)
(
(MOVE    D2,SR
(MOVE.W  #transmitOK,D0
(BRA.W   exit
(
 error1  ; assume collision because we didn't receive the expected CTS
(ADDQ    #1,collsnCount
(BSET    #0,collsnHistory
(ADDQ    #1,collsnTries
(CMPI    #maxCollsns,collsnTries
(BHI     excssC
(
(MOVE.W  lclbackoff,D0
(BEQ     c12
(LSL     #1,D0
(CMPI    #16,D0
(BLS     c13
(MOVEQ   #16,D0
(BRA     c13
#c12: MOVEQ   #2,D0
#c13: MOVE    D0,lclbackoff
(
(BRA     again1
(
 excssC: ; *** Error: too many collisions ***
(MOVE.W  #excessCollsns,D0
 exit:   ADDQ.L  #4,A7
$END;
"END TransmitPacket;
 
 PROCEDURE TransmitFrame;
"BEGIN
$ASSEMBLER
(; A0: ^aTxFrame, A1: CTLA, A2: $FFFFFA00
(; enableTxDrivers
(MOVE.B  #5,(A1)
(MOVE.B  #setRTS,(A1)
(
(; Pause f. Sync-Pulse (1 Bit: 1.5 * bitTime (6.51s) = 16 Zyklen)
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #4,$1F(A2)      ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
%l: BTST    #5,$0B(A2)      ; IPRA
(BEQ     l
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; disableTxDrivers
(MOVE.B  #5,(A1)
(MOVE.B  #$60,(A1)
(
(; Pause f. Sync-Pulse (1 Bit: 1.5 * bitTime (6.51s) = 16 Zyklen)
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #4,$1F(A2)      ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
%l2 BTST    #5,$0B(A2)      ; IPRA
(BEQ     l2
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; enableTxDrivers, enableTx
(MOVE.B  #5,(A1)
(MOVE.B  #txEnable,(A1)
(
(; disableRx
(MOVE.B  #3,(A1)
(MOVE.B  #$D0,(A1)
(
(; 2 * txFlag
(; Delay: 2 * 1.5 * byteTime (39s) = 116 Zyklen
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #70,$1F(A2)     ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
%l3 BTST    #5,$0B(A2)      ; IPRA
(BEQ     l3
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; resetCRC
(MOVE.B  #$80,(A1)
(
(BSR     TxChar
(BSR     TxChar
(BSR     TxChar
(ADDQ.L  #1,A0
(MOVE.L  (A0)+,A2
(MOVE.W  (A0)+,D0
(DBRA    D0,nextChar1
(BRA     allSent1
(
%TxChar:
(BTST    #2,(A1)
(BEQ     TxChar
(MOVE.B  (A0)+,2(A1)
(RTS
(
%nextChar1:
(BTST    #2,(A1)
(BEQ     nextChar1
(MOVE.B  (A2)+,2(A1)
(DBRA    D0,nextChar1
%allSent1:
(MOVE.L  (A0)+,A2
(MOVE.W  (A0)+,D0
(DBRA    D0,nextChar2
(BRA     allSent2
%nextChar2:
(BTST    #2,(A1)
(BEQ     nextChar2
(MOVE.B  (A2)+,2(A1)
(DBRA    D0,nextChar2
%allSent2:
(
(; resetUnderrun
(MOVE.B  #$C0,(A1)
(
(; TxFCS: wait for underrun
%notUnder:
(BTST    #6,(A1)
(BEQ     notUnder
(
(; TxFlag (?)
%notEmpty2:
(BTST    #2,(A1)
(BEQ     notEmpty2
(
(; enableTxDrivers, disableTx
(MOVE.B  #5,(A1)
(MOVE.B  #setRTS,(A1)
(
(; txONEs (?)
(; Delay: 1.5 * byteTime (39s) = 58 Zyklen
(MOVEA.W #$FA00,A2
(MOVE.B  #$DF,$0B(A2)    ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #35,$1F(A2)     ; TADR: Set Timer Count
(MOVE.B  #1,$19(A2)      ; TACR: Timer Start (Teiler: 1/4)
%l4 BTST    #5,$0B(A2)      ; IPRA
(BEQ     l4
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(
(; disableTxDrivers
(MOVE.B  #5,(A1)
(MOVE.B  #$60,(A1)
(
(; resetMissingClock
(MOVE.B  #14,(A1)
(MOVE.B  #$41,(A1)
$END;
"END TransmitFrame;
 
 (*$L+*)
 
 PROCEDURE ReceivePacket (VAR dstParam: anAddress;
9VAR srcParam: anAddress;
9VAR typeParam: aLAPtype;
9VAR dataParam: aDataField;
9VAR dataLength: INTEGER);
"VAR status: ReceiveStatus; packet: ptrPacket;
"BEGIN
$REPEAT UNTIL (ReceiveLinkMgmt (packet) = receiveOK) OR InOut.KeyPressed ();
$WITH packet^.frame DO
&dstParam:= dstAddr;
&srcParam:= srcAddr;
&typeParam:= lapType;
&dataParam:= dataField (*!!! hier werden 600 Byte kopiert -> Ptr verw.*)
$END;
"END ReceivePacket;
 
 PROCEDURE ReceiveLinkMgmt (VAR packet: ptrPacket): ReceiveStatus;
"
"VAR status: ReceiveStatus;
&rcvdStatus: FrameStatus;
&sr: CARDINAL;
"
"BEGIN
$ASSEMBLER
(MOVE    SR,sr(A6)
(MOVE    #$2500,SR
$END;
$status:= receiving;
$REPEAT
&rcvdStatus:= ReceiveFrame (packet);
&IF rcvdStatus # noFrame THEN
(InOut.WriteCard (packet^.no, 1); InOut.Write (' ');
(WriteFrame (packet^,99);
(InOut.WriteLn;
(WriteStatus (rcvdStatus); InOut.WriteLn;
&END;
&CASE rcvdStatus OF
&|badframeCRC, badframeSize, badframeType, overrunError, underrunError,
'lostAddress:
(status:= frameError
&|lapACKframe:
&|lapENQframe:
((* wird nun schon beim Empfang erledigt *)
(HALT
((*
*IF fAdrValid THEN
,WITH ACKframe DO
.dstAddr:= packet^.frame.srcAddr;
.srcAddr:= myAddress;
.lapType:= lapACK
,END;
,TransmitFrame (ACKframe, 3);
*ELSE
,fAdrInUse:= TRUE
*END;
*status:= nullReceive
(*)
&|lapRTSframe:
((* wird nun schon beim Empfang erledigt *)
(HALT
((*
*IF fAdrValid THEN
,WITH CTSframe DO
.dstAddr:= headPacket^.frame.srcAddr;
.srcAddr:= myAddress;
.lapType:= lapCTS
,END;
,TransmitFrame (CTSframe, 3);
*ELSE
,fAdrInUse:= TRUE;
,status:= nullReceive
*END;
(*)
&|lapDATAframe:
(IF fAdrValid THEN
*status:= receiveOK
(ELSE
*ASSEMBLER
+;BREAK
*END;
*fAdrInUse:= TRUE;
*status:= nullReceive
(END;
&|noFrame:
(status:= nullReceive
&ELSE
&END
$UNTIL status # receiving;
$ASSEMBLER
(MOVE    sr(A6),SR
$END;
$RETURN status
"END ReceiveLinkMgmt;
 
 PROCEDURE ReceiveFrame (VAR packet: ptrPacket): FrameStatus;
"
"VAR status: FrameStatus;
 
"BEGIN
$ASSEMBLER
(MOVEA.W #CTLA,A1
(MOVEA.W #$FA00,A2
(MOVE.L  tailPacket,A0
(
(; *** warten auf Frame-Empfang (IR o. Polling) ***
(
(MOVEQ   #0,D1
(
$l1: MOVE.B  #$DF,$0B(A2)               ; IPRA: Clear Timer-A Pending Bit
(MOVE.B  #maxIFGtime DIV 4,$1F(A2)  ; TADR: Set Timer Count
(MOVE.B  #2,$19(A2)                 ; TACR: Timer Start (Teiler: 1/10)
$l0: ; zuerst prfen, ob evtl. noch ein Frame zu pollen ist,
(; auch wenn noch weitere Pakete schon im Puffer warten.
(MOVE.B  #3,(A1)
(BTST.B  #5,(A1)         ; RR3: Rx IR pending?
(BNE     pollFrame
(CMPA.L  headPacket,A0
(BNE     gotFrame
(BTST    #5,$0B(A2)      ; time over?
(BEQ     l0
(; IR-Receive nochmal prfen, falls IR zw. vorigem CMP und Time-Chk kam.
(CMPA.L  headPacket,A0
(BNE     gotFrame
(
((*
(TST     test
(BEQ     timeout
(
(ADDQ    #1,D1
(BRA     l1
(*)
(
$timeout:
(; time out
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(MOVE.L  packet(A6),A0
(CLR.L   (A0)
(MOVE    #noFrame,status(A6)
(BRA.W   exit2
(
$gotFrame:
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(BRA     exit
(
$pollFrame:
(MOVE    SR,D2
(ORI     #NMI_Mask,SR
(MOVE.B  #$00,$19(A2)    ; TACR: Timer Stop
(JSR     GetFrame
(MOVE.B  #1,(A1)
(MOVE.B  #$08,(A1)
(MOVE    D2,SR
(
$exit:
(MOVE.L  tailPacket,D0
(MOVE.L  packet(A6),A0
(MOVE.L  D0,(A0)
(MOVE.L  D0,A0
(MOVE    aPacket.status(A0),status(A6)
(MOVE.L  aPacket.next(A0),tailPacket
(
$exit2:
$END;
$RETURN status
"END ReceiveFrame;
 
 PROCEDURE IR_Handler;
"(*$L-*)
"BEGIN
$ASSEMBLER
(ORI     #NMI_Mask,SR
(MOVEM.L A0-A2/D0-D1,-(A7)
(
(MOVEA.W #$FA00,A2
(MOVEA.W #CTLA,A1
(JSR     GetFrame
(
(ADDQ.W  #1,Interrupts
(
(MOVEM.L (A7)+,A0-A2/D0-D1
(RTE
$END;
"END IR_Handler;
"(*$L=*)
 
 PROCEDURE GetFrame;
"(*$L-*)
"BEGIN
$ASSEMBLER
(; overrun?
(MOVE.B  #1,(A1)   ; RR1
(BTST.B  #5,(A1)
(BNE     isOverrun
(
(MOVE.L  headPacket,A0
(
(MOVE.B  2(A1),D0                ; 1. char sofort holen
(MOVE.B  D0,aPacket.frame(A0)
(
(MOVE.B  #2,4(A1)
(BTST.B  #0,4(A1)                ; RR2B
(BNE     specCond
(
(MOVEQ   #100,D1
&wait2:
(BTST    #0,(A1)
(DBNE    D1,wait2
(; overrun?
(MOVE.B  #1,(A1)   ; RR1
(BTST.B  #5,(A1)
(BNE     isOverrun
(
(MOVE.B  2(A1),aPacket.frame+1(A0)
(
(MOVEQ   #2,D0
(BRA     nextChar
(
$specCond:
(
$again:
(CLR     D0
(
$loop2:
(; overrun?
(MOVE.B  #1,(A1)   ; RR1
(BTST.B  #5,(A1)
(BEQ     noOverrun
(
$isOverrun:
(MOVE    D0,aPacket.length(A0)
(MOVE.W  #overrunError,aPacket.status(A0)
(BRA.W   exit2
(
$timeOut:
(MOVE    D0,aPacket.length(A0)
(MOVE.W  #noFrame,aPacket.status(A0)
(BRA.W   exit2
(
$noOverrun:
(MOVEQ   #100,D1 ;!!! Wert OK?
&wait4:
(BTST    #0,(A1)
(DBNE    D1,wait4
(BEQ     timeOut
(
(; *** read data ***
(CMPI.W  #maxFrameSize,D0        ; incomingLength
(BCS     getChar
(
$sizeError:
(MOVE    D0,aPacket.length(A0)
(MOVE.W  #badframeSize,aPacket.status(A0)
(BRA.W   exit2
(
$getChar:
(; headPacket^.frame.rawData [incomingLength]:= rxData ()
(MOVE.B  2(A1),aPacket.frame(A0,D0.W)  ; RR8
(ADDQ.W  #1,D0             ; incomingLength
(
$nextChar:
$noDataNow:
(; end of frame?
(MOVE.B  #1,(A1)   ; RR1
(TST.B   (A1)
(BPL     loop2
(
(SUBQ.W  #2,D0           ; incomingLength
(MOVE    D0,aPacket.length(A0)
(
(CMPI.W  #minFrameSize,D0
(BCS     sizeError
(
(; resetRx
(MOVE.B  #3,(A1)
(MOVE.B  #$D0,(A1)       ; disableRx
(
(; CRC OK?
(MOVE.B  #1,(A1)   ; RR1
(BTST.B  #6,(A1)
(BEQ     crcOK
(
(MOVE.W  #badframeCRC,aPacket.status(A0)
(BRA.W   exit2
(
$crcOK:
(; Stimmt 1. Byte (unsere Adr. oder #$FF)?
(MOVE.B  aPacket.frame(A0),D0
(CMPI.B  #$FF,D0
(BEQ     adrOK
(CMP.B   myAddress,D0
(BEQ     adrOK
(
(MOVE.W  #lostAddress,aPacket.status(A0)
(BRA.W   exit2
(
%adrOK:
(; *** frameDone ***
(
(TST.W   fAdrValid
(BEQ     notValid
(
(MOVE.B  aPacket.frame.lapType(A0),D0
(BMI     ctrlFrame
(
(MOVE.W  #lapDATAframe,aPacket.status(A0)
(BRA.W   exit2
(
&ctrlFrame:
(CMPI.B  #lapENQ,D0
(BEQ     isENQ
(CMPI.B  #lapACK,D0
(BEQ     isACK
(CMPI.B  #lapRTS,D0
(BEQ     isRTS
(CMPI.B  #lapCTS,D0
(BEQ     isCTS
&badFrame:
(MOVE.W  #badframeType,aPacket.status(A0)
(BRA     exit2
&isENQ:
(MOVE.W  #lapENQframe,aPacket.status(A0)
(
(BRA     exit2
&isACK:
(MOVE.W  #lapACKframe,aPacket.status(A0)
(MOVE.W  #1,fAdrInUse
(BRA     exit2
&isRTS:
(MOVE.W  #lapRTSframe,aPacket.status(A0)
(BRA     exit2
&isCTS:
(MOVE.W  #lapCTSframe,aPacket.status(A0)
(TST.W   fCTSexpected
(BNE     exit2
(; das mu wieder hier rein (s. NOTES):
(MOVE.W  #1,fAdrInUse
(BRA     badFrame
(BRA     isNoFrame ;!!!testweise
(
&notValid:
(CMPI.B  #$FF,aPacket.frame.dstAddr(A0)
(BEQ     exit2
(
(;BREAK
(MOVE    #1,fAdrInUse
&isNoFrame
(MOVE.W  #noFrame,aPacket.status(A0)
(
$exit2:
(
(MOVEQ   #2,D0
&flushFIFO:
(TST.B   2(A1)
(DBRA    D0,flushFIFO
(
(; resetMissingClock
(;MOVE.B  #14,(A1)
(;MOVE.B  #$41,(A1)
(
(; reset error
(MOVE.B  #$30,(A1)
(
(; reset IUS
(MOVE.B  #$38,(A1)
(
(; resetMissingClock
(MOVE.B  #14,(A1)
(MOVE.B  #$41,(A1)
(
(
(CMPI.W  #lapENQframe,aPacket.status(A0)
(BNE     noENQ
(
(; ACK senden
(
(CLR.W   -(A7)
(MOVE.B  #lapACK,-(A7)
(BRA     sendCtrlFrame
(
&noENQ:
(
(CMPI.W  #lapRTSframe,aPacket.status(A0)
(BNE     noRTS
(
(; CTS senden, falls kein Broadcast
(
(CMPI.B  #$FF,aPacket.frame.dstAddr(A0)
(BEQ     noCTS
(CLR.W   -(A7)
(SUBQ.L  #4,A7
(CLR.W   -(A7)
(SUBQ.L  #4,A7
(MOVE.B  #lapCTS,-(A7)
&sendCtrlFrame:
(MOVE.B  aPacket.frame.srcAddr(A0),D0
(LSL     #8,D0
(MOVE.B  myAddress,D0
(MOVE.W  D0,-(A7)
(MOVE.L  A7,A0
(ADDQ.W  #1,CTSFramesOut
(JSR     TransmitFrame
(ADDA.W  #16,A7
(MOVE.L  headPacket,A0
&noCTS:
(MOVE.W  #noFrame,aPacket.status(A0)
(
&noRTS:
(
(ADDQ.W  #1,FramesReceived
(
(MOVE.L  aPacket.next(A0),A0
(MOVE.L  A0,headPacket
(
(MOVE.B  #$20,(A1)         ; enable IR on next Rx
(
(MOVE.B  #3,(A1)
(MOVE.B  #rxEnable,(A1)  ; enableRx
(
(; more IRs?
(BTST    #0,(A1)
(BNE     again
$END
"END GetFrame;
"(*$L=*)
 
 BEGIN
"packetBuffers:= 0;
 END ALAP.
 
(* $FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$00003AF1$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$00004A3B$00004919$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$000030B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$FFEFD9B8$000058A6T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$FFF006F0$000058A6$00005978$00003746$000001EC$0000371D$000037D9$00003640$000030A5$00003B02$00002DC7$00005886$FFF006F0$000058A6$00005883$00005876*)
