 MODULE LANDriver; (*$H+,Z+,S-,R-*)
 
 IMPORT TOSIO;
 FROM InOut IMPORT Write, WriteString, ReadCard;
 
 IMPORT SYSTEM;
 FROM SYSTEM IMPORT ASSEMBLER, ADR, WORD, BYTE, ADDRESS;
 
 IMPORT ALAP;
 
 IMPORT MOSGlobals, PrgCtrl, ModCtrl;
 FROM GEMDOS IMPORT Super;
 
 
 CONST DataLAP = $20;    (* LAP-Type fr Daten *)
 
 VAR ch: CHAR;
$rxIdx, n, c: CARDINAL;
$lc: LONGCARD;
$i: INTEGER;
$ssp, li: LONGINT;
$redraw, quit, ok, b: BOOLEAN;
$myaddr: CARDINAL;
$sentDatas,sendTrials,rcvdDatas: LONGCARD;
$
$txFrame: ALAP.aTxFrame;
$packet: ALAP.ptrPacket;
$dstParam, srcParam: ALAP.anAddress;
$typeParam: ALAP.aLAPtype;
$dataParam: ALAP.aDataField;
$txStatus: ALAP.TransmitStatus;
$frameStatus: ALAP.FrameStatus;
$dataLength: INTEGER;
$
$bos: ARRAY [1..400] OF WORD; tos: WORD;
 
 VAR trapV [$80]: PROC; oldv: PROC;
 
 (*$L-*)
 
 PROCEDURE trapHandler;
"BEGIN
$ASSEMBLER
(; cmd-code in D0
(MOVE.L  A3,-(A7)
(MOVE.L  A2,-(A7)
(MOVE.L  A7,A2
(LEA     tos,A7
(LEA     bos,A3
(MOVE.L  A2,-(A7)
(BREAK
(SUBQ    #1,D2
(BMI     getFrame
(BEQ     sendFrame
(
(; Init
(MOVE.W  myaddr,D0
(JSR     ALAP.Init
(JSR     ALAP.NewPacketBuffer
(JSR     ALAP.NewPacketBuffer
(JSR     ALAP.NewPacketBuffer
(MOVEQ   #1,D0
(BRA     exit
(
&getFrame:
(MOVE.L  A0,-(A7)        ;rette ^Ziel-Puffer
(MOVE.L  #packet,(A3)+
(JSR     ALAP.ReceiveFrame/
(MOVE.L  (A7)+,A0
(CMPI    #ALAP.lapDATAframe,D0
(BEQ     dataOK
(MOVEQ   #0,D0           ;error!
(BRA     exit
&dataOK:
(MOVE.L  packet,A1
(CMPI.B  #DataLAP,ALAP.aPacket.frame.lapType(A1)
(; 4 Byte-Header schreiben
(MOVE.B  D0,(A0)+
(CLR.B   (A0)+
(MOVE.W  ALAP.aPacket.length(A1),D0
(MOVE.W  D0,(A0)+
(; Daten schreiben
(LEA     ALAP.aPacket.frame.dataField(A1),A1
(ADDQ    #1,D0
(LSR     #1,D0
(BRA     copys
&copyl:
(MOVE.W  (A1)+,(A0)+
&copys:
(DBRA    D0,copyl
(MOVEQ   #1,D0
(BRA     exit
(
&sendFrame:
(LEA     txFrame,A2
(MOVE.B  5(A0),ALAP.aTxFrame.ctrl.dstAddr(A2) ; Low-Byte der Ethernet-Adresse
(MOVE.W  myaddr,D2
(MOVE.B  D2,ALAP.aTxFrame.ctrl.srcAddr(A2)
(MOVE.B  #DataLAP,ALAP.aTxFrame.ctrl.lapType(A2)
(LEA     ALAP.aTxFrame.dataPtr1(A2),A1
(MOVE.L  A0,(A1)+
(MOVE.W  D0,(A1)+
(MOVE.L  A1,(A1)+
(MOVE.W  D1,(A1)+
(JSR     ALAP.TransmitPacket
(
&exit:
(MOVE.L  (A7)+,A7
(MOVE.L  (A7)+,A2
(MOVE.L  (A7)+,A3
(RTE
$END
"END trapHandler;
 
 (*$L+*)
 
 PROCEDURE removal;
"BEGIN
$ssp:= Super (0);
$trapV:= oldv;
$ssp:= Super (ssp);
"END removal;
 
 BEGIN
"IF ModCtrl.FirstModuleStart () THEN
$WriteString ('Adresse? ');
$ReadCard (myaddr);
$ssp:= Super (0);
$oldv:= trapV;
$trapV:= trapHandler;
$ssp:= Super (ssp);
$ModCtrl.InstallModule (removal, MOSGlobals.MemArea{NIL,0})
"ELSE
$removal;
$ModCtrl.ReleaseModule
"END
 END LANDriver.
 
(* $FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$00000A7B$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$FFF006F0$00000A5E$000004BAT.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000507$000007F7$00000804$00000797$000007A3$FFF006F0$000008CC$FFF006F0$FFF006F0$000008C3$000008B9$000008C3$000004D6$000004BA$0000041D$0000050F*)
