 IMPLEMENTATION MODULE Compressions;
 (*$R-,Y+*)
 
 (*
"16.09.89: Korrektur in Decode.readCode
 *)
 
 
 (*
 FROM    InOut   IMPORT WriteString, WriteLn, WriteCard, Write;
 
 FROM StrConv IMPORT CardToStr, HexToStr;
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 
 FROM    SYSTEM  IMPORT ADDRESS,
7TSIZE;
 
 FROM    Storage IMPORT ALLOCATE, DEALLOCATE;
 
 FROM    BinOps IMPORT LowerLCard;
 
 IMPORT  Block;
 
 
 CONST   maxTable = 2047;
(maxHash  = 4073;        (*  Sollte prim sein  *)
(hashStep = 31;          (*  Sollte prim sein  *)
(maxStr   = 49;
 
(increaseWidth   = 256;
(newTable        = 257;
(firstFreeEntry  = 258;
 
 TYPE    ptrChar         = POINTER TO CHAR;
(ptrCard         = POINTER TO CARDINAL;
(string          = ARRAY[0..maxStr] OF CHAR;
 
(hashTaElem      = RECORD
<used: BOOLEAN;
<elem: CARDINAL;
:END;
(hashTable       = POINTER TO ARRAY[0..MaxCard] OF hashTaElem;
 
((*  ACHTUNG: 'copyCurrentIntoTable' und 'stringsEqual' baut auf
)*           dem Aussehen des Record's auf.
)*)
(codeTaElem      = RECORD
<len: CARDINAL;
<str: string;
:END;
(codeTable       = POINTER TO ARRAY[0..MaxCard] OF codeTaElem;
(
((*  ACHTUNG: 'Decode' baut auf der Lnge des Record's auf.
)*           (Bei Array indizierung)
)*           'initDecodeTable' baut auf der STRUKTUR des Record's
)*           auf.
)*)
(decodeTaElem    = RECORD
<prefix: CARDINAL;
<first, last: CHAR;
:END;
(decodeTable     = POINTER TO ARRAY[0..MaxCard] OF decodeTaElem;
 
 
 PROCEDURE initCodeTable (table: codeTable; hash: hashTable);
"VAR i: CARDINAL;
"BEGIN
$FOR i:= 0 TO 255 DO
&table^[i].str[0]:= CHR (i);
&table^[i].str[1]:= 0C;
$END;
$FOR i := 0 TO maxHash DO hash^[i].used := FALSE END;
"END initCodeTable;
 
 (*  VAR bei 'currentString' nur aus Effizenzgrnden.
!*)
 PROCEDURE searchCodeTable (VAR currentString: string;
?stringLength : CARDINAL;
?table        : codeTable;
?hash         : hashTable;
;VAR success      : BOOLEAN;
;VAR newCode      : CARDINAL;
?newEntry     : CARDINAL);
?
"VAR i: CARDINAL;
"
"(*$L-*)
"PROCEDURE stringsEqual (entryNo: CARDINAL): BOOLEAN;
"
$BEGIN
&ASSEMBLER
(MOVE.W  #maxStr, D0
(ADDQ.W  #4, D0                  ; 'str' fngt bei null an + 'len'
(AND.W   #-2, D0                 ; auerdem grade Anzahl von bytes
(MULU    -(A3), D0
(MOVE.L  table(A6), A0
(MOVE.W  #FALSE, (A3)+
(ADDA.L  D0, A0
(LEA     codeTaElem.str(A0), A1
(MOVE.L  currentString(A6), A2
(MOVE.W  stringLength(A6), D1
(CMP.W   codeTaElem.len(A0), D1
(BNE     ende
 
(SUBQ.W  #1, D1
 loop
(MOVE.B  (A1)+, D0
(CMP.B   (A2)+, D0
(DBNE    D1, loop
(BNE     ende
(MOVE.W  #TRUE, -2(A3)
(
 ende
&END;
$END stringsEqual;
$(*$L=*)
$
"BEGIN
$
$i := (stringLength + ORD (currentString[0]) * 256) MOD (maxHash + 1);
$
$success := FALSE;
$WHILE hash^[i].used AND NOT success DO
$
&IF stringsEqual (hash^[i].elem) THEN
 (*
 currentString[stringLength] := 0C;
 table^[hash^[i].elem].str[table^[hash^[i].elem].len] := 0C;
 WriteString (currentString); WriteString (' = ');
 WriteString (table^[hash^[i].elem].str); WriteLn;
 *)
(success := TRUE;
(newCode := hash^[i].elem;
 (*
 WriteString ('  code: '); WriteCard (newCode, 0); WriteLn;
 *)
&ELSE
(i := (i + hashStep) MOD (maxHash + 1);
&END;
&
$END;
$IF NOT success THEN
&hash^[i].used := TRUE;
&hash^[i].elem := newEntry;
$END;
$
$(*
$i := firstFreeEntry;
$success := FALSE;
$
$WHILE (i < newEntry) AND NOT success DO
&
&IF stringsEqual () THEN
(newCode := i;
(success := TRUE;
(
&ELSE INC (i); END;
$
$END;
$*)
$
"END searchCodeTable;
#
 PROCEDURE Encode (    type     : CARDINAL;
6source   : ADDRESS;
6sourceLen: LONGCARD;
6dest     : ADDRESS;
6destLen  : LONGCARD;
2VAR codeLen  : LONGCARD);
 
"VAR currentString  : string;
&stringLength,
&nextEntry,
&currentCode,
&nextW,
&newCode,
&bitWidth, bit  : CARDINAL;
&i              : LONGCARD;
&success        : BOOLEAN;
&ch             : CHAR;
&table          : codeTable;
&hash           : hashTable;
&destLenSave    : LONGCARD;
&destSave       : ptrCard;
&charSource     : ptrChar;
&destLP         : POINTER TO LONGCARD;
 
"PROCEDURE writeCode (c: CARDINAL);
"
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  D3, -(A7)
 
(MOVE.L  dest(A6), A0
(MOVE.L  codeLen(A6), A1
(MOVE.L  (A1), D3
(MOVE.L  destLen(A6), D2
(MOVEQ   #0, D0
(MOVE.W  -(A3), D0
(MOVE.W  bit(A6), D1
(BEQ     noOr
(LSL.L   D1, D0
(TST.L   D2
(BEQ     noOr
(OR.B    (A0), D0
 noOr
(ADD.W   bitWidth(A6), D1
 loop
(ADDQ.L  #1, D3
(SUBQ.L  #1, D2
(BCS     notEnoughRoom
(MOVE.B  D0, (A0)+
(LSR.L   #8, D0
(BRA     cont
 notEnoughRoom
(ADDQ.L  #1, D2
 cont
(SUBQ.W  #8, D1
(BHI     loop
(BEQ     notByteAligned
(
(SUBQ.L  #1, A0
(ADDQ.L  #1, D2
(SUBQ.L  #1, D3
(ADDQ.W  #8, D1
 
 notByteAligned
(MOVE.W  D1, bit(A6)
(MOVE.L  D2, destLen(A6)
(MOVE.L  D3, (A1)        ; codelen
(MOVE.L  A0, dest(A6)
(
(MOVE.L  (A7)+, D3
&END;
$END writeCode;
$(*$L=*)
"
"PROCEDURE copyCurrentIntoTable;
"
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.W  #maxStr, D0
(ADDQ.W  #4, D0                  ; 'str' fngt bei null an + 'len'
(AND.W   #-2, D0                 ; auerdem gerade Anzahl von bytes
(MULU    nextEntry(A6), D0
(MOVE.L  table(A6), A0
(ADDA.L  D0, A0
(LEA     codeTaElem.str(A0), A1
(LEA     currentString(A6), A2
(MOVE.W  stringLength(A6), D0
(MOVE.W  D0, codeTaElem.len(A0)
(SUBQ.W  #1, D0
 loop
(MOVE.B  (A2)+, (A1)+
(DBF     D0, loop
&END;
$END copyCurrentIntoTable;
$(*$L=*)
0
"BEGIN (* Encode *)
 
$codeLen := 0L;
$IF sourceLen = 0L THEN RETURN END;
$ALLOCATE (table, TSIZE (codeTaElem) * LONG (maxTable + 1));
$IF table = NIL THEN RETURN END;
$ALLOCATE (hash, TSIZE (hashTaElem) * LONG (maxHash + 1));
$IF hash = NIL THEN
&DEALLOCATE (table, 0 (* TSIZE (codeTaElem) * LONG (maxTable + 1) *) );
&RETURN
$END;
$IF dest = NIL THEN destLen := 0L END;
$charSource := ptrChar (source);
$
$bit := 0;
$bitWidth := 9;
$nextW := 512;
$nextEntry := firstFreeEntry;
$initCodeTable (table, hash);
$ch := charSource^;
$INC (charSource);
$currentString[0] := ch;
$stringLength := 1;
$currentCode := ORD (ch);
$
$(* 1. CARDINAL des Ausgabepuffers erhlt Kodierungskennung, 0=keine Kod. *)
$(* Darauf folgt die Originallnge als LONGCARD *)
$destSave:= dest;
$destLenSave:= destLen;
$INC (codeLen,6);
$IF destLen >= 6L THEN
&(* 1. Byte vom Puffer berspringen *)
&INC (dest,6);
&DEC (destLen,6);
$ELSE
&destLen:= 0
$END;
 
$FOR i := 2L TO sourceLen DO
&ch := charSource^;
&INC (charSource);
&currentString[stringLength] := ch;
&INC (stringLength);
&searchCodeTable (currentString, stringLength, table, hash,
7success, newCode, nextEntry);
&
&IF success AND (stringLength # maxStr) THEN
(currentCode := newCode
&ELSE
(writeCode (currentCode);
(IF NOT success THEN
*copyCurrentIntoTable;
*INC (nextEntry);
*IF nextEntry = maxTable THEN
,writeCode (newTable);
,initCodeTable (table, hash);
,bitWidth := 9;
,nextW := 512;
,nextEntry := firstFreeEntry;
*END;
(END;
(
(IF nextEntry = nextW THEN
*INC (nextW, nextW);
*writeCode (increaseWidth);
*INC (bitWidth);
(END;
(currentString[0] := ch;
(stringLength := 1;
(currentCode := ORD (ch);
&END;
$END;
$writeCode (currentCode);
$IF bit # 0 THEN INC (codeLen) END;
$IF destLenSave >= 6L THEN
&IF codeLen > sourceLen THEN
((* Kodierung verwerfen, Daten unkodiert bernehmen *)
(codeLen:= sourceLen + 6L;
(Block.Copy (source,
4LowerLCard (sourceLen, destLenSave - 6L),
4ADDRESS (destSave) + 6L);
((* Kennung: Daten nicht kodiert *)
(destSave^:= 0;
&ELSE
((* Kennung: Daten kodiert *)
(destSave^:= 1;
&END;
&IF codeLen > destLenSave THEN
((* Kennung: Daten nicht vollstndig *)
(destSave^:= MaxCard;
&END;
&destLP:= ADDRESS (destSave) + 2L;
&destLP^:= sourceLen
$END;
$DEALLOCATE (table, 0 (* TSIZE (codeTaElem) * LONG (maxTable + 1) *) );
$DEALLOCATE (hash, 0 (* TSIZE (hashTaElem) * LONG (maxHash + 1) *) );
"END Encode;
 
 
 PROCEDURE initDecodeTable (VAR table: decodeTable);
 
"(*
"VAR i : CARDINAL;
"BEGIN
"
$FOR i := 0 TO 255 DO
&table^[i].first := CHR(i);
&table^[i].last  := CHR(i);
&table^[i].prefix := MaxCard;
$END;
$
"END initDecodeTable;
"*)
"
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.W  #255, D0
(MOVE.L  #-1 - $FFFF, D1
(MOVE.L  -(A3), A0
(MOVE.L  (A0), A0
 loop
(MOVE.L  D1, (A0)+
(ADD.W   #$0101, D1
(DBF     D0, loop
$END;
"END initDecodeTable;
"(*$L=*)
 
 
 PROCEDURE Decode (    source   : ADDRESS;
6sourceLen: LONGCARD;
6dest     : ADDRESS;
6destLen  : LONGCARD;
2VAR success  : BOOLEAN );
"
"CONST tabElemSize = 4;
 
"VAR table          : decodeTable;
&lastCode,
&code, nextEntry,
&bit, bitWidth  : CARDINAL;
&endOfSource    : BOOLEAN;
&kennung        : ptrCard;
&ptrL           : POINTER TO LONGCARD;
&charDest       : ptrChar;
 
 
"PROCEDURE readCode (): CARDINAL;
$
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVE.L  D3, -(A7)
(MOVE.L  D4, -(A7)
(
(MOVE.L  source(A6), A0
(MOVE.L  sourceLen(A6), D2
(MOVE.W  bitWidth(A6), D1
(ADD.W   bit(A6), D1
(MOVEQ   #0, D3
(MOVEQ   #0, D0
(
 loop
(TST.L   D2
(BEQ     sourceEnded
(MOVEQ   #0,D4
(MOVE.B  (A0)+, D4
(LSL.L   D3, D4
(OR.L    D4, D0
(ADDQ.W  #8, D3
(SUBQ.L  #1, D2
(SUBQ.W  #8, D1
(BHI     loop
(BEQ     notByteAligned
(
(SUBQ.L  #1, A0
(ADDQ.L  #1, D2
(
 notByteAligned
(MOVE.W  bit(A6), D1
(LSR.L   D1, D0
(ADD.W   bitWidth(A6), D1
(ANDI.W  #7, D1
(MOVE.W  D1, bit(A6)
(MOVE.L  A0, source(A6)
(MOVE.L  D2, sourceLen(A6)
(MOVEQ   #-1, D1
(MOVE.W  bitWidth(A6), D2
(LSL.W   D2, D1
(NOT     D1
(AND.W   D1, D0
(BRA     ende
 
 sourceEnded
(MOVE.W  #TRUE, endOfSource(A6)
 
 ende
(MOVE.W  D0, (A3)+
(
(MOVE.L  (A7)+, D4
(MOVE.L  (A7)+, D3
&END;
$END readCode;
$(*$L=*)
$
"PROCEDURE writeCode (code: CARDINAL);
$
$(*
$VAR last, next,
(zws       : CARDINAL;
(back      : BOOLEAN;
$
$BEGIN
&back := FALSE;
&next := table^[code].prefix;
&last := MaxCard;
&WHILE NOT back OR (next # MaxCard) DO
&
(IF next = MaxCard THEN
*back := TRUE;
*zws := next; next := last; last := zws;
(ELSE
*table^[code].prefix := last;
*last := code;
*code := next;
*next := table^[code].prefix;
(END;
(IF back AND (destLen # 0L) THEN
*charDest^ := table^[code].last;
*INC (charDest);
*DEC (destLen);
(END;
'
&END;
&table^[code].prefix := last;
$END writeCode;
$*)
$
$(*$L-*)
$BEGIN
&ASSEMBLER
(MOVEM.L D3-D4, -(A7)
(
(;  D0.W -- 'next'
(;  D1.W -- 'code'
(;  D2.W -- 'last'
(;  D3.W -- 'back'
(;  D4.W -- zws
(;  A0.L -- 'table'
(;  A1.L -- zws
(;  A2.L -- 'charDest'
(;
(MOVE.L  table(A6), A0                   ; 'table' -> A0
(MOVE.L  charDest(A6), A2                ; 'charDest' -> A2
(MOVE.W  -(A3), D1                       ; 'code' -> D1
(CLR.W   D3                              ; 'back := FALSE'
(MOVE.L  A0, A1
(MOVE.W  D1, D4
(EXT.L   D4
(LSL.L   #2, D4
(MOVE.W  decodeTaElem.prefix(A1,D4.L),D0 ; 'table^[code].prefix' -> D0
(MOVE.W  #MaxCard, D2                    ; 'MaxCard' -> D2
 loop
(TST.W   D3
(BEQ     loopBody
(CMP.W   #MaxCard, D0
(BEQ     loopEnd
H; WHILE NOT back OR (next # MaxCard) DO
 loopBody
(CMP.W   #MaxCard, D0
(BNE     else
(
(MOVE.W  #TRUE, D3;                      ; 'back := TRUE'
(EXG     D0, D2                          ; EXG ('next', 'last')
(BRA     if1End
 else
 
(MOVE.L  A0, A1
(MOVE.W  D1, D4
(EXT.L   D4
(LSL.L   #2, D4
(MOVE.W  D2, decodeTaElem.prefix(A1,D4.L); 'table^[code].prefix := last'
(MOVE.W  D1, D2                          ; 'last := code'
(MOVE.W  D0, D1                          ; 'code := next'
(MOVE.L  A0, A1
(MOVE.W  D1, D4
(EXT.L   D4
(LSL.L   #2, D4
(MOVE.W  decodeTaElem.prefix(A1,D4.L),D0 ; 'next := table^[code].prefix'
(
 if1End
(TST.W   D3
(BEQ     if2End
(TST.L   destLen(A6)
(BEQ     if2End
(
(; 'charDest^ := table^[code].last'
(; 'INC (charDest)'
(;
(MOVE.L  A0, A1
(MOVE.W  D1, D4
(EXT.L   D4
(LSL.L   #2, D4
(MOVE.B  decodeTaElem.last(A1,D4.L), (A2)+
(
(SUBQ.L  #1, destLen(A6)                         ; 'DEC (destLen)'
 if2End
(BRA     loop
(
 loopEnd
(MOVE.L  A0, A1
(MOVE.W  D1, D4
(EXT.L   D4
(LSL.L   #2, D4
(MOVE.W  D2,decodeTaElem.prefix(A1,D4.L) ; 'table^[code].prefix := last'
(MOVE.L  A2,charDest(A6)                 ; setzt neuen 'charDest'
(
(MOVEM.L (A7)+, D3-D4
&END;
$END writeCode;
$(*$L=*)
$
 (*
"PROCEDURE toBuffer (str: ARRAY OF CHAR);
$VAR i: CARDINAL;
$BEGIN
&i := 0;
&WHILE (HIGH (str) >= i) AND (str[i] # 0C) AND (destLen # 0L) DO
(charDest^ := str[i];
(INC (charDest);
(DEC (destLen);
(INC (i);
&END;
$END toBuffer;
 *)
 
"BEGIN (* Decode *)
 
$success:= FALSE;
 
$IF sourceLen <= 6L THEN ASSEMBLER MOVEQ #3,D1 END; RETURN END;
$kennung:= source;
$INC (source, 6L);
$DEC (sourceLen, 6L);
$IF kennung^ = 0 THEN
 
&IF destLen >= sourceLen THEN
(Block.Copy (source, sourceLen, dest);
(success:= TRUE
&END; (* ansonsten bleibt 'success' FALSE *)
&ASSEMBLER MOVEQ #2,D1 END;
 
$ELSIF kennung^ = 1 THEN
 
&ALLOCATE (table, TSIZE(decodeTaElem) * LONG (maxTable + 1));
&IF table = NIL THEN ASSEMBLER MOVEQ #1,D1 END; RETURN END;
&IF dest = NIL THEN destLen := 0L END;
&charDest := dest;
 
&bit := 0;
&bitWidth := 9;
&nextEntry := firstFreeEntry;
&initDecodeTable (table);
&endOfSource := FALSE;
&code := readCode ();
&lastCode := code;
&writeCode (code);
&
&IF NOT endOfSource THEN code := readCode () END;
&(*
&WHILE NOT endOfSource DO
&
(IF code = increaseWidth THEN INC (bitWidth);
(ELSIF code = newTable THEN
(
*(*initDecodeTable (table);*)
*bitWidth := 9;
*nextEntry := firstFreeEntry;
 
*code := readCode ();
*lastCode := code;
*writeCode (code);
*
(ELSIF code < nextEntry THEN
(
*writeCode (code);
*table^[nextEntry].prefix := lastCode;
*table^[nextEntry].first  := table^[lastCode].first;
*table^[nextEntry].last   := table^[code].first;
*INC (nextEntry);
*lastCode := code;
*
(ELSE
(
*table^[nextEntry].prefix := lastCode;
*table^[nextEntry].first  := table^[lastCode].first;
*table^[nextEntry].last   := table^[lastCode].first;
*writeCode (nextEntry);
*lastCode := nextEntry;
*INC (nextEntry);
*
(END;
(
(code := readCode ();
"(*
"toBuffer (15C); toBuffer (12C);
"toBuffer (HexToStr (code, 0)); toBuffer ('=');
"*)
&END;
&*)
&ASSEMBLER
 whileStart
(TST.W   endOfSource(A6)
(BNE.W   whileEnd                        ; 'WHILE NOT endOfSource DO'
(
(MOVE.W  code(A6), D0
(CMP.W   #increaseWidth, D0
(BNE     elsif1
(
(ADDQ.W  #1, bitWidth(A6)
(BRA.W   ifEnd
(
 elsif1
(CMP.W   #newTable, D0
(BNE     elsif2
(
(MOVE.W  #9, bitWidth(A6)                ; 'bitWidth := 9'
(MOVE.W  #firstFreeEntry, nextEntry(A6)  ; 'nextEntry := firstFreeEntry'
(BSR     readCode
(MOVE.W  -2(A3), D0
(MOVE.W  D0, code(A6)                    ; 'code := readCode ()'
(MOVE.W  D0, lastCode(A6)                ; 'lastCode := code'
(BSR     writeCode                       ; 'writeCode (code)'
(BRA.W   ifEnd
 
 elsif2
(CMP.W   nextEntry(A6), D0
(BCC     else
(
(MOVE.W  D0, (A3)+
(BSR     writeCode                       ; 'writeCode (code)'
(MOVE.L  table(A6), A0
(MOVE.L  A0, A1
(MOVE.L  A0, A2
(MOVE.W  nextEntry(A6), D1
(EXT.L   D1
(LSL.L   #2, D1
(ADDA.L  D1, A0
(MOVE.W  lastCode(A6), D1
(MOVE.W  D1, D2
(EXT.L   D1
(LSL.L   #2, D1
(ADDA.L  D1, A1
(MOVE.W  code(A6), D1
(EXT.L   D1
(LSL.L   #2, D1
(ADDA.L  D1, A2
(
(; table^[nextEntry].prefix := lastCode;
(;
(MOVE.W  D2, decodeTaElem.prefix(A0)
(
(; table^[nextEntry].first  := table^[lastCode].first;
(;
(MOVE.B  decodeTaElem.first(A1), decodeTaElem.first(A0)
(
(;  table^[nextEntry].last   := table^[code].first;
(;
(MOVE.B  decodeTaElem.first(A2), decodeTaElem.last(A0)
(
(ADDQ.W  #1, nextEntry(A6)               ; 'INC (nextEntry)'
(MOVE.W  code(A6), lastCode(A6)          ; 'lastCode := code'
(BRA     ifEnd
 
 else
(MOVE.L  table(A6), A0
(MOVE.L  A0, A1
(MOVE.W  nextEntry(A6), D1
(MOVE.W  D1, D2
(EXT.L   D1
(LSL.L   #2, D1
(ADDA.L  D1, A0
(MOVE.W  lastCode(A6), D1
(EXT.L   D1
(LSL.L   #2, D1
(ADDA.L  D1, A1
(
(; table^[nextEntry].prefix := lastCode;
(;
(MOVE.W  lastCode(A6), decodeTaElem.prefix(A0)
(
(; table^[nextEntry].first  := table^[lastCode].first;
(;
(MOVE.B  decodeTaElem.first(A1), D0
(MOVE.B  D0,  decodeTaElem.first(A0)
(
(; table^[nextEntry].last   := table^[lastCode].first;
(;
(MOVE.B  D0, decodeTaElem.last(A0)
(
(MOVE.W  D2, (A3)+
(BSR     writeCode                       ; 'writeCode (nextEntry)'
(MOVE.W  nextEntry(A6), lastCode(A6)     ; 'lastCode := nextEntry'
(ADDQ.W  #1, nextEntry(A6)               ; 'INC (nextEntry)'
 
 ifEnd
(BSR     readCode
(MOVE.W  -(A3), code(A6)                 ; 'code := readCode ()'
(BRA     whileStart
 
 whileEnd
&END;
&DEALLOCATE (table, 0 (* TSIZE(decodeTaElem) * LONG (maxTable + 1)*) );
&
&IF destLen = 0L THEN
(success:= TRUE
&END;
&ASSEMBLER MOVEQ #2,D1 END;
$ELSE
&(* ungltige Kennung! *)
&ASSEMBLER MOVEQ #4,D1 END;
$END;
"END Decode;
 
 PROCEDURE GetInfo (     code:   ADDRESS;
4VAR type:   CARDINAL;
4VAR length: LONGCARD );
"VAR pl: POINTER TO LONGCARD;
&pc: ptrCard;
"BEGIN
$pc:= code;
$pl:= code + 2L;
$type:= pc^;
$length:= pl^
"END GetInfo;
 
 END Compressions.
  
(* $FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$000000ED$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEA7F3A$000015C8$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$FFEC9820$000021E3$FFEC9820$FFEC9820$FFEC9820$0000002ET.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000031EC$00003384$0000337B$000031A4$0000426C$000042AB$000042A0$00004261$0000428E$0000424F$000032F6$0000002E$0000006E$00000035$000000ED$00003188*)
