 IMPLEMENTATION MODULE ResHandler;
 (*$R-,Y+*)
 (*  $S- findet sich weiter unten! *)
 
 (*------------------------------------------------------------------------------
!* Version 1.3
!*------------------------------------------------------------------------------
!* Copyright  1989, 1990 by Michael Seyfried
!*------------------------------------------------------------------------------
!*       89 MS 1.0  Ersterstellung aus SysLibDemo
!* 29.09.89 MS 1.1  Vorschlge von Thomas Tempelmann bercksichtigt
!* 30.09.89 MS 1.1a Kleine Korrekturen; Modul erfolgreich ausgetestet.
!* 02.01.90 MS 1.1a Modul mit korrigiertem Loader erfolgreich ausgetestet.
!* 12.05.90 MS 1.3  Namensnderungen von TT bernommen. Die Freigabeprozedur hat
!*                  nun einen zustzlichen Parameter, mit dessen Hilfe man fest-
!*                  stellen kann, ob sie vom Benutzer oder vom System aufgerufen
!*                  wird.
!* 27.05.90 TT      Doku in Def-Modul korrigiert (Kommata, usw), sowie im Modul-
!*                  Kopf 2 neue Abstze (am Ende). Statt ErrBase.RaiseError wird
!*                  SystemError.OutOfMemory aufgerufen
!* 30.05.90 TT      $Y+ eingefgt
!* 10.11.90 TT      $S- weiter unten eingefgt
!*------------------------------------------------------------------------------
!*)
 
 FROM SYSTEM IMPORT ADDRESS, ADR;
 
 FROM MOSGlobals IMPORT MemArea;
 
 FROM SystemError IMPORT OutOfMemory;
 
 FROM PrgCtrl IMPORT CatchProcessTerm, TermCarrier, SetEnvelope, EnvlpCarrier;
 
 FROM ResCtrl IMPORT CatchRemoval, RemovalCarrier;
 
 FROM Storage IMPORT SysAlloc, DEALLOCATE; (* Systemmodul, daher 'SysAlloc' *)
 
 FROM Strings IMPORT Relation;
 
 FROM Lists IMPORT List, SysCreateList, DeleteList, ResetList, AppendEntry,
2PrevEntry, NextEntry, CurrentEntry, RemoveEntry, FindEntry,
2ListEmpty, LCarrier, InsertEntry;
 
 (*
 IMPORT Terminal;
 
 IMPORT Strings;
 
 IMPORT StrConv;
 
 FROM SYSTEM IMPORT LONGWORD, VAL;
 *)
 
 
 CONST SysLevel        = -1;         (* Systemlevel *)
 
 TYPE  Resource = POINTER TO List;
 
&ListEntry = RECORD
4level: INTEGER;       (* Systemlevel der Resource *)
4resHdl: ADDRESS;      (* Kennung der Resource *)
4delProc: CloseProc;   (* Freigabe-Prozedur *)
2END;
 
&PtrListEntry = POINTER TO ListEntry;
 
 VAR   MyLevel: INTEGER;                   (* aktuelles Systemlevel *)
&ResListList: List;                  (* Liste aller Resource-Listen *)
 
 
 (*
 (* Die folgenden Prozeduren sind fr's Debugging gedacht. Ich habe sie
!* vorsichtshalber nicht gelscht (man kann nie wissen). Das Modul ist
!* mit Hilfe dieser Routinen und 'SysLibDemo' ausgetestet worden. Es
!* sollte also weitgehend ohne Fehler sein.
!*)
 PROCEDURE Info( msg: ARRAY OF CHAR);
"BEGIN
$Terminal.WriteString( msg);
$Terminal.WriteLn
"END Info;
 
 PROCEDURE Wait;
"VAR wait: CHAR;
"BEGIN
$Terminal.WriteString( 'waiting ');
$Terminal.Read( wait)
"END Wait;
 
 PROCEDURE ShowLHex( LongWord: LONGWORD);
"VAR Str: Strings.String;
"BEGIN
$Str:= StrConv.LHexToStr( VAL( LONGCARD, LongWord), 10);
$Terminal.WriteString( Str);
$Terminal.WriteLn;
"END ShowLHex;
 
 PROCEDURE ShowResource( ResList: Resource);
"VAR OldCurrent: LCarrier;
&EntryPtr: PtrListEntry;
"BEGIN
$OldCurrent:= ResList^.current;
$Info( 'ShowResource');
$ShowLHex( ResList);
$ResetList( ResList^);
$WHILE NextEntry( ResList^) # NIL DO
&EntryPtr:= CurrentEntry( ResList^);
&ShowLHex( EntryPtr^.resHdl)
$END;
$Wait;
$ResList^.current:= OldCurrent;
"END ShowResource;
 
 PROCEDURE ShowList( list: List);
"VAR OldCurrent: LCarrier;
"BEGIN
$OldCurrent:= list.current;
$Info( 'ShowList');
$ResetList( list);
$WHILE NextEntry( list) # NIL DO
&ShowLHex( CurrentEntry( list))
$END;
$Wait;
$list.current:= OldCurrent;
"END ShowList;
 *)
 
 
 PROCEDURE CreateResource( VAR ResList: Resource; VAR error: BOOLEAN);
 
"VAR voidB: BOOLEAN;
 
"BEGIN
$SysAlloc( ResList, SIZE( ResList^));
$IF ResList # NIL THEN
&SysCreateList( ResList^, error);
&IF error THEN
((* Fehler => Speicher freigeben *)
(DEALLOCATE( ResList, 0)
&ELSE
((* Resource-Liste am Anfang der Liste der Resource-Listen einfgen *)
(ResetList( ResListList);
(InsertEntry( ResListList, ResList, error);
(IF error THEN
*(* im Fehlerfall Speicher wieder freigeben *)
*DeleteList( ResList^, voidB);
*DEALLOCATE( ResList, 0)
(END
&END
$ELSE
&error:= TRUE;
$END;
"END CreateResource;
 
 PROCEDURE insertResource(     useLevel: INTEGER;
>ResList: Resource;
>ResHdl: ADDRESS;
>ResDel: CloseProc;
:VAR error: BOOLEAN);
 
"VAR EntryPtr: PtrListEntry;
&OldCurrent: LCarrier;
 
"BEGIN
$SysAlloc( EntryPtr, SIZE( EntryPtr^));
$IF EntryPtr # NIL THEN
&WITH EntryPtr^ DO
(level:= useLevel;
(resHdl:= ResHdl;
(delProc:= ResDel
&END;
 
&(* 'current' merken *)
&OldCurrent:= ResList^.current;
 
&(* Neues Element am Anfang der Liste einfgen *)
&ResetList( ResList^);
&InsertEntry( ResList^, EntryPtr, error);
 
&(* 'current' zurckschreiben *)
&ResList^.current:= OldCurrent;
$ELSE
&error:= TRUE
$END;
"END insertResource;
 
 PROCEDURE InsertHandle(     ResList: Resource;
>ResHdl: ADDRESS;
>ResDel: CloseProc;
:VAR error: BOOLEAN);
"BEGIN
$insertResource( MyLevel, ResList, ResHdl, ResDel, error)
"END InsertHandle;
 
 PROCEDURE InsertSysHandle(     ResList: Resource;
AResHdl: ADDRESS;
AResDel: CloseProc;
=VAR error: BOOLEAN);
"BEGIN
$insertResource( SysLevel, ResList, ResHdl, ResDel, error)
"END InsertSysHandle;
 
 PROCEDURE HandleInList( ResList: Resource; ResHdl: ADDRESS): BOOLEAN;
 
"VAR EntryPtr: PtrListEntry;
&OldCurrent: LCarrier;
 
"BEGIN
$OldCurrent:= ResList^.current;
$ResetList ( ResList^ );
$WHILE NextEntry ( ResList^ ) # NIL DO
&EntryPtr:= CurrentEntry ( ResList^ );
&IF EntryPtr^.resHdl = ResHdl THEN
(ResList^.current:= OldCurrent;
(RETURN TRUE
&END
$END;
$ResList^.current:= OldCurrent;
$RETURN FALSE
"END HandleInList;
 
 PROCEDURE FirstHandle( ResList: Resource): ADDRESS;
 
"VAR EntryPtr: PtrListEntry;
 
"BEGIN
$ResetList( ResList^);
$EntryPtr:= NextEntry( ResList^);
$IF EntryPtr = NIL THEN
&RETURN NIL
$ELSE
&RETURN EntryPtr^.resHdl
$END
"END FirstHandle;
 
 PROCEDURE NextHandle( ResList: Resource): ADDRESS;
 
"VAR EntryPtr: PtrListEntry;
 
"BEGIN
$EntryPtr:= NextEntry( ResList^);
$IF EntryPtr = NIL THEN
&RETURN NIL
$ELSE
&RETURN EntryPtr^.resHdl
$END
"END NextHandle;
 
 
 (*$S-  ab hier kein Stackcheck mehr *)
 
 
 PROCEDURE ResourceDelete( EntryPtr: PtrListEntry; user: BOOLEAN);
 
"BEGIN
$WITH EntryPtr^ DO
&delProc( resHdl, user)
$END;
$DEALLOCATE( EntryPtr, 0);
"END ResourceDelete;
 
 PROCEDURE RemoveHandle( ResList: Resource; ResHdl: ADDRESS);
 (*
!* ResList^.current wird nur verndert, wenn dieser Zeiger auf das zu lschende
!* Listenelement zeigt. Dann zeigt er anschlieend auf den Vorgnger. Dies ist
!* wichtig, damit 'RemoveHandle' auch zwischen 'FirstHandle' und
!* 'NextHandle' verwendet werden kann.
!*)
"VAR error, setOldCurrent: BOOLEAN;
&EntryPtr: PtrListEntry;
&OldCurrent: LCarrier;
 
"BEGIN
$OldCurrent:= ResList^.current;
$ResetList ( ResList^ );
$WHILE NextEntry ( ResList^ ) # NIL DO
&EntryPtr:= CurrentEntry ( ResList^ );
&IF EntryPtr^.resHdl = ResHdl THEN
(setOldCurrent:= OldCurrent # ResList^.current;
(RemoveEntry( ResList^, error);        (* Aus Liste lschen *)
(IF setOldCurrent THEN
*ResList^.current:= OldCurrent
(END;
(ResourceDelete( EntryPtr, TRUE);      (* Freigabe-Prozedur aufrufen *)
(RETURN                                (* nur ein Handle lschen *)
&END
$END;
$ResList^.current:= OldCurrent
"END RemoveHandle;
 
 PROCEDURE ResListCloseLevel( ResList: Resource);
 
"VAR EntryPtr: PtrListEntry;
&error: BOOLEAN;
 
"BEGIN
$ResetList ( ResList^ );
$WHILE NextEntry ( ResList^) # NIL DO
&EntryPtr:= CurrentEntry ( ResList^ );
&IF EntryPtr^.level >= MyLevel THEN
(RemoveEntry( ResList^, error);        (* Aus Liste lschen *)
(ResourceDelete( EntryPtr, FALSE);     (* Freigabe-Prozedur aufrufen *)
&END
$END;
"END ResListCloseLevel;
 
 PROCEDURE CloseLevel;
"(*
#* Schliet alle Zugriffe, die unter dem gerade beendeten Proze
#* geffnet wurden.
#*)
"BEGIN
$ResetList ( ResListList);
$WHILE NextEntry ( ResListList) # NIL DO
&(* fr alle Resource-Listen ... *)
&ResListCloseLevel( CurrentEntry( ResListList)); (* Eintrge schlieen *)
$END;
"END CloseLevel;
 
 PROCEDURE Envelope ( starting, inChild: BOOLEAN; VAR exitCode: INTEGER );
"BEGIN
$IF inChild THEN
&IF starting THEN
(INC ( MyLevel );
&ELSE
(CloseLevel;
(DEC ( MyLevel )
&END
$END
"END Envelope;
 
 PROCEDURE Removal;
 
"PROCEDURE DeleteResList( ResList: Resource);
"(*
#* Es werden alle Eintrge aus der Liste entfernt. Anschlieend wird die Liste
#* gelscht.
#*)
$VAR EntryPtr: PtrListEntry;
(error: BOOLEAN;
 
$BEGIN
&(* Zunchst Liste leeren *)
&ResetList( ResList^);
&WHILE NextEntry( ResList^) # NIL DO
((* Die Listenelemente selbst werden nicht gelscht, da Sys-Resourcen !
)* (Andere Resourcen wurden schon bei 'CloseLevel' geschlossen.)
)*)
(EntryPtr:= CurrentEntry( ResList^);
(DEALLOCATE( EntryPtr, 0);
(RemoveEntry( ResList^, error);
&END;
 
&(* Liste selbst lschen *)
&DeleteList( ResList^, error);
 
&DEALLOCATE( ResList, 0);
$END DeleteResList;
 
"VAR error: BOOLEAN;
 
"BEGIN
$(* Die Resource-Listen werden gelscht, da das Modul gerade terminiert.
%* Alle Resourcen, die mit 'InsertSysHandle' in eine Liste eingefgt
%* wurden, bleiben aber geffnet !!
%*)
 
$(* Zunchst alle Resource-Listen lschen *)
$ResetList( ResListList);
$WHILE NextEntry( ResListList) # NIL DO
&DeleteResList( CurrentEntry( ResListList));
&RemoveEntry( ResListList, error);
$END;
 
$(* Nun leere Liste der Resource-Listen lschen *)
$DeleteList( ResListList, error);
"END Removal;
 
 VAR tCarrier: TermCarrier;
$eCarrier: EnvlpCarrier;
$rCarrier: RemovalCarrier;
 
 PROCEDURE InitModule(): BOOLEAN;
 
"VAR error: BOOLEAN;
&wsp: MemArea;
 
"BEGIN
$MyLevel:= 0;
$(* Liste der Resource - Listen anlegen *)
$SysCreateList( ResListList, error);
$IF error THEN
&RETURN FALSE
$ELSE
&wsp.bottom:= NIL;
&CatchProcessTerm ( tCarrier, CloseLevel, wsp );
&SetEnvelope ( eCarrier, Envelope, wsp );
&CatchRemoval ( rCarrier, Removal, wsp );
&RETURN TRUE
$END;
"END InitModule;
 
 BEGIN
"IF NOT InitModule() THEN
$OutOfMemory
"END
 END ResHandler.
 
(* $FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$FFEF8D6E$000004D3T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00001598$00002542$000013FE$0000005A$000004AF$000004C5$000004D3$FFEE2C3C$000020BE$00001FD2$00001949$0000197F$00001859$00001B59$00001759$00001763*)
