 MODULE Archive;
 
 (*
!* Lscht Archive-Bit bei COPYMM2F-Files, wenn gewnscht.
!*)
 
 IMPORT GEMDOSIO; (*$E MOS *)
 
 FROM InOut IMPORT Write, WriteLn, WriteString, WriteInt, Read, ReadString,
(WritePg;
 
 FROM Paths IMPORT SearchFile, ListPos;
 FROM PathEnv IMPORT HomePath;
 
 FROM ShellMsg IMPORT ShellPath, StdPaths;
 
 FROM Files IMPORT File, Access, Open, Close, Create, State,
(replaceOld, GetDateTime, SetDateTime;
 
 FROM MOSGlobals IMPORT Date, Time;
 
 FROM Clock IMPORT PackDate, PackTime;
 
 FROM Binary IMPORT FileSize, WriteBytes, ReadBytes;
 
 FROM Directory IMPORT MakeFullPath, DirQuery, DirEntry, SetFileAttr,
(GetFileAttr, QueryFiles, QueryAll, FileAttr, FileAttrSet;
 
 FROM FileNames IMPORT ValidatePath, FilePrefix;
 
 FROM Strings IMPORT String, StrEqual, Append, Assign, Length, Space, Upper,
(Concat;
 
 FROM SYSTEM IMPORT ADDRESS, ADR, TSIZE, BYTE, WORD, LONGWORD, ASSEMBLER;
 
 VAR subdirs, ok: BOOLEAN;
$res: INTEGER;
$fOld, fNew: File;
$buf: ARRAY [1..$8000] OF CARDINAL;
 
 PROCEDURE error (s, m: ARRAY OF CHAR);
"VAR ch: CHAR;
"BEGIN
$WriteLn;
$WriteString (s);
$Write (' ');
$WriteString (m);
$Read (ch);
"END error;
 
 PROCEDURE checkFile (REF path: ARRAY OF CHAR; entry: DirEntry): BOOLEAN;
 
"VAR old, new: String;
&n: LONGCARD;
&s1, s2: LONGCARD;
&dat1, dat2: Date;
&tim1, tim2: Time;
&attr: FileAttrSet;
&ch: CHAR;
 
"BEGIN
$Concat (path, entry.name, old, ok);
$IF subdirAttr IN entry.attr THEN
&IF entry.name[0] # '.' THEN
(IF StrEqual ('ST_FPU', FilePrefix (entry.name))
(OR StrEqual ('TT_FPU', FilePrefix (entry.name))
(OR StrEqual ('LIB_SRC', FilePrefix (entry.name))
(OR StrEqual ('PACKER', FilePrefix (entry.name))
(OR StrEqual ('MAXIDISK', FilePrefix (entry.name))
(OR StrEqual ('TEMPLMON', FilePrefix (entry.name)) THEN
*(* diese Dateien nicht kopieren *)
*RETURN TRUE
(END;
(Append ('\*.*', old, ok);
(DirQuery (old, QueryAll, checkFile, res);
(Close (fOld);
(Close (fNew);
(IF res < 0 THEN
*error (old, "Can't access subdir");
(END
&END
$ELSE
&IF StrEqual ('MM2DEF.M2L', entry.name)
&OR StrEqual ('DEF_1.TOS', entry.name)
&OR StrEqual ('DEF_2.TOS', entry.name)
&OR StrEqual ('MOS.TOS', entry.name)
&OR StrEqual ('MOS.LZH', entry.name)
&OR StrEqual ('LIB_SRC.TOS', entry.name)
&OR StrEqual ('UTILITY.LZH', entry.name)
&OR StrEqual ('UTILITY.TOS', entry.name)
&OR StrEqual ('XREF.TXT', entry.name)
&OR StrEqual ('HINWEIS.TXT', entry.name)
&OR StrEqual ('MM2TINYS.M2B', entry.name)
&OR StrEqual ('MM2TINYS.M2P', entry.name)
&OR StrEqual ('MM2SHELL.M2B', entry.name)
&OR StrEqual ('MM2SHELL.M2P', entry.name) THEN
((* diese Dateien nicht kopieren *)
(RETURN TRUE
&END;
&SearchFile (entry.name, StdPaths, fromStart, ok, new);
&IF ok THEN
(GetFileAttr (new, attr, res);
(
((* Zeitvergleich: *)
(Open (fOld, old, readOnly);
(IF State (fOld) < 0 THEN
*error (old, 'Open error');
*RETURN TRUE
(END;
(Open (fNew, new, readOnly);
(IF State (fNew) < 0 THEN
*error (new, 'Open error');
*Close (fOld);
*RETURN TRUE
(END;
(GetDateTime (fOld, dat1, tim1);
(GetDateTime (fNew, dat2, tim2);
(IF (PackDate (dat1) # PackDate (dat2))
(OR (PackTime (tim1) # PackTime (tim2))
(OR (FileSize (fOld) # FileSize (fNew))
(THEN
*IF archiveAttr IN attr THEN
,(* ok *)
*ELSE
,WriteLn;
,WriteString (new);
,WriteString (' is DIFF but has no archive bit set! SET it? (Y/N) ');
,REPEAT
.Read (ch);
,UNTIL (CAP (ch) = 'Y') OR (CAP (ch) = 'N');
,IF CAP (ch) = 'Y' THEN
.SetFileAttr (new, attr + FileAttrSet {archiveAttr}, res);
,END;
*END;
(ELSE
*(* Dateien sind gleich *)
*IF archiveAttr IN attr THEN
,WriteLn;
,WriteString (new);
,WriteString (' is SAME but has archive bit set! CLEAR it? (Y/N) ');
,REPEAT
.Read (ch);
,UNTIL (CAP (ch) = 'Y') OR (CAP (ch) = 'N');
,IF CAP (ch) = 'Y' THEN
.SetFileAttr (new, attr - FileAttrSet {archiveAttr}, res);
,END;
*END;
(END;
(Close (fOld);
(Close (fNew);
(
((*
(IF archiveAttr IN attr THEN
*WriteLn;
*WriteString ('archive ');
*WriteString (new);
*WriteString ('? (Y/N)');
*REPEAT
,Read (ch);
*UNTIL (CAP (ch) = 'Y') OR (CAP (ch) = 'N');
*IF CAP (ch) = 'Y' THEN
,SetFileAttr (new, attr - FileAttrSet {archiveAttr}, res);
*END;
(END;
(*)
(
&ELSE
(error (new, 'Not found!');
&END;
$END;
$RETURN TRUE
"END checkFile;
 
 PROCEDURE checkRes (): BOOLEAN;
"VAR ch: CHAR;
"BEGIN
$IF res < 0 THEN
&WriteLn;
&WriteString ('Error #');
&WriteInt (res,0);
&WriteLn;
&Read (ch);
&RETURN TRUE
$END;
$RETURN FALSE
"END checkRes;
 
 VAR     n1: String;
(ch: CHAR;
 
 BEGIN
"HomePath:= ShellPath;
"WriteLn;
"DirQuery ('F:\MASTER\*.*', QueryAll, checkFile, res);
"Close (fOld);
"Close (fNew);
"IF checkRes () THEN END;
"WriteLn;
 END Archive.
 
(* $FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$00001062$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$FFEEC08C$00000E86T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000E86$00000E98$00000F22$00000E7D$00000E9C$00000D4E$00000D2E$FFEF5D06$FFEF5D06$00000C98$00000CBE$00000CC8$00000F54$00000E47$00000E29$00000E79*)
