 IMPLEMENTATION MODULE TOSDebug;(* V#053 *)  (* berarbeitet von M.Grebe *)
 (*$B+,R-,F-*)
 
 (*
"Stand Nov. 1991:
$- Der Debugger reserviert sich einen eigenen Bildschirm und speichert
&die Cursorpositionen zwischen, soda der Bildschirmaufbau nicht mehr
&gestrt wird.
$- Mit T lt sich eine Protokollierung der Ausgabe in der Datei DEBUG.LST
&im Root-Verzeichnis des aktuellen Laufwerks ein- bzw. ausschalten.
$- ESC schaltet auf den Programmbildschirm und zurck
$- B unterdrckt die Bildschirmausgabe, die eventuelle Protokollierung in
&eine Datei luft weiter
$- P zeigt die aktuelle Prozedur
$- L ab der aktuellen Zeile wird ein Listing der folgenden Zeilen
&bis zum Prozedur- oder Programmende ausgegeben.
$- M setzt eine Marke (B wie Breakpoint schon vergeben) hinter der der
&Programmablauf wieder unterbrochen wird.
&Die Zeilenadresse erhlt man aus L. Somit ist dieser Breakpoint
&auf die aktuelle Prozedur beschrnkt, aber immerhin
$- Z schaltet nun Zeilenadressen ab (ich brauchte L)
 
$Bekannte Fehler:
&Luft nicht mit Programmen, die selbst den Bildschirm umlegen.
&Man knnte es zwar einbauen, indem man sich immer die aktuellen
&Adressen holt, ich habe es aber noch nie grbraucht - drum.
 *)
 
 FROM SYSTEM IMPORT ADR,ADDRESS,ASSEMBLER,BYTE,CAST,WORD,LONGWORD;
 
 FROM Excepts IMPORT InstallPreExc;
 
 FROM PrgCtrl IMPORT TermProcess,CatchProcessTerm,TermCarrier;
 
 FROM Strings IMPORT Assign,Empty,Insert,Length;
 
 FROM MOSGlobals IMPORT UserBreak,MemArea;
 
 FROM SysTypes IMPORT ExcSet,TRAP5,ExcDesc;
 
 FROM Terminal IMPORT GotoXY,Read,Write,WriteLn,CondRead,WriteString,
5FlushKbd,ReadString;
 
 FROM ModCtrl IMPORT GetModName;
 
 FROM SysUtil1 IMPORT Peek;
 
 FROM Files IMPORT Access,ReplaceMode,Create,Close,File;
 
 FROM GEMDOS IMPORT Alloc,Free;
 
 FROM XBIOS IMPORT ScreenPhysicalBase,ScreenLogicalBase,SetScreenBase,VSync;
 
 IMPORT StrConv,Text;
 
 CONST ypos=24;
&space='    ';
 
 TYPE Mode=(m2Line,asmLine,procEntry,procExit);
 
 VAR waitnext,waitkey,screen,file,debugscreen,switchscreen,breakpoint:BOOLEAN;
$outfile:File;
$allocadr,logbase,physbase,debugbase:ADDRESS;
$level:LONGINT;
$breakadr:LONGCARD;
$xpos:CARDINAL;
 
 PROCEDURE SaveCur;
 BEGIN
"Write(33C); Write('j');
 END SaveCur;
 
 PROCEDURE RestoreCur;
 BEGIN
"Write(33C); Write('k');
 END RestoreCur;
 
 PROCEDURE WriteNew(ch:CHAR);
 BEGIN
"IF screen THEN
$Write(ch);
$INC(xpos)
"END;
"IF file THEN
$Text.Write(outfile,ch)
"END;
 END WriteNew;
 
 PROCEDURE ConvTab(VAR str:ARRAY OF CHAR);
 VAR pos:CARDINAL;
$ok:BOOLEAN;
 BEGIN
"pos:=LENGTH(str);
"IF pos>0 THEN
$REPEAT
&DEC(pos);
&IF str[pos]=CHR(9) THEN
(str[pos]:=' ';
(Insert(' ',pos,str,ok);
&END
$UNTIL pos=0
"END
 END ConvTab;
 
 PROCEDURE WriteStringNew(s:ARRAY OF CHAR);
 VAR i:CARDINAL;
$ok:BOOLEAN;
$str:ARRAY[0..128] OF CHAR;
 BEGIN
"Assign(s,str,ok);
"ConvTab(str);
"IF screen THEN
$INC(xpos,Length(str));
$WriteString(str)
"END;
"IF file THEN
$Text.WriteString(outfile,str)
"END;
 END WriteStringNew;
 
 PROCEDURE WriteLnNew;
 BEGIN
"IF screen THEN
$WriteLn; xpos:=0
"END;
"IF file THEN
$Text.WriteLn(outfile)
"END;
 END WriteLnNew;
 
 PROCEDURE WriteLHex(v:LONGWORD);
 BEGIN
"WriteStringNew(StrConv.LHexToStr(v,9))
 END WriteLHex;
 
 PROCEDURE ShowProc(adr:LONGCARD);
 VAR proc,name:ARRAY [0..39] OF CHAR; rel:LONGCARD;
 BEGIN
"GetModName(adr,name,rel,proc);
"WriteLnNew;
"WriteStringNew('Modul '); WriteStringNew(name); WriteNew(',');
"WriteStringNew('Procedure '); WriteStringNew(proc); WriteLnNew;
 END ShowProc;
 
 PROCEDURE Listing(listadr:LONGCARD);
 TYPE String=ARRAY[0..255] OF CHAR;
 VAR dummy:LONGCARD;
$ptr:POINTER TO CARDINAL;
$strptr:POINTER TO String;
$ch:CHAR;
 BEGIN
"ShowProc(listadr);
"ptr:=CAST(ADDRESS,listadr-2L);
"REPEAT
$INC(ptr,2L);
$IF ptr^=$4e45 THEN
&INC(ptr,2L);
&IF (ptr^=0) OR (ptr^=10) THEN
(strptr:=CAST(ADDRESS,ptr);
(INC(strptr,2L);
(ptr:=ptr+CAST(ADDRESS,Length(strptr^)-2);
(IF ODD(ptr) THEN
*INC(ptr)
(END;
(WriteLHex(CAST(LONGCARD,ptr)+4L); WriteStringNew(strptr^); WriteLnNew;
&END
$END;
"UNTIL ptr^=$4e5d;
 END Listing;
 
 PROCEDURE dispRegs(VAR info:ExcDesc);
 BEGIN
"WriteLnNew;
"WITH info DO
$WriteStringNew('D0:');  WriteLHex(regD0);
$WriteStringNew(' D1:'); WriteLHex(regD1);
$WriteStringNew(' D2:'); WriteLHex(regD2);
$WriteStringNew(' D3:'); WriteLHex(regD3);
$WriteLnNew;
$WriteStringNew('D4:');  WriteLHex(regD4);
$WriteStringNew(' D5:'); WriteLHex(regD5);
$WriteStringNew(' D6:'); WriteLHex(regD6);
$WriteStringNew(' D7:'); WriteLHex(regD7);
$WriteLnNew;
$WriteStringNew('A0:');  WriteLHex(regA0);
$WriteStringNew(' A1:'); WriteLHex(regA1);
$WriteStringNew(' A2:'); WriteLHex(regA2);
$WriteStringNew(' A3:'); WriteLHex(regA3);
$WriteLnNew;
$WriteStringNew('A4:');  WriteLHex(regA4);
$WriteStringNew(' A5:'); WriteLHex(regA5);
$WriteStringNew(' A6:'); WriteLHex(regA6);
$WriteStringNew(' A7:'); WriteLHex(regUSP);
"END
 END dispRegs;
 
 PROCEDURE dispLine(mode:Mode; VAR info:ExcDesc);
 VAR buffered:BOOLEAN; bufCh:CHAR;
 
"PROCEDURE KeyPress():BOOLEAN;
"BEGIN
$CondRead(bufCh,buffered);
$RETURN buffered
"END KeyPress;
 
"PROCEDURE GetKey(VAR ch:CHAR);
"BEGIN
$IF buffered THEN
&buffered:=FALSE;
&ch:=bufCh
$ELSE
&Read(ch)
$END
"END GetKey;
 
 VAR ch:CHAR;
$s:ARRAY[0..9] OF CHAR;
$p:CARDINAL;
$done,ok:BOOLEAN;
$ps:POINTER TO ARRAY[0..160] OF CHAR;
$proc,name:ARRAY[0..39] OF CHAR;
$rel:LONGCARD;
 
 BEGIN(* dispLine *)
"IF Active THEN
$Step:=0L
"END;
"IF (Step<>0L) THEN
$DEC(Step);
$IF (Step=0L) OR breakpoint THEN
&Active:=TRUE; Continuous:=FALSE; switchscreen:=TRUE; breakadr:=0L;
&SetScreenBase(debugbase,debugbase,-1);
&VSync;
&GotoXY(xpos,ypos); WriteLn;
$END
"END;
"xpos:=0;
"IF waitkey THEN
$buffered:=FALSE;
$IF ~Continuous OR KeyPress() THEN
&IF Step<>0L THEN
(SetScreenBase(debugbase,debugbase,-1);
(VSync;
(Active:=TRUE; Continuous:=FALSE; switchscreen:=TRUE;
&END;
&REPEAT
(GetKey(ch);
(ok:=TRUE;
(CASE CAP(ch) OF
*11C : SetScreenBase(debugbase,-1L,-1);              (* Tab *)
0VSync;
0Write(33C); Write('E'); ok:=FALSE |
*33C : debugscreen:=~debugscreen; ok:=FALSE;          (* ESC *)
0IF debugscreen THEN
2SetScreenBase(-1L,debugbase,-1)
0ELSE
2SetScreenBase(-1L,physbase,-1)
0END;
0VSync |
*15C : Continuous:=TRUE|                            (* RETURN *)
*' ' : Continuous:=FALSE|                           (* SPACE *)
*3C  : TermProcess(UserBreak)|                      (* CTRL-C *)
*'A' : Step:=0L; Active:=TRUE; Continuous:=FALSE |
*'S' : WriteString('Step? '); ReadString(s); p:=0;
0Step:=StrConv.StrToLCard(s,p,done);
0IF done THEN
2Active:=FALSE; Continuous:=TRUE;
2switchscreen:=FALSE;
0END|
*'Z' : LineAddr:=~LineAddr; ok:=FALSE|
*'H' : Hex:=TRUE; ok:=FALSE|
*'D' : Hex:=FALSE; ok:=FALSE|
*'R' : dispRegs(info); ok:=FALSE|
*'B' : screen:=~screen; ok:=FALSE;
0IF screen THEN
2WriteString('Bildschirmausgabe aktiv'); switchscreen:=TRUE;
0ELSE
2WriteString('Bildschirmausgabe inaktiv'); switchscreen:=FALSE;
0END;
0WriteLn |
*'M' : WriteString('Breakpoint nach Zeile an Adresse:'); ReadString(s); p:=0;
0breakadr:=StrConv.StrToLCard(s,p,done);
0IF done THEN
2Active:=FALSE; Continuous:=TRUE; Step:=4294967295;
2switchscreen:=FALSE;
0ELSE
2breakadr:=0L;
0END;
0breakpoint:=FALSE |
*'T' : file:=~file; ok:=FALSE;
0IF file THEN
2WriteString('Dateiausgabe aktiv')
0ELSE
2WriteString('Dateiausgabe inaktiv')
0END;
0WriteLn |
*'L' : Listing(info.regPC); ok:=FALSE |
*'P' : ShowProc(info.regPC); ok:=FALSE |
(ELSE
*ok:=FALSE
(END
&UNTIL ok
$END
"END;
"IF waitnext THEN
$FlushKbd; waitkey:=TRUE; waitnext:=FALSE
"END;
"ps:=info.regPC;                   (* PC hinter Zeilentext setzen *)
"INC(info.regPC,Length(ps^)+1);
"IF ODD(info.regPC) THEN
$INC(info.regPC)
"END;
"IF breakadr=info.regPC THEN
$breakpoint:=TRUE
"END;
"IF Active THEN                     (* Zeile anzeigen *)
$WriteLnNew;
$IF (mode=m2Line) OR (mode=asmLine) THEN
&WriteLnNew;
&IF LineAddr THEN
(WriteLHex(info.regPC);
(WriteStringNew(':');
(GetModName(info.regPC,name,rel,proc);
(WriteStringNew(name);
(WriteStringNew(' / ');
(IF ~Empty(proc) THEN
*WriteStringNew(proc)
(ELSE
*WriteStringNew(StrConv.LHexToStr(rel,5))
(END;
(WriteLnNew;
&END;
&IF ps^[0]=12C (* LF *) THEN
(INC(ps)
&END;
&WriteStringNew(ps^);
&WriteLnNew;
$ELSE
&IF mode=procEntry THEN
(WriteStringNew('Enter '); INC(level);
&ELSE
(WriteStringNew('                                   Exit '); DEC(level);
&END;
&WriteStringNew(ps^);
&WriteStringNew(' ('); WriteStringNew(StrConv.IntToStr(level,0)); WriteNew(')');
$END;
"END;
"SetScreenBase(logbase,physbase,-1);
"VSync;
 END dispLine;
 
 
 PROCEDURE HdlExc(VAR info:ExcDesc):BOOLEAN;
 
"PROCEDURE loadValue(VAR v:ARRAY OF BYTE);
"(* holt Wert vom A3-Stack und korrigiert A3 dabei auch *)
"VAR n:CARDINAL;
"BEGIN
$n:=HIGH(v);
$IF n=0 THEN
&INC(n)
$END;
$DEC(info.regA3.p,n+1);
$Peek(info.regA3.p,v);
"END loadValue;
 
"PROCEDURE dispNum(size:CARDINAL; signed:BOOLEAN);
"VAR by:BYTE;
&wd:WORD;
&lw:LONGWORD;
"BEGIN
$IF size=4 THEN
&loadValue(lw);
$ELSE
&IF size=2 THEN
(loadValue(wd);
&ELSE
(loadValue(by);
(IF signed THEN
*wd:=WORD(INT(by))
(ELSE
*wd:=WORD(ORD(by))
(END
&END;
&IF signed THEN
(lw:=LONGWORD(LONG(INTEGER(wd)))
&ELSE
(lw:=LONGWORD(LONG(CARDINAL(wd)))
&END
$END;
$IF Active THEN
&IF Hex THEN
(WriteStringNew(StrConv.LHexToStr(lw,0))
&ELSIF signed THEN
(WriteStringNew(StrConv.IntToStr(LONGINT(lw),0));
&ELSE
(WriteStringNew(StrConv.CardToStr(LONGCARD(lw),0));
&END
$END;
"END dispNum;
 
"PROCEDURE dispChar();
"VAR ch:CHAR;
"BEGIN
$loadValue(ch);
$IF Active THEN
&IF ch<' ' THEN       (* Steuerzeichen als Oktalkonstante anzeigen *)
(WriteStringNew(StrConv.NumToStr(ORD(ch),8,0,' '));
(WriteNew('C')
&ELSE
(WriteNew("'");
(WriteNew(ch);
(WriteNew("'");
&END
$END;
"END dispChar;
 
"PROCEDURE dispReal(long:BOOLEAN);
"VAR sr:REAL;
&lr:LONGREAL;
"BEGIN
$IF long THEN
&loadValue(lr)
$ELSE
&loadValue(sr);
&lr:=LONG(sr)
$END;
$IF Active THEN
&WriteStringNew(StrConv.RealToStr(lr,0,6))
$END;
"END dispReal;
 
"PROCEDURE dispBool();
"VAR b:BOOLEAN;
"BEGIN
$loadValue(b);
$IF Active THEN
&IF b THEN
(WriteStringNew('TRUE ')
&ELSE
(WriteStringNew('FALSE')
&END
$END;
"END dispBool;
 
"PROCEDURE dispString();
"(* Fr Strings werden Adresse und HIGH-Wert auf dem A3-Stack abgelegt *)
"VAR high:CARDINAL;
&ptr:POINTER TO CHAR;
"BEGIN
$loadValue(high);
$loadValue(ptr);
$IF Active THEN
&WriteNew('"');
&LOOP
(IF ptr^=0C THEN
*EXIT
(END;
(WriteNew(ptr^);
(INC(ptr);
(IF high=0 THEN
*EXIT
(END;
(DEC(high)
&END;
&WriteNew('"')
$END;
"END dispString;
 
 VAR no:CARDINAL;
$old:BOOLEAN;
 
 BEGIN
"SaveCur;
"IF switchscreen THEN
$SetScreenBase(debugbase,debugbase,-1);
$VSync
"END;
"GotoXY(xpos,ypos);
"no:=CARDINAL(info.regPC^);
"INC(info.regPC,2);
"CASE no OF
%0 : dispLine(m2Line,info)|
$64 : dispLine(asmLine,info)|
$66 : dispLine(procEntry,info)|
$67 : dispLine(procExit,info)|
"ELSE
$CASE no OF
*1,4 : dispNum(4,TRUE)|
,2 : dispReal(TRUE)|
+40 : dispReal(FALSE)|
,3 : dispChar()|
&35,34,9 : dispNum(2,FALSE)|
 8,20,23,25,26 : old:=Hex; Hex:=TRUE; dispNum(4,FALSE); Hex:=old|
(21,41 : old:=Hex; Hex:=TRUE; dispNum(2,FALSE); Hex:=old|
(30,22 : dispNum(4,FALSE)|
+24 : dispBool()|
+27 : dispString()|
+33 : dispNum(2,TRUE)|
(38,39 : old:=Hex; Hex:=TRUE; dispNum(1,FALSE); Hex:=old|
$ELSE
(DEC(info.regPC,2);
(SetScreenBase(logbase,physbase,-1);
(VSync;
(RETURN TRUE
$END;
$IF Active THEN
&WriteStringNew('   ')
$END
"END;
"SetScreenBase(logbase,physbase,-1);
"VSync;
"RestoreCur;
"RETURN FALSE
 END HdlExc;
 
 VAR stk:ARRAY[1..2000] OF WORD;
$wsp:MemArea;
$hdl:ADDRESS;
$tHdl:TermCarrier;
 
 PROCEDURE Terminate;
 VAR ch:CHAR;
 BEGIN
"WriteLnNew;
"screen:=TRUE;
"WriteStringNew('Programmende:Bitte Taste...');
"Close(outfile);
"Read(ch);
"SetScreenBase(logbase,physbase,-1);
"VSync;
"IF allocadr<>0L THEN
$IF Free(allocadr) THEN END
"END
 END Terminate;
 
 BEGIN
"breakadr:=0L;
"Active:=TRUE;
"Step:=0L;
"Continuous:=FALSE;
"Hex:=FALSE;
"LineAddr:=FALSE;
"screen:=TRUE; file:=FALSE;
"level:=-1L;
"Create(outfile,'\DEBUG.LST',writeOnly,replaceOld);
"logbase:=ScreenLogicalBase();
"physbase:=ScreenPhysicalBase();
"Alloc(33000L,allocadr);
"IF allocadr=0L THEN
$debugbase:=logbase
"ELSE
$debugbase:=(allocadr DIV 256L)*256L+256L;
$SetScreenBase(debugbase,-1L,-1);
$VSync;
$Write(33C); Write('E');
$SetScreenBase(logbase,-1L,-1);
$VSync;
"END;
"debugscreen:=TRUE;
"switchscreen:=TRUE;
"(* damit erste Zeile sofort erscheint: *)
"waitkey:=FALSE;
"waitnext:=TRUE;
"wsp.bottom:=ADR(stk);
"wsp.length:=SIZE(stk);
"InstallPreExc(ExcSet{TRAP5},HdlExc,TRUE,wsp,hdl);
"IF hdl=NIL THEN
$HALT
"END;
"CatchProcessTerm(tHdl,Terminate,wsp);
 END TOSDebug.
 
 