; @(#)autotake.t, Dirk Haun, 05.05.1996
; Auto-Takefile fr Pure C
;
env PURE=d:\pure       ; Pure-C-Verzeichnis
env OBJ=$PURE\obj      ; Verzeichnis fr die Objektfiles
env PRGPATH=$PURE\exec ; Verzeichnis fr die ausfhrbaren Programme
env TAKE=$PURE\takes   ; Verzeichnis fr die Takefiles
env SRC=$PURE\sources  ; Verzeichnis der Quelltexte
env LIB=$PURE\lib      ; Verzeichnis, in dem die Libs stehen
env PRGEXT=app         ; Default-Extension fr neue Programme
env OPTC=-Y            ; Default-Compileroptionen
env OPTL=-L -G -Y      ; Default-Linkeroptionen
env OPTA=-Y            ; Default-Assembleroptionen
env DEFINES=-DGERMAN   ; sonstige Compileropt., z.B. Defines
;
; das fertige Programm lt sich so einfach mit "run" starten
alias run $PRGPATH\%%.$PRGEXT $*
;
;----- Makros fr Project-Files in Chatwin ---------------------------
;
macro project
  echo Project: $0
  env THECURRPATH=$CD
  env FNREM=%
  fname $0
  env PROJECT=%%
  if !$TAKE\$PROJECT.lnk || time($TAKE\$PROJECT.lnk<$TAKE\$PROJECT.t)
    echo $-O=$PRGPATH\$PROJECT.$PRGEXT >$TAKE\$PROJECT.lnk
    env CREATE=NEW
  else
    env CREATE
  endif
  env BREAK
endm
;
macro use
  if !env(BREAK=TRUE)
    shift
    fname $SHIFT
    fsplit $SHIFT
    if env(FSEXT=c) || env(FSEXT=C)
      if !$OBJ\%%.o || TIME($OBJ\%%.o<%.c)
        env CCEXT=c
        $TAKE\compile.t $*
        if $?!=0
          env BREAK=TRUE
        endif
      endif
      if env(CREATE=NEW)
        echo $OBJ\%%.o >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=s) || env(FSEXT=S)
      if !$OBJ\%%.o || TIME($OBJ\%%.o<%.s)
        $TAKE\assemble.t
        if $?!=0
          env BREAK=TRUE
        endif
      endif
      if env(CREATE=NEW)
        echo $OBJ\%%.o >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=o) || env(FSEXT=O)
      if env(CREATE=NEW)
        echo %.O >>$TAKE\$PROJECT.lnk
      endif
    elsif env(FSEXT=lib) || env(FSEXT=LIB)
      if env(CREATE=NEW)
        echo %.LIB >>$TAKE\$PROJECT.lnk
      endif
    else ; alles andere wird wie *.c behandelt
      if !$OBJ\%%.o || TIME($OBJ\%%.o<%.$FSEXT)
        env CCEXT=$FSEXT
        $TAKE\compile.t $*
        if $?!=0
          env BREAK=TRUE
        endif
      endif
      if env(CREATE=NEW)
        echo $OBJ\%%.o >>$TAKE\$PROJECT.lnk
      endif
    endif
  endif
  if env(BREAK=TRUE) && env(CREATE=NEW)
    rm -q $TAKE\$PROJECT.lnk
  endif
endm
;
macro link
  if !env(BREAK=TRUE)
    echo Linking "$PROJECT.$PRGEXT"
    ld $OPTL $* -C=$TAKE\$PROJECT.lnk >$OBJ\linker.err
    if $?
      more $OBJ\linker.err
    else
      rm $OBJ\linker.err
    endif
  endif
  fname $FNREM
  cd $THECURRPATH
  env THECURRPATH
  env FNREM
  env CREATE
  env BREAK
  env PROJECT
  env CCEXT
endm
