/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mode;

import cryptix.CryptixException;
import cryptix.provider.mode.FeedbackMode;
import java.security.Cipher;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;

public class CBC
extends FeedbackMode {
    protected byte[] xorBlock;

    public CBC() {
        super(false, false, "Cryptix");
    }

    public CBC(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public CBC(Cipher cipher, byte[] byArray) {
        this(cipher);
        this.setInitializationVector(byArray);
    }

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.xorBlock = new byte[this.length];
    }

    protected int engineBlockSize() {
        return this.length;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.cipher.initDecrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("CBC: IV is not set");
        }
        switch (this.getState()) {
            case 1: {
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = n4++;
                    this.ivBlock[n5] = (byte)(this.ivBlock[n5] ^ byArray[n++]);
                }
                this.cipher.update(this.ivBlock, 0, n2, this.ivBlock, 0);
                System.arraycopy(this.ivBlock, 0, byArray2, n3, n2);
                break;
            }
            case 2: {
                byte[] byArray3 = new byte[n2];
                System.arraycopy(byArray, n, byArray3, 0, n2);
                this.cipher.update(byArray, n, n2, this.xorBlock, 0);
                int n6 = 0;
                while (n6 < n2) {
                    byArray2[n6 + n3] = (byte)(this.xorBlock[n6] ^ this.ivBlock[n6]);
                    ++n6;
                }
                System.arraycopy(byArray3, 0, this.ivBlock, 0, n2);
                byArray3 = null;
                break;
            }
            default: {
                throw new CryptixException("CBC: Cipher not initialized");
            }
        }
        return n2;
    }
}

