/* XLIB driver module */
#include "defs.h"
#include <stdio.h>
#include <math.h>
#ifdef VMS
#include <decw$include/Xlib.h>
#include <decw$include/Xutil.h>
#include <decw$include/Xos.h>
#else	/* UNIX */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#endif
#define byte_size 8
#define BASE_INDEX 0 /* how many reserved colours ? */
/* store these pointers to allow lookups into the CGM data structures */
static struct one_opt 		*popt;	/* the command line options, in only */
static struct mf_d_struct 	*pc1;	/* the class 1 elements, in only */
static struct pic_d_struct 	*pc2;	/* the class 2 elements, in only */
static struct control_struct	*pc3;	/* the class 3 elements, in only */
static struct attrib_struct	*pc5;	/* the class 5 elements, in only */
static struct info_struct 	*dptr;	/* device info in and out */


/* these are the screen variables */
Display *display_ptr = NULL;
Screen *screen_id;
static Visual *my_visual;
static Colormap my_colormap;
Window window_id = 0, top_window_id = 0, root_id;
static int xw_size, yw_size, xw_mm, yw_mm, w_depth;
static unsigned long display, parent_id, width, height, 
  border_width, border_height, border_id, background_id;
static long x_coord, y_coord;
static int no_planes, release_no, no_cells, no_screens;
#define MONOCHROME (no_cells <= 2) /* monochrome screen */
static char *vendor;
static unsigned long gc_mask;
/* declare the Graphics contexts we shall use */
/* the GC's for defaults, pictures and the one we use */
static GC gc_line_def, gc_line_pic, gc_line_use;
static GC gc_fill_def, gc_fill_pic, gc_fill_use;
static GC gc_edge_def, gc_edge_pic, gc_edge_use;
static XGCValues values_struct;
static XWindowAttributes window_attributes;
static unsigned int dev_type, tot_indices, colors, maps, rbits, gbits, bbits,
  ibits, res_indices, regen;
#define max_str 128
static char fname[max_str + 1];
static int fname_l;
static int state_level;
static unsigned int gbl_style = ~0;
static char file_buffer[max_str + 1], prog_buffer[max_str + 1];
extern char *allocate_mem();
static int old_index;
static int max_val;	/* maximum colour value */
#define MAX_D_VAL 65535		/* max direct colour value */
/* macro to convert from real to integer colour value */
#define ushort_col(r_col) ((unsigned short) ((r_col) * MAX_D_VAL + 0.49999))
static struct rgbi_struct back_col;
static int my_inds[3];
/* the dash and dot lists */
#define DASH_N 2
#define DOT_N 2
#define DASH_D_N 4
#define DASH_D_D_N 6
static char dash_list[DASH_N];
static char dot_list[DOT_N];
static char dash_d_list[DASH_D_N];
static char dash_d_d_list[DASH_D_D_N];
/* start everything up, beginning of CGM file */
xl_begin(comment, file_name, prog_name)
     char *comment, *file_name, *prog_name;
     
{
  /* get the default graphics contexts */
  /* note problems in mixing line widths */
  values_struct.line_width = 0; /* default */
  gc_line_def = XCreateGC(display_ptr, window_id, GCLineWidth,
			  &values_struct);
  gc_fill_def = XCreateGC(display_ptr, window_id, GCLineWidth,
			  &values_struct);
  gc_edge_def = XCreateGC(display_ptr, window_id, GCLineWidth,
			  &values_struct);
  gc_line_pic = XCreateGC(display_ptr, window_id, (unsigned long) 0,
			  &values_struct);
  gc_fill_pic = XCreateGC(display_ptr, window_id, (unsigned long) 0,
			  &values_struct);
  gc_edge_pic = XCreateGC(display_ptr, window_id, (unsigned long) 0,
			  &values_struct);
  /* make the defaults active */
  gc_line_use = gc_line_def;
  gc_fill_use = gc_fill_def;
  gc_edge_use = gc_edge_def;

  return(1);
}
/* start a picture  */
xl_bp(pic_name)
char *pic_name;
{
  /* copy over the defaults to the picture specific GC's */
  XCopyGC(display_ptr, gc_line_def, (unsigned long) ~0, gc_line_pic);
  XCopyGC(display_ptr, gc_fill_def, (unsigned long) ~0, gc_fill_pic);
  XCopyGC(display_ptr, gc_edge_def, (unsigned long) ~0, gc_edge_pic);

  /* make the picture specific GC's active */
  gc_line_use = gc_line_pic;
  gc_fill_use = gc_fill_pic;
  gc_edge_use = gc_edge_pic;

  /* now see what we got */
  if (XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    /* fill out the device info structure */
    dptr->x_size = window_attributes.width / dptr->pxl_in;
    dptr->y_size = window_attributes.height / dptr->ypxl_in;
  }
 return(1);
}
/* start a picture body  */
xl_bpage(pic_name, xoffset, yoffset, rotation, rb, gb, bb, page_no, 
	 xsize, ysize)
     char *pic_name;
     float rotation;
     int xoffset, yoffset, page_no, xsize, ysize;
     float rb, gb, bb;	/* background colour values */
{
  char *icon_name;
  XColor back_colour;
  
  /* set the icon name */ 
  if (*pic_name) icon_name = pic_name;
  else if (*file_buffer) icon_name = file_buffer;
  else if (*prog_buffer) icon_name = prog_buffer;
  else icon_name = "GPLOT";
  XSetIconName(display_ptr, window_id, icon_name);
  
  back_colour.red = ushort_col(rb);
  back_colour.green = ushort_col(gb);
  back_colour.blue = ushort_col(bb);
  XAllocColor(display_ptr, my_colormap, &back_colour);
  XSetWindowBackground(display_ptr, window_id, back_colour.pixel);
  /* clear the picture */
  XClearWindow(display_ptr, window_id);
  return(1);
  
}
/* end a page */
xl_epage(copies)
     int copies;
{
  XSync(display_ptr, False);

  return(1);
}
/* end the metafile */
xl_end(pages_done)
     int pages_done;
{
  /* free up some memory */
  if (gc_line_def) {
    XFreeGC(display_ptr, gc_line_def);
    gc_line_def = (GC) 0;
  }
  if (gc_line_use) {
    XFreeGC(display_ptr, gc_line_use);
    gc_line_use = (GC) 0;
  }
  if (gc_fill_def) {
    XFreeGC(display_ptr, gc_fill_def);
    gc_fill_def = (GC) 0;
  }
  if (gc_fill_use) {
    XFreeGC(display_ptr, gc_fill_use);
    gc_fill_use = (GC) 0;
  }
  if (gc_edge_def) {
    XFreeGC(display_ptr, gc_edge_def);
    gc_edge_def = (GC) 0;
  }
  if (gc_edge_use) {
    XFreeGC(display_ptr, gc_edge_use);
    gc_edge_use = (GC) 0;
  }
  return(1);
}
/* handle clipping */
/* set the clipping rectangle */
xl_cliprect(int_coords, float_coords)
int *int_coords;
float *float_coords; /* two corner points */
{
  Region r;
  XPoint points[4];
  points[0].x = points[1].x = int_coords[0];
  points[0].y = points[3].y = window_attributes.height - int_coords[1];

  points[2].x = points[3].x = int_coords[2];
  points[2].y = points[1].y = window_attributes.height - int_coords[3];


  r = XPolygonRegion(points, 4, EvenOddRule);
  XSetRegion(display_ptr, gc_line_use, r);
  XSetRegion(display_ptr, gc_fill_use, r);
  XSetRegion(display_ptr, gc_edge_use, r);
  return(1);
}
/* set the clipping indicator */
xl_clipindic(clip_ind)
int clip_ind;
{
	return(1);
}
/* plot a set of lines between alternate points */
xl_dpline(no_pairs, x1_ptr, y1_ptr)
     int no_pairs, *x1_ptr, *y1_ptr;
{
  
  return(1);
}
/* do line between a series of points */
xl_pline(no_pairs, x1_ptr, y1_ptr)
     int no_pairs, *x1_ptr, *y1_ptr;
{
  int i;
  XPoint *points, *this_point;
  
  /* make some memory */
  points = (XPoint *) allocate_mem(2 * no_pairs * sizeof(XPoint), 0);
  this_point = points;
  for (i=0; i<no_pairs; ++i) {
    this_point->x = x1_ptr[i];
    this_point->y = window_attributes.height - y1_ptr[i];
    ++this_point;
  }
  
  
  XDrawLines(display_ptr, window_id, gc_line_use, points,
	     no_pairs, CoordModeOrigin);
  
  (void) free(points);
  
  return(1);
}

/* do a polygon, may want to fill it */
xl_pgon(no_pairs, x1_ptr, y1_ptr)
     int no_pairs, *x1_ptr, *y1_ptr;
{
  int i;
  XPoint *points, *this_point;
  
  if ( no_pairs <= 1 ) return(1);
  /* make some memory */
  points = (XPoint *) allocate_mem(2 * (no_pairs + 1) * sizeof(XPoint), 0);
  this_point = points;
  for (i=0; i<no_pairs; ++i) {
    this_point->x = x1_ptr[i];
    this_point->y = window_attributes.height - y1_ptr[i];
    ++this_point;
  }
  /* get the last point for the outline */
  this_point->x = points->x;
  this_point->y = points->y;
  
  /* first do the polygon interior */
  switch (pc5->int_style) {
  case hollow :
  case empty : break;
  case pattern :    /* no pattern fill yet */
  case hatch :    /* no hatch fill yet */
  case solid_i :
    XFillPolygon(display_ptr, window_id, gc_fill_use, points, 
		 no_pairs, Complex, CoordModeOrigin);
    break;
  }
  
  /* may want visible edge */
  if ((pc5->edge_vis == on) || (pc5->int_style == hollow)){	
    XDrawLines(display_ptr, window_id, gc_edge_use, points,
	       no_pairs + 1, CoordModeOrigin);
  }
  (void) free(points);
  
  return(1);
}
/* do a rectangle */
xl_rectangle(x1, y1, x2, y2)
     int x1, x2, y1, y2;
{
  int x, y;
  unsigned int width, height;

  if (x1 < x2) {
    x = x1;
    width = x2 - x1;
  } else {
    x = x2;
    width = x1 - x2;
  }
  if (y1 < y2) {
    y = window_attributes.height - y2;
    height = y2 - y1;
  } else {
    y = window_attributes.height - y1;
    height = y1 - y2;
  }
  /* first do the rectangle interior */
  switch (pc5->int_style) {
  case hollow :
  case empty : break;
  case pattern :    /* no pattern fill yet */
  case hatch :    /* no hatch fill yet */
  case solid_i :
    XFillRectangle(display_ptr, window_id, gc_fill_use,
		   x, y, width, height);
    break;
  }
  
  /* may want visible edge */
  if ((pc5->edge_vis == on) || (pc5->int_style == hollow)){	
    XDrawRectangle(display_ptr, window_id, gc_edge_use,
		   x, y, width, height);
  }
  return(1);
}
/* set  a Circle */
xl_circle(x, y, r)
     int x, y, r;
{
  /* first do the circle interior */
  switch (pc5->int_style) {
  case hollow :
  case empty : break;
  case pattern :    /* no pattern fill yet */
  case hatch :    /* no hatch fill yet */
  case solid_i :
    XFillArc(display_ptr, window_id, gc_fill_use, x - r,
	     window_attributes.height - y - r,
	     (unsigned int) 2 * r, (unsigned int) 2 * r, 0, 360 * 64);
    break;
  }
  
  /* may want visible edge */
  if ((pc5->edge_vis == on) || (pc5->int_style == hollow)){	
    XDrawArc(display_ptr, window_id, gc_fill_use, x - r,
	     window_attributes.height - y - r,
	     (unsigned int) 2 * r, (unsigned int) 2 * r, 0, 360 * 64);
  }

  return(1);
}

/* set an arc, we get the positions of 1st pt, intermediate pt, end pt */
/* see utils.c for details */
xl_c3(pt_ptr)
     int *pt_ptr;
{
  return(1);
}
/* set  a closed arc, get the positions of 1st pt, intermdiate pt, end pt */
xl_c3_close(pt_ptr, chord)
     int *pt_ptr;
     enum boolean chord;
{
  return(1);
}
/* set an arc, ends specified by vectors */
xl_c_centre(x, y, vec_array, r)
     int x, y, *vec_array, r;
{
  return(1);
}
/* set an arc, ends specified by vectors, but close it */
xl_c_c_close(x, y, vec_array, r, chord)
     int x, y, *vec_array, r;
     enum boolean chord;
{
  return(1);
}
/* first the basic  ellipse routine */
static do_ellipse(x, y, r, deg0, deg1)
     int x, y, r;	/* position of centre and radius */
     float *deg0, *deg1;	/* beginning and ending degrees (start at top) */
{
  return(1);
}
/* set an ellipse, centre and two endpoints */
xl_ellipse(pt_array)
     int *pt_array;
{
  
  return(1);
}
/* set an elliptical arc, centre, two endpoints, vectors for ends */
xl_ell_arc(pt_array, vec_array)
     int *pt_array, *vec_array;
{
  
  return(1);
}
/* set an elliptical arc, close it */
xl_e_a_close(pt_array, vec_array, chord)
     int *pt_array, *vec_array;
     enum boolean chord;
{
  
  return(1);
}

/* set marker at a series of points */
xl_pmarker(no_pairs, x1_ptr, y1_ptr)
     int no_pairs, *x1_ptr, *y1_ptr;
{
  return(1);
}
/* for cell arrays */
xl_carray(cp, cq, cr, nx, ny, col_prec, dat_ptr, rep_mode, no_bytes)
     int *cp;	/* first corner */
     int *cq;	/* the diagonal to cp p*/
     int *cr;	/* first row is from cp to cr */
     int nx;	/* number of elements in x rows (i.e., parallel to cp-cr) */
     int ny;	/* number of rows */
     int col_prec;  /* the colour precision (how many possible colour values */
     unsigned char *dat_ptr;	/* pointer to the body of information */
     int rep_mode; /* the rep mode; 0, run length encoded, 1 normal */
     int no_bytes;	/* number of data bytes */
{
  static int *my_ptr;
  int *set_cinds();
  char *new_ptr, *temp_ptr;
  unsigned int new_bytes, i, j, row_size, bdone, c_size, new_size;
  int x1, y1;
#define lctab_size 2
  static float lctab[3 * lctab_size] = {1.0, 1.0, 1.0, 0.0, 0.0, 0.0};
  int out_flag;
  int my_flag = 0;
  int want_rmode = 1;
  int want_cp;
  int want_csmode = 0;
  int new_nx, new_ny;
  int bytes_needed, bits_row, bytes_row, first_index, my_format;
  int px, py, qx, qy, rx, ry;	/* the local co-ord system */
  XImage *my_ximage;

  px = cp[0];
  py = cp[1];
  qx = cq[0];
  qy = cq[1];
  rx = cr[0];
  ry = cr[1];

  /* split up by visual */
  switch(my_visual->class) {
  case GrayScale: 
  case StaticGray:
  case PseudoColor:
  case StaticColor:
    want_cp = w_depth; 
    break;
  case DirectColor:
  case TrueColor: 
    want_cp = w_depth / 3; 
    break;
  }
  my_format = (w_depth == 1) ? XYBitmap : ZPixmap;
  first_index =  (pc2->c_s_mode == d_c_mode) ? 1 : 0;
  /* the rows and columns we need */
  new_nx = (rx > px) ? 1 + rx - px : 1 + px - rx;
  new_ny = (qy > py) ? 1 + qy - py : 1 + py - qy;
  /* need to invert it for X */
  py = cq[1];
  qy = cp[1];
  ry = py;
  
  bits_row = new_nx * want_cp;
  bytes_row = (bits_row + byte_size - 1) / byte_size;
  bytes_needed = bytes_row * new_ny;
  
  if (!(new_ptr = (char *) allocate_mem(bytes_needed, 1)))
    return(2);

  my_ximage = XCreateImage(display_ptr, my_visual, w_depth,
			   my_format, 0, new_ptr, new_nx, new_ny,
			   8, bytes_row);
  /* modify it */
  my_ximage->byte_order = MSBFirst;
  my_ximage->bitmap_bit_order = MSBFirst;

  /* get the appropriate XL coordinates */
  /* basically only need the top left hand corner, nx and ny */
  x1 = (cp[0] < cr[0]) ? cp[0] : cr[0];
  y1 = (cp[1] > cq[1]) ? cp[1] : cq[1];
  y1 = window_attributes.height - y1;
  /* take care of my_inds */
  if ((!*my_inds) && (pc2->c_s_mode == d_c_mode)) 
    my_ptr = set_cinds(w_depth, my_inds);

  /* lets make the cell array fit */
  new_carray(NULL, nx, ny, col_prec, rep_mode, 
	     0, dat_ptr, no_bytes, pc2->c_s_mode,
	     pc5->ctab, pc1->max_c_index, px, py, qx, qy,
	     rx, ry, new_nx, new_ny,
	     want_cp, want_rmode, bits_row, new_ptr, bytes_needed, 
	     want_csmode, lctab, lctab_size, my_flag, &out_flag, 
	     first_index, my_inds, &(pc1->c_v_extent));
  if ((my_visual->class == PseudoColor) && (pc2->c_s_mode == d_c_mode)) {
    /* remap the pixels */
    for (i=0; i<new_nx; ++i) {
      temp_ptr = new_ptr + i * bytes_row;
      for (j=0; j<new_ny; ++j) {
	*temp_ptr = my_ptr[*temp_ptr];
	++temp_ptr;
      }
    }
  }
  /* write out the array */
  XPutImage(display_ptr, window_id, gc_line_use, my_ximage, 0, 0,
	    x1, y1, new_nx, new_ny);

  XDestroyImage(my_ximage);
  
  (void) free(new_ptr);
  return(1);
}
/* set text */
xl_text(x, y, final, buffer)
     int x, y, final;
     char *buffer;
{
  return(1);
  
}
/* now set the attributes */
/* set the line type */
xl_l_type(l_type)
     enum line_enum l_type;
{
  switch (l_type) {
  case solid_l:
    values_struct.line_style = LineSolid;
    XChangeGC(display_ptr, gc_line_use, GCLineStyle, &values_struct);
    break;
  case dash:
    values_struct.line_style = LineOnOffDash;
    XChangeGC(display_ptr, gc_line_use, GCLineStyle, &values_struct);
    XSetDashes(display_ptr, gc_line_use, 0, dash_list, DASH_N);
    break;
  case dot_l:	    
    values_struct.line_style = LineOnOffDash;
    XChangeGC(display_ptr, gc_line_use, GCLineStyle, &values_struct);
    XSetDashes(display_ptr, gc_line_use, 0, dot_list, DOT_N);
    break;
  case dash_dot:    
    values_struct.line_style = LineOnOffDash;
    XChangeGC(display_ptr, gc_line_use, GCLineStyle, &values_struct);
    XSetDashes(display_ptr, gc_line_use, 0, dash_d_list, DASH_D_N);
    break;
  case dash_d_d:    
    values_struct.line_style = LineOnOffDash;
    XChangeGC(display_ptr, gc_line_use, GCLineStyle, &values_struct);
    XSetDashes(display_ptr, gc_line_use, 0, dash_d_d_list, DASH_D_D_N);
    break;
  }
  return(1);
}
/* set the edge type */
xl_etype(l_type)
     enum line_enum l_type;
{
  switch (l_type) {
  case solid_l:
    values_struct.line_style = LineSolid;
    XChangeGC(display_ptr, gc_edge_use, GCLineStyle, &values_struct);
    break;
  case dash:
    values_struct.line_style = LineOnOffDash;
    XChangeGC(display_ptr, gc_edge_use, GCLineStyle, &values_struct);
    XSetDashes(display_ptr, gc_edge_use, 0, dash_list, DASH_N);
    break;
  case dot_l:	    
    values_struct.line_style = LineOnOffDash;
    XChangeGC(display_ptr, gc_edge_use, GCLineStyle, &values_struct);
    XSetDashes(display_ptr, gc_edge_use, 0, dot_list, DOT_N);
    break;
  case dash_dot:    
    values_struct.line_style = LineOnOffDash;
    XChangeGC(display_ptr, gc_edge_use, GCLineStyle, &values_struct);
    XSetDashes(display_ptr, gc_edge_use, 0, dash_d_list, DASH_D_N);
    break;
  case dash_d_d:    
    values_struct.line_style = LineOnOffDash;
    XChangeGC(display_ptr, gc_edge_use, GCLineStyle, &values_struct);
    XSetDashes(display_ptr, gc_edge_use, 0, dash_d_d_list, DASH_D_D_N);
    break;
  }
  return(1);
}
/* set the line width */
xl_l_width(l_width, rmul)
     int l_width;
     float rmul;
{
  if (l_width < 2) l_width = 0;
  values_struct.line_width = l_width;
  XChangeGC(display_ptr, gc_line_use, GCLineWidth, &values_struct);
  return(1);
}
/* set the edge width */
xl_edwidth(l_width, rmul)
     int l_width;
     float rmul;
{
  if (l_width < 2) l_width = 0;
  values_struct.line_width = l_width;
  XChangeGC(display_ptr, gc_fill_use, GCLineWidth, &values_struct);
  return(1);
}
/* set the line colour */
xl_lcolour(r, g, b, index)
     float r, g, b;
     int index;
{
  XColor line_colour;
  line_colour.red = ushort_col(r);
  line_colour.green = ushort_col(g);
  line_colour.blue = ushort_col(b);
  switch(my_visual->class) {
    /* first grey-only */
  case GrayScale: 
  case StaticGray:
    /* read only colour */
  case StaticColor:
  case TrueColor: 
  case PseudoColor:
  case DirectColor:
    XAllocColor(display_ptr, my_colormap, &line_colour);
    values_struct.foreground = line_colour.pixel;
    XChangeGC(display_ptr, gc_line_use, GCForeground, &values_struct);
    break;
  }
  return(1);
}
/* set the edge colour */
xl_edcolour(r, g, b, index)
     float r, g, b;
     int index;
{
  XColor edge_colour;
  edge_colour.red = ushort_col(r);
  edge_colour.green = ushort_col(g);
  edge_colour.blue = ushort_col(b);
  switch(my_visual->class) {
    /* first grey-only */
  case GrayScale: 
  case StaticGray:
    break;
    /* read only colour */
  case StaticColor:
  case TrueColor: 
  case PseudoColor:
  case DirectColor:
    XAllocColor(display_ptr, my_colormap, &edge_colour);
    values_struct.foreground = edge_colour.pixel;
    XChangeGC(display_ptr, gc_edge_use, GCForeground, &values_struct);
    break;
  }
  return(1);
}
/* set the fill colour */
xl_fillcolour(r, g, b, index)
     float r, g, b;
     int index;
{
#define COL_GREY(r, g, b)  (1.0 - (0.3 * r + 0.59 * g + 0.11 * b))
#define NO_STIPPLES 8
  int i;
  static char my_data[NO_STIPPLES] = {0, 1, 3, 7, 15, 31, 63, 127};
  static Pixmap my_stipple[NO_STIPPLES];
  XColor fill_colour;
  if (!*my_stipple && MONOCHROME) for (i=0; i<NO_STIPPLES; ++i) {
    my_stipple[i] = XCreateBitmapFromData(display_ptr, window_id,
					  my_data + i, 4, 2);
  }
  fill_colour.red = ushort_col(r);
  fill_colour.green = ushort_col(g);
  fill_colour.blue = ushort_col(b);
  switch(my_visual->class) {
    /* first grey-only */
  case GrayScale: 
  case StaticGray:
    if (MONOCHROME) {
    i = NO_STIPPLES * COL_GREY(r, g, b);
    if (i < 0) i = 0;
    if (i >= NO_STIPPLES) {
      values_struct.fill_style = FillSolid;
      XChangeGC(display_ptr, gc_fill_use, GCFillStyle,
		&values_struct);
    }
    else {
      values_struct.fill_style = FillOpaqueStippled;
      values_struct.stipple = my_stipple[i];
      XChangeGC(display_ptr, gc_fill_use, GCFillStyle | GCStipple,
		&values_struct);
    }
    break;
   } 
    /* read only colour */
  case StaticColor:
  case TrueColor: 
  case PseudoColor:
  case DirectColor:
    XAllocColor(display_ptr, my_colormap, &fill_colour);
    values_struct.fill_style = FillSolid;
    values_struct.foreground = fill_colour.pixel;
    XChangeGC(display_ptr, gc_fill_use, GCFillStyle | GCForeground,
	      &values_struct);
    break;
  }
  return(1);
}

/* set the character height */
xl_cheight(size)
     int size;
{
  
  return(1);
}
/* get a colour table here */
xl_ctab(beg_index, no_entries, ctab)
     int beg_index, 	/* beginning index */
       no_entries; 	/* number of entries to add starting at beg_index */
     float *ctab;	/* direct colour array, *(ctab + i*3) is the red
			   entry for the i'th index, followed by g and b */
{
  /* are we in the right mode ? */
  if (pc2->c_s_mode != i_c_mode) return(2);

  /* update the various attributes, if necessary */
  /* fill colour */
  if ((beg_index <= pc5->fill_colour.ind) &&
      (beg_index + no_entries >= pc5->fill_colour.ind)) {
    xl_fillcolour(*(ctab + pc5->fill_colour.ind * 3),
		  *(ctab + pc5->fill_colour.ind * 3 + 1),
		  *(ctab + pc5->fill_colour.ind * 3 + 2),
		  pc5->fill_colour.ind);
  }
  /* line colour */
  if ((beg_index <= pc5->line_colour.ind) &&
      (beg_index + no_entries >= pc5->line_colour.ind)) {
    xl_lcolour(*(ctab + pc5->line_colour.ind * 3),
	       *(ctab + pc5->line_colour.ind * 3 + 1),
	       *(ctab + pc5->line_colour.ind * 3 + 2),
	       pc5->line_colour.ind);
  }
  /* edge colour */
  if ((beg_index <= pc5->edge_colour.ind) &&
      (beg_index + no_entries >= pc5->edge_colour.ind)) {
    xl_edcolour(*(ctab + pc5->edge_colour.ind * 3),
		*(ctab + pc5->edge_colour.ind * 3 + 1),
		*(ctab + pc5->edge_colour.ind * 3 + 2),
		pc5->edge_colour.ind);
  }

  return(1);

}

/* set a font */
xl_font(index, size)
     int index, size;
{
  
  return(1);
}
/* this is the routine that sets everything up */
/* the initialising routine for the XLIB module */
void xl_setup(opt, dev_info, c1, c2, c3, c5, delim, mfdesc, pdesc, mfctrl,
	      gprim, attr, escfun, extfun, ctrl, pargc, argv)
     
     struct one_opt 		*opt;	/* the command line options, in only */
     struct info_struct *dev_info;	/* device info to fill out, out only */
     struct mf_d_struct 	*c1;	/* the class 1 elements, in only */
     struct pic_d_struct 	*c2;	/* the class 2 elements, in only */
     struct control_struct	*c3;	/* the class 3 elements, in only */
     struct attrib_struct	*c5;	/* the class 5 elements, in only */
     int (*delim[])();	/* delimiter functions */
     int (*mfdesc[])();	/* metafile descriptor functions */
     int (*pdesc[])();	/* page descriptor functions */
     int (*mfctrl[])();	/* control functions */
     int (*gprim[])();	/* graphical primitives */
     int (*attr[])();	/* the attribute functions */
     int (*escfun[])();	/* the escape functions */
     int (*extfun[])();	/* the external functions */
     int (*ctrl[])();	/* external controller functions */
     int *pargc;			/* argc pointer */
     char **argv;			/* argv */	
{
  int x_wanted, y_wanted, x_start, y_start, ret;
  char display_name[129], *disp_str;
  char *window_name, *icon_name;
  Pixmap icon_pixmap;
  XEvent event;
  XSizeHints size_hints;
#define icon_width 40
#define icon_height 40
  static char icon_bits[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
    0x3f, 0x00, 0x00, 0x3f, 0xfe, 0x7f, 0xe0, 0x07, 0xef, 0xfe, 0x3f, 0xf8,
    0x0f, 0xc7, 0xfe, 0x00, 0x3c, 0x00, 0x87, 0xe1, 0x00, 0x1e, 0x00, 0x87,
    0xe1, 0x00, 0x0e, 0x00, 0x87, 0xe0, 0x00, 0x07, 0x00, 0x87, 0xe0, 0x00,
    0x03, 0x00, 0xc3, 0x60, 0x00, 0x03, 0x00, 0xe3, 0x60, 0x00, 0x03, 0x00,
    0x7f, 0x60, 0x00, 0x03, 0x00, 0x03, 0x60, 0x00, 0x03, 0x00, 0x03, 0x60,
    0x00, 0x07, 0x00, 0x03, 0x70, 0x00, 0x06, 0x00, 0x03, 0x70, 0x00, 0x06,
    0x00, 0x03, 0x70, 0x00, 0x0e, 0x30, 0x03, 0x70, 0x00, 0x0c, 0xb0, 0x03,
    0x78, 0x00, 0x1c, 0xb0, 0x03, 0x78, 0x00, 0x78, 0xb0, 0x01, 0x78, 0x00,
    0xf0, 0xbf, 0x01, 0x78, 0x00, 0xe0, 0xbf, 0x01, 0x78, 0x00, 0x80, 0xaf,
    0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  unsigned long black_pixel, white_pixel;
  XIconSize *size_list_return, *this_icon;
  int count_return = 0, i, count;
  char **font_list_ptr;
  unsigned width, height, base_size;
  	/* store the command line argument pointer */
  popt = opt;
  /* store the device info pointer */
  dptr = dev_info;
  /* store the CGM data structure pointers */
  pc1 = c1;
  pc2 = c2;
  pc3 = c3;
  pc5 = c5;
  
  /* figure out the display string */
  disp_str = (char *) NULL;	/* default */
  /* did we get something on the command line ? (xl + something ?) */
  if (opt[(int) screen].set && opt[(int) screen].val.str[2]) {
    disp_str = opt[(int) screen].val.str + 2;
  } else if (opt[(int) device].set && opt[(int) device].val.str[2]) {
    disp_str = opt[(int) device].val.str + 2;
  }
  if (!display_ptr) { /* not already opened */
#ifdef VMS
    /* check to see if we are using DECNET and no string */
    if (!disp_str && 
	translate("SYS$REM_NODE", "LNM$JOB", display_name) & 1) {
      sprintf(display_name + strlen(display_name), "%d.%d", 0, 0);
      disp_str = display_name;
    }
#endif
    if (opt[(int) debug].set && disp_str) 
      (void) fprintf(stderr, "display %s\n", disp_str);
    
    /* open up the display */
    if (NULL == (display_ptr = XOpenDisplay(disp_str))) {
      if (disp_str) (void) fprintf(stderr, 
				   "Couldn't open display %s\n", disp_str);
      exit(0);
    }
  }
  /* get info on the display and screen */
  screen_id = XDefaultScreenOfDisplay(display_ptr);
  no_screens = XScreenCount(display_ptr);
  root_id = XRootWindowOfScreen(screen_id);
  no_planes = XPlanesOfScreen(screen_id);
  xw_size = XWidthOfScreen(screen_id);
  yw_size = XHeightOfScreen(screen_id);
  xw_mm = XWidthMMOfScreen(screen_id);
  yw_mm = XHeightMMOfScreen(screen_id);
  release_no = XVendorRelease(display_ptr);
  vendor = XServerVendor(display_ptr);
  no_cells = XCellsOfScreen(screen_id);
  /* create a simple window */
  dev_info->pxl_in 	= (xw_size * 25.4) / xw_mm;
  dev_info->ypxl_in 	= (yw_size * 25.4) / yw_mm;
  
  width = (opt[(int) x_size].set) ?
    opt[(int) x_size].val.r * dev_info->pxl_in : xw_size * 0.8;
  height = (opt[(int) y_size].set) ?
    opt[(int) y_size].val.r * dev_info->ypxl_in : yw_size * 0.8;
  
  border_width = xw_size/100;
  black_pixel = XBlackPixelOfScreen(screen_id);
  
  x_coord = xw_size * 0.1;
  y_coord = border_width;
  
  white_pixel = XWhitePixelOfScreen(screen_id);
  if (!window_id) {
    window_id = XCreateSimpleWindow(display_ptr, root_id,
				    x_coord, y_coord,
				    width, height, border_width,
				    black_pixel, white_pixel);
    switch(window_id) {
    case BadAlloc:	fprintf(stderr, "BadAlloc in xsetup\n"); exit(0);
    case BadMatch:	fprintf(stderr, "BadMatch in xsetup\n"); exit(0);
    case BadValue:	fprintf(stderr, "BadValue in xsetup\n"); exit(0);
    case BadWindow:	fprintf(stderr, "BadWindow in xsetup\n"); exit(0);
    }
    if (XGetIconSizes(display_ptr, window_id, &size_list_return,
		      &count_return) && popt[(int) debug].set) {
      this_icon = size_list_return;
      for (i=0; i<count_return; ++i) {
	(void) fprintf(stderr, 
		       "ic min = (%d, %d), max = (%d, %d), incr = (%d, %d)\n",
		       this_icon->min_width, this_icon->min_height,
		       this_icon->max_width, this_icon->max_height,
		       this_icon->width_inc, this_icon->height_inc);
	++this_icon;
      }
    }
    /* set some window properties */
    /* create the icon map */
    icon_pixmap = XCreateBitmapFromData(display_ptr, window_id, 
					icon_bits, icon_width, icon_height);
    /* set the size hints */
    size_hints.flags = PSize | PMinSize;
    size_hints.width = width;
    size_hints.height = height;
    size_hints.min_width = 300;
    size_hints.min_height = 300;
    
    ret = XSetStandardProperties(display_ptr, window_id, "GPLOT", "GPLOT",
				 icon_pixmap, argv, *pargc, &size_hints);
    if ((ret == BadWindow) || (ret == BadAlloc)) {
      fprintf(stderr, "trouble with standard properties\n");
      exit(0);
    }
    
    /* now actually map the window */
    if (BadWindow == XMapWindow(display_ptr, window_id)) {
      fprintf(stderr, "BadWindow in XMapWindow\n");
      exit(0);
    }
    XFlush(display_ptr);
    max_val = (1 << no_planes) - 1;
    if (max_val <BASE_INDEX) {
      fprintf(stderr, " no colours available !\n");
    }
    XCheckTypedEvent(display_ptr, Expose, &event);
  }
  /* now see what we got */
  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    (void) fprintf(stderr, "couldn't get attributes\n");
    exit(0);
  }
  /* look at some colours */
  xlcheck_colours(popt[(int) debug].set, &window_attributes);
  /* fill out the device info structure */
  dev_info->x_size 	= window_attributes.width / dev_info->pxl_in;
  dev_info->y_size 	= window_attributes.height / dev_info->ypxl_in;
  dev_info->x_offset	= 0.0;	
  dev_info->y_offset	= 0.0;
  dev_info->c_height	= 12;
  dev_info->c_width	= 12;
  dev_info->d_l_width	= 1;				
  dev_info->d_e_width	= 1;				
  dev_info->d_m_size	= dev_info->c_height;	/* marker size */
  *dev_info->out_name	= '\0';		/* no output file */
  dev_info->capability	= can_clip;	/* for now */
  
  if (opt[(int) debug].set) {
    fprintf(stderr, 
	    "%d planes, screen size = (%.4f, %.4f), release %d\n",
	    no_planes, dev_info->x_size, dev_info->y_size,  release_no);
    fprintf(stderr, 
	    "vendor %s, %d cells, %d screen%s,\nresolution (%.4f, %.4f)\n", 
	    vendor, no_cells, no_screens, (no_screens > 1) ? "s" : "",
	    dev_info->pxl_in, dev_info->ypxl_in);

    font_list_ptr = XListFonts(display_ptr, "*", 10000, &count);
    fprintf(stderr, "%d fonts\n", count);
  }
  /* fill out the dash and dot lists */
  /* must all be non zero */
  base_size = dev_info->pxl_in > 30 ? dev_info->pxl_in : 30;
  dash_list[1] = dash_list[0] = base_size / 10;
  dot_list[1] = dot_list[0] = dash_list[0] / 3;
  dash_d_list[0] = dash_list[0];
  dash_d_list[1] = dash_d_list[2] = dash_d_list[3] = dot_list[0];
  dash_d_d_list[0] = dash_list[0];
  dash_d_d_list[1] = dash_d_d_list[2] = dash_d_d_list[3] =
    dash_d_d_list[4] = dash_d_d_list[5] = dot_list[0];
    
  /* now fill out the function pointer arrays for CGM */
  /* the delimiter functions */
  delim[(int) B_Mf] 	= xl_begin;
  delim[(int) E_Mf]	= xl_end;
  delim[(int) B_Pic]	= xl_bp;
  delim[(int) B_Pic_Body]	= xl_bpage;
  delim[(int) E_Pic]	= xl_epage;
  
  /* the control elements */
  mfctrl[(int) ClipRect]	= xl_cliprect;
  mfctrl[(int) ClipIndic]	= xl_clipindic;

  /* the graphical primitives */
  gprim[(int) PolyLine]	= xl_pline;
  gprim[(int) Polygon]	= xl_pgon;
  gprim[(int) Cell_Array]	= xl_carray; 
  gprim[(int) Rectangle]	= xl_rectangle;
  gprim[(int) Cgm_Circle]	= xl_circle;

  /*	gprim[(int) Dis_Poly]	= xl_dpline;
	gprim[(int) PolyMarker]	= xl_pmarker;
	gprim[(int) Text]	= xl_text;
	gprim[(int) Circ_3]	= xl_c3;
	gprim[(int) Circ_3_Close]	= xl_c3_close;
	gprim[(int) Circ_Centre]	= xl_c_centre;
	gprim[(int) Circ_C_Close]	= xl_c_c_close;
	gprim[(int) Ellipse]	= xl_ellipse;
	gprim[(int) Ellip_Arc]	= xl_ell_arc;
	gprim[(int) El_Arc_Close] 	= xl_e_a_close;
	
	*/
	/* the attributes */
  attr[(int) LType]	= xl_l_type;
  attr[(int) LWidth]	= xl_l_width;
  attr[(int) CHeight]	= xl_cheight;
  attr[(int) ColTab] 	= xl_ctab;
  attr[(int) EdWidth]	= xl_edwidth;
  attr[(int) EType]	= xl_etype;
  attr[(int) FillColour]= xl_fillcolour;
  attr[(int) LColour]	= xl_lcolour;
  attr[(int) EdColour]	= xl_edcolour;
/*
  attr[(int) MColour]	= xl_mcolour;
  attr[(int) TColour]	= xl_tcolour;
*/
  return;
}
/* the following function optimises our TeX implementation and is 
   unnecessary for CGM support only */
/* set a rule */
xl_s_rule(h, v, w_pxl, h_pxl)
     int h, v, w_pxl, h_pxl;
{
  
  XFillRectangle(display_ptr, window_id, gc_fill_use, h,
		 window_attributes.height - v - h_pxl,
		 w_pxl, h_pxl);
  
  return(1);
}

void xl_gtex_setup(opt, gtex_calls)	/* function pointers, out only */
     struct one_opt 		*opt;	/* the command line options, in only */
     int (*gtex_calls[])();
{
  /* assign TeX-specific functions */
  gtex_calls[(int) S_Rule]	= xl_s_rule;
/*
  gtex_calls[(int) S_Font] 	= ps_s_font;
  gtex_calls[(int) Suspend]	= ps_suspend;
  gtex_calls[(int) Restart]	= ps_restart;
  gtex_calls[(int) S_Abs_Both]	= ps_abs_both;
  gtex_calls[(int) S_Abs_H]	= ps_abs_h;
  gtex_calls[(int) S_Abs_V]	= ps_abs_v;
  gtex_calls[(int) M_Rel_H]	= ps_rel_h;
  gtex_calls[(int) S_Char]	= ps_s_char;
  gtex_calls[(int) St_Font]	= ps_st_font;
  gtex_calls[(int) M_Dev_Char]	= ps_dev_char;
  gtex_calls[(int) E_Font]	= ps_e_font;
*/
  return;
}
/* check what's available for colours */
xlcheck_colours(talk, watts)
     int talk;
     XWindowAttributes *watts;
{
 my_visual = watts->visual; /* get the visual */
 my_colormap = watts->colormap;
 if (talk) {
   switch(my_visual->class) {
   case GrayScale: fprintf(stderr, "GrayScale visual, "); break;
   case PseudoColor: fprintf(stderr, "PseudoColor visual, "); break;
   case DirectColor: fprintf(stderr, "DirectColor visual, "); break;
   case StaticGray: fprintf(stderr, "StaticGray visual, "); break;
   case StaticColor: fprintf(stderr, "StaticColor visual, "); break;
   case TrueColor: fprintf(stderr, "TrueColor visual, "); break;
   default: fprintf(stderr, "unknown visual %d, ", (int) my_visual); break;
   }
   fprintf(stderr, "%d entries\n", my_visual->map_entries);
 }
 w_depth = watts->depth;
 return(1);
}
static xl_load_map(ninds, inptr)
     int *ninds, *inptr;
{
  int i, j, k, l;
  float top0, top1, top2;
  XColor map_colour;
  
  /* establish bounds */
  top0 = (ninds[0] > 1) ? ninds[0] - 1.0 : 1.0;
  top1 = (ninds[1] > 1) ? ninds[1] - 1.0 : 1.0;
  top2 = (ninds[2] > 1) ? ninds[2] - 1.0 : 1.0;
  
  l = 0;
  for (i=0; i<ninds[2]; ++i) {
    for (j=0; j<ninds[1]; ++j) {
      for (k=0; k<ninds[0]; ++k) {
	map_colour.red = ushort_col(k / top0);
	map_colour.green = ushort_col(j / top1);
	map_colour.blue = ushort_col(i / top2);
	XAllocColor(display_ptr, my_colormap, &map_colour);
	inptr[l] = (int) map_colour.pixel;
	++l;
      }
    }
  }
  return(1);
}
static int *set_cinds(depth, inds)
     int depth, *inds;
{
  extern get_cinds(); /* in utils.c */
  int i, map_size, *my_ptr;

  map_size = 1 << depth;

  /* first get the index values */
  get_cinds(map_size, inds);
  
  /* grap some memory */
  my_ptr = (int *) allocate_mem(inds[0] * inds[1] * inds[2] * sizeof(int), 0);
  xl_load_map(inds, my_ptr);

  return(my_ptr);
}
