#ifndef  __DFA_H__
#define  __DFA_H__ 1
#include "concon.h"

/* 
     dfa.h
*/ 

/*
     The matching goes as follows; if a current input char belongs to
     an edge, the automaton is allowed to follow that edge to the next
     node.
*/     

#define SPECIALS   "_$@!#%&;<=>?[\\]*+-.,/:^{|}~"

typedef struct dfaNode
    {
    char     range[3];
    int      next;
    int      accept;     
    } DfaNode;     


/* 
    Token rules tell what action should be taken if a certain DFA
    belonging to startState matches.
*/  
typedef struct tokenRules
    {
    int      startState;
    Inherit  (*actionFunc)( void );
    } TokenRules;
    

#endif



