/*   Input module.
     This module reads input from streams, puts it in the
 readIn buffer and gives the input to the other modules. It also
 contains the routines that control the input. Other modules can
 direct the input module to do several actions on buffers.
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>
#include "concon.h"
#include "global.h"
#include "input.fdf"
#include "format.fdf"
#include "states.fdf"
#include "manager.fdf"

#define READ_SIZE     (int)256

char readInBuf[READ_SIZE];
int readSize;

void increment( char **pointerPP, int size )
	{
	*pointerPP += size;
    while (*pointerPP >= (stateP->readInP+readSize)) 
    	*pointerPP -= readSize;
    while (*pointerPP < stateP->readInP) *pointerPP += readSize;
    }

Inherit proInput_init( void )
    {
	setvbuf( stdin, NULL, _IOLBF, BUFSIZ );
    readSize = READ_SIZE; /* the size of a buffer */
    proInput_reset();
    return TRUE;
	}

Inherit proInput_openFile( List *fileP )
	{
	char *nameP, *bufP;
	FILE *newFileP;
	State *prevStateP = stateP->prevStateP;
	List *subP;
	
	if (fileP == NULL)
		return FALSE;
    if (fileP->u.p.type != LITERAL &&
        fileP->u.p.type != ALPHA)
		return FALSE;
	subP = fileP->data.dataP;
	if (subP->nextP != NULL)
		return FALSE;
	bufP = (char *)malloc( READ_SIZE );
	if (bufP == NULL)
		return FALSE;
	nameP = subP->data.dataP;
    if (fileP->u.p.type == LITERAL)
		{
		nameP[strlen(nameP)-1] = '\0';
		newFileP = fopen( &nameP[1], "r" );
		nameP[strlen(nameP)] = '\"';
		}
	else
		newFileP = fopen( nameP, "r" );
	
	if (newFileP == NULL)
		{
		free( bufP );
		proFor_print("\nERROR - File not found...");
		exit_state();
		return FALSE;
		}
	if (prevStateP != stateSpaceP && stateP->inP != prevStateP->inP)
		proInput_closeFile( stateP );
	subP->nextP = newFileP;
	stateP->inP = proMem_getAvail();
	*(stateP->inP) = *fileP;
	stateP->inP->nextP = NULL;
	stateP->readInP = bufP;
	proInput_reset();
	return TRUE;
	}

void proInput_closeFile( State *stP )
	{
	if ((FILE *)(((List *)stP->inP->data.dataP)->nextP) != 
		stdin)
		{
		fclose( ((List *)stP->inP->data.dataP)->nextP );
		free( stP->readInP );
		((List *)stP->inP->data.dataP)->nextP = NULL;
		stP->inP = proMem_getAvail();
		*(stP->inP) = *(List *)inDescrP->nextP;
		stP->readInP = readInBuf;
		}
	}

Inherit proInput_reset( void )
    {
	*(stateP->inputMarkP = stateP->lookAheadP = stateP->walkerP = stateP->readInP) = '\0';
    return TRUE;
	}

Inherit proInput_undo( void )
    {
    stateP->walkerP = stateP->inputMarkP;
    return TRUE;
    }

Inherit proInput_forget( void )
    {
    stateP->inputMarkP = stateP->walkerP;
    return TRUE;
    }

Inherit proInput_release( void )
	{
    increment( &stateP->walkerP, readSize-1 );
    stateP->inputMarkP = stateP->walkerP;
    return TRUE;
    }

char proInput_getChar( void )
	{
    char buf[10];
    
    if (stateP->endOfFile ) return '\0';
    if (stateP->lookAheadP == stateP->walkerP)
        increment( &stateP->lookAheadP, 1 );
    increment( &stateP->walkerP, 1);
    if (stateP->walkerP == stateP->inputMarkP) return '\0';
        if (stateP->walkerP == stateP->lookAheadP)
            {
            int ii;
            if (stateP->newLiner && STREAM_IN == stdin)
                {
                sprintf( buf, "\n%d:>", stateP->brackets);
                proFor_print( buf );
                }
            stateP->newLiner = FALSE;
        *stateP->lookAheadP = (char)(ii = fgetc( STREAM_IN ));
        if (ii == EOF)
            {
            *stateP->lookAheadP = '\n';
			stateP->endOfFile = TRUE;
            }
        if (*stateP->lookAheadP == '\n') stateP->newLiner = TRUE;
        }
    if (stateP->lookAheadP == stateP->walkerP)
        increment( &stateP->lookAheadP, 1);
     return *stateP->walkerP;
     }

Inherit proInput_copy( char *buffer, int maxSize )
    {
    char *walkWithMe;
    int size = 0;
	walkWithMe = stateP->inputMarkP;
    if (stateP->walkerP != walkWithMe)
        increment( &walkWithMe, 1 );
    while (size < maxSize && stateP->walkerP != walkWithMe)
        {
        buffer[size++] = *walkWithMe;
        increment( &walkWithMe, 1 );
        }
    if (size < maxSize)
        {
        buffer[size] = '\0';
        return TRUE;
        }
    else
        return FALSE;
    }




