(*
$File: Compiler/Apply.sml $
$Date: 1992/09/18 18:03:48 $
$Revision: 1.2 $
$Locker:  $
*)

(*$Apply: OBJECTS CRASH APPLY*)
functor Apply(structure Objects: OBJECTS
	      structure Crash: CRASH
	     ): APPLY =
  struct
    open Objects

    fun dePair object = (select(0, object), select(1, object))

    fun dePairInt object = (deInteger (select(0, object)), 
			    deInteger (select(1, object)))
      
    fun dePairReal object = (deReal (select(0, object)), 
			     deReal (select(1, object)))
  
    fun intPairToInt(f, object) =
      let
	val (arg1, arg2) = dePair object
      in
	integer(f(deInteger arg1, deInteger arg2))
      end

    fun realPairToReal(f, object) =
      let 
	val (arg1, arg2) = dePair object
      in
	real(f(deReal arg1, deReal arg2))
      end

    fun bool b = vector [void, integer(if b then 1 else 0)]

    fun apply(n, object) =
      case n
	of  0 => bool(equal(dePair object))
	  | ~1 => integer(abs (deInteger object))
	  | ~2 => real(abs (deReal object))
	  | ~3 => integer(~ (deInteger object))
          | ~4 => real(~ (deReal object))
	  | ~5 => intPairToInt(op +, object) 
          | ~6 => realPairToReal(op +, object)
	  | ~7 => intPairToInt(op -, object)
          | ~8 => realPairToReal(op -, object)
	  | ~9 => intPairToInt(op *, object)
          | ~10 => realPairToReal(op *, object)
	  | ~11 => bool((op < : int * int -> bool) (dePairInt object))
	  | ~12 => bool((op < : real * real -> bool) (dePairReal object))
	  | ~13 => bool((op > : int * int -> bool) (dePairInt object))
	  | ~14 => bool((op > : real * real -> bool) (dePairReal object))
	  | ~15 => bool((op <= : int * int -> bool) (dePairInt object))
	  | ~16 => bool((op <= : real * real -> bool) (dePairReal object))
	  | ~17 => bool((op >= : int * int -> bool) (dePairInt object))
	  | ~18 => bool((op >= : real * real -> bool) (dePairReal object))
 	  | _ => Crash.unimplemented("apply(#" ^ Int.string n ^ ")")

    fun FAIL_USE() =
      Crash.unimplemented "Apply.FAIL_USE"
  end;
