-- help.i
-- version for skipbrek
-- extensive changes to help and hint verbs
-- added 
--    commands verb
--    DECREASE Turns OF Hero.
--   'in_help' check to stop events appending text to help screens 
-- remove 'h' alias for help
-- hint verb moved to separate file hint.ala


SYNTAX
	help = help.
    commands = commands.

VERB help
DOES
    "$pEnter one of the following commands"
    "$p$tCOMMANDS$t-$tIntroduction to standard Interactive Fiction commands."
    "$iHINT$t$t-$tReceive a hint when you're stuck on what to do next."
    "$iCREDITS$t$t-$tThe author's notes and acknowledgements."
    DECREASE Turns OF Hero.
    MAKE hero in_help.
    SCHEDULE not_in_help AFTER 1.
END VERB.

SYNONYMS command = commands.
VERB commands
DOES
DECREASE Turns OF Hero.
"$pSome Standard Interactive Fiction Commands
$p$t(replace text in 'quotes-marks' with the name of an object,
$n$tdon't include the 'quote-marks')"

"$pDirections
$inorth,south,southwest,etc (abbreviate as n,s,sw,etc)
$ialso enter or exit in some locations
$igo north, etc also works


$pObjects
$iexamine or look at 'object' (abbr. x 'object')
$itake,get, or pick up 'object'
$idrop,throw or put down 'object'
$iput 'object' in (or on) 'another object'
$igive 'object' to 'character'


$pCharacters
$iask 'character' about 'subject'
$itell 'character' about 'subject'
$igive 'object' to 'character'
"
"
$pGame Status
$iinventory (abbr. i ) - list objects being carried
$ilook (abbr. l ) - repeat description of current location
$iscore - display game points currently earned

$pGet Help
$icommands - brief general instructions for I.F. games
$ihint - receive a hint for solving puzzles
$ireview - repeat hints previously shown by the hint command
$icredits, notes or info - general notes

$pStopping and starting game
$isave - save current game state to a disk file
$irestore - restore previously saved game from disk file
$irestart - start playing game again from the beginning
$iquit (abbr. q ) - exit the game

$pMiscellaneous
$ibrief - only describe a location when first visit it
$iverbose - display description each time visit a location
$inotify - turn off (or turn back on) the display of a message
$i$t$twhen game points change
$iwait (abbr. z ) - do nothing for a turn
$ipress F3 to repeat last command
$n"

MAKE hero in_help.
SCHEDULE not_in_help AFTER 1.
END VERB.

----

SYNONYMS
    info, notes, author = credits.

SYNTAX
    credits = credits.

VERB credits
DOES
    DECREASE Turns OF Hero.
	"$t$t$t$t""Skipping Breakfast""
    $n$t$t$t$tRelease 2 - June 1999
    $n$t$t$tCopyright (1999) Stephen Griffiths."

	"$p""Skipping Breakfast"" was written as an entry in the February 1999
    ""WackyComp"" run on the rec.games.int-fiction Usenet newsgroup by 
    David Glasser."

	"$pThis game was written using the Alan Adventure Language (version 2.8).
	The Alan language is written by Thomas Nilsson.
	$n$tWWW :$t http://www.pp.softlab.se/thomas.nilsson/alan/
	$nMany thanks to Thomas for creating this excellent language and for the
	help and support he has given me in using it.

    $pOne of the main reasons I released this second version of ""Skipping
    Breakfast"" was that I wanted to release the game's source code.
    Hopefully it will be of interest to other IF authors using the Alan
    language."
    "The source code can be downloaded from the IF Archive."

	"$pI welcome any 
    feedback or bug reports on ""Skipping Breakfast"" (either as a game or as
    a source code example.) Comments can be sent to me, via Internet email,
    to sg@xtra.co.nz. "

    "$pThanks to Lelah Conrad and Bob Reeves for beta-testing
	and offering many helpful suggestions."
    
    "$pMore games and more information about Interactive Fiction can be obtained
	from the Interactive Fiction Archive.
	$n$tFTP/WWW : $t ftp://ftp.gmd.de/if-archive
	$n$t'mirror': $t http://if-archive.org/ 
	$pInteractive fiction Usenet newsgroups
	$n$tnews://rec.arts.int-fiction
	$n$tnews://rec.games.int-fiction"

	MAKE hero in_help.
	SCHEDULE not_in_help AFTER 1.
END VERB.

----

SYNTAX walkthru=walkthru.
SYNONYMS
  walkthrough = walkthru.
VERB walkthru
DOES
    DECREASE Turns OF Hero.
    "A walkthrough solution is not included with this game. Use the HINT
    command for assistance or
    post a hint request to Internet newsgroup rec.games.int-fiction."
    MAKE hero in_help.
    SCHEDULE not_in_help AFTER 1.
END VERB.

----

SYNONYMS
    hints = hint.

SYNTAX
    hint = hint.

$INCLUDE 'hints.ala'

----

EVENT not_in_help
    MAKE hero NOT in_help.
END EVENT.

