/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class TValue {
    public static final int NUMBER = 1;
    public static final int OBJECT = 2;
    public static final int SSTRING = 3;
    public static final int NIL = 5;
    public static final int CODE = 6;
    public static final int LIST = 7;
    public static final int TRUE = 8;
    public static final int DSTRING = 9;
    public static final int FUNCTION = 10;
    public static final int OLD_TEMPLATE = 11;
    public static final int PROPERTY = 13;
    public static final int DEMAND = 14;
    public static final int SYNONYM = 15;
    public static final int REDIR = 16;
    public static final int TEMPLATE = 17;
    public static final String[] type_names = new String[]{"UNUSED", "number", "object", "sstring", "UNUSED", "nil", "code", "list", "true", "dstring", "function", "???", "???", "property", "demand", "synonym", "redir", "template"};
    int _type;
    int _int_value;
    String _str_value;
    Vector _list_value;
    byte[] _data_value;

    public TValue(int n, byte[] byArray) {
        this(n, byArray, 0, byArray.length);
    }

    public TValue(int n, byte[] byArray, int n2, int n3) {
        this._type = n;
        if (n == 1) {
            this._int_value = GameFileParser.read_32signed(byArray, n2);
        } else if (n == 2 || n == 10 || n == 13 || n == 15 || n == 16) {
            this._int_value = GameFileParser.read_16(byArray, n2);
        } else if (n != 5 && n != 8 && n != 14) {
            if (n == 3 || n == 9) {
                this._str_value = new String(byArray, n2, n3 - n2);
            } else if (n == 6) {
                this._data_value = new byte[n3 - n2];
                System.arraycopy(byArray, n2, this._data_value, 0, n3 - n2);
            } else if (n == 7) {
                this._list_value = new Vector(5);
                while (n2 < n3) {
                    byte by = byArray[n2++];
                    TValue tValue = null;
                    if (by == 1) {
                        tValue = new TValue(by, byArray, n2, n2 + 4);
                        n2 += 4;
                    } else if (by == 2 || by == 10 || by == 13) {
                        tValue = new TValue(by, byArray, n2, n2 + 2);
                        n2 += 2;
                    } else if (by == 5 || by == 8) {
                        tValue = new TValue(by, byArray, n2, n2);
                    } else if (by == 3 || by == 7) {
                        int n4 = GameFileParser.read_16(byArray, n2) - 2;
                        tValue = new TValue(by, byArray, n2 += 2, n2 + n4);
                        n2 += n4;
                    } else {
                        Jetty.out.print_error("Unknown type of list member: " + by, 1);
                        n2 = n3;
                    }
                    this._list_value.addElement(tValue);
                }
            } else if (n == 17 || n == 11) {
                int n5 = GameFileParser.read_8(byArray, n2++);
                this._list_value = new Vector(n5);
                for (int i = 0; i < n5; ++i) {
                    int[] nArray = new int[6];
                    nArray[0] = GameFileParser.read_16signed(byArray, n2 + 0);
                    if (nArray[0] == -1) {
                        nArray[0] = 0;
                    }
                    nArray[1] = GameFileParser.read_16(byArray, n2 + 2);
                    nArray[2] = GameFileParser.read_16(byArray, n2 + 4);
                    nArray[3] = GameFileParser.read_16(byArray, n2 + 6);
                    nArray[4] = GameFileParser.read_16(byArray, n2 + 8);
                    if (n == 11) {
                        nArray[5] = 0;
                        n2 += 10;
                        this._type = 17;
                    } else {
                        nArray[5] = GameFileParser.read_8(byArray, n2 + 10);
                        n2 += 16;
                    }
                    this._list_value.addElement(nArray);
                }
            } else {
                Jetty.out.print_error("Unknown type in TValue constructor: " + n, 1);
            }
        }
    }

    public TValue(int n, int n2) {
        this._type = n;
        if (n == 1 || n == 2 || n == 10 || n == 13) {
            this._int_value = n2;
        } else if (n != 5 && n != 8 && n != 14) {
            Jetty.out.print_error("Illegal type in this TValue constructor: " + n, 1);
        }
    }

    public TValue(int n, String string) {
        this._type = n;
        if (n == 3) {
            this._str_value = string;
        } else {
            Jetty.out.print_error("Illegal type in this TValue constructor: " + n, 1);
        }
    }

    public TValue(int n, Vector vector) {
        this._type = n;
        if (n == 7) {
            this._list_value = vector;
        } else {
            Jetty.out.print_error("Illegal type in this TValue constructor: " + n, 1);
        }
    }

    public TValue do_clone() {
        TValue tValue = new TValue(1, 0);
        tValue.copy(this);
        return tValue;
    }

    public void copy(TValue tValue) {
        if (tValue == this) {
            Jetty.out.print_error("copying onto self; not really doing it", 2);
            return;
        }
        this._type = tValue._type;
        if (this._type == 1 || this._type == 2 || this._type == 10 || this._type == 13 || this._type == 15 || this._type == 16) {
            this._int_value = tValue._int_value;
        } else if (this._type != 5 && this._type != 8 && this._type != 14) {
            if (this._type == 3 || this._type == 9) {
                this._str_value = tValue._str_value;
            } else if (this._type == 6) {
                this._data_value = tValue._data_value;
            } else if (this._type == 7) {
                this._list_value = new Vector(tValue._list_value.size());
                for (int i = 0; i < tValue._list_value.size(); ++i) {
                    this._list_value.addElement(((TValue)tValue._list_value.elementAt(i)).do_clone());
                }
            } else if (this._type == 17) {
                this._list_value = tValue._list_value;
            } else {
                Jetty.out.print_error("Unknown type in TValue copy(): " + this._type, 1);
            }
        }
    }

    public int get_type() {
        return this._type;
    }

    public boolean must_be(int n) {
        if (this._type != n) {
            Jetty.out.print_error("Error: wrong type -- expected " + type_names[n] + ", found " + type_names[this._type], 1);
            return false;
        }
        return true;
    }

    public boolean must_be(int n, int n2) {
        if (this._type != n && this._type != n2) {
            Jetty.out.print_error("Error: wrong type -- expected " + type_names[n] + " or " + type_names[n2] + ", found " + type_names[this._type], 1);
            return false;
        }
        return true;
    }

    public boolean must_be(int n, int n2, int n3) {
        if (this._type != n && this._type != n2 && this._type != n3) {
            Jetty.out.print_error("Error: wrong type -- expected " + type_names[n] + ", " + type_names[n2] + ", or " + type_names[n3] + ", found " + type_names[this._type], 1);
            return false;
        }
        return true;
    }

    public int get_number() throws HaltTurnException {
        if (!this.must_be(1)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public boolean get_logical() {
        if (this._type != 1 && this._type != 8 && this._type != 5) {
            return true;
        }
        this.must_be(1, 8, 5);
        if (this._type == 8) {
            return true;
        }
        if (this._type == 5) {
            return false;
        }
        return this._int_value != 0;
    }

    public String get_string() throws HaltTurnException {
        if (!this.must_be(3)) {
            throw new HaltTurnException(-10);
        }
        return this._str_value;
    }

    public String get_dstring() throws HaltTurnException {
        if (!this.must_be(9)) {
            throw new HaltTurnException(-10);
        }
        return this._str_value;
    }

    public Vector get_list() throws HaltTurnException {
        if (!this.must_be(7)) {
            throw new HaltTurnException(-10);
        }
        return this._list_value;
    }

    public int get_object() throws HaltTurnException {
        if (!this.must_be(2)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public int get_function() throws HaltTurnException {
        if (!this.must_be(10)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public int get_property() throws HaltTurnException {
        if (!this.must_be(13)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public int get_redir() throws HaltTurnException {
        if (!this.must_be(16)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public int get_synonym() throws HaltTurnException {
        if (!this.must_be(15)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public byte[] get_code() throws HaltTurnException {
        if (!this.must_be(6)) {
            throw new HaltTurnException(-10);
        }
        return this._data_value;
    }

    public Vector get_template() throws HaltTurnException {
        if (!this.must_be(17)) {
            throw new HaltTurnException(-10);
        }
        return this._list_value;
    }

    public int get_comparison(TValue tValue) throws HaltTurnException {
        if (this._type == tValue._type) {
            if (!this.must_be(1, 3)) {
                throw new HaltTurnException(-10);
            }
            if (this._type == 1) {
                return this._int_value == tValue._int_value ? 0 : (this._int_value < tValue._int_value ? -1 : 1);
            }
            int n = this._str_value.compareTo(tValue._str_value);
            return n == 0 ? 0 : (n < 0 ? -1 : 1);
        }
        Jetty.out.print_error("Mismatched types in comparison: " + type_names[this._type] + " and " + type_names[tValue._type], 1);
        throw new HaltTurnException(-10);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TValue)) {
            return false;
        }
        TValue tValue = (TValue)object;
        if (this._type != tValue._type) {
            return false;
        }
        if (this._type == 1 || this._type == 2 || this._type == 10 || this._type == 13 || this._type == 15 || this._type == 16) {
            return this._int_value == tValue._int_value;
        }
        if (this._type == 5 || this._type == 8) {
            return true;
        }
        if (this._type == 3 || this._type == 9) {
            return this._str_value.equals(tValue._str_value);
        }
        if (this._type == 7) {
            if (this._list_value.size() != tValue._list_value.size()) {
                return false;
            }
            for (int i = 0; i < this._list_value.size(); ++i) {
                if (((TValue)this._list_value.elementAt(i)).equals(tValue._list_value.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

