
"
chapman.st - ChapMan installation script
This script installs the ChapMan system
Execute the script by filing it in or invoking doit.
"

| srcDir file doit newApp newApp2 chappClass regVer chapManDLL | 
srcDir := Disk.
(File exists: 'BugFix20.cls' in: srcDir) ifFalse: [
	srcDir := Prompter
		prompt: 'Specify the directory of the installation files'
			default: srcDir fullDirName.
	    srcDir isNil ifTrue: [^nil].
	].
srcDir := Directory pathName: srcDir.

(regVer := File exists: 'chapmr.dll' in: srcDir)
	ifTrue: [chapManDLL := 'chapmr']
	ifFalse: [chapManDLL := 'chapmu'].

Transcript cr.
doit := true.
(Smalltalk includesKey: #ChApplication) ifTrue: [
	doit := MessageBox confirm: 'ChapMan already installed. Installing a new version causes all applications and class comments to be lost. You must have saved all applications in order to recreate them. In addition you must allow the reinitialization of the window system, which closes all windows. Proceed?'.
	doit ifTrue: [
		Transcript cr; show: 'Unbinding old ChapMan DLL...'.
		#('chapmu' 'chapmr') do: [:each |
			(ObjectLibraryBind isBound: each) ifTrue: [
				ObjectLibraryBind unBind: each]
			]
		]
	].

doit ifTrue: [
	Transcript cr; show: 'Copying (new) DLL files...'.
	(Array with: 'chapmres.dll' with: chapManDLL, '.dll') do: [:each |
		File copy: srcDir fullDirName, each to: Disk pathName].

	file := srcDir fileReadOnly: 'BugFix20.cls'.
	Transcript cr; show: 'Filing in ', file pathName, '...'.
	file fileIn; close.

	Transcript cr; show: 'Binding object library chapmr.dll...'.
	ObjectLibraryBind bindTo: chapManDLL.

	file := srcDir fileReadOnly: 'ChapMInt.cls'.
	Transcript cr; show: 'Filing in ', file pathName, '...'.
	file fileIn; close.

	Transcript cr; show: 'Filing in application data...'.
	chappClass := Smalltalk at: #ChApplication.
	#('bugfix20.cha' 'ChapMInt.cha') do: [:each |
		newApp := chappClass newFromFile: srcDir fullDirName, 
			each subApplications: false.
		chappClass subApplication: newApp of: nil].
	
	newApp2 := chappClass newFromFile: srcDir fullDirName, 
		'ChapMan.cha' subApplications: false.
	chappClass subApplication: newApp2 of: newApp.

	#('Register.cha' 'GenTools.cha') do: [:each |
		newApp := chappClass newFromFile: srcDir fullDirName,
			each subApplications: false.
		chappClass subApplication: newApp of: newApp2].

	Transcript cr; show: 'ChapMan installed.'; cr.
	MessageBox message: 'Reinitialization of the window system will be done.'.
	Notifier reinitialize]

ifFalse: [
	Transcript cr; show: 'Installation aborted'] !

