
#include "pvm3.h"
#include "pvmconst.h"
#include "../src/bfunc.h"

void
FUNCTION(pvmftasks)
	ARGS(`where,
		ntaskp,
		tidp,
		ptidp,
		hostp,
		flagp,
		STRING_ARG(a_out),
		infop')

	int  *where, *ntaskp, *tidp, *ptidp, *hostp, *flagp, *infop;
	STRING_ARG_DECL(a_out);
{
	static struct taskinfo *tip = 0;
	static int ntask = 0;
	static int next = 0;

	int cc;
	struct taskinfo *tip2;

	char *malloc();

	if (!tip) {
		if ((cc = pvm_tasks(*where, &ntask, &tip2)) < 0) {
			*infop = cc;
			return;
		}
		tip = (struct taskinfo*)malloc(ntask * sizeof(struct taskinfo));
		BCOPY((char*)tip2, (char*)tip, ntask * sizeof(struct taskinfo));
		next = 0;
	}

	if (next < ntask) {
		*ntaskp = ntask;
		*tidp = tip[next].ti_tid;
		*ptidp = tip[next].ti_ptid;
		*hostp = tip[next].ti_host;
		*flagp = tip[next].ti_flag;
		ctofstr(STRING_PTR(a_out), STRING_LEN(a_out), tip[next].ti_a_out);
		*infop = 1;
		next++;
	}

	if (next == ntask) {
		free((char*)tip);
		tip = 0;
	}
}

