ARCHCFLAGS	=	-DSYSVSIGNAL -DNOGETDTBLSIZ
PVM_ARCH	=	OS2
#
# Generic Makefile body to be concatenated to config header.
#
SHELL	=	cmd.exe
SDIR =  ..
CC   =  gcc
CFLAGS = -O2 -D$(PVM_ARCH) -c $(ARCHCFLAGS) -I$(SDIR) -I$(SDIR)/../include $(CDEBUGFLAGS)
RM = rm -f
M4 = m4
FORTRAN=`case "$(FC)@$(F77)" in *@) echo $(FC) ;; @*) echo $(F77) ;; *) echo f77;; esac`
M4FILE	=	../../conf/$(PVM_ARCH).m4
PVMLDIR	=	../../lib/$(PVM_ARCH)

LOBS = faddhost.o \
	fadvise.o \
	fbarrier.o \
	fbcast.o \
	fbufinfo.o \
	fconfig.o \
	fdelhost.o \
	fexit.o \
	ffreebuf.o \
	fgetinst.o \
	fgetopt.o \
	fgetrbuf.o \
	fgetsbuf.o \
	fgettid.o \
	fgsize.o \
	finitsnd.o \
	fjoingrp.o \
	fkill.o \
	flvgrp.o \
	fmcast.o \
	fmkbuf.o \
	fmstat.o \
	fmytid.o \
	fnotify.o \
	fnrecv.o \
	fpack.o \
	fparent.o \
	fperror.o \
	fprobe.o \
	fpstat.o \
	frecv.o \
	fsend.o \
	fsendsig.o \
	fserror.o \
	fsetopt.o \
	fsetrbuf.o \
	fsetsbuf.o \
	fspawn.o \
	ftasks.o \
	ftidtoh.o \
	funpack.o

default:	libfpvm3.a

install:	libfpvm3.a $(PVMLDIR)
	mv libfpvm3.a $(PVMLDIR)

$(PVMLDIR):
	- mkdir $(PVMLDIR)

libfpvm3.a:  $(LOBS) ftocstr.o
	ar cr libfpvm3.a $?
	ar d  libfpvm3.a __.SYMDEF
	ar s  libfpvm3.a

clean:
	rm -f $(LOBS) ftocstr.o libfpvm3.a

tidy:
	rm -f $(LOBS)

ftocstr.o: $(SDIR)/ftocstr.c $(SDIR)/../src/bfunc.h
	$(CC) $(CFLAGS) $(SDIR)/ftocstr.c
faddhost.o:	$(SDIR)/faddhost.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/faddhost.m4 > faddhost.c
	$(CC) $(CFLAGS) faddhost.c
fadvise.o:	$(SDIR)/fadvise.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fadvise.m4 > fadvise.c
	$(CC) $(CFLAGS) fadvise.c
fbarrier.o:	$(SDIR)/fbarrier.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fbarrier.m4 > fbarrier.c
	$(CC) $(CFLAGS) fbarrier.c
fbcast.o:	$(SDIR)/fbcast.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fbcast.m4 > fbcast.c
	$(CC) $(CFLAGS) fbcast.c
fbufinfo.o:	$(SDIR)/fbufinfo.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fbufinfo.m4 > fbufinfo.c
	$(CC) $(CFLAGS) fbufinfo.c
fconfig.o:	$(SDIR)/fconfig.m4 $(M4FILE) $(SDIR)/../src/bfunc.h
	$(M4) $(M4FILE) $(SDIR)/fconfig.m4 > fconfig.c
	$(CC) $(CFLAGS) fconfig.c
fdelhost.o:	$(SDIR)/fdelhost.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fdelhost.m4 > fdelhost.c
	$(CC) $(CFLAGS) fdelhost.c
fexit.o:	$(SDIR)/fexit.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fexit.m4 > fexit.c
	$(CC) $(CFLAGS) fexit.c
ffreebuf.o:	$(SDIR)/ffreebuf.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/ffreebuf.m4 > ffreebuf.c
	$(CC) $(CFLAGS) ffreebuf.c
fgetinst.o:	$(SDIR)/fgetinst.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fgetinst.m4 > fgetinst.c
	$(CC) $(CFLAGS) fgetinst.c
fgetopt.o:	$(SDIR)/fgetopt.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fgetopt.m4 > fgetopt.c
	$(CC) $(CFLAGS) fgetopt.c
fgetrbuf.o:	$(SDIR)/fgetrbuf.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fgetrbuf.m4 > fgetrbuf.c
	$(CC) $(CFLAGS) fgetrbuf.c
fgetsbuf.o:	$(SDIR)/fgetsbuf.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fgetsbuf.m4 > fgetsbuf.c
	$(CC) $(CFLAGS) fgetsbuf.c
fgettid.o:	$(SDIR)/fgettid.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fgettid.m4 > fgettid.c
	$(CC) $(CFLAGS) fgettid.c
fgsize.o:	$(SDIR)/fgsize.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fgsize.m4 > fgsize.c
	$(CC) $(CFLAGS) fgsize.c
finitsnd.o:	$(SDIR)/finitsnd.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/finitsnd.m4 > finitsnd.c
	$(CC) $(CFLAGS) finitsnd.c
fjoingrp.o:	$(SDIR)/fjoingrp.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fjoingrp.m4 > fjoingrp.c
	$(CC) $(CFLAGS) fjoingrp.c
fkill.o:	$(SDIR)/fkill.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fkill.m4 > fkill.c
	$(CC) $(CFLAGS) fkill.c
flvgrp.o:	$(SDIR)/flvgrp.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/flvgrp.m4 > flvgrp.c
	$(CC) $(CFLAGS) flvgrp.c
fmcast.o:	$(SDIR)/fmcast.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fmcast.m4 > fmcast.c
	$(CC) $(CFLAGS) fmcast.c
fmkbuf.o:	$(SDIR)/fmkbuf.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fmkbuf.m4 > fmkbuf.c
	$(CC) $(CFLAGS) fmkbuf.c
fmstat.o:	$(SDIR)/fmstat.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fmstat.m4 > fmstat.c
	$(CC) $(CFLAGS) fmstat.c
fmytid.o:	$(SDIR)/fmytid.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fmytid.m4 > fmytid.c
	$(CC) $(CFLAGS) fmytid.c
fnotify.o:	$(SDIR)/fnotify.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fnotify.m4 > fnotify.c
	$(CC) $(CFLAGS) fnotify.c
fnrecv.o:	$(SDIR)/fnrecv.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fnrecv.m4 > fnrecv.c
	$(CC) $(CFLAGS) fnrecv.c
fpack.o:	$(SDIR)/fpack.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fpack.m4 > fpack.c
	$(CC) $(CFLAGS) fpack.c
fparent.o:	$(SDIR)/fparent.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fparent.m4 > fparent.c
	$(CC) $(CFLAGS) fparent.c
fperror.o:	$(SDIR)/fperror.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fperror.m4 > fperror.c
	$(CC) $(CFLAGS) fperror.c
fprobe.o:	$(SDIR)/fprobe.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fprobe.m4 > fprobe.c
	$(CC) $(CFLAGS) fprobe.c
fpstat.o:	$(SDIR)/fpstat.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fpstat.m4 > fpstat.c
	$(CC) $(CFLAGS) fpstat.c
frecv.o:	$(SDIR)/frecv.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/frecv.m4 > frecv.c
	$(CC) $(CFLAGS) frecv.c
fsend.o:	$(SDIR)/fsend.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fsend.m4 > fsend.c
	$(CC) $(CFLAGS) fsend.c
fsendsig.o:	$(SDIR)/fsendsig.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fsendsig.m4 > fsendsig.c
	$(CC) $(CFLAGS) fsendsig.c
fserror.o:	$(SDIR)/fserror.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fserror.m4 > fserror.c
	$(CC) $(CFLAGS) fserror.c
fsetopt.o:	$(SDIR)/fsetopt.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fsetopt.m4 > fsetopt.c
	$(CC) $(CFLAGS) fsetopt.c
fsetrbuf.o:	$(SDIR)/fsetrbuf.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fsetrbuf.m4 > fsetrbuf.c
	$(CC) $(CFLAGS) fsetrbuf.c
fsetsbuf.o:	$(SDIR)/fsetsbuf.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fsetsbuf.m4 > fsetsbuf.c
	$(CC) $(CFLAGS) fsetsbuf.c
fspawn.o:	$(SDIR)/fspawn.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/fspawn.m4 > fspawn.c
	$(CC) $(CFLAGS) fspawn.c
ftasks.o:	$(SDIR)/ftasks.m4 $(M4FILE) $(SDIR)/../src/bfunc.h
	$(M4) $(M4FILE) $(SDIR)/ftasks.m4 > ftasks.c
	$(CC) $(CFLAGS) ftasks.c
ftidtoh.o:	$(SDIR)/ftidtoh.m4 $(M4FILE) $(SDIR)/../src/bfunc.h
	$(M4) $(M4FILE) $(SDIR)/ftidtoh.m4 > ftidtoh.c
	$(CC) $(CFLAGS) ftidtoh.c
funpack.o:	$(SDIR)/funpack.m4 $(M4FILE)
	$(M4) $(M4FILE) $(SDIR)/funpack.m4 > funpack.c
	$(CC) $(CFLAGS) funpack.c
