/* Copyright (C) 2001-2011 Artifex Software, Inc.
   All Rights Reserved.

   This software is provided AS-IS with no warranty, either express or
   implied.

   This software is distributed under license and may not be copied, modified
   or distributed except as expressly authorized under the terms of that
   license.  Refer to licensing information at http://www.artifex.com/
   or contact Artifex Software, Inc.,  7 Mt. Lassen Drive - Suite A-134,
   San Rafael, CA  94903, U.S.A., +1(415)492-9861, for further information.
*/

/* $Id: opdfread.h 11951 2010-12-15 08:22:58Z ken */
/* opdfread.ps - A procset for interpreting an ordered PDF 1.3 file. */
/* Originally stored in gs/Resource/Init as opdfread.ps and built into
 * the ROM file system, this file was referenced by ps2write when
 * writing PostScript output. With the inclusion of ps2write in the
 * PCL and XPS interpreters we can no longer rely on the PostScript
 * resources being present, and so this file has been converted to
 * 'C' and included as a header. The original file is now stored
 * in gs/lib with the comments intact.
 */
const char *opdfread_ps [] = {
"currentdict/DSC_OPDFREAD known{\n",
"currentdict/DSC_OPDFREAD get\n",
"}{\n",
"false\n",
"}ifelse\n",
"10 dict begin\n",
"/DSC_OPDFREAD exch def\n",
"/this currentdict def\n",
"/y 720 def\n",
"/ebuf 200 string def\n",
"/prnt{\n",
"36//this/y get moveto//ebuf cvs show\n",
"//this/y 2 copy get 12 sub put\n",
"}bind def\n",
"/newline{\n",
"36//this/y get moveto\n",
"//this/y 2 copy get 12 sub put\n",
"}bind def\n",
"errordict/handleerror\n",
"{systemdict begin\n",
"$error begin\n",
"newerror\n",
"{(%%[ Error handled by opdfread.ps : )print errorname//ebuf cvs print(; OffendingCommand: )\n",
"print/command load//ebuf cvs print( ]%%)= flush\n",
"/newerror false store vmstatus pop pop 0 ne\n",
"{grestoreall\n",
"}if\n",
"errorname(VMerror)ne\n",
"{showpage\n",
"}if\n",
"initgraphics\n",
"0 720 moveto\n",
"errorname(VMerror)eq\n",
"{//this/ehsave known\n",
"{clear//this/ehsave get restore 2 vmreclaim\n",
"}if\n",
"vmstatus exch pop exch pop\n",
"}\n",
"/Courier 12 selectfont\n",
"{\n",
"(ERROR: )//prnt exec errorname//prnt exec\n",
"(OFFENDING COMMAND: )//prnt exec\n",
"/command load//prnt exec\n",
"$error/ostack known{\n",
"(%%[STACK:)=\n",
"(STACK:)//prnt exec\n",
"$error/ostack get aload length{\n",
"//newline exec\n",
"dup mark eq{\n",
"(-mark-)dup = show\n",
"}{\n",
"dup type/nametype eq{\n",
"dup xcheck not{\n",
"(/)show\n",
"(/)print\n",
"}if\n",
"}if\n",
"dup =//ebuf cvs show\n",
"}ifelse\n",
"}repeat\n",
"}if\n",
"}ifelse\n",
"(%%]%)=\n",
"//systemdict/showpage get exec\n",
"quit\n",
"}if\n",
"end\n",
"end\n",
"}bind readonly put\n",
"end\n",
"50 dict begin\n",
"/DefaultSwitch\n",
"{\n",
"dup where{\n",
"pop pop\n",
"}{\n",
"false def\n",
"}ifelse\n",
"}bind def\n",
"/=string 256 string def\n",
"/=only{\n",
"//=string cvs print\n",
"}bind def\n",
"/HexDigits(0123456789ABCDEF)readonly def\n",
"/PrintHex\n",
"{8{\n",
"dup -28 bitshift//HexDigits exch 1 getinterval//=only exec\n",
"4 bitshift\n",
"}repeat\n",
"pop\n",
"}bind def\n",
"/PDFR_DEBUG DefaultSwitch\n",
"/PDFR_DUMP DefaultSwitch\n",
"/PDFR_STREAM DefaultSwitch\n",
"/TTFDEBUG DefaultSwitch\n",
"/RotatePages DefaultSwitch\n",
"/FitPages DefaultSwitch\n",
"/CenterPages DefaultSwitch\n",
"/SetPageSize DefaultSwitch\n",
"/error\n",
"{\n",
"counttomark 1 sub -1 0{\n",
"index dup type/arraytype eq{==}{=only}ifelse\n",
"}for\n",
"()=\n",
"cleartomark\n",
"....Undefined\n",
"}bind def\n",
"//SetPageSize{\n",
"//RotatePages//FitPages or//CenterPages or{\n",
"mark(/RotatePages, /FitPages and CenterPages are not allowed with /SetPageSize)//error exec\n",
"}if\n",
"}\n",
"{\n",
"//FitPages//CenterPages and{\n",
"mark(CenterPages is not allowed with /FitPages)//error exec\n",
"}if\n",
"}\n",
"ifelse\n",
"/knownget\n",
"{\n",
"2 copy known{\n",
"get true\n",
"}{\n",
"pop pop false\n",
"}ifelse\n",
"}bind def\n",
"/IsUpper\n",
"{dup(A)0 get ge exch(Z)0 get le and\n",
"}bind def\n",
"/cpa2g{\n",
"dup length array\n",
"0 1 2 index length 1 sub{\n",
"dup 3 index exch get cp2g\n",
"3 copy put pop pop\n",
"}for\n",
"exch pop\n",
"}bind def\n",
"/cpd2g{\n",
"dup length dict exch{\n",
"cp2g 2 index 3 1 roll put\n",
"}forall\n",
"}bind def\n",
"/cps2g{\n",
"dup length string copy\n",
"}bind def\n",
"/cp2gprocs\n",
"<</arraytype//cpa2g/dicttype//cpd2g/packedarraytype//cpa2g/stringtype//cps2g >>\n",
"def\n",
"/cp2g{\n",
"dup gcheck not{\n",
"dup//cp2gprocs 1 index type\n",
"2 copy known{\n",
"get currentglobal 3 1 roll true setglobal exec exch setglobal\n",
"1 index wcheck not{readonly}if\n",
"1 index xcheck{cvx}if\n",
"exch pop\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}if\n",
"}bind def\n",
"/BlockBuffer 65535 string def\n",
"/PDFReader currentdict def\n",
"/ObjectRegistryMaxLength 50000 def\n",
"/ObjectRegistry 10 dict def\n",
"ObjectRegistry\n",
"begin 0 ObjectRegistryMaxLength dict def end\n",
"/CurrentObject null def\n",
"/DoneDocumentStructure false def\n",
"/GraphicState 20 dict begin\n",
"/InitialTextMatrix matrix def\n",
"/InitialMatrix matrix currentmatrix def\n",
"currentdict end def\n",
"/TempMatrix matrix def\n",
"/GraphicStateStack 20 array def\n",
"/GraphicStateStackPointer 0 def\n",
"/InitialTextMatrixStack 20 array def\n",
"/InitialTextMatrixStackPointer 0 def\n",
"/PDFColorSpaces 50 dict def\n",
"/InstalledFonts 50 dict def\n",
"/MacRomanEncodingInverse null def\n",
"currentglobal false setglobal\n",
"userdict/PDFR_InitialGS gstate put\n",
"userdict/PDFR_Patterns 50 dict put\n",
"userdict/FuncDataReader 10 dict put\n",
"setglobal\n",
"/InitialExtGState 20 dict begin\n",
"/BG2 currentblackgeneration cp2g def\n",
"/UCR2 currentundercolorremoval cp2g def\n",
"/TR2 currentglobal false setglobal[currentcolortransfer]exch setglobal cp2g def\n",
"/HT currenthalftone cp2g def\n",
"currentdict end readonly def\n",
"/InitialGraphicState 20 dict begin\n",
"/FontSize 0 def\n",
"/CharacterSpacing 0 def\n",
"/TextLeading 0 def\n",
"/TextRenderingMode 0 def\n",
"/WordSpacing 0 def\n",
"currentdict end readonly def\n",
"/SimpleColorSpaceNames 15 dict begin\n",
"/DeviceGray true def\n",
"/DeviceRGB true def\n",
"/DeviceCMYK true def\n",
"currentdict end readonly def\n",
"/1_24_bitshift_1_sub 1 24 bitshift 1 sub def\n",
"/ReadFontProcs 10 dict def\n",
"/GetObject{\n",
"dup ObjectRegistryMaxLength idiv\n",
"//PDFReader /ObjectRegistry get exch knownget\n",
"{exch knownget}{pop false}ifelse\n",
"}bind def\n",
"/PutObject\n",
"{1 index ObjectRegistryMaxLength idiv\n",
"//PDFReader /ObjectRegistry get 1 index knownget{\n",
"exch pop 3 1 roll put}{\n",
"//PDFReader /ObjectRegistry get dup begin\n",
"1 index ObjectRegistryMaxLength dict def\n",
"end exch get 3 1 roll put\n",
"}ifelse\n",
"}bind def\n",
"/Register\n",
"{1 index GetObject{\n",
"dup xcheck{\n",
"4 3 roll pop\n",
"//PDFR_DEBUG{\n",
"(Have a daemon for ) print 2 index ==\n",
"}if\n",
"exec\n",
"}{\n",
"dup null ne{\n",
"mark (The object ) 4 index (is already defined : ) 4 index //error exec\n",
"}{\n",
"pop\n",
"}ifelse\n",
"3 2 roll\n",
"exec\n",
"}ifelse\n",
"}{\n",
"3 2 roll\n",
"exec\n",
"}ifelse\n",
"PutObject\n",
"} bind def\n",
"/IsRegistered{\n",
"GetObject{\n",
"null ne\n",
"}{\n",
"false\n",
"}ifelse\n",
"}bind def\n",
"/GetRegistered{\n",
"dup GetObject not{\n",
"exch mark exch (Object ) exch ( isn't defined before needed (1).) //error exec\n",
"}if\n",
"dup xcheck{\n",
"exch mark exch (Object ) exch ( isn't defined before needed (2).) //error exec\n",
"}{\n",
"dup null eq{\n",
"exch mark exch (Object ) exch ( isn't defined before needed (3).) //error exec\n",
"}if\n",
"exch pop\n",
"}ifelse\n",
"}bind def\n",
"/StandardFontNames<<\n",
"/Times-Roman true\n",
"/Helvetica true\n",
"/Courier true\n",
"/Symbol true\n",
"/Times-Bold true\n",
"/Helvetica-Bold true\n",
"/Courier-Bold true\n",
"/ZapfDingbats true\n",
"/Times-Italic true\n",
"/Helvetica-Oblique true\n",
"/Courier-Oblique true\n",
"/Times-BoldItalic true\n",
"/Helvetica-BoldOblique true\n",
"/Courier-BoldOblique true\n",
">>def\n",
"/CleanAllResources\n",
"{//PDFR_DEBUG{\n",
"(CleanAllResources beg)=\n",
"}if\n",
"//PDFReader/ObjectRegistry get{\n",
"dup length 0 exch 1 exch 1 sub{\n",
"2 copy get dup xcheck{\n",
"pop pop\n",
"}{\n",
"dup null eq{\n",
"pop pop\n",
"}{\n",
"dup type/dicttype eq{/.Global known}{pop false}ifelse{\n",
"pop\n",
"}{\n",
"//PDFR_DEBUG{\n",
"(Dropping )print dup =\n",
"}if\n",
"1 index exch/DroppedObject put\n",
"}ifelse\n",
"}ifelse\n",
"}ifelse\n",
"}for\n",
"pop\n",
"}forall\n",
"FontDirectory length dict begin\n",
"FontDirectory{\n",
"pop\n",
"dup//StandardFontNames exch known not{\n",
"dup null def\n",
"}if\n",
"pop\n",
"}forall\n",
"currentdict\n",
"end{\n",
"pop\n",
"//PDFR_DEBUG{\n",
"(Undefining font )print dup =\n",
"}if\n",
"undefinefont\n",
"}forall\n",
"//PDFR_DEBUG{\n",
"(CleanAllResources end)=\n",
"}if\n",
"}bind def\n",
"/PrintReference\n",
"{\n",
"//PDFR_DEBUG{\n",
"({ )print\n",
"dup{\n",
"=only( )print\n",
"}forall\n",
"( })=\n",
"}if\n",
"}bind def\n",
"/R\n",
"{\n",
"0 ne{\n",
"exch mark exch(A referred object generation )exch( isn't 0.)//error exec\n",
"}if\n",
"[\n",
"exch//GetRegistered/exec load\n",
"]cvx\n",
"//PrintReference exec\n",
"}bind def\n",
"/IsObjRef\n",
"{\n",
"dup type/arraytype eq{\n",
"dup length 3 eq{\n",
"dup xcheck exch\n",
"dup 0 get type/integertype eq 3 2 roll and exch\n",
"dup 1 get//GetRegistered eq 3 2 roll and exch\n",
"2 get/exec load eq and\n",
"}{\n",
"pop false\n",
"}ifelse\n",
"}{\n",
"pop false\n",
"}ifelse\n",
"}bind def\n",
"/DoNothing\n",
"{\n",
"}def\n",
"/RunTypeDaemon\n",
"{\n",
"dup type/dicttype eq{\n",
"dup/Type//knownget exec{\n",
"//PDFReader/TypeDaemons get exch\n",
"//knownget exec{\n",
"exec\n",
"}if\n",
"}if\n",
"}if\n",
"}bind def\n",
"/obj\n",
"{\n",
"//PDFR_DEBUG{\n",
"(Defining )print 1 index =only( )print dup =only( obj)=\n",
"}if\n",
"0 ne{\n",
"exch mark exch(An object generation )exch( isn't 0.)//error exec\n",
"}if\n",
"}bind def\n",
"/endobj\n",
"{\n",
"//PDFR_DEBUG{\n",
"(endobj )=\n",
"}if\n",
"dup type/dicttype eq{\n",
"dup/.endobj_daemon//knownget exec{\n",
"//PDFR_DEBUG{(.endobj_daemon for )print 2 index =}if\n",
"exec\n",
"}if\n",
"}if\n",
"dup type/dicttype eq{dup/ImmediateExec known}{false}ifelse{\n",
"pop pop\n",
"}{\n",
"//PDFR_DEBUG{\n",
"(Storing )print 1 index =\n",
"}if\n",
"//RunTypeDaemon exec\n",
"//DoNothing 3 1 roll//Register exec\n",
"}ifelse\n",
"}bind def\n",
"/StoreBlock\n",
"{\n",
"//PDFR_DEBUG{\n",
"(StoreBlock )print//PDFReader/BlockCount get =only(, Length = )print dup length =\n",
"}if\n",
"dup length string copy\n",
"//PDFReader/BlockCount get exch\n",
"//PDFReader/CurrentObject get 3 1 roll\n",
"put\n",
"//PDFReader/BlockCount get 1 add\n",
"//PDFReader exch/BlockCount exch put\n",
"}bind def\n",
"/CheckLength\n",
"{dup type/integertype ne{\n",
"mark(Object length isn't an integer.)//error exec\n",
"}if\n",
"}bind def\n",
"/ResolveD\n",
"{\n",
"3 copy pop get\n",
"dup//IsObjRef exec{\n",
"//PDFR_DEBUG{\n",
"(Resolving )print//PrintReference exec\n",
"}if\n",
"exec\n",
"exch exec\n",
"}{\n",
"exch pop\n",
"}ifelse\n",
"dup 4 1 roll\n",
"put\n",
"}bind def\n",
"/ResolveA\n",
"{2 index 2 index get\n",
"dup//IsObjRef exec{\n",
"exec\n",
"exch exec\n",
"3 copy put\n",
"}{\n",
"exch pop\n",
"}ifelse\n",
"exch pop exch pop\n",
"}bind def\n",
"/StoreStream\n",
"{\n",
"dup//PDFReader exch/CurrentObject exch put\n",
"//PDFReader/BlockCount 0 put\n",
"dup/Length//CheckLength//ResolveD exec\n",
"//PDFR_DEBUG{\n",
"(StoreStream Length = )print dup =\n",
"}if\n",
"currentfile exch()/SubFileDecode filter\n",
"{dup//BlockBuffer readstring{\n",
"//StoreBlock exec\n",
"}{\n",
"//StoreBlock exec\n",
"exit\n",
"}ifelse\n",
"}loop\n",
"pop\n",
"//PDFReader/CurrentObject null put\n",
"//PDFR_DEBUG{\n",
"(StoreStream end.)=\n",
"}if\n",
"}bind def\n",
"/MakeStreamDumper\n",
"{\n",
"//PDFR_DEBUG{\n",
"(MakeStreamDumper beg.)=\n",
"}if\n",
"currentglobal exch dup gcheck setglobal\n",
"[exch\n",
"1 dict dup/c 0 put exch\n",
"1024 string\n",
"{readstring pop\n",
"(StreamDumper )print 1 index/c get =string cvs print( )print\n",
"dup length =string cvs print( <)print dup print(>\\n)print\n",
"dup length\n",
"3 2 roll\n",
"dup/c get\n",
"3 2 roll\n",
"add/c exch put\n",
"}/exec load\n",
"]\n",
"cvx 0()/SubFileDecode filter\n",
"exch setglobal\n",
"//PDFR_DEBUG{\n",
"(MakeStreamDumper end.)=\n",
"}if\n",
"}bind def\n",
"/ShortFilterNames 15 dict begin\n",
"/AHx/ASCIIHexDecode def\n",
"/A85/ASCII85Decode def\n",
"/LZW/LZWDecode def\n",
"/Fl/FlateDecode def\n",
"/RL/RunLengthDecode def\n",
"/CCF/CCITTFaxDecode def\n",
"/DCT/DCTDecode def\n",
"currentdict end readonly def\n",
"/AppendFilters\n",
"{\n",
"//PDFR_DEBUG{\n",
"(AppendFilters beg.)=\n",
"}if\n",
"dup 3 1 roll\n",
"/Filter//knownget exec{\n",
"dup type/nametype eq{\n",
"dup//ShortFilterNames exch//knownget exec{\n",
"exch pop\n",
"}if\n",
"2 index/DecodeParms//knownget exec{\n",
"exch\n",
"}if\n",
"filter\n",
"}{\n",
"dup 0 exch 1 exch length 1 sub{\n",
"2 copy get\n",
"dup//ShortFilterNames exch//knownget exec{\n",
"exch pop\n",
"}if\n",
"3 1 roll\n",
"4 index/DecodeParms//knownget exec{\n",
"exch get\n",
"}{\n",
"pop null\n",
"}ifelse\n",
"dup null eq{\n",
"pop 3 1 roll filter exch\n",
"}{\n",
"3 1 roll\n",
"4 1 roll filter exch\n",
"}ifelse\n",
"}for\n",
"pop\n",
"}ifelse\n",
"//PDFR_DEBUG//PDFR_DUMP and{\n",
"//MakeStreamDumper exec\n",
"}if\n",
"}if\n",
"exch pop\n",
"//PDFR_DEBUG{\n",
"(AppendFilters end.)=\n",
"}if\n",
"}bind def\n",
"/ExecuteStream\n",
"{\n",
"dup//PDFReader exch/CurrentObject exch put\n",
"dup/Length//CheckLength//ResolveD exec\n",
"//PDFR_DEBUG{\n",
"(ExecuteStream id = )print 2 index =only( Length = )print dup =\n",
"}if\n",
"//PDFReader/InitialGraphicState get\n",
"//PDFReader/GraphicState get copy pop\n",
"//PDFReader/Operators get begin\n",
"pop currentfile 0(endstream)/SubFileDecode filter\n",
"1 index//AppendFilters exec\n",
"cvx mark exch\n",
"exec\n",
"counttomark 0 ne{\n",
"mark(Data left on ostack after an immediate stream execution.)//error exec\n",
"}if\n",
"cleartomark\n",
"end\n",
"//PDFR_DEBUG{\n",
"(ExecuteStream end.)=\n",
"}if\n",
"//PDFReader/CurrentObject null put\n",
"dup/IsPage known{\n",
"dup/Context get/NumCopies//knownget exec{\n",
"1 sub{\n",
"copypage\n",
"}repeat\n",
"}if\n",
"showpage\n",
"}if\n",
"}bind def\n",
"/stream\n",
"{\n",
"//PDFR_DEBUG{\n",
"1 index =only( stream)=\n",
"}if\n",
"1 index GetObject{\n",
"dup xcheck{\n",
"exec\n",
"1 index null PutObject\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}if\n",
"dup/ImmediateExec known{\n",
"dup/GlobalExec//knownget exec{\n",
"currentglobal 4 1 roll\n",
"setglobal\n",
"//ExecuteStream exec\n",
"3 2 roll setglobal\n",
"}{\n",
"//ExecuteStream exec\n",
"}ifelse\n",
"}{\n",
"//StoreStream exec\n",
"}ifelse\n",
"dup/.CleanResources//knownget exec{\n",
"/All eq{\n",
"//CleanAllResources exec\n",
"}if\n",
"}if\n",
"}bind def\n",
"/HookFont\n",
"{\n",
"//PDFR_DEBUG{\n",
"(Loaded the font )print dup/FontName get =\n",
"}if\n",
"{\n",
"dup/FontFileType get dup/Type1 eq exch/MMType1 eq or{\n",
"dup/FontName get\n",
"//PDFReader/RemoveFontNamePrefix get exec\n",
"findfont\n",
"exit\n",
"}if\n",
"dup/FontFileType get/TrueType eq{\n",
"//PDFReader/MakeType42 get exec\n",
"//PDFR_DEBUG{\n",
"(Font dict <<)=\n",
"dup{\n",
"1 index/sfnts eq{\n",
"exch pop\n",
"(/sfnts [)print\n",
"{\n",
"(-string\\()print length//=only exec(\\)- )=\n",
"}forall\n",
"(])=\n",
"}{\n",
"exch//=only exec( )print ==\n",
"}ifelse\n",
"}forall\n",
"(>>)=\n",
"}if\n",
"dup/FontName get exch definefont\n",
"exit\n",
"}if\n",
"mark(FontHook has no proc for )2 index/FontFileType get//error exec\n",
"}loop\n",
"/Font exch put\n",
"}bind def\n",
"/endstream\n",
"{\n",
"}bind def\n",
"/xref\n",
"{\n",
"//PDFR_DEBUG{\n",
"(xref)=\n",
"//PDFR_DUMP{\n",
"//PDFReader/ObjectRegistry get ==\n",
"}if\n",
"}if\n",
"end\n",
"count 0 ne{\n",
"mark(Excessive data on estack at the end of the interpretation.)//error exec\n",
"}if\n",
"currentfile 1(%%EOF)/SubFileDecode filter\n",
"flushfile\n",
"cleardictstack\n",
"}bind def\n",
"/ResolveDict\n",
"{dup{\n",
"pop 1 index exch\n",
"//DoNothing//ResolveD exec\n",
"pop\n",
"}forall\n",
"pop\n",
"}bind def\n",
"/SetupPageView\n",
"{\n",
"//PDFR_DEBUG{\n",
"(SetupPageView beg)=\n",
"}if\n",
"//DSC_OPDFREAD not{\n",
"//GraphicState/InitialMatrix get setmatrix\n",
"}if\n",
"/MediaBox get aload pop\n",
"3 index neg 3 index neg translate\n",
"3 -1 roll sub 3 1 roll exch sub exch\n",
"userdict/.HWMargins//knownget exec{\n",
"aload pop\n",
"}{\n",
"currentpagedevice/.HWMargins//knownget exec{\n",
"aload pop\n",
"}{\n",
"0 0 0 0\n",
"}ifelse\n",
"}ifelse\n",
"currentpagedevice/PageSize get aload pop\n",
"3 -1 roll sub 3 1 roll exch sub exch\n",
"exch 3 index sub exch 3 index sub\n",
"//SetPageSize{\n",
"//PDFR_DEBUG{\n",
"(Setting page size to )print 1 index//=only exec( )print dup =\n",
"}if\n",
"pop pop 3 index 3 index 2 copy\n",
"currentglobal false setglobal 3 1 roll\n",
"currentpagedevice dup /PageSize known{\n",
"/PageSize get aload pop}{\n",
"0 0}ifelse\n",
"round cvi 2 index round cvi eq\n",
"exch round cvi 3 index round cvi eq and{\n",
"pop pop}{\n",
"2 array astore\n",
"<< exch /PageSize exch >> setpagedevice\n",
"} ifelse\n",
"userdict/PDFR_InitialGS gstate put\n",
"setglobal\n",
"}if\n",
"//RotatePages{\n",
"2 copy gt 6 index 6 index gt ne{\n",
"1 index 5 index le 1 index 5 index le and not\n",
"}{\n",
"false\n",
"}ifelse\n",
"}{\n",
"false\n",
"}ifelse\n",
"{//CenterPages{\n",
"//PDFR_DEBUG{\n",
"(Rotating page, and then centering it)==\n",
"}if\n",
"90 rotate\n",
"0 5 index neg translate\n",
"5 index 1 index exch sub 2 div\n",
"2 index 6 index sub 2 div neg\n",
"translate\n",
"}{\n",
"//FitPages{\n",
"1 index 5 index div 1 index 7 index div\n",
"2 copy gt{\n",
"exch\n",
"}if\n",
"pop dup scale\n",
"}if\n",
"90 rotate\n",
"0 5 index neg translate\n",
"}ifelse\n",
"}{\n",
"//CenterPages{\n",
"//PDFR_DEBUG{\n",
"(Ccentering page)==\n",
"}if\n",
"1 index 6 index sub 2 div\n",
"1 index 6 index sub 2 div\n",
"translate\n",
"}{\n",
"//FitPages{\n",
"1 index 6 index div 1 index 6 index div\n",
"2 copy gt{\n",
"exch\n",
"}if\n",
"pop dup scale\n",
"}if\n",
"}ifelse\n",
"}ifelse\n",
"pop pop\n",
"translate\n",
"pop pop\n",
"//PDFR_DEBUG{\n",
"(SetupPageView end)=\n",
"}if\n",
"}bind def\n",
"/PageContentsDaemon\n",
"{\n",
"//PDFR_DEBUG{\n",
"(Executing PageContentsDaemon for )print 2 index =\n",
"}if\n",
"1 index exch/Context exch put\n",
"dup/ImmediateExec true put\n",
"dup/IsPage true put\n",
"dup/Context get//SetupPageView exec\n",
"}bind def\n",
"/FontFileDaemon\n",
"{\n",
"//PDFR_DEBUG{\n",
"(Executing FontFileDaemon for )print 2 index =\n",
"}if\n",
"dup/FontFileType get\n",
"2 index exch\n",
"dup//ReadFontProcs exch//knownget exec{\n",
"exch pop exec\n",
"}{\n",
"mark(FontFile reader for )2 index( isn't implemented yet.)//error exec\n",
"}ifelse\n",
"//PDFR_DEBUG{\n",
"(FontFileDaemon end)=\n",
"}if\n",
"pop\n",
"}bind def\n",
"/FontDescriptorDaemon\n",
"{\n",
"//PDFR_DEBUG{\n",
"(Executing FontDescriptorDaemon for )print 2 index =\n",
"}if\n",
"2 copy/FontResource exch put\n",
"/Subtype get 1 index exch/FontFileType exch put\n",
"}bind def\n",
"/UnPDFEscape{\n",
"dup dup length string cvs\n",
"dup(#)search{\n",
"{\n",
"pop\n",
"(16#--)2 index 0 2 getinterval\n",
"1 index 3 2 getinterval copy pop\n",
"cvi\n",
"0 exch put\n",
"0\n",
"1 index 2 1 index length 2 sub getinterval\n",
"3 copy putinterval\n",
"length\n",
"3 copy exch put\n",
"getinterval\n",
"(#)search not{\n",
"pop exit\n",
"}if\n",
"}loop\n",
"(\\0)search pop exch pop exch pop\n",
"cvn\n",
"exch pop\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}bind def\n",
"/TypeDaemons<<\n",
"/Page\n",
"{//PDFR_DEBUG{\n",
"(Recognized a page.)=\n",
"}if\n",
"dup/Contents//knownget exec{\n",
"0 get//DoNothing exch\n",
"[\n",
"3 index//PageContentsDaemon/exec load\n",
"]cvx\n",
"//Register exec\n",
"}{\n",
"(fixme: page with no Contents won't be printed.)=\n",
"}ifelse\n",
"}bind\n",
"/FontDescriptor\n",
"{//PDFR_DEBUG{\n",
"(Recognized a font descriptor.)=\n",
"}if\n",
"dup/FontName//knownget exec{\n",
"1 index/FontName 3 -1 roll//UnPDFEscape exec put\n",
"}if\n",
"dup dup/FontFile known{/FontFile}{/FontFile2}ifelse\n",
"//knownget exec{\n",
"0 get//DoNothing exch\n",
"[\n",
"3 index//FontFileDaemon/exec load\n",
"]cvx\n",
"//Register exec\n",
"}{\n",
"(Font descriptor )print 1 index =only( has no FontFile.)=\n",
"}ifelse\n",
"}bind\n",
"/Font\n",
"{//PDFR_DEBUG{\n",
"(Recognized a font resource.)=\n",
"}if\n",
"dup/BaseFont//knownget exec{\n",
"//UnPDFEscape exec 2 copy/BaseFont exch put\n",
"//PDFReader/RemoveFontNamePrefix get exec\n",
"currentglobal exch\n",
"dup/Font resourcestatus{\n",
"pop pop\n",
"//PDFReader/GetInstalledFont get exec pop\n",
"}{\n",
"pop\n",
"}ifelse\n",
"setglobal\n",
"}if\n",
"dup/FontDescriptor//knownget exec{\n",
"0 get\n",
"dup//IsRegistered exec{\n",
"//PDFR_DEBUG{\n",
"(already registered )print dup =\n",
"}if\n",
"pop\n",
"}{\n",
"//DoNothing exch\n",
"[\n",
"3 index//FontDescriptorDaemon/exec load\n",
"]cvx\n",
"//Register exec\n",
"}ifelse\n",
"}if\n",
"}bind\n",
">>def\n",
"/MakeStreamReader\n",
"{dup\n",
"[\n",
"exch\n",
"//PDFR_DEBUG{\n",
"(Stream proc )\n",
"/print load\n",
"//PDFR_STREAM{\n",
"(<)\n",
"/print load\n",
"}if\n",
"}if\n",
"1 dict dup/i -1 put\n",
"/dup load\n",
"/i\n",
"/get load\n",
"1\n",
"/add load\n",
"/dup load\n",
"3\n",
"1\n",
"/roll load\n",
"/i\n",
"/exch load\n",
"/put load\n",
"//knownget\n",
"/exec load\n",
"/not load\n",
"{()}\n",
"/if load\n",
"//PDFR_DEBUG{\n",
"//PDFR_STREAM{\n",
"/dup load\n",
"/print load\n",
"(>)\n",
"/print load\n",
"}if\n",
"( end of stream proc.\\n)\n",
"/print load\n",
"}if\n",
"]cvx\n",
"//PDFR_DEBUG{\n",
"(Stream reader )print dup ==\n",
"}if\n",
"0()/SubFileDecode filter\n",
"exch//AppendFilters exec\n",
"}bind def\n",
"/RunDelayedStream\n",
"{\n",
"//GraphicState/InitialTextMatrix get\n",
"//InitialTextMatrixStack//PDFReader/InitialTextMatrixStackPointer get\n",
"2 copy get null eq{\n",
"2 copy currentglobal true setglobal matrix exch setglobal put\n",
"}if\n",
"get copy pop\n",
"//PDFReader/InitialTextMatrixStackPointer 2 copy get 1 add put\n",
"//MakeStreamReader exec\n",
"mark exch\n",
"cvx exec\n",
"counttomark 0 ne{\n",
"mark(Data left on ostack after a delayed stream execution.)//error exec\n",
"}if\n",
"cleartomark\n",
"//PDFReader/InitialTextMatrixStackPointer 2 copy get 1 sub put\n",
"//InitialTextMatrixStack//PDFReader/InitialTextMatrixStackPointer get get\n",
"//GraphicState/InitialTextMatrix get\n",
"copy pop\n",
"}bind def\n",
"//ReadFontProcs begin\n",
"/Type1\n",
"{//PDFR_DEBUG{\n",
"(ReadFontProcs.Type1)=\n",
"}if\n",
"dup/.endobj_daemon[4 index//HookFont/exec load]cvx put\n",
"dup/ImmediateExec true put\n",
"/GlobalExec true put\n",
"}bind def\n",
"/MMType1//Type1 def\n",
"/TrueType\n",
"{//PDFR_DEBUG{\n",
"(ReadFontProcs.TrueType)=\n",
"}if\n",
"dup/.endobj_daemon[4 index//HookFont/exec load]cvx put\n",
"pop\n",
"}bind def\n",
"end\n",
"/.opdloadttfontdict 50 dict def\n",
".opdloadttfontdict begin\n",
"/maxstring 65400 def\n",
"end\n",
"/.InsertionSort\n",
"{\n",
"/CompareProc exch def\n",
"/Array exch def\n",
"1 1 Array length 1 sub\n",
"{\n",
"/Ix exch def\n",
"/Value1 Array Ix get def\n",
"/Jx Ix 1 sub def\n",
"{\n",
"Jx 0 lt{\n",
"exit\n",
"}if\n",
"/Value2 Array Jx get def\n",
"Value1 Value2 CompareProc{\n",
"exit\n",
"}if\n",
"Array Jx 1 add Value2 put\n",
"/Jx Jx 1 sub def\n",
"}loop\n",
"Array Jx 1 add Value1 put\n",
"}for\n",
"Array\n",
"}bind def\n",
"/putu16{\n",
"3 copy -8 bitshift put\n",
"exch 1 add exch 16#ff and put\n",
"}bind def\n",
"/putu32{\n",
"3 copy -16 bitshift putu16\n",
"exch 2 add exch 16#ffff and putu16\n",
"}bind def\n",
"/.readtable{\n",
"dup dup 1 and add string\n",
"dup 0 4 -1 roll getinterval\n",
"3 -1 roll exch\n",
"dup()ne{readstring}if pop pop\n",
"}bind def\n",
"/.readbigtable{\n",
"dup maxstring lt{\n",
".readtable\n",
"}{\n",
"currentuserparams/VMReclaim get -2 vmreclaim\n",
"[4 2 roll{\n",
"dup maxstring le{exit}if\n",
"1 index maxstring string readstring pop 3 1 roll maxstring sub\n",
"}loop .readtable]\n",
"exch vmreclaim\n",
"}ifelse\n",
"}bind def\n",
"/ReadTTF\n",
"{\n",
".opdloadttfontdict begin\n",
"/TTFontFile exch def\n",
"/TableDir TTFontFile 12 string readstring pop def\n",
"/tables TTFontFile TableDir 4 getu16 16 mul string readstring pop def\n",
"/tabarray tables length 16 idiv array def\n",
"TableDir 0 4 getinterval(ttcf)eq{\n",
"QUIET not{(Can't handle TrueType font Collections.)=}if\n",
"/.loadttfonttables cvx/invalidfont signalerror\n",
"}{\n",
"0 16 tables length 1 sub{\n",
"dup\n",
"tables exch 16 getinterval\n",
"exch 16 div cvi exch\n",
"tabarray 3 1 roll put\n",
"}for\n",
"}ifelse\n",
"tabarray{exch 8 getu32 exch 8 getu32 gt}.InsertionSort pop\n",
"/Read TableDir length tables length add def\n",
"/tabs[\n",
"tabarray{\n",
"dup 8 getu32\n",
"Read sub\n",
"dup 0 gt{\n",
"dup string TTFontFile exch readstring pop pop\n",
"Read add/Read exch def\n",
"}{\n",
"pop\n",
"}ifelse\n",
"12 getu32\n",
"dup Read add\n",
"/Read exch def\n",
"TTFontFile exch .readbigtable\n",
"}forall\n",
"]def\n",
"end\n",
"}bind def\n",
"/GetLocaType\n",
"{\n",
"0 1 tabarray length 1 sub{\n",
"dup tabarray exch get\n",
"0 4 getinterval(head)eq{\n",
"tabs exch get\n",
"50 gets16\n",
"/LocaType exch def\n",
"exit\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}for\n",
"}bind def\n",
"/GetNumGlyphs\n",
"{\n",
"0 1 tabarray length 1 sub{\n",
"dup tabarray exch get\n",
"0 4 getinterval(maxp)eq{\n",
"tabs exch get\n",
"4 getu16\n",
"/NumGlyphs exch def\n",
"exit\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}for\n",
"}bind def\n",
"/StringToLoca\n",
"{\n",
"/LocaIndex exch def\n",
"/StringOffset 0 def\n",
"{\n",
"dup length StringOffset gt{\n",
"dup\n",
"LocaType 1 eq{\n",
"StringOffset getu32\n",
"LocaArray LocaIndex 3 -1 roll put\n",
"/LocaIndex LocaIndex 1 add def\n",
"/StringOffset StringOffset 4 add\n",
"def\n",
"}{\n",
"dup\n",
"StringOffset getu16\n",
"LocaArray LocaIndex 3 -1 roll put\n",
"/LocaIndex LocaIndex 1 add def\n",
"/StringOffset StringOffset 4 add\n",
"def\n",
"}ifelse\n",
"}{\n",
"pop\n",
"LocaIndex\n",
"exit\n",
"}ifelse\n",
"}loop\n",
"}bind def\n",
"/GetSortedLoca\n",
"{\n",
"NumGlyphs 1 add array/LocaArray exch def\n",
"0 1 tabarray length 1 sub{\n",
"dup tabarray exch get\n",
"0 4 getinterval(loca)eq{\n",
"tabs exch get\n",
"exit\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}for\n",
"dup type/stringtype eq{\n",
"0 StringToLoca pop\n",
"}{\n",
"0 exch\n",
"{\n",
"exch StringToLoca\n",
"}forall\n",
"pop\n",
"}ifelse\n",
"LocaArray{gt}.InsertionSort pop\n",
"}bind def\n",
"/GetWorkingString\n",
"{\n",
"WorkString 0\n",
"GlyfArray GlyfStringIndex get\n",
"putinterval\n",
"/WorkBytes GlyfArray GlyfStringIndex get length def\n",
"/GlyfStringIndex GlyfStringIndex 1 add def\n",
"}bind def\n",
"/GetWorkingBytes\n",
"{\n",
"/BytesToRead exch def\n",
"WorkString 0 BytesToRead getinterval\n",
"dup length string copy\n",
"WorkString BytesToRead WorkBytes BytesToRead sub getinterval\n",
"dup length string copy\n",
"WorkString 0 3 -1 roll putinterval\n",
"/WorkBytes WorkBytes BytesToRead sub def\n",
"}bind def\n",
"/GetGlyfBytes\n",
"{\n",
"/ToRead exch def\n",
"WorkBytes 0 eq{\n",
"GetWorkingString\n",
"}if\n",
"WorkBytes ToRead ge{\n",
"ToRead string dup 0\n",
"ToRead GetWorkingBytes putinterval\n",
"}{\n",
"ToRead string\n",
"dup\n",
"0\n",
"WorkString 0 WorkBytes getinterval\n",
"putinterval\n",
"dup\n",
"WorkBytes\n",
"ToRead WorkBytes sub\n",
"GetWorkingString\n",
"GetWorkingBytes\n",
"putinterval\n",
"}ifelse\n",
"}bind def\n",
"/SplitGlyf\n",
"{\n",
"/GlyfArray exch def\n",
"/DestArray GlyfArray length 2 mul array def\n",
"/DestArrayIndex 0 def\n",
"/LastLoca 0 def\n",
"/NextLocaIndex 0 def\n",
"/LastLocaIndex 0 def\n",
"/GlyfStringIndex 0 def\n",
"/WorkString maxstring string def\n",
"/WorkBytes 0 def\n",
"{\n",
"LocaArray NextLocaIndex get\n",
"LastLoca sub maxstring gt\n",
"{\n",
"LocaArray LastLocaIndex get LastLoca sub\n",
"GetGlyfBytes\n",
"DestArray DestArrayIndex 3 -1 roll put\n",
"/DestArrayIndex DestArrayIndex 1 add def\n",
"LocaArray LastLocaIndex get/LastLoca exch def\n",
"}{\n",
"/LastLocaIndex NextLocaIndex def\n",
"/NextLocaIndex NextLocaIndex 1 add def\n",
"NextLocaIndex NumGlyphs gt\n",
"{\n",
"WorkBytes\n",
"GlyfStringIndex GlyfArray length lt{\n",
"GlyfArray GlyfStringIndex get length\n",
"add string dup\n",
"0\n",
"WorkString 0 WorkBytes getinterval\n",
"putinterval\n",
"dup\n",
"WorkBytes\n",
"GetWorkingString\n",
"WorkString 0 WorkBytes getinterval\n",
"putinterval\n",
"}{\n",
"pop\n",
"WorkString 0 WorkBytes getinterval\n",
"}ifelse\n",
"dup length string copy\n",
"DestArray DestArrayIndex 3 -1 roll put\n",
"exit\n",
"}if\n",
"}ifelse\n",
"}loop\n",
"DestArray\n",
"}bind def\n",
"/ProcessTTData\n",
"{\n",
".opdloadttfontdict begin\n",
"0 1 tabarray length 1 sub{\n",
"/ix exch def\n",
"tabarray ix get\n",
"12 getu32 dup maxstring le{\n",
"dup 4 mod 0 ne{\n",
"4 div cvi 1 add 4 mul string/newstring exch def\n",
"/oldstring tabs ix get def\n",
"newstring 0 oldstring putinterval\n",
"0 1 newstring length oldstring length sub 1 sub{\n",
"newstring exch oldstring length add 0 put\n",
"}for\n",
"tabs ix newstring put\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}{\n",
"dup 4 mod 0 ne{\n",
"dup maxstring idiv maxstring mul sub\n",
"4 idiv 1 add 4 mul string/newstring exch def\n",
"tabs ix get\n",
"dup length 1 sub dup/iy exch def get/oldstring exch def\n",
"newstring 0 oldstring putinterval\n",
"0 1 newstring length oldstring length sub 1 sub{\n",
"newstring exch oldstring length add 0 put\n",
"}for\n",
"tabs ix get iy newstring put\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}ifelse\n",
"}for\n",
"0 1 tabarray length 1 sub{\n",
"dup tabarray exch get\n",
"dup 12 getu32 maxstring gt{\n",
"0 4 getinterval dup(glyf)eq{\n",
"pop\n",
"GetLocaType\n",
"GetNumGlyphs\n",
"GetSortedLoca\n",
"dup tabs exch get\n",
"SplitGlyf\n",
"tabs 3 1 roll put\n",
"}{\n",
"(Warning, table )print print( > 64Kb\\n)print\n",
"pop\n",
"}ifelse\n",
"}{\n",
"pop\n",
"pop\n",
"}ifelse\n",
"}for\n",
"end\n",
"}bind def\n",
"/Makesfnts\n",
"{\n",
".opdloadttfontdict begin\n",
"0\n",
"tabs{\n",
"dup type/stringtype eq{\n",
"pop\n",
"1 add\n",
"}{\n",
"{\n",
"type/stringtype eq{\n",
"1 add\n",
"}if\n",
"}forall\n",
"}ifelse\n",
"}forall\n",
"1 add\n",
"/TTOffset\n",
"TableDir length\n",
"tabarray length 16 mul add\n",
"def\n",
"0\n",
"tabarray{\n",
"exch dup 1 add\n",
"3 1 roll\n",
"dup\n",
"tabs exch get\n",
"dup type/stringtype eq{\n",
"length\n",
"2 index exch\n",
"TTOffset\n",
"dup 3 1 roll add\n",
"/TTOffset exch def\n",
"8 exch putu32\n",
"exch tabarray 3 1 roll\n",
"put\n",
"}{\n",
"0 exch\n",
"{\n",
"dup type/stringtype eq{\n",
"length add\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}forall\n",
"2 index exch\n",
"TTOffset\n",
"dup 3 1 roll add\n",
"/TTOffset exch def\n",
"8 exch putu32\n",
"exch tabarray 3 1 roll\n",
"put\n",
"}ifelse\n",
"}forall\n",
"pop\n",
"array\n",
"dup 0\n",
"TableDir length\n",
"tables length add\n",
"string\n",
"dup 0 TableDir putinterval\n",
"dup 12 tables putinterval\n",
"put\n",
"dup\n",
"/ix 1 def\n",
"tabs{\n",
"dup type/stringtype eq{\n",
"ix exch\n",
"put dup\n",
"/ix ix 1 add def\n",
"}{\n",
"{\n",
"dup type/stringtype eq{\n",
"ix exch put dup\n",
"/ix ix 1 add def\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}forall\n",
"}ifelse\n",
"}forall\n",
"pop\n",
"end\n",
"}bind def\n",
"/MakeType42\n",
"{\n",
"//PDFR_DEBUG{\n",
"(MakeType42 beg)=\n",
"}if\n",
"10 dict begin\n",
"/FontName 1 index/FontName get def\n",
"/FontType 42 def\n",
"/FontMatrix[1 0 0 1 0 0]def\n",
"/FontBBox 1 index/FontBBox get def\n",
"dup/FontResource get\n",
"dup/Encoding known{\n",
"//PDFReader/ObtainEncoding get exec\n",
"/Encoding get\n",
"}{\n",
"pop null\n",
"}ifelse\n",
"/PDFEncoding exch def\n",
"/CharStrings 2 index//PDFReader/MakeTTCharStrings get exec def\n",
"/sfnts 2 index//MakeStreamReader exec\n",
"ReadTTF\n",
"ProcessTTData\n",
"Makesfnts\n",
"def\n",
"/Encoding StandardEncoding def\n",
"/PaintType 0 def\n",
"currentdict end\n",
"//PDFR_DEBUG{\n",
"(MakeType42 end)=\n",
"}if\n",
"}bind def\n",
"/GetInstalledFont\n",
"{\n",
"dup//InstalledFonts exch knownget{\n",
"exch pop\n",
"}{\n",
"dup findfont dup 3 1 roll\n",
"//InstalledFonts 3 1 roll put\n",
"}ifelse\n",
"}bind def\n",
"/RemoveFontNamePrefix\n",
"{//=string cvs true\n",
"0 1 5{\n",
"2 index exch get//IsUpper exec not{\n",
"pop false exit\n",
"}if\n",
"}for\n",
"{(+)search{\n",
"pop pop\n",
"}if\n",
"}if\n",
"cvn\n",
"}bind def\n",
"/CheckFont\n",
"{dup/Type get/Font ne{\n",
"mark(Resource )3 index( must have /Type/Font .)//error exec\n",
"}if\n",
"}bind def\n",
"/CheckEncoding\n",
"{dup type/nametype ne{\n",
"dup/Type get/Encoding ne{\n",
"mark(Resource )3 index( must have /Type/Encoding .)//error exec\n",
"}if\n",
"}if\n",
"}bind def\n",
"/ObtainEncoding\n",
"{dup/Encoding known{\n",
"dup dup/Encoding//CheckEncoding//ResolveD exec\n",
"dup type dup/arraytype eq exch/packedarraytype eq or{\n",
"pop pop\n",
"}{\n",
"dup type/nametype eq{\n",
"/Encoding findresource\n",
"}{\n",
"dup/BaseEncoding//knownget exec not{\n",
"/StandardEncoding\n",
"}if\n",
"/Encoding findresource\n",
"exch\n",
"/Differences//knownget exec{\n",
"exch dup length array copy exch\n",
"0 exch\n",
"{\n",
"dup type/integertype eq{\n",
"exch pop\n",
"}{\n",
"3 copy put pop\n",
"1 add\n",
"}ifelse\n",
"}forall\n",
"pop\n",
"}if\n",
"}ifelse\n",
"/Encoding exch put\n",
"}ifelse\n",
"}{\n",
"dup/Encoding/StandardEncoding/Encoding findresource put\n",
"}ifelse\n",
"}bind def\n",
"/ObtainMetrics\n",
"{dup/Widths//knownget exec{\n",
"1 index/Encoding get\n",
"256 dict\n",
"3 index/Subtype get/TrueType eq{\n",
"1000\n",
"}{\n",
"1\n",
"}ifelse\n",
"4 index/MissingWidth//knownget exec not{\n",
"0\n",
"}if\n",
"5 index/FirstChar//knownget exec not{\n",
"0\n",
"}if\n",
"6 5 roll\n",
"dup 0 exch 1 exch length 1 sub{\n",
"2 copy get\n",
"exch 3 index add\n",
"7 index exch get\n",
"dup dup null ne exch/.notdef ne and{\n",
"6 index 3 1 roll exch\n",
"6 index div\n",
"3 copy pop//knownget exec{\n",
"0 eq\n",
"}{\n",
"true\n",
"}ifelse\n",
"{put\n",
"}{\n",
"pop pop pop\n",
"}ifelse\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}for\n",
"pop pop pop pop exch pop\n",
"1 index exch/Metrics exch put\n",
"}{\n",
"dup/MissingWidth//knownget exec{\n",
"256 dict\n",
"2 index/Encoding get{\n",
"dup null ne{\n",
"3 copy 3 2 roll put\n",
"}if\n",
"pop\n",
"}forall\n",
"exch pop\n",
"1 index exch/Metrics exch put\n",
"}if\n",
"}ifelse\n",
"}bind def\n",
"/NotDef\n",
"{\n",
"FontMatrix aload pop pop pop exch pop exch pop\n",
"1 exch div exch\n",
"1 exch div exch\n",
"1 index 0 setcharwidth\n",
"0 setlinewidth\n",
"0 0 moveto\n",
"2 copy rlineto\n",
"1 index 0 rlineto\n",
"neg exch neg exch rlineto\n",
"closepath stroke\n",
"}bind def\n",
"/SaveResourcesToStack{",
"[//PDFReader/OldResources known{",
"//PDFReader/OldResources get}{null}ifelse\n",
"//PDFReader/CurrentObject get/Context get/Resources get]",
"//PDFReader/OldResources 3 -1 roll put}bind def\n",
"/RestoreResourcesFromStack{",
"//PDFReader/OldResources get dup\n",
"0 get//PDFReader/OldResources 3 -1 roll put\n",
"1 get//PDFReader/CurrentObject get/Context get/Resources 3 -1 roll put",
"} bind def\n",
"/BuildChar\n",
"{//PDFR_DEBUG{\n",
"(BuildChar )print dup//=only exec( )print\n",
"}if\n",
"exch begin\n",
"Encoding exch get\n",
"//PDFR_DEBUG{\n",
"dup =\n",
"}if\n",
"dup null eq{\n",
"pop//NotDef exec\n",
"}{\n",
"CharProcs exch//knownget exec{",
"currentfont/Font get/Resources//knownget exec{",
"exec SaveResourcesToStack",
"//PDFReader/CurrentObject get/Context get",
"/Resources 3 -1 roll put",
"//RunDelayedStream exec RestoreResourcesFromStack",
"}{//RunDelayedStream exec}ifelse",
"}{\n",
"//NotDef exec\n",
"}ifelse\n",
"}ifelse\n",
"end\n",
"}bind def\n",
"/printdict\n",
"{(<<)=\n",
"{exch = ==}forall\n",
"(>>)=\n",
"}bind def\n",
"/printfont\n",
"{\n",
"dup{\n",
"exch dup =\n",
"dup/Encoding eq{\n",
"pop =\n",
"}{\n",
"dup/FontInfo eq exch/Private eq or{\n",
"//printdict exec\n",
"}{\n",
"==\n",
"}ifelse\n",
"}ifelse\n",
"}forall\n",
"}bind def\n",
"/ScaleMetrics\n",
"{1 index{\n",
"2 index div\n",
"3 index\n",
"3 1 roll put\n",
"}forall\n",
"pop\n",
"}bind def\n",
"/ResolveAndSetFontAux\n",
"{exch dup\n",
"//PDFReader/CurrentObject get/Context get/Resources get\n",
"/Font//DoNothing//ResolveD exec\n",
"exch//CheckFont//ResolveD exec\n",
"dup/Font//knownget exec{\n",
"exch pop exch pop\n",
"}{\n",
"{\n",
"dup/Subtype get dup dup/Type1 eq exch/TrueType eq or exch/MMType1 eq or{\n",
"exch pop\n",
"dup/BaseFont get\n",
"//RemoveFontNamePrefix exec\n",
"//PDFR_DEBUG{\n",
"(Font )print dup =\n",
"}if\n",
"1 index/FontDescriptor known{\n",
"//PDFR_DEBUG{\n",
"(Font from a font descriptor.)=\n",
"}if\n",
"1 index\n",
"/FontDescriptor//DoNothing//ResolveD exec\n",
"/Font//knownget exec{\n",
"exch pop\n",
"}{\n",
"//PDFR_DEBUG{\n",
"(Font descriptor has no Font resolved.)=\n",
"}if\n",
"//GetInstalledFont exec\n",
"}ifelse\n",
"}{\n",
"//GetInstalledFont exec\n",
"}ifelse\n",
"exch\n",
"dup/Encoding known not{\n",
"1 index/Encoding get 1 index exch/Encoding exch put\n",
"}if\n",
"//ObtainEncoding exec\n",
"//ObtainMetrics exec\n",
"exch\n",
"dup length dict copy\n",
"dup 2 index/Encoding get\n",
"/Encoding exch put\n",
"1 index/Metrics//knownget exec{\n",
"2 index/Subtype get/TrueType ne{\n",
"1 index/FontMatrix get 0 get\n",
"dup 0 eq{\n",
"pop\n",
"1 index/FontMatrix get 1 get\n",
"dup 0 eq{pop 1}if\n",
"}if\n",
"0.001 div\n",
"//ScaleMetrics exec\n",
"}{\n",
"1 index/sfnts known not{\n",
"1 index/FontMatrix get 0 get\n",
"dup 0 eq{\n",
"pop\n",
"1 index/FontMatrix get 1 get\n",
"dup 0 eq{pop 1}if\n",
"}if\n",
"//ScaleMetrics exec\n",
"}if\n",
"}ifelse\n",
"1 index exch/Metrics exch put\n",
"}if\n",
"1 index/BaseFont get\n",
"exch\n",
"dup/FID undef\n",
"dup/UniqueID undef\n",
"definefont\n",
"dup 3 1 roll\n",
"/Font exch put\n",
"exit\n",
"}if\n",
"dup/Subtype get/Type3 eq{\n",
"//ObtainEncoding exec\n",
"2 copy exch/FontName exch put\n",
"dup/CharProcs get//ResolveDict exec\n",
"dup/FontType 3 put\n",
"dup/BuildChar//BuildChar put\n",
"dup dup/Font exch put\n",
"dup 3 1 roll\n",
"definefont\n",
"2 copy ne{\n",
"2 copy/Font exch put\n",
"}if\n",
"exch pop\n",
"exit\n",
"}if\n",
"dup/Subtype get/Type0 eq{\n",
"}if\n",
"dup/Subtype get/CIDFontType0 eq{\n",
"}if\n",
"dup/Subtype get/CIDFontType2 eq{\n",
"}if\n",
"mark(Unknown font type )2 index/Subtype get//error exec\n",
"}loop\n",
"}ifelse\n",
"exch scalefont setfont\n",
"}bind def\n",
"/ResolveAndSetFont\n",
"{\n",
"//ResolveAndSetFontAux exec\n",
"}bind def\n",
"/.knownget\n",
"{2 copy known{\n",
"get true\n",
"}{\n",
"pop pop false\n",
"}ifelse\n",
"}bind def\n",
"/.min\n",
"{2 copy lt{\n",
"exch\n",
"}if\n",
"pop\n",
"}bind def\n",
"/.max\n",
"{2 copy gt{\n",
"exch\n",
"}if\n",
"pop\n",
"}bind def\n",
"/.dicttomark\n",
"{>>\n",
"}bind def\n",
"/getu16{\n",
"2 copy get 8 bitshift 3 1 roll 1 add get add\n",
"}bind def\n",
"/gets16{\n",
"getu16 16#8000 xor 16#8000 sub\n",
"}bind def\n",
"/getu32{\n",
"2 copy getu16 16 bitshift 3 1 roll 2 add getu16 add\n",
"}bind def\n",
"/gets32{\n",
"2 copy gets16 16 bitshift 3 1 roll 2 add getu16 add\n",
"}bind def\n",
"/cmapformats mark\n",
"0{\n",
"6 256 getinterval{}forall 256 packedarray\n",
"}bind\n",
"2{\n",
"/sHK_sz 2 def\n",
"/sH_sz 8 def\n",
"dup 2 getu16/cmapf2_tblen exch def\n",
"dup 4 getu16/cmapf2_lang exch def\n",
"dup 6 256 sHK_sz mul getinterval/sHKs exch def\n",
"0\n",
"0 1 255{\n",
"sHKs exch\n",
"2 mul getu16\n",
"1 index\n",
"1 index\n",
"lt{exch}if pop\n",
"}for\n",
"/sH_len exch def\n",
"dup 6 256 sHK_sz mul add\n",
"cmapf2_tblen 1 index sub getinterval\n",
"/sH_gIA exch def\n",
"/cmapf2_glyph_array 65535 array def\n",
"/.cmapf2_putGID{\n",
"/cmapf2_ch cmapf2_ch_hi 8 bitshift cmapf2_ch_lo add def\n",
"firstCode cmapf2_ch_lo le\n",
"cmapf2_ch_lo firstCode entryCount add lt\n",
"and{\n",
"sH_offset idRangeOffset add\n",
"cmapf2_ch_lo firstCode sub 2 mul\n",
"add 6 add\n",
"sH_gIA exch getu16\n",
"dup 0 gt{\n",
"idDelta add\n",
"cmapf2_glyph_array exch cmapf2_ch exch put\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}{\n",
"}ifelse\n",
"}def\n",
"16#00 1 16#ff{\n",
"/cmapf2_ch_hi exch def\n",
"sHKs cmapf2_ch_hi sHK_sz mul getu16\n",
"/sH_offset exch def\n",
"sH_gIA sH_offset sH_sz getinterval\n",
"dup 0 getu16/firstCode exch def\n",
"dup 2 getu16/entryCount exch def\n",
"dup 4 gets16/idDelta exch def\n",
"dup 6 getu16/idRangeOffset exch def\n",
"pop\n",
"sH_offset 0 eq{\n",
"/cmapf2_ch_lo cmapf2_ch_hi def\n",
"/cmapf2_ch_hi 0 def\n",
".cmapf2_putGID\n",
"}{\n",
"16#00 1 16#ff{\n",
"/cmapf2_ch_lo exch def\n",
".cmapf2_putGID\n",
"}for\n",
"}ifelse\n",
"}for\n",
"pop\n",
"0 1 cmapf2_glyph_array length 1 sub{\n",
"dup cmapf2_glyph_array exch get\n",
"null eq{cmapf2_glyph_array exch 0 put}{pop}ifelse\n",
"}for\n",
"cmapf2_glyph_array\n",
"}bind\n",
"4{\n",
"/etab exch def\n",
"/nseg2 etab 6 getu16 def\n",
"14/endc etab 2 index nseg2 getinterval def\n",
"2 add\n",
"nseg2 add/startc etab 2 index nseg2 getinterval def\n",
"nseg2 add/iddelta etab 2 index nseg2 getinterval def\n",
"nseg2 add/idroff etab 2 index nseg2 getinterval def\n",
"pop\n",
"/firstcode startc 0 getu16 16#ff00 and dup 16#f000 ne{pop 0}if def\n",
"/lastcode firstcode def\n",
"/striptopbyte false def\n",
"/putglyph{\n",
"glyphs code 3 -1 roll put/code code 1 add def\n",
"}bind def\n",
"/numcodes 0 def/glyphs 0 0 2 nseg2 3 sub{\n",
"/i2 exch def\n",
"/scode startc i2 getu16 def\n",
"/ecode endc i2 getu16 def\n",
"ecode lastcode gt {\n",
"/lastcode ecode def\n",
"}if\n",
"}for pop\n",
"firstcode 16#f000 ge lastcode firstcode sub 255 le and {\n",
"lastcode 255 and\n",
"/striptopbyte true def\n",
"} {\n",
"lastcode\n",
"}ifelse\n",
"1 add\n",
"array def\n",
"glyphs length 1024 ge{\n",
".array1024z 0 1024 glyphs length 1023 sub{glyphs exch 2 index putinterval}for\n",
"glyphs dup length 1024 sub 3 -1 roll\n",
"putinterval\n",
"}{\n",
"0 1 glyphs length 1 sub{glyphs exch 0 put}for\n",
"}ifelse\n",
"/numcodes 0 def/code 0 def\n",
"0 2 nseg2 3 sub{\n",
"/i2 exch def\n",
"/scode startc i2 getu16 def\n",
"/ecode endc i2 getu16 def\n",
"numcodes scode firstcode sub\n",
"exch sub 0 .max dup/code exch code exch add def\n",
"ecode scode sub 1 add add numcodes add/numcodes exch def\n",
"/delta iddelta i2 gets16 def\n",
"TTFDEBUG{\n",
"(scode=)print scode =only\n",
"( ecode=)print ecode =only\n",
"( delta=)print delta =only\n",
"( droff=)print idroff i2 getu16 =\n",
"}if\n",
"idroff i2 getu16 dup 0 eq{\n",
"pop scode delta add 65535 and 1 ecode delta add 65535 and\n",
"striptopbyte {\n",
"/code scode 255 and def\n",
"} {\n",
"/code scode def\n",
"} ifelse\n",
"{putglyph}for\n",
"}{\n",
"/gloff exch 14 nseg2 3 mul add 2 add i2 add add def\n",
"striptopbyte {\n",
"/code scode 255 and def\n",
"} {\n",
"/code scode def\n",
"} ifelse\n",
"0 1 ecode scode sub{\n",
"2 mul gloff add etab exch getu16\n",
"dup 0 ne{delta add 65535 and}if putglyph\n",
"}for\n",
"}ifelse\n",
"}for glyphs/glyphs null def\n",
"}bind\n",
"6{\n",
"dup 6 getu16/firstcode exch def dup 8 getu16/ng exch def\n",
"firstcode ng add array\n",
"0 1 firstcode 1 sub{2 copy 0 put pop}for\n",
"dup firstcode ng getinterval\n",
"0 1 ng 1 sub{\n",
"dup 2 mul 10 add 4 index exch getu16 3 copy put pop pop\n",
"}for pop exch pop\n",
"}bind\n",
".dicttomark readonly def\n",
"/cmaparray{\n",
"dup 0 getu16 cmapformats exch .knownget{\n",
"TTFDEBUG{\n",
"(cmap: format )print 1 index 0 getu16 = flush\n",
"}if exec\n",
"}{\n",
"(Can't handle format )print 0 getu16 = flush\n",
"0 1 255{}for 256 packedarray\n",
"}ifelse\n",
"TTFDEBUG{\n",
"(cmap: length=)print dup length = dup ==\n",
"}if\n",
"}bind def\n",
"/postremap mark\n",
"/Cdot/Cdotaccent\n",
"/Edot/Edotaccent\n",
"/Eoverdot/Edotaccent\n",
"/Gdot/Gdotaccent\n",
"/Ldot/Ldotaccent\n",
"/Zdot/Zdotaccent\n",
"/cdot/cdotaccent\n",
"/edot/edotaccent\n",
"/eoverdot/edotaccent\n",
"/gdot/gdotaccent\n",
"/ldot/ldotaccent\n",
"/zdot/zdotaccent\n",
".dicttomark readonly def\n",
"/get_from_stringarray\n",
"{1 index type/stringtype eq{\n",
"get\n",
"}{\n",
"exch{\n",
"2 copy length ge{\n",
"length sub\n",
"}{\n",
"exch get exit\n",
"}ifelse\n",
"}forall\n",
"}ifelse\n",
"}bind def\n",
"/getinterval_from_stringarray\n",
"{\n",
"2 index type/stringtype eq{\n",
"getinterval\n",
"}{\n",
"string exch 0\n",
"4 3 roll{\n",
"dup length\n",
"dup 4 index lt{\n",
"3 index exch sub\n",
"exch pop 3 1 roll exch pop\n",
"}{\n",
"dup 3 1 roll\n",
"4 index sub\n",
"5 index length 4 index sub\n",
"2 copy gt{exch}if pop\n",
"dup 3 1 roll\n",
"5 index exch getinterval\n",
"5 index 4 index 3 index\n",
"getinterval\n",
"copy pop\n",
"exch pop add exch pop 0 exch\n",
"dup 3 index length ge{exit}if\n",
"}ifelse\n",
"}forall\n",
"pop pop\n",
"}ifelse\n",
"}bind def\n",
"/string_array_size\n",
"{dup type/stringtype eq{\n",
"length\n",
"}{\n",
"0 exch{length add}forall\n",
"}ifelse\n",
"}bind def\n",
"/postformats mark\n",
"16#00010000{\n",
"pop MacGlyphEncoding\n",
"}\n",
"16#00020000{\n",
"dup dup type/arraytype eq{0 get}if length 36 lt{\n",
"TTFDEBUG{(post format 2.0 invalid.)= flush}if\n",
"pop[]\n",
"}{\n",
"/postglyphs exch def\n",
"/post_first postglyphs dup type/arraytype eq{0 get}if def\n",
"post_first 32 getu16/numglyphs exch def\n",
"/glyphnames numglyphs 2 mul 34 add def\n",
"/postpos glyphnames def\n",
"/total_length postglyphs//string_array_size exec def\n",
"numglyphs array 0 1 numglyphs 1 sub{\n",
"postpos total_length ge{\n",
"1 numglyphs 1 sub{1 index exch/.notdef put}for\n",
"exit\n",
"}if\n",
"postglyphs postpos//get_from_stringarray exec\n",
"postglyphs postpos 1 add 2 index//getinterval_from_stringarray exec cvn\n",
"exch postpos add 1 add/postpos exch def\n",
"2 index 3 1 roll\n",
"put\n",
"}for\n",
"/postnames exch def\n",
"numglyphs array 0 1 numglyphs 1 sub{\n",
"dup 2 mul 34 add postglyphs exch 2//getinterval_from_stringarray exec\n",
"dup 0 get 8 bitshift exch 1 get add dup 258 lt{\n",
"MacGlyphEncoding exch get\n",
"}{\n",
"dup 32768 ge{\n",
"pop/.notdef\n",
"}{\n",
"258 sub dup postnames length ge{\n",
"TTFDEBUG{(   *** warning: glyph index past end of 'post' table)= flush}if\n",
"pop\n",
"exit\n",
"}if\n",
"postnames exch get\n",
"postremap 1 index .knownget{exch pop}if\n",
"}ifelse\n",
"}ifelse\n",
"2 index 3 1 roll put\n",
"}for\n",
"}\n",
"ifelse\n",
"}bind\n",
"16#00030000{\n",
"pop[]\n",
"}bind\n",
".dicttomark readonly def\n",
"/first_post_string\n",
"{\n",
"post dup type/arraytype eq{0 get}if\n",
"}bind def\n",
"/.getpost{\n",
"/glyphencoding post null eq{\n",
"TTFDEBUG{(post missing)= flush}if[]\n",
"}{\n",
"postformats first_post_string 0 getu32 .knownget{\n",
"TTFDEBUG{\n",
"(post: format )print\n",
"first_post_string\n",
"dup 0 getu16 =only(,)print 2 getu16 = flush\n",
"}if\n",
"post exch exec\n",
"}{\n",
"TTFDEBUG{(post: unknown format )print post 0 getu32 = flush}if[]\n",
"}ifelse\n",
"}ifelse def\n",
"}bind def\n",
"/TTParser<<\n",
"/Pos 0\n",
"/post null\n",
">>def\n",
"/readu8\n",
"{read not{\n",
"mark(Insufficient data in the stream.)//error exec\n",
"}if\n",
"}bind def\n",
"/readu16\n",
"{dup//readu8 exec 8 bitshift exch//readu8 exec or\n",
"}bind def\n",
"/reads16\n",
"{//readu16 exec 16#8000 xor 16#8000 sub\n",
"}bind def\n",
"/readu32\n",
"{dup//readu16 exec 16 bitshift exch//readu16 exec or\n",
"}bind def\n",
"/reads32\n",
"{dup//reads16 exec 16 bitshift exch//readu16 exec or\n",
"}bind def\n",
"/SkipToPosition\n",
"{dup//TTParser/Pos get\n",
"exch//TTParser exch/Pos exch put\n",
"sub\n",
"//PDFR_DEBUG{\n",
"(Skipping )print dup//=only exec( bytes.)=\n",
"}if\n",
"dup 0 eq{\n",
"pop pop\n",
"}{\n",
"dup 3 1 roll\n",
"()/SubFileDecode filter\n",
"exch\n",
"{1 index//BlockBuffer readstring pop length\n",
"dup 0 eq{pop exch pop exit}if\n",
"sub\n",
"}loop\n",
"0 ne{\n",
"mark(Insufficient data in the stream for SkipToPosition.)//error exec\n",
"}if\n",
"}ifelse\n",
"}bind def\n",
"/TagBuffer 4 string def\n",
"/ParseTTTableDirectory\n",
"{//PDFR_DEBUG{\n",
"(ParseTTTableDirectory beg)=\n",
"}if\n",
"15 dict begin\n",
"dup//readu32 exec 16#00010000 ne{\n",
"mark(Unknown True Type version.)//error exec\n",
"}if\n",
"dup//readu16 exec/NumTables exch def\n",
"dup//readu16 exec/SearchRange exch def\n",
"dup//readu16 exec/EntrySelector exch def\n",
"dup//readu16 exec/RangeShift exch def\n",
"//PDFR_DEBUG{\n",
"(NumTables = )print NumTables =\n",
"}if\n",
"NumTables{\n",
"dup//TagBuffer readstring not{\n",
"mark(Could not read TT tag.)//error exec\n",
"}if\n",
"cvn\n",
"[2 index//readu32 exec pop\n",
"2 index//readu32 exec\n",
"3 index//readu32 exec\n",
"]\n",
"//PDFR_DEBUG{\n",
"2 copy exch//=only exec( )print ==\n",
"}if\n",
"def\n",
"}repeat\n",
"pop\n",
"//TTParser/Pos 12 NumTables 16 mul add put\n",
"currentdict end\n",
"//PDFR_DEBUG{\n",
"(ParseTTTableDirectory end)=\n",
"}if\n",
"}bind def\n",
"/ParseTTcmap\n",
"{//PDFR_DEBUG{\n",
"(ParseTTcmap beg)=\n",
"}if\n",
"/cmap get aload pop\n",
"3 1 roll\n",
"7 dict begin\n",
"//PDFR_DEBUG{\n",
"(Current position = )print//TTParser/Pos get =\n",
"(cmap position = )print dup =\n",
"}if\n",
"1 index exch//SkipToPosition exec\n",
"//TTParser/Pos get/TablePos exch def\n",
"dup//readu16 exec pop\n",
"dup//readu16 exec/NumEncodings exch def\n",
"//PDFR_DEBUG{\n",
"(NumEncodings = )print NumEncodings =\n",
"}if\n",
"null\n",
"NumEncodings{\n",
"1 index//readu32 exec\n",
"2 index//readu32 exec\n",
"3 array dup 3 2 roll 0 exch put\n",
"2 index null ne{\n",
"dup 0 get 3 index 0 get sub\n",
"3 index exch 1 exch put\n",
"}if\n",
"dup 4 3 roll pop 3 1 roll\n",
"def\n",
"}repeat\n",
"dup 0 get\n",
"4 3 roll exch sub\n",
"1 exch put\n",
"//PDFR_DEBUG{\n",
"currentdict{\n",
"exch dup type/integertype eq{\n",
"//PrintHex exec( )print ==\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}forall\n",
"}if\n",
"4 NumEncodings 8 mul add/HeaderLength exch def\n",
"//TTParser/Pos//TTParser/Pos get HeaderLength add put\n",
"0\n",
"NumEncodings{\n",
"16#7FFFFFF null\n",
"currentdict{\n",
"1 index type/integertype eq{\n",
"exch pop dup 0 get\n",
"dup 5 index gt{\n",
"dup 4 index lt{\n",
"4 1 roll\n",
"exch pop exch pop\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}forall\n",
"//PDFR_DEBUG{\n",
"(Obtaining subtable for )print dup ==\n",
"}if\n",
"3 2 roll pop\n",
"3 copy pop\n",
"TablePos add//SkipToPosition exec\n",
"3 copy exch pop 1 get\n",
"//TTParser/Pos//TTParser/Pos get 3 index add put\n",
"string\n",
"readstring not{\n",
"mark(Can't read a cmap subtable.)//error exec\n",
"}if\n",
"2 exch put\n",
"}repeat\n",
"pop pop\n",
"currentdict end\n",
"//PDFR_DEBUG{\n",
"(ParseTTcmap end)=\n",
"}if\n",
"}bind def\n",
"/GetTTEncoding\n",
"{//PDFR_DEBUG{\n",
"(GetTTEncoding beg)=\n",
"}if\n",
"get\n",
"exch pop\n",
"2 get\n",
"10 dict begin\n",
"/TTFDEBUG//PDFR_DEBUG def\n",
"//cmaparray exec\n",
"end\n",
"//PDFR_DEBUG{\n",
"(GetTTEncoding end)=\n",
"dup ==\n",
"}if\n",
"}bind def\n",
"/InverseEncoding\n",
"{\n",
"256 dict begin\n",
"dup length 1 sub -1 0{\n",
"2 copy get\n",
"exch\n",
"1 index currentdict exch//knownget exec{\n",
"dup type/arraytype eq{\n",
"aload length 1 add array astore\n",
"}{\n",
"2 array astore\n",
"}ifelse\n",
"}if\n",
"def\n",
"}for\n",
"pop\n",
"currentdict end\n",
"}bind def\n",
"/GetMacRomanEncodingInverse\n",
"{//PDFReader/MacRomanEncodingInverse get\n",
"dup null eq{\n",
"pop\n",
"MacRomanEncoding//InverseEncoding exec\n",
"dup//PDFReader exch/MacRomanEncodingInverse exch put\n",
"}if\n",
"}bind def\n",
"/PutCharStringSingle\n",
"{\n",
"dup 3 index length lt{\n",
"2 index exch get\n",
"dup 0 ne{\n",
"def\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}bind def\n",
"/PutCharString\n",
"{1 index type/nametype ne{\n",
"mark(Bad charstring name)//error exec\n",
"}if\n",
"dup type/arraytype eq{\n",
"{\n",
"3 copy//PutCharStringSingle exec\n",
"pop pop\n",
"}forall\n",
"pop\n",
"}{\n",
"//PutCharStringSingle exec\n",
"}ifelse\n",
"}bind def\n",
"/ComposeCharStrings\n",
"{\n",
"//PDFR_DEBUG{\n",
"(ComposeCharStrings beg)=\n",
"}if\n",
"1 index length 1 add dict begin\n",
"/.notdef 0 def\n",
"exch\n",
"//TTParser/post get\n",
"dup null ne{\n",
"exch\n",
"1 index length 1 sub -1 0{\n",
"dup 3 index exch get exch\n",
"dup 0 eq 2 index/.notdef eq or{\n",
"pop pop\n",
"}{\n",
"def\n",
"}ifelse\n",
"}for\n",
"}if\n",
"exch pop exch\n",
"{\n",
"//PutCharString exec\n",
"}forall\n",
"pop\n",
"currentdict end\n",
"//PDFR_DEBUG{\n",
"(ComposeCharStrings end)=\n",
"}if\n",
"}bind def\n",
"/ParseTTpost\n",
"{\n",
"//PDFR_DEBUG{\n",
"(ParseTTpost beg)=\n",
"}if\n",
"/post get aload pop\n",
"3 1 roll\n",
"//PDFR_DEBUG{\n",
"(Current position = )print//TTParser/Pos get =\n",
"(post position = )print dup =\n",
"}if\n",
"1 index exch//SkipToPosition exec\n",
"//TTParser/Pos//TTParser/Pos get 4 index add put\n",
"exch dup 65535 le{\n",
"string\n",
"readstring not{\n",
"mark(Insufficient data in the stream for ParseTTpost.)//error exec\n",
"}if\n",
"}{\n",
"[3 1 roll\n",
"dup 16384 div floor cvi\n",
"exch 1 index 16384 mul\n",
"sub exch\n",
"1 sub 0 1 3 -1 roll\n",
"{\n",
"1 add index\n",
"16384 string readstring not{\n",
"mark(Insufficient data in the stream for ParseTTpost.)//error exec\n",
"}if\n",
"}for\n",
"counttomark -2 roll\n",
"string readstring not{\n",
"mark(Insufficient data in the stream for ParseTTpost.)//error exec\n",
"}if\n",
"]\n",
"}ifelse\n",
"1 dict begin\n",
"/post exch def\n",
"//.getpost exec\n",
"//TTParser/post glyphencoding put\n",
"//PDFR_DEBUG{\n",
"(ParseTTpost end)=\n",
"glyphencoding ==\n",
"}if\n",
"end\n",
"}bind def\n",
"/MakeTTCharStrings\n",
"{//MakeStreamReader exec\n",
"dup dup//ParseTTTableDirectory exec\n",
"//TTParser/post null put\n",
"dup/post//knownget exec{\n",
"0 get\n",
"1 index/cmap get 0 get\n",
"lt{\n",
"2 copy//ParseTTpost exec\n",
"//ParseTTcmap exec\n",
"}{\n",
"2 copy//ParseTTcmap exec\n",
"3 1 roll\n",
"//ParseTTpost exec\n",
"}ifelse\n",
"}{\n",
"//ParseTTcmap exec\n",
"}ifelse\n",
"{\n",
"dup 16#00030001 known{\n",
"//PDFR_DEBUG{\n",
"(Using the TT cmap encoding for Windows Unicode.)=\n",
"}if\n",
"16#00030001//GetTTEncoding exec\n",
"AdobeGlyphList//ComposeCharStrings exec\n",
"exit\n",
"}if\n",
"dup 16#00010000 known{\n",
"//PDFR_DEBUG{\n",
"(Using the TT cmap encoding for Macintosh Roman.)=\n",
"}if\n",
"16#00010000//GetTTEncoding exec\n",
"PDFEncoding dup null eq{\n",
"pop//GetMacRomanEncodingInverse exec\n",
"}{\n",
"//InverseEncoding exec\n",
"}ifelse\n",
"//ComposeCharStrings exec\n",
"exit\n",
"}if\n",
"dup 16#00030000 known{\n",
"//PDFR_DEBUG{\n",
"(Using the TT cmap encoding 3.0 - not sure why Ghostscript writes it since old versions.)=\n",
"}if\n",
"16#00030000//GetTTEncoding exec\n",
"PDFEncoding dup null eq{\n",
"pop//GetMacRomanEncodingInverse exec\n",
"}{\n",
"//InverseEncoding exec\n",
"}ifelse\n",
"//ComposeCharStrings exec\n",
"exit\n",
"}if\n",
"mark(True Type cmap has no useful encodings.)//error exec\n",
"}loop\n",
"//PDFR_DEBUG{\n",
"(CharStrings <<)=\n",
"dup{\n",
"exch\n",
"dup type/nametype eq{\n",
"//=only exec\n",
"}{\n",
"==\n",
"}ifelse\n",
"( )print ==\n",
"}forall\n",
"(>>)=\n",
"}if\n",
"}bind def\n",
"/ScaleVal\n",
"{\n",
"aload pop\n",
"1 index sub\n",
"3 2 roll mul add\n",
"}bind def\n",
"/ScaleArg\n",
"{\n",
"aload pop\n",
"1 index sub\n",
"3 1 roll\n",
"sub exch div\n",
"}bind def\n",
"/ScaleArgN\n",
"{\n",
"dup length 2 sub -2 0{\n",
"2\n",
"2 index 3 1 roll getinterval\n",
"3 2 roll\n",
"exch//ScaleArg exec\n",
"1 index length 2 idiv 1 add 1 roll\n",
"}for\n",
"pop\n",
"}bind def\n",
"/ComputeFunction_10\n",
"{\n",
"//PDFR_DEBUG{\n",
"(ComputeFunction_10 beg )print 1 index//=only exec( stack=)print count =\n",
"}if\n",
"exch\n",
"dup 1 eq{\n",
"pop dup length 1 sub get\n",
"}{\n",
"1 index length 1 sub mul\n",
"dup dup floor sub\n",
"dup 0 eq{\n",
"pop cvi get\n",
"}{\n",
"3 1 roll floor cvi\n",
"2 getinterval\n",
"aload pop\n",
"2 index mul 3 2 roll 1 exch sub 3 2 roll mul add\n",
"}ifelse\n",
"}ifelse\n",
"//PDFR_DEBUG{\n",
"(ComputeFunction_10 end )print dup//=only exec( stack=)print count =\n",
"}if\n",
"}bind def\n",
"/ComputeFunction_n0\n",
"{\n",
"//PDFR_DEBUG{\n",
"(ComputeFunction_n0 beg N=)print dup//=only exec( stack=)print count =\n",
"}if\n",
"dup 0 eq{\n",
"pop\n",
"}{\n",
"dup 2 add -1 roll\n",
"dup 3 index length 1 sub ge{\n",
"pop 1 sub\n",
"exch dup length 1 sub get exch\n",
"//PDFReader/ComputeFunction_n0 get exec\n",
"}{\n",
"dup floor cvi dup\n",
"4 index exch get\n",
"3 index dup\n",
"5 add copy\n",
"6 2 roll\n",
"pop pop pop pop\n",
"1 sub\n",
"//PDFReader/ComputeFunction_n0 get exec\n",
"3 2 roll pop\n",
"exch\n",
"4 3 roll exch\n",
"4 add 2 roll 1 add\n",
"3 2 roll exch get\n",
"exch 1 sub\n",
"//PDFReader/ComputeFunction_n0 get exec\n",
"1 index mul\n",
"3 1 roll\n",
"1 exch sub mul add\n",
"}ifelse\n",
"}ifelse\n",
"//PDFR_DEBUG{\n",
"(ComputeFunction_n0 end )print dup//=only exec( stack=)print count =\n",
"}if\n",
"}bind def\n",
"/FunctionToProc_x01\n",
"{\n",
"dup/Domain get exch\n",
"dup/Data get 0 get exch\n",
"/Size get length\n",
"[4 1 roll\n",
"//PDFR_DEBUG{\n",
"{(function beg, stack =)print count//=only exec(\\n)print}/exec load\n",
"5 2 roll\n",
"}if\n",
"dup 1 gt{\n",
"{mark exch\n",
"3 add 2 roll\n",
"//ScaleArgN exec\n",
"counttomark dup\n",
"3 add -2 roll\n",
"pop exch\n",
"//ComputeFunction_n0 exec\n",
"}/exec load\n",
"}{\n",
"pop\n",
"3 1/roll load//ScaleArg/exec load\n",
"/exch load\n",
"//ComputeFunction_10/exec load\n",
"}ifelse\n",
"//PDFR_DEBUG{\n",
"(function end, stack =)/print load/count load//=only/exec load(\\n)/print load\n",
"}if\n",
"]cvx\n",
"//PDFR_DEBUG{\n",
"(Made a procedure for the 1-result function :)=\n",
"dup ==\n",
"}if\n",
"}bind def\n",
"/FunctionProcDebugBeg\n",
"{(FunctionProcDebugBeg )print count =\n",
"}bind def\n",
"/FunctionProcDebugEnd\n",
"{(FunctionProcDebugEnd )print count =\n",
"}bind def\n",
"/FunctionToProc_x0n\n",
"{\n",
"PDFR_DEBUG{\n",
"(FunctionToProc_x0n beg m=)print dup =\n",
"}if\n",
"1 index/Size get length exch\n",
"dup 7 mul 2 add array\n",
"PDFR_DEBUG{\n",
"dup 0//FunctionProcDebugBeg put\n",
"}{\n",
"dup 0//DoNothing put\n",
"}ifelse\n",
"dup 1/exec load put\n",
"dup 2 5 index/Domain get put\n",
"2 index 1 eq{\n",
"dup 3//ScaleArg put\n",
"}{\n",
"dup 3//ScaleArgN put\n",
"}ifelse\n",
"dup 4/exec load put\n",
"1 index 1 sub 0 exch 1 exch{\n",
"dup 7 mul 5 add\n",
"1 index 4 index 1 sub ne{\n",
"dup 3 index exch 6 index put 1 add\n",
"dup 3 index exch/copy load put 1 add\n",
"}if\n",
"[\n",
"6 index/Data get 3 index get\n",
"6 index 1 eq{\n",
"//ComputeFunction_10/exec load\n",
"}{\n",
"6 index\n",
"//ComputeFunction_n0/exec load\n",
"}ifelse\n",
"]cvx\n",
"3 index exch 2 index exch put 1 add\n",
"2 index 1 index/exec load put 1 add\n",
"1 index 4 index 1 sub ne{\n",
"2 index 1 index 6 index 1 add put 1 add\n",
"2 index 1 index 1 put 1 add\n",
"2 index 1 index/roll load put\n",
"}if\n",
"pop pop\n",
"}for\n",
"PDFR_DEBUG{\n",
"dup dup length 2 sub//FunctionProcDebugEnd put\n",
"}{\n",
"dup dup length 2 sub//DoNothing put\n",
"}ifelse\n",
"dup dup length 1 sub/exec load put\n",
"cvx exch pop exch pop exch pop\n",
"//PDFR_DEBUG{\n",
"(Made a procedure for the n-argument function :)=\n",
"dup ==\n",
"}if\n",
"PDFR_DEBUG{\n",
"(FunctionToProc_x0n end)=\n",
"}if\n",
"}bind def\n",
"/MakeTableRec\n",
"{\n",
"0\n",
"exec\n",
"}bind def\n",
"/MakeTable\n",
"{//PDFR_DEBUG{\n",
"(MakeTable beg )print count =\n",
"}if\n",
"1 index/Size get exch\n",
"1 sub dup\n",
"3 1 roll\n",
"get\n",
"array\n",
"1 index 0 eq{\n",
"exch pop exch pop\n",
"}{\n",
"dup length 1 sub -1 0{\n",
"3 index 3 index//MakeTableRec exec\n",
"2 index 3 1 roll put\n",
"}for\n",
"exch pop exch pop\n",
"}ifelse\n",
"//PDFR_DEBUG{\n",
"(MakeTable end )print count =\n",
"}if\n",
"}bind def\n",
"//MakeTableRec 0//MakeTable put\n",
"/StoreSample\n",
"{\n",
"1 sub\n",
"dup 0 eq{\n",
"pop\n",
"}{\n",
"-1 1{\n",
"I exch get get\n",
"}for\n",
"}ifelse\n",
"I 0 get 3 2 roll put\n",
"}bind def\n",
"/ReadSample32\n",
"{\n",
"4{\n",
"File read not{\n",
"mark(Insufficient data for function.)//error exec\n",
"}if\n",
"}repeat\n",
"pop\n",
"3 1 roll exch\n",
"256 mul add 256 mul add\n",
"//1_24_bitshift_1_sub div\n",
"}bind def\n",
"/ReadSample\n",
"{\n",
"Buffer BitsLeft BitsPerSample\n",
"{2 copy ge{\n",
"exit\n",
"}if\n",
"3 1 roll\n",
"8 add 3 1 roll\n",
"256 mul File read not{\n",
"mark(Insufficient data for function.)//error exec\n",
"}if\n",
"add\n",
"3 1 roll\n",
"}loop\n",
"sub dup\n",
"2 index exch\n",
"neg bitshift\n",
"2 copy exch bitshift\n",
"4 3 roll exch sub\n",
"/Buffer exch def\n",
"exch/BitsLeft exch def\n",
"Div div\n",
"}bind def\n",
"/ReadSamplesRec\n",
"{0\n",
"exec\n",
"}bind def\n",
"/ReadSamples\n",
"{\n",
"//PDFR_DEBUG{\n",
"(ReadSamples beg )print count =\n",
"}if\n",
"dup 1 eq{\n",
"pop\n",
"0 1 Size 0 get 1 sub{\n",
"I exch 0 exch put\n",
"0 1 M 1 sub{\n",
"dup Range exch 2 mul 2 getinterval\n",
"//PDFR_DEBUG{\n",
"(Will read a sample ... )print\n",
"}if\n",
"BitsPerSample 32 eq{//ReadSample32}{//ReadSample}ifelse\n",
"exec exch//ScaleVal exec\n",
"//PDFR_DEBUG{\n",
"(value=)print dup =\n",
"}if\n",
"exch Table exch get\n",
"Size length//StoreSample exec\n",
"}for\n",
"}for\n",
"}{\n",
"1 sub\n",
"dup Size exch get 0 exch 1 exch 1 sub{\n",
"I exch 2 index exch put\n",
"dup//ReadSamplesRec exec\n",
"}for\n",
"pop\n",
"}ifelse\n",
"//PDFR_DEBUG{\n",
"(ReadSamples end )print count =\n",
"}if\n",
"}bind def\n",
"//ReadSamplesRec 0//ReadSamples put\n",
"/StreamToArray\n",
"{//PDFR_DEBUG{\n",
"(StreamToArray beg )print count =\n",
"}if\n",
"userdict/FuncDataReader get begin\n",
"dup/BitsPerSample get/BitsPerSample exch def\n",
"dup/Size get length/N exch def\n",
"dup/Range get length 2 idiv/M exch def\n",
"1 BitsPerSample bitshift 1 sub/Div exch def\n",
"/BitsLeft 0 def\n",
"/Buffer 0 def\n",
"dup/Size get/Size exch def\n",
"dup/Range get/Range exch def\n",
"/File 1 index//MakeStreamReader exec def\n",
"/I[N{0}repeat]def\n",
"M array\n",
"dup length 1 sub -1 0{\n",
"2 index N//MakeTable exec\n",
"2 index 3 1 roll put\n",
"}for\n",
"/Table exch def\n",
"N//ReadSamples exec\n",
"PDFR_DEBUG{\n",
"(Table = )print Table ==\n",
"}if\n",
"/Data Table put\n",
"end\n",
"//PDFR_DEBUG{\n",
"(StreamToArray end )print count =\n",
"}if\n",
"}bind def\n",
"/FunctionToProc10\n",
"{\n",
"PDFR_DEBUG{\n",
"(FunctionToProc10 beg, Range = )print dup/Range get ==\n",
"}if\n",
"dup/Order//knownget exec{\n",
"1 ne{\n",
"(Underimplemented function Type 0 Order 3.)=\n",
"}if\n",
"}if\n",
"dup//StreamToArray exec\n",
"dup/Range get length dup 2 eq{\n",
"pop//FunctionToProc_x01 exec\n",
"}{\n",
"2 idiv//FunctionToProc_x0n exec\n",
"}ifelse\n",
"PDFR_DEBUG{\n",
"(FunctionToProc10 end)=\n",
"}if\n",
"}bind def\n",
"/FunctionToProc12\n",
"{begin\n",
"currentdict/C0//knownget exec{length 1 eq}{true}ifelse{\n",
"N\n",
"currentdict/C0//knownget exec{\n",
"0 get\n",
"}{\n",
"0\n",
"}ifelse\n",
"currentdict/C1//knownget exec{\n",
"0 get\n",
"}{\n",
"1\n",
"}ifelse\n",
"1 index sub\n",
"[4 1 roll\n",
"{\n",
"4 2 roll\n",
"exp mul add\n",
"}aload pop\n",
"]cvx\n",
"}{\n",
"[\n",
"0 1 C0 length 1 sub{\n",
"N\n",
"C0 2 index get\n",
"C1 3 index get\n",
"4 3 roll pop\n",
"1 index sub\n",
"[/dup load\n",
"5 2 roll\n",
"{\n",
"4 2 roll\n",
"exp mul add\n",
"exch\n",
"}aload pop\n",
"]cvx\n",
"/exec load\n",
"}for\n",
"/pop load\n",
"]cvx\n",
"}ifelse\n",
"end\n",
"//PDFR_DEBUG{\n",
"(FunctionType2Proc : )print dup ==\n",
"}if\n",
"}bind def\n",
"/FunctionToProc14\n",
"{//MakeStreamReader exec cvx exec\n",
"//PDFR_DEBUG{\n",
"(FunctionType4Proc : )print dup ==\n",
"}if\n",
"}bind def\n",
"/FunctionToProc1\n",
"{\n",
"dup/FunctionType get\n",
"{dup 0 eq{\n",
"pop//FunctionToProc10 exec exit\n",
"}if\n",
"dup 2 eq{\n",
"pop//FunctionToProc12 exec exit\n",
"}if\n",
"dup 4 eq{\n",
"pop//FunctionToProc14 exec exit\n",
"}if\n",
"mark exch(Function type )exch( isn't implemented yet.)//error exec\n",
"}loop\n",
"}bind def\n",
"/FunctionToProc20\n",
"{\n",
"PDFR_DEBUG{\n",
"(FunctionToProc20, Range = )print dup/Range get ==\n",
"}if\n",
"dup/Order//knownget exec{\n",
"1 ne{\n",
"(Underimplemented function Type 0 Order 3.)=\n",
"}if\n",
"}if\n",
"dup//StreamToArray exec\n",
"dup/Range get length dup 2 eq{\n",
"pop//FunctionToProc_x01 exec\n",
"}{\n",
"2 idiv//FunctionToProc_x0n exec\n",
"}ifelse\n",
"}bind def\n",
"/FunctionToProc\n",
"{//PDFR_DEBUG{\n",
"(FunctionToProc beg )print count =\n",
"}if\n",
"dup type/dicttype eq{\n",
"dup/Domain get length 2 idiv\n",
"{\n",
"dup 1 eq{\n",
"pop//FunctionToProc1 exec exit\n",
"}if\n",
"dup 2 eq{\n",
"pop//FunctionToProc20 exec exit\n",
"}if\n",
"mark(Functions with many arguments aren't implemented yet.)//error exec\n",
"}loop\n",
"}{\n",
"//PDFR_DEBUG{(Not a function dict, assume already a procedure.)print}if\n",
"}ifelse\n",
"//PDFR_DEBUG{\n",
"(FunctionToProc end )print count =\n",
"}if\n",
"}bind def\n",
"/spotfunctions mark\n",
"/Round{\n",
"abs exch abs 2 copy add 1 le{\n",
"dup mul exch dup mul add 1 exch sub\n",
"}{\n",
"1 sub dup mul exch 1 sub dup mul add 1 sub\n",
"}ifelse\n",
"}\n",
"/Diamond{\n",
"abs exch abs 2 copy add .75 le{\n",
"dup mul exch dup mul add 1 exch sub\n",
"}{\n",
"2 copy add 1.23 le{\n",
".85 mul add 1 exch sub\n",
"}{\n",
"1 sub dup mul exch 1 sub dup mul add 1 sub\n",
"}ifelse\n",
"}ifelse\n",
"}\n",
"/Ellipse{\n",
"abs exch abs 2 copy 3 mul exch 4 mul add 3 sub dup 0 lt{\n",
"pop dup mul exch .75 div dup mul add 4 div 1 exch sub\n",
"}{\n",
"dup 1 gt{\n",
"pop 1 exch sub dup mul exch 1 exch sub\n",
".75 div dup mul add 4 div 1 sub\n",
"}{\n",
".5 exch sub exch pop exch pop\n",
"}ifelse\n",
"}ifelse\n",
"}\n",
"/EllipseA{dup mul .9 mul exch dup mul add 1 exch sub}\n",
"/InvertedEllipseA{dup mul .9 mul exch dup mul add 1 sub}\n",
"/EllipseB{dup 5 mul 8 div mul exch dup mul exch add sqrt 1 exch sub}\n",
"/EllipseC{dup mul .9 mul exch dup mul add 1 exch sub}\n",
"/InvertedEllipseC{dup mul .9 mul exch dup mul add 1 sub}\n",
"/Line{exch pop abs neg}\n",
"/LineX{pop}\n",
"/LineY{exch pop}\n",
"/Square{abs exch abs 2 copy lt{exch}if pop neg}\n",
"/Cross{abs exch abs 2 copy gt{exch}if pop neg}\n",
"/Rhomboid{abs exch abs 0.9 mul add 2 div}\n",
"/DoubleDot{2{360 mul sin 2 div exch}repeat add}\n",
"/InvertedDoubleDot{2{360 mul sin 2 div exch}repeat add neg}\n",
"/SimpleDot{dup mul exch dup mul add 1 exch sub}\n",
"/InvertedSimpleDot{dup mul exch dup mul add 1 sub}\n",
"/CosineDot{180 mul cos exch 180 mul cos add 2 div}\n",
"/Double{exch 2 div exch 2{360 mul sin 2 div exch}repeat add}\n",
"/InvertedDouble{\n",
"exch 2 div exch 2{360 mul sin 2 div exch}repeat add neg\n",
"}\n",
".dicttomark readonly def\n",
"/CheckColorSpace\n",
"{\n",
"dup type/arraytype ne{\n",
"mark(Resource )3 index( must be an array.)//error exec\n",
"}if\n",
"}bind def\n",
"/SubstitutePDFColorSpaceRec\n",
"{0\n",
"exec\n",
"}bind def\n",
"/SubstitutePDFColorSpace\n",
"{\n",
"{\n",
"dup 0 get/Pattern eq{\n",
"dup length 1 gt{\n",
"dup dup 1//CheckColorSpace//ResolveA exec\n",
"dup type/nametype ne{\n",
"//SubstitutePDFColorSpaceRec exec\n",
"}if\n",
"1 exch put\n",
"}if\n",
"exit\n",
"}if\n",
"dup 0 get/Indexed eq{\n",
"exit\n",
"}if\n",
"dup 0 get/Separation eq{\n",
"dup dup 2//CheckColorSpace//ResolveA exec\n",
"dup type/nametype ne{\n",
"//SubstitutePDFColorSpaceRec exec\n",
"}if\n",
"2 exch put\n",
"exit\n",
"}if\n",
"dup 0 get/CalGray eq{\n",
"1 get\n",
"dup/Gamma//knownget exec{\n",
"[exch[exch/exp load]cvx dup dup]\n",
"1 index exch/DecodeLMN exch put\n",
"}if\n",
"[exch/CIEBasedA exch]\n",
"exit\n",
"}if\n",
"dup 0 get/CalRGB eq{\n",
"1 get\n",
"dup/Matrix//knownget exec{\n",
"1 index exch/MatrixLMN exch put\n",
"}if\n",
"dup/Gamma//knownget exec{\n",
"aload pop\n",
"[exch/exp load]cvx\n",
"3 1 roll\n",
"[exch/exp load]cvx\n",
"3 1 roll\n",
"[exch/exp load]cvx\n",
"3 1 roll\n",
"3 array astore\n",
"1 index exch/DecodeLMN exch put\n",
"}if\n",
"[exch/CIEBasedABC exch]\n",
"exit\n",
"}if\n",
"dup 0 get/Lab eq{\n",
"1 get\n",
"begin\n",
"currentdict/Range//knownget exec{aload pop}{-100 100 -100 100}ifelse\n",
"0 100 6 2 roll 6 array astore\n",
"/RangeABC exch def\n",
"/DecodeABC[{16 add 116 div}bind{500 div}bind{200 div}bind]def\n",
"/MatrixABC[1 1 1 1 0 0 0 0 -1]def\n",
"{dup 6 29 div ge{dup dup mul mul}{4 29 div sub 108 841 div mul}ifelse}\n",
"/DecodeLMN[\n",
"[3 index aload pop WhitePoint 0 get/mul load]cvx\n",
"[4 index aload pop WhitePoint 1 get/mul load]cvx\n",
"[5 index aload pop WhitePoint 2 get/mul load]cvx\n",
"]def pop\n",
"//PDFR_DEBUG{\n",
"(Constructed from Lab <<)=\n",
"currentdict{exch = ==}forall\n",
"(>>)=\n",
"}if\n",
"[/CIEBasedABC currentdict]\n",
"end\n",
"exit\n",
"pop\n",
"}if\n",
"dup 0 get/CIEBasedA eq{exit}if\n",
"dup 0 get/CIEBasedABC eq{exit}if\n",
"mark exch(Unimplemented color space )exch//error exec\n",
"}loop\n",
"}bind def\n",
"//SubstitutePDFColorSpaceRec 0//SubstitutePDFColorSpace put\n",
"/ResolveArrayElement\n",
"{2 copy get\n",
"dup type dup/arraytype eq exch\n",
"/packedarraytype eq or{\n",
"xcheck{\n",
"2 copy get\n",
"dup 0 get type/integertype eq\n",
"1 index 1 get type dup/arraytype\n",
"eq exch\n",
"/packedarraytype eq or\n",
"and{\n",
"exec\n",
"2 index 4 1 roll put\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}bind def\n",
"/ResolveColorSpaceArrayRec\n",
"{0\n",
"exec\n",
"}bind def\n",
"/SetColorSpaceSafe\n",
"{\n",
"PDFR_DEBUG{\n",
"(SetColorSpaceSafe beg)=\n",
"}if\n",
"currentcolorspace dup type/arraytype eq{\n",
"1 index type/arraytype eq{\n",
"dup length 2 index length eq{\n",
"false exch\n",
"dup length 0 exch 1 exch 1 sub{\n",
"dup\n",
"4 index exch get exch\n",
"2 index exch get\n",
"ne{\n",
"exch pop true exch exit\n",
"}if\n",
"}for\n",
"pop\n",
"{\n",
"setcolorspace\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}{\n",
"pop setcolorspace\n",
"}ifelse\n",
"}{\n",
"pop setcolorspace\n",
"}ifelse\n",
"}{\n",
"pop setcolorspace\n",
"}ifelse\n",
"PDFR_DEBUG{\n",
"(SetColorSpaceSafe end)=\n",
"}if\n",
"}bind def\n",
"/ResolveColorSpaceArray\n",
"{\n",
"//PDFR_DEBUG{\n",
"(ResolveColorSpaceArray beg )print dup ==\n",
"}if\n",
"dup 0 get/Indexed eq{\n",
"1//ResolveArrayElement exec\n",
"dup dup 1 get\n",
"dup type/arraytype eq{\n",
"//SubstitutePDFColorSpace exec\n",
"//ResolveColorSpaceArrayRec exec\n",
"1 exch put\n",
"}{\n",
"pop pop\n",
"}ifelse\n",
"}if\n",
"dup 0 get/Separation eq{\n",
"3//ResolveArrayElement exec\n",
"dup 3 get//FunctionToProc exec\n",
"2 copy 3 exch put\n",
"pop\n",
"}if\n",
"dup 0 get/Pattern eq{\n",
"dup length 1 gt{dup\n",
"1 get dup type/arraytype eq{\n",
"ResolveColorSpaceArray\n",
"1 index 1 3 -1 roll put\n",
"}{pop}ifelse}if\n",
"}if\n",
"PDFR_DEBUG{\n",
"(Construcrted color space :)=\n",
"dup ==\n",
"}if\n",
"//PDFR_DEBUG{\n",
"(ResolveColorSpaceArray end )print dup ==\n",
"}if\n",
"}bind def\n",
"//ResolveColorSpaceArrayRec 0//ResolveColorSpaceArray put\n",
"/ResolveColorSpace\n",
"{\n",
"//PDFR_DEBUG{\n",
"(ResolveColorSpace beg )print dup =\n",
"}if\n",
"dup//SimpleColorSpaceNames exch known not{\n",
"dup//PDFColorSpaces exch//knownget exec{\n",
"exch pop\n",
"//PDFR_DEBUG{\n",
"(ResolveColorSpace known )=\n",
"}if\n",
"}{\n",
"dup\n",
"//PDFReader/CurrentObject get/Context get/Resources get\n",
"/ColorSpace//DoNothing//ResolveD exec\n",
"exch//CheckColorSpace//ResolveD exec\n",
"dup type/arraytype eq{\n",
"//SubstitutePDFColorSpace exec\n",
"//ResolveColorSpaceArray exec\n",
"dup//PDFColorSpaces 4 2 roll put\n",
"}if\n",
"}ifelse\n",
"}if\n",
"//PDFR_DEBUG{\n",
"(ResolveColorSpace end )print dup ==\n",
"}if\n",
"}bind def\n",
"/CheckPattern\n",
"{\n",
"dup/PatternType//knownget exec{\n",
"dup 1 ne{\n",
"mark(Resource )4 index( is a shading, which can't be handled at level 2. )//error exec\n",
"}if\n",
"pop\n",
"}if\n",
"dup/Type knownget{\n",
"/Pattern ne{\n",
"mark(Resource )4 index( must have /Type/Pattern .)//error exec\n",
"}if\n",
"}if\n",
"}bind def\n",
"/PaintProc\n",
"{/Context get\n",
"//RunDelayedStream exec\n",
"}bind def\n",
"/ResolvePattern\n",
"{\n",
"dup\n",
"userdict/PDFR_Patterns get\n",
"exch//knownget exec{\n",
"exch pop\n",
"}{\n",
"dup\n",
"//PDFReader/CurrentObject get/Context get/Resources get\n",
"/Pattern//DoNothing//ResolveD exec\n",
"exch//CheckPattern//ResolveD exec\n",
"dup dup/Context exch put\n",
"dup/Resources//DoNothing//ResolveD exec pop\n",
"dup/PaintProc//PaintProc put\n",
"gsave userdict/PDFR_InitialGS get setgstate\n",
"currentglobal exch false setglobal\n",
"dup/Matrix get\n",
"makepattern\n",
"exch setglobal\n",
"grestore\n",
"dup userdict/PDFR_Patterns get\n",
"4 2 roll\n",
"put\n",
"}ifelse\n",
"}bind def\n",
"/SetColor\n",
"{//PDFR_DEBUG{\n",
"(SetColor beg)=\n",
"}if\n",
"currentcolorspace dup type/nametype eq{\n",
"pop setcolor\n",
"}{\n",
"0 get/Pattern eq{\n",
"//ResolvePattern exec setpattern\n",
"}{\n",
"setcolor\n",
"}ifelse\n",
"}ifelse\n",
"//PDFR_DEBUG{\n",
"(SetColor end)=\n",
"}if\n",
"}bind def\n",
"/ImageKeys 15 dict begin\n",
"/BPC/BitsPerComponent def\n",
"/CS/ColorSpace def\n",
"/D/Decode def\n",
"/DP/DecodeParms def\n",
"/F/Filter def\n",
"/H/Height def\n",
"/IM/ImageMask def\n",
"/I/Interpolate def\n",
"/W/Width def\n",
"currentdict end readonly def\n",
"/ImageValues 15 dict begin\n",
"/G/DeviceGray def\n",
"/RGB/DeviceRGB def\n",
"/CMYK/DeviceCMYK def\n",
"/I/Indexed def\n",
"/AHx/ASCIIHexDecode def\n",
"/A85/ASCII85Decode def\n",
"/LZW/LZWDecode def\n",
"/Fl/FlateDecode def\n",
"/RL/RunLengthDecode def\n",
"/CCF/CCITTFaxDecode def\n",
"/DCT/DCTDecode def\n",
"currentdict end readonly def\n",
"/GetColorSpaceRange\n",
"{2 index/ColorSpace get\n",
"dup type/arraytype eq{\n",
"1 get\n",
"}if\n",
"exch//knownget exec{\n",
"exch pop\n",
"}if\n",
"}bind def\n",
"/DecodeArrays 15 dict begin\n",
"/DeviceGray{[0 1]}def\n",
"/DeviceRGB{[0 1 0 1 0 1]}def\n",
"/DeviceCMYK{[0 1 0 1 0 1 0 1]}def\n",
"/Indexed{\n",
"dup/BitsPerComponent get 1 exch bitshift 1 sub[exch 0 exch]\n",
"}def\n",
"/Separation{[0 1]}def\n",
"/CIEBasedA{[0 1]/RangeA//GetColorSpaceRange exec}def\n",
"/CIEBasedABC{[0 1 0 1 0 1]/RangeABC//GetColorSpaceRange exec}def\n",
"currentdict end readonly def\n",
"/Substitute\n",
"{1 index//knownget exec{\n",
"exch pop\n",
"}if\n",
"}bind def\n",
"/DebugImagePrinting\n",
"{\n",
"//PDFR_DEBUG{\n",
"(Image :)=\n",
"dup{exch//=only exec( )print ==\n",
"}forall\n",
"}if\n",
"}bind def\n",
"/CompleteImage\n",
"{\n",
"dup/ColorSpace known{\n",
"dup/ColorSpace//CheckColorSpace//ResolveD exec pop\n",
"}if\n",
"dup/Decode known not{\n",
"dup/ColorSpace//knownget exec{\n",
"dup type/arraytype eq{\n",
"0 get\n",
"}if\n",
"//DecodeArrays exch get exec\n",
"}{\n",
"[0 1]\n",
"}ifelse\n",
"1 index exch/Decode exch put\n",
"}if\n",
"dup/ImageMatrix[2 index/Width get 0 0 5 index/Height get neg\n",
"0 7 index/Height get]put\n",
"//DebugImagePrinting exec\n",
"}bind def\n",
"/CompleteInlineImage\n",
"{\n",
"//PDFR_DEBUG{\n",
"(CompleteInlineImage beg)=\n",
"}if\n",
"dup/ImageType known not{\n",
"dup/ImageType 1 put\n",
"}if\n",
"dup length dict exch{\n",
"exch//ImageKeys//Substitute exec\n",
"dup/Filter eq{\n",
"exch//ImageValues//Substitute exec exch\n",
"}if\n",
"dup/ColorSpace eq{\n",
"exch\n",
"dup//ImageValues exch//knownget exec{\n",
"exch pop\n",
"}{\n",
"//ResolveColorSpace exec\n",
"}ifelse\n",
"exch\n",
"}if\n",
"exch\n",
"2 index 3 1 roll put\n",
"}forall\n",
"//CompleteImage exec\n",
"dup/DataSource 2 copy get\n",
"2 index//AppendFilters exec put\n",
"//PDFR_DEBUG{\n",
"(CompleteInlineImage end)=\n",
"}if\n",
"}bind def\n",
"/CompleteOutlineImage\n",
"{\n",
"currentglobal exch dup gcheck setglobal\n",
"//PDFR_DEBUG{\n",
"(CompleteOutlineImage beg)=\n",
"}if\n",
"dup dup//MakeStreamReader exec/DataSource exch put\n",
"dup/ImageType known not{\n",
"//CompleteImage exec\n",
"dup/ImageType 1 put\n",
"dup/ColorSpace known{\n",
"dup/ColorSpace//CheckColorSpace//ResolveD exec\n",
"dup type/arraytype eq{\n",
"//ResolveColorSpaceArray exec\n",
"//SubstitutePDFColorSpace exec\n",
"1 index exch/ColorSpace exch put\n",
"}{\n",
"pop\n",
"}ifelse\n",
"}if\n",
"}if\n",
"//PDFR_DEBUG{\n",
"(CompleteOutlineImage end)=\n",
"}if\n",
"exch setglobal\n",
"}bind def\n",
"/DoImage\n",
"{\n",
"//PDFR_DEBUG{\n",
"(DoImage beg)=\n",
"}if\n",
"gsave\n",
"dup/ColorSpace//knownget exec{setcolorspace}if\n",
"dup/ImageMask//knownget exec not{false}if\n",
"{imagemask}{image}ifelse\n",
"grestore\n",
"//PDFR_DEBUG{\n",
"(DoImage end)=\n",
"}if\n",
"}bind def\n",
"/GSave\n",
"{\n",
"gsave\n",
"//PDFReader/GraphicStateStackPointer get\n",
"dup//GraphicStateStack exch get null eq{\n",
"dup//GraphicStateStack exch//InitialGraphicState length dict put\n",
"}if\n",
"dup//GraphicStateStack exch get\n",
"//GraphicState exch copy pop\n",
"1 add//PDFReader exch/GraphicStateStackPointer exch put\n",
"}bind def\n",
"/GRestore\n",
"{\n",
"grestore\n",
"//PDFReader/GraphicStateStackPointer get\n",
"1 sub dup\n",
"//PDFReader exch/GraphicStateStackPointer exch put\n",
"//GraphicStateStack exch get\n",
"//GraphicState copy pop\n",
"}bind def\n",
"/SetFont\n",
"{dup//GraphicState exch/FontSize exch put\n",
"//ResolveAndSetFont exec\n",
"//GraphicState/FontMatrixNonHV currentfont/FontMatrix get 1 get 0 ne put\n",
"}bind def\n",
"/ShowText\n",
"{//GraphicState/TextRenderingMode get 0 eq{\n",
"//GraphicState/WordSpacing get 0\n",
"32\n",
"//GraphicState/CharacterSpacing get 0\n",
"6 5 roll\n",
"//GraphicState/FontMatrixNonHV get{\n",
"[\n",
"7 -2 roll pop\n",
"5 -2 roll pop\n",
"5 -1 roll\n",
"{\n",
"exch\n",
"pop\n",
"3 index add\n",
"exch 2 index eq{3 index add}if\n",
"4 1 roll\n",
"}\n",
"currentfont/FontMatrix get 0 get 0 ne{\n",
"1 1 index length 1 sub getinterval cvx\n",
"}if\n",
"5 index\n",
"cshow\n",
"pop pop pop]\n",
"xshow\n",
"}{\n",
"awidthshow\n",
"}ifelse\n",
"}{\n",
"//GraphicState/CharacterSpacing get 0 eq\n",
"//GraphicState/FontMatrixNonHV get not and\n",
"//GraphicState/WordSpacing get 0 eq and{\n",
"true charpath\n",
"}{\n",
"{\n",
"exch\n",
"pop 0\n",
"currentpoint 5 4 roll\n",
"( )dup 0 3 index put true charpath\n",
"5 1 roll\n",
"moveto rmoveto\n",
"//GraphicState/CharacterSpacing get 0 rmoveto\n",
"32 eq{\n",
"//GraphicState/WordSpacing get 0 rmoveto\n",
"}if\n",
"}\n",
"//GraphicState/FontMatrixNonHV get dup not exch{\n",
"pop currentfont/FontMatrix get 0 get 0 ne\n",
"}if{\n",
"1 1 index length 1 sub getinterval cvx\n",
"}if\n",
"exch cshow\n",
"}ifelse\n",
"}ifelse\n",
"}bind def\n",
"/ShowTextBeg\n",
"{//GraphicState/TextRenderingMode get 0 ne{\n",
"currentpoint newpath moveto\n",
"}if\n",
"}bind def\n",
"/ShowTextEnd\n",
"{//GraphicState/TextRenderingMode get\n",
"{dup 1 eq{\n",
"stroke exit\n",
"}if\n",
"dup 2 eq{\n",
"gsave fill grestore stroke exit\n",
"}if\n",
"dup 3 eq{\n",
"currentpoint newpath moveto\n",
"}if\n",
"dup 4 eq{\n",
"gsave fill grestore clip exit\n",
"}if\n",
"dup 5 eq{\n",
"gsave stroke grestore clip exit\n",
"}if\n",
"dup 6 eq{\n",
"gsave fill grestore gsave stroke grestore fill exit\n",
"}if\n",
"dup 7 eq{\n",
"clip exit\n",
"}if\n",
"exit\n",
"}loop\n",
"pop\n",
"}bind def\n",
"/ShowTextWithGlyphPositioning\n",
"{//ShowTextBeg exec\n",
"{dup type/stringtype eq{\n",
"//ShowText exec\n",
"}{\n",
"neg 1000 div//GraphicState/FontSize get mul 0 rmoveto\n",
"}ifelse\n",
"}forall\n",
"//ShowTextEnd exec\n",
"}bind def\n",
"/CheckFont\n",
"{dup/Type get/ExtGState ne{\n",
"mark(Resource )3 index( must have /Type/ExtGState.)//error exec\n",
"}if\n",
"}bind def\n",
"/SetTransfer\n",
"{\n",
"//PDFR_DEBUG{(SetTransfer beg )print count =}if\n",
"dup type/arraytype eq 1 index xcheck not and{\n",
"0 4 getinterval aload pop\n",
"setcolortransfer\n",
"}{\n",
"settransfer\n",
"}ifelse\n",
"//PDFR_DEBUG{(SetTransfer end )print count =}if\n",
"}bind def\n",
"/CheckExtGState\n",
"{dup/Type get/ExtGState ne{\n",
"mark(Resource )3 index( must have /Type/ExtGState.)//error exec\n",
"}if\n",
"}bind def\n",
"/CheckHalftone\n",
"{dup/HalftoneType known not{\n",
"mark(Resource )3 index( must have /HalftoneType.)//error exec\n",
"}if\n",
"}bind def\n",
"/ResolveFunction\n",
"{\n",
"//PDFR_DEBUG{(ResolveFunction beg )print dup = count =}if\n",
"2 copy get//IsObjRef exec{\n",
"2 copy//DoNothing//ResolveD exec\n",
"3 copy put pop\n",
"}if\n",
"2 copy get dup type/arraytype eq exch xcheck and not{\n",
"2 copy get\n",
"dup type/arraytype eq 1 index xcheck not and{\n",
"dup length 1 sub -1 0{\n",
"2 copy//DoNothing ResolveA\n",
"dup/Identity eq{\n",
"pop 2 copy{}put\n",
"}{\n",
"//FunctionToProc exec\n",
"3 copy put pop\n",
"}ifelse\n",
"pop\n",
"}for\n",
"}{\n",
"dup/Default eq{\n",
"}{\n",
"dup/Identity eq{\n",
"pop{}\n",
"}{dup type/nametype eq{\n",
"//spotfunctions exch get\n",
"}{\n",
"//FunctionToProc exec\n",
"}ifelse\n",
"}ifelse\n",
"}ifelse\n",
"}ifelse\n",
"3 copy put\n",
"exch pop\n",
"}{\n",
"1 index exch get\n",
"}ifelse\n",
"//PDFR_DEBUG{(ResolveFunction end )print dup == count =}if\n",
"}bind def\n",
"/ResolveFunctionSafe\n",
"{2 copy known{\n",
"//ResolveFunction exec\n",
"}if\n",
"pop\n",
"}bind def\n",
"/CreateHalftoneThresholds\n",
"{\n",
"dup/Thresholds known not{\n",
"dup/HalftoneType get 10 eq{\n",
"dup dup//MakeStreamReader exec\n",
"/Thresholds exch put\n",
"}if\n",
"dup/HalftoneType get dup 3 eq exch 6 eq or{\n",
"dup dup//MakeStreamReader exec\n",
"//BlockBuffer readstring pop\n",
"dup length\n",
"dup 0 eq{\n",
"mark(Could not read Thresholds)//error exec\n",
"}if\n",
"string copy/Thresholds exch put\n",
"dup/HalftoneType 3 put\n",
"}if\n",
"}if\n",
"}bind def\n",
"/SetExtGState\n",
"{\n",
"//PDFReader/CurrentObject get/Context get/Resources get\n",
"/ExtGState//DoNothing//ResolveD exec\n",
"exch//CheckExtGState//ResolveD exec\n",
"dup/LW//knownget exec{\n",
"setlinewidth\n",
"}if\n",
"dup/LC//knownget exec{\n",
"setlinecap\n",
"}if\n",
"dup/LJ//knownget exec{\n",
"setlinejoin\n",
"}if\n",
"dup/ML//knownget exec{\n",
"setmeterlimit\n",
"}if\n",
"dup/D//knownget exec{\n",
"setdash\n",
"}if\n",
"dup/RI//knownget exec{\n",
"mark(Unimplemented ExtGState.RI)//error exec\n",
"}if\n",
"dup/OP//knownget exec{\n",
"setoverprint\n",
"}if\n",
"dup/op//knownget exec{\n",
"setoverprint\n",
"}if\n",
"dup/OPM//knownget exec{\n",
"mark(Unimplemented ExtGState.OPM)//error exec\n",
"}if\n",
"dup/Font//knownget exec{\n",
"mark(Unimplemented ExtGState.Font)//error exec\n",
"}if\n",
"dup/BG known{\n",
"/BG//ResolveFunction exec\n",
"setblackgeneration\n",
"}if\n",
"dup/BG2 known{\n",
"/BG2//ResolveFunction exec\n",
"dup/Default eq{\n",
"//InitialExtGState/BG2 get\n",
"}if\n",
"setblackgeneration\n",
"}if\n",
"dup/UCR known{\n",
"/UCR//ResolveFunction exec\n",
"setundercolorremoval\n",
"}if\n",
"dup/UCR2 known{\n",
"/UCR2//ResolveFunction exec\n",
"dup/Default eq{\n",
"//InitialExtGState/UCR2 get\n",
"}if\n",
"setundercolorremoval\n",
"}if\n",
"dup/TR known{\n",
"/TR//ResolveFunction exec\n",
"//SetTransfer exec\n",
"}if\n",
"dup/TR2 known{\n",
"/TR2//ResolveFunction exec\n",
"dup/Default eq{\n",
"pop//InitialExtGState/TR2 get\n",
"aload pop setcolortransfer\n",
"}{\n",
"//SetTransfer exec\n",
"}ifelse\n",
"}if\n",
"dup/HT//knownget exec{\n",
"dup/Default eq{\n",
"pop//InitialExtGState/HT get\n",
"sethalftone\n",
"}{\n",
"//PDFR_DEBUG{(Ht beg)=}if\n",
"pop dup/HT//CheckHalftone//ResolveD exec\n",
"/SpotFunction//ResolveFunctionSafe exec\n",
"/TransferFunction//ResolveFunctionSafe exec\n",
"null exch\n",
"dup/HalftoneType get dup 5 eq exch dup 4 eq exch 2 eq or or{\n",
"dup{\n",
"dup//IsObjRef exec{\n",
"pop\n",
"1 index exch//CheckHalftone ResolveD\n",
"}if\n",
"dup type/dicttype eq{\n",
"dup/SpotFunction//ResolveFunctionSafe exec\n",
"/TransferFunction//ResolveFunctionSafe exec\n",
"//CreateHalftoneThresholds exec\n",
"dup/HalftoneType get 5 gt{\n",
"4 3 roll pop\n",
"dup 4 1 roll\n",
"}if\n",
"}if\n",
"pop pop\n",
"}forall\n",
"}if\n",
"//CreateHalftoneThresholds exec\n",
"//PDFR_DEBUG{\n",
"(HT:)=\n",
"dup{\n",
"1 index/Default eq{\n",
"(Default <<)=\n",
"exch pop\n",
"{exch = ==}forall\n",
"(>>)=\n",
"}{\n",
"exch = ==\n",
"}ifelse\n",
"}forall\n",
"(HT end)= flush\n",
"}if\n",
"exch dup null ne{\n",
"(Warning: Ignoring a halftone with a Level 3 component halftone Type )print dup/HalftoneType get =\n",
"pop pop\n",
"}{\n",
"pop\n",
"dup/HalftoneType get 5 gt{\n",
"(Warning: Ignoring a Level 3 halftone Type )print dup/HalftoneType get =\n",
"pop\n",
"}{\n",
"sethalftone\n",
"}ifelse\n",
"}ifelse\n",
"//PDFR_DEBUG{(HT set)= flush}if\n",
"}ifelse\n",
"}if\n",
"dup/FL//knownget exec{\n",
"setflattness\n",
"}if\n",
"dup/SM//knownget exec{\n",
"setsmoothness\n",
"}if\n",
"dup/SA//knownget exec{\n",
"setstrokeadjust\n",
"}if\n",
"dup/BM//knownget exec{\n",
"mark(Unimplemented ExtGState.BM)//error exec\n",
"}if\n",
"dup/SMask//knownget exec{\n",
"mark(Unimplemented ExtGState.SMask)//error exec\n",
"}if\n",
"dup/CA//knownget exec{\n",
"mark(Unimplemented ExtGState.CA)//error exec\n",
"}if\n",
"dup/ca//knownget exec{\n",
"mark(Unimplemented ExtGState.ca)//error exec\n",
"}if\n",
"dup/AIS//knownget exec{\n",
"mark(Unimplemented ExtGState.AIS)//error exec\n",
"}if\n",
"dup/TK//knownget exec{\n",
"mark(Unimplemented ExtGState.TK)//error exec\n",
"}if\n",
"pop\n",
"}bind def\n",
"/CheckXObject\n",
"{dup/Subtype get dup/Image ne exch dup/Form ne exch/PS ne and and{\n",
"mark(Resource )3 index( must have /Subtype /Image or /Form or /PS.)//error exec\n",
"}if\n",
"}bind def\n",
"/DoXObject\n",
"{\n",
"//PDFReader/CurrentObject get/Context get/Resources get\n",
"/XObject//DoNothing//ResolveD exec\n",
"exch//CheckXObject//ResolveD exec\n",
"dup/Subtype get\n",
"dup/Image eq{\n",
"pop\n",
"//CompleteOutlineImage exec\n",
"//DoImage exec\n",
"}{\n",
"dup/PS eq{\n",
"PDFR_DEBUG{\n",
"(Executing a PS Xobject)=\n",
"}if\n",
"pop\n",
"//RunDelayedStream exec\n",
"}{\n",
"dup/Form eq{\n",
"pop\n",
"PDFR_DEBUG{\n",
"(Executing a Form XObject)=\n",
"}if\n",
"//PDFReader/CurrentObject get exch\n",
"dup//PDFReader exch<< exch/Context exch >>/CurrentObject exch put\n",
"dup/Matrix get concat\n",
"dup/BBox get aload pop exch 3 index sub exch 2 index sub rectclip\n",
"//RunDelayedStream exec\n",
"//PDFReader exch/CurrentObject exch put\n",
"}{\n",
"mark exch(unimplemented XObject type )exch//error exec\n",
"}ifelse\n",
"}ifelse\n",
"}ifelse\n",
"}bind def\n",
"/Operators 50 dict begin\n",
"/q{//GSave exec}bind def\n",
"/Q{//GRestore exec}bind def\n",
"/cm{//TempMatrix astore concat}bind def\n",
"/i{1 .min setflat}bind def\n",
"/J/setlinecap load def\n",
"/d/setdash load def\n",
"/j/setlinejoin load def\n",
"/w/setlinewidth load def\n",
"/M/setmiterlimit load def\n",
"/gs{SetExtGState}bind def\n",
"/g/setgray load def\n",
"/rg/setrgbcolor load def\n",
"/k/setcmykcolor load def\n",
"/cs{//ResolveColorSpace exec//SetColorSpaceSafe exec\n",
"}bind def\n",
"/sc/setcolor load def\n",
"/scn{//SetColor exec}bind def\n",
"/G/setgray load def\n",
"/RG/setrgbcolor load def\n",
"/K/setcmykcolor load def\n",
"/CS//cs def\n",
"/ri{SetColorRenderingIntent}bind def\n",
"/SC/setcolor load def\n",
"/SCN{//SetColor exec}bind def\n",
"/m/moveto load def\n",
"/l/lineto load def\n",
"/c/curveto load def\n",
"/v{currentpoint 6 2 roll curveto}bind def\n",
"/y{2 copy curveto}bind def\n",
"/re{\n",
"4 2 roll moveto exch dup 0 rlineto 0 3 -1 roll rlineto neg 0 rlineto\n",
"closepath\n",
"}def\n",
"/h/closepath load def\n",
"/n/newpath load def\n",
"/S/stroke load def\n",
"/s{closepath stroke}bind def\n",
"/f/fill load def\n",
"/f*/eofill load def\n",
"/B{gsave fill grestore stroke}bind def\n",
"/b{closepath gsave fill grestore stroke}bind def\n",
"/B*{gsave eofill grestore stroke}bind def\n",
"/b*{closepath gsave eofill grestore stroke}bind def\n",
"/W/clip load def\n",
"/W*/eoclip load def\n",
"/sh{\n",
"ResolveShading\n",
"dup/Background known{\n",
"gsave\n",
"dup/ColorSpace get setcolorspace\n",
"dup/Background get aload pop setcolor\n",
"pathbbox\n",
"2 index sub exch 3 index sub exch\n",
"rectfill\n",
"grestore\n",
"}if\n",
"shfill\n",
"}bind def\n",
"/Do{//DoXObject exec}bind def\n",
"/BI{currentglobal false setglobal<<}bind def\n",
"/ID{>>\n",
"dup/DataSource currentfile\n",
"2 index/F//knownget exec{\n",
"/A85 eq{\n",
"0(~>)/SubFileDecode filter\n",
"}if\n",
"}if\n",
"put\n",
"//CompleteInlineImage exec\n",
"exch setglobal\n",
"//DoImage exec\n",
"}bind def\n",
"/EI{}bind def\n",
"/BT{gsave//GraphicState/InitialTextMatrix get currentmatrix pop}bind def\n",
"/ET{grestore}bind def\n",
"/Tc{//GraphicState exch/CharacterSpacing exch put}bind def\n",
"/TL{//GraphicState exch/TextLeading exch put}bind def\n",
"/Tr{//GraphicState exch/TextRenderingMode exch put}bind def\n",
"/Ts{\n",
"mark(Unimplemented SetTextRise)//error exec\n",
"}bind def\n",
"/Tw{//GraphicState exch/WordSpacing exch put}bind def\n",
"/Tz{\n",
"mark(Unimplemented SetHorizontalTextScaling)//error exec\n",
"}bind def\n",
"/Td{translate 0 0 moveto}bind def\n",
"/TD{dup neg//TL exec//Td exec}bind def\n",
"/Tm{//GraphicState/InitialTextMatrix get setmatrix\n",
"//TempMatrix astore concat\n",
"0 0 moveto}bind def\n",
"/T*{0//GraphicState/TextLeading get neg//Td exec}bind def\n",
"/Tj{//ShowTextBeg exec//ShowText exec//ShowTextEnd exec}bind def\n",
"/'{//T* exec//ShowText exec//ShowTextEnd exec}bind def\n",
"/\"{3 2 roll//Tw exec exch//Tc exec//' exec}bind def\n",
"/TJ//ShowTextWithGlyphPositioning def\n",
"/Tf//SetFont def\n",
"/d0/setcharwidth load def\n",
"/d1/setcachedevice load def\n",
"/BDC{BeginMarkedContentSequenceWithPropertyList}bind def\n",
"/BMC{BeginMarkedContentSequence}bind def\n",
"/EMC{EndMarkedContentSequence}bind def\n",
"/BX{BeginCompatibilitySection}bind def\n",
"/EX{EndCompatibilitySection}bind def\n",
"/DP{DefineMarkedContentPointWithPropertyList}bind def\n",
"/MP{DefineMarkedContentPoint}bind def\n",
"/PS{cvx exec}bind def\n",
"currentdict end def\n",
"//PDFR_STREAM{\n",
"//Operators length dict begin\n",
"//Operators{\n",
"exch dup\n",
"[exch//=only/exec load\n",
"( )/print load\n",
"8 7 roll\n",
"dup type/arraytype eq{\n",
"/exec load\n",
"}if\n",
"( )/print load\n",
"]cvx\n",
"def\n",
"}forall\n",
"currentdict end/Operators exch def\n",
"}if\n",
"/.registerencoding\n",
"{pop pop\n",
"}bind def\n",
"/.defineencoding\n",
"{def\n",
"}bind def\n",
"/.findencoding\n",
"{load\n",
"}bind def\n",
0x00
};
