/*  chkrlib.h prototypes of functions for chkrlib.
   Copyright 1993 Tristan Gingold
		  Written September 1993 Tristan Gingold

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.

   The author may be reached (Email) at the address marc@david.saclay.cea.fr,
   or (US/French mail) as Tristan Gingold 
   			  8 rue Parmentier
   			  F91120 PALAISEAU
   			  FRANCE
 */
#ifndef _CHKRLIB_H_
#define _CHKRLIB_H_

#include <sys/types.h>
#include <sys/stat.h>
 
extern int chkr_out;

#ifdef CHKR_USE_BITMAP
# ifdef __i386__
#  include "string.h"
# else
void memset(void *zone, unsigned char c, unsigned int lg);
void strncpy(char *d, const char *s, int lg);
extern char *strchr (const char *s, int c);
extern char *strcat (char *src, const char *dest);
extern __ptr_t memmove (__ptr_t dest, const __ptr_t src, size_t n);
# endif
extern char* mktemp (char *_template);
extern char *getenv(const char *name);
extern char *getcwd (char *buf, size_t size);
extern void qsort(void *base, size_t nmemb, size_t size,
		int (*compar)(const void *, const void *));
extern int atexit(void (*func)(void));		

extern int read (int fd, __ptr_t buf, size_t nbytes);
extern int write (int fd, const __ptr_t buf, size_t n);
extern int close (int fd);
extern long lseek (int fd, long offset, int whence);
extern int unlink (const char *name);
extern void* sbrk (ptrdiff_t __increment);
extern pid_t getpid (void);
extern int kill (pid_t pid, int sig);
extern int open (const char *filename, int flags, ...);
extern int access (const char *name, int type);
extern int stat (const char *__filename, struct stat *stat_buf);
extern int lstat (const char *__filename, struct stat *stat_buf);

#if 0
extern int _chkr_read (int fd, __ptr_t buf, size_t nbytes);
extern int _chkr_write (int fd, const __ptr_t buf, size_t n);
extern int _chkr_close (int fd);
extern long _chkr_lseek (int fd, long offset, int whence);
extern int _chkr_unlink (const char *name);
extern void* _chkr_sbrk (ptrdiff_t __increment);
extern pid_t _chkr_getpid (void);
extern int _chkr_kill (pid_t pid, int sig);
extern int _chkr_open (const char *filename, int flags, ...);
extern int _chkr_access (const char *name, int type);
extern int _chkr_stat (const char *__filename, struct stat *stat_buf);
extern int _chkr_lstat (const char *__filename, struct stat *stat_buf);

#define read(a,b,c)	_chkr_read(a,b,c)
#define write(a,b,c)	_chkr_write(a,b,c)
#define lseek(a,b,c,)	_chkr_lseek(a,b,c)
#define close(a)	_chkr_close(a)
#define unlink(a)	_chkr_unlink(a)
#define sbrk(a)		_chkr_sbrk(a) 
#define getpid()	_chkr_getpid()
#define kill(a,b)	_chkr_kill(a,b)
#define open		_chkr_open
#define access(a,b)	_chkr_access(a,b)
#define stat(a,b)	_chkr_stat(a,b)
#define lstat(a,b)	_chkr_lstat(a,b)
#endif
#else /* !CHKR_USE_BITMAP */

#include <unistd.h>
#include <string.h>

extern char* mktemp (char *_template);
extern char *getenv(const char *name);
extern char *getcwd (char *buf, size_t size);
extern void qsort(void *base, size_t nmemb, size_t size,
		int (*compar)(const void *, const void *));

#endif /* CHKR_USE_BITMAP */

#include <alloca.h>
#include <errno.h>

extern int chkr_out; 	/* stderr for Checker */
void chkr_vprintf(const char *message, void **param);
void chkr_printf(const char *message, ...);
void chkr_header(const char *message);
extern void (*__chkr_trap) __P((const char *message));

#endif /* _CHKRLIB_H_ */