/* Memory access checker.
   Copyright 1993 Tristan Gingold
		  Written September 1993 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 The author may be reached (Email) at the address gingold@amoco.saclay.cea.fr,
 or (US/French mail) as Tristan Gingold
   			  8 rue Parmentier
   			  F91120 PALAISEAU
   			  FRANCE
*/

#define _MALLOC_INTERNAL
#include "malloc.h"
#include "errlist.h"

void *
sbrk (signed long incr)
{
  int round_size = (incr + 3) & ~3;

  /* initialize all, if necessary */
  if (__malloc_initialized == 0)
    {
      __malloc_initialized = 1;
      chkr_initialize ();	/* which called init_morecore */
    }
  if (incr >= 0)		/* get more memory */
    {
      if (_lastblock && _lastblock->state == MDBRK)	/* sbrk already used */
	{
	  __ptr_t res;
	  res = morecore (incr);
	  if (res == (__ptr_t) 0)
	    {
	      errno = ENOMEM;
	      return (void *) -1;
	    }
	  _lastblock->info.brk.real_size += incr;
#ifdef CHKR_HEAPBITMAP
	  chkr_set_right (res, incr, CHKR_RW);
#endif
	  memset (res, 0, incr);
	  return res;
	}
      else if (_lastblock && _lastblock->state == MDFREE)
	{
	  if (morecore (round_size - _lastblock->size) == (__ptr_t) 0)
	    {
	      errno = ENOMEM;
	      return (void *) -1;
	    }
	  _lastblock->size = round_size;
	  _lastblock->info.brk.real_size = incr;
	  return (void *) _lastblock + HEADER_SIZE;
	}
      else
	{
	  struct malloc_header *res;
	  res = (struct malloc_header *) morecore (round_size + HEADER_SIZE);
	  if (res == NULL_HEADER)
	    {
	      errno = ENOMEM;
	      return (void *) -1;
	    }
	  res->size = round_size;
	  res->prev = _lastblock;
	  if (_lastblock)
	    _lastblock->next = res;
	  res->next = NULL_HEADER;
	  _lastblock = res;
	  if (!_firstblock)
	    _firstblock = res;
	  res->state = MDBRK;
	  res->s_diff = res->size - incr;
	  res->info.brk.real_size = incr;
#ifdef CHKR_HEAPBITMAP
	  chkr_set_right ((void *) res + HEADER_SIZE, incr, CHKR_RW);
#endif
	  memset ((void *) res + HEADER_SIZE, 0, incr);
	  return (void *) res + HEADER_SIZE;
	}
    }
  else
    {				/* realease memory */
      __ptr_t res;
      if (!_lastblock || _lastblock->state != MDBRK)
	{
	  chkr_errno = E_BAD_SBRK;
	  chkr_perror ();
	  errno = ENOMEM;
	  return (void *) -1;
	}
      res = (void *) _lastblock + HEADER_SIZE;
      if (_lastblock->info.brk.real_size + incr < 0)
	{
	  chkr_errno = E_BAD_SBRK;
	  chkr_perror ();
	  incr = -_lastblock->info.brk.real_size;
	}
      if (_lastblock->info.brk.real_size + incr == 0)
	{
	  if (_firstblock == _lastblock)
	    _firstblock = NULL_HEADER;
	  _lastblock = _lastblock->prev;
	  if (_lastblock)
	    _lastblock->next = NULL_HEADER;
	  morecore (incr - HEADER_SIZE);
	  return res;
	}
      else
	{
	  morecore (round_size);
	  _lastblock->size += round_size;
	  res += _lastblock->info.brk.real_size;
	  _lastblock->info.brk.real_size += incr;
	  return res;
	}
    }
}
