head	1.4;
access;
symbols;
locks
	PTI:1.4; strict;
comment	@ * @;


1.4
date	96.08.05.20.58.47;	author PTI;	state Exp;
branches;
next	1.3;

1.3
date	96.08.04.11.55.04;	author PTI;	state Exp;
branches;
next	1.2;

1.2
date	96.08.01.23.35.52;	author PTI;	state Exp;
branches;
next	1.1;

1.1
date	96.07.24.20.46.03;	author PTI;	state Exp;
branches;
next	;


desc
@Administrative tool
@


1.4
log
@Changed directory support to the 'dirent.h' emulation provided by
Dirk Ohme.
Reason : VC40 does not support anything closely resembling standard
directory handling. Well, what d'ya expect from Bill...
@
text
@/*
**      msqladmin.c     -
**
**
** Copyright (c) 1993-95  David J. Hughes
** Copyright (c) 1995  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/


#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>

#ifdef HAVE_DIRENT
#  include <dirent.h>
#else
#  ifdef OS2
#    include <stdlib.h>
#    include <string.h>
#  else
#    include <sys/dir.h>
#  endif
#endif
#ifdef WINSOCK
#  define APIENTRY
#endif

#include "version.h"
#include "msql.h"


#include <common/site.h>
#include <common/portable.h>

int     qFlag = 0;
char    *msqlHomeDir;


usage()
{
        printf("\n\nusage : msqladmin [-h host] [-q] <Command>\n\n");
        printf("where command =");
        printf("\t drop DatabaseName\n");
        printf("\t\t create DatabaseName\n");
        printf("\t\t shutdown\n");
        printf("\t\t reload\n");
        printf("\t\t version\n");
        printf("\n -q\tQuiet mode.  No verification of commands.\n\n");
}


createDB(sock,db)
        int     sock;
        char    *db;
{
        if(msqlCreateDB(sock,db) < 0)
        {
                fprintf(stderr,"\nmSQL Command failed!\nServer error = %s\n\n",
                                msqlErrMsg);
                msqlClose(sock);
                exit(1);
                  }
        else
        {
                printf("Database \"%s\" created.\n",db);
                  }
}


dropDB(sock,db)
        int     sock;
        char    *db;
{
        char    buf[10];


        if (!qFlag)
        {
                                         printf("\n\nDropping the database is potentially a very bad ");
                printf("thing to do.\nAny data stored in the database will be");
                printf(" destroyed.\n\nDo you really want to drop the ");
                printf("\"%s\" ",db);
                printf("database?  [Y/N] ");
                fflush( stdout );
                bzero(buf,10);
                fgets(buf,10,stdin);
                if ( (*buf != 'y') && (*buf != 'Y'))
                                         {
                        printf("\n\nOK, aborting database drop!\n\n");
                        msqlClose(sock);
                        exit(0);
                                         }
        }
        if(msqlDropDB(sock,db) < 0)
        {
                fprintf(stderr,"\nmSQL Command failed!\nServer error = %s\n\n",
                        msqlErrMsg);
                msqlClose(sock);
                exit(1);
        }
                  else
        {
                fprintf(stderr,"Database \"%s\" dropped\n",db);
        }
}



main(argc,argv)
        int     argc;
        char    *argv[];
{
        int     sock,
                                         c,
                argsLeft,
                errFlag = 0;
        char    *host = NULL;
#ifdef OS2
                  int optind;
#endif
#ifdef WINNT
                  int optind;
#endif
#ifdef UNIX
                  extern  int optind;
                  extern  char *optarg;
#endif

                  msqlHomeDir = (char *)getenv("MSQL_HOME");
        if (!msqlHomeDir)
                  {
                msqlHomeDir = INST_DIR;
        }

#ifdef UNIX
                /*
                 * UNIX
                 */
        while((c=getopt(argc,argv,"h:q"))!= -1)
                  {
                switch(c)
                                         {
                        case 'h':
                                                                                  if (host)
                                        errFlag++;
                                else
                                        host = optarg;
                                break;
                        case 'q':
                                if (qFlag)
                                        errFlag++;
                                else
                                                                                                         qFlag++;
                                break;
                                                                case '?':
                                errFlag++;
                                                                                  break;
                }
        }

#else
                /*
                 * OS2 & WINNT
                 */
        optind    = 1;
                  if( 3     < argc                  &&
            0    == strcmp(argv[1], "-h") )
                  { host    = argv[2];
          optind += 2;
                  }

        if( (2    < argc                   &&
             0   == strcmp(argv[1], "-q")) ||
            (4    < argc                   &&
             0   == strcmp(argv[3], "-q")) )
        { qFlag++;
          optind++;
        }

        printf("\n");
                  if ( argc <= optind )
        {
                                         usage();
                exit(1);
        }
#endif

        argsLeft = argc - optind;

        if (errFlag || argsLeft == 0)
        {
                                         usage();
                                         exit(1);
                  }

                  /*
                  ** If we don't have a hostname have a look at MSQL_HOST
                  */
                  if (!host)
                  {
                                         host = (char *)getenv("MSQL_HOST");
                  }

                  if ((sock = msqlConnect(host)) < 0)
                  {
                                         fprintf(stderr,"ERROR : %s (%s)\n",msqlErrMsg, host);
                                         exit(1);
                  }

                  if (strcmp(argv[optind],"create") == 0)
                  {
                                         if (argsLeft != 2)
                                         {
                                                                usage();
                                                                msqlClose(sock);
                                                                exit(1);
                                         }
                                         createDB(sock,argv[optind+1]);
                                         msqlClose(sock);
                                         exit(0);
                  }
                  if (strcmp(argv[optind],"drop") == 0)
                  {
                                         if (argsLeft != 2)
                                         {
                                                                usage();
                                                                msqlClose(sock);
                                                                exit(1);
                                         }
                                         dropDB(sock,argv[optind+1]);
                                         msqlClose(sock);
                                         exit(0);
                  }
                  if (strcmp(argv[optind],"shutdown") == 0)
                  {
                                         if (argsLeft != 1)
                                         {
                                                                usage();
                                                                msqlClose(sock);
                                                                exit(1);
                                         }
                                         if(msqlShutdown(sock) < 0)
                                         {
                                                                printf("\nmSQL Command failed!\nServer error = %s\n\n",
                                                                                  msqlErrMsg);
                                                                msqlClose(sock);
                                                                exit(1);
                                         }
                                         exit(0);
                  }
                  if (strcmp(argv[optind],"reload") == 0)
                  {
                                         if (argsLeft != 1)
                                         {
                                                                usage();
                                                                msqlClose(sock);
                                                                exit(1);
                                         }
                                         if(msqlReloadAcls(sock) < 0)
                                         {
                                                                printf("\nmSQL Command failed!\nServer error = %s\n\n",
                                                                                  msqlErrMsg);
                                                                msqlClose(sock);
                                                                exit(1);
                                         }
                                         msqlClose(sock);
                                         exit(0);
                  }
                  if (strcmp(argv[optind],"version") == 0)
                  {
                                         if (argsLeft != 1)
                                         {
                                                                usage();
                                                                msqlClose(sock);
                                                                exit(1);
                                         }
                                         printf("\nVersion Details :-\n\n");
                                         printf("\tmsqladmin version \t%s\n",SERVER_VERSION);
                                         printf("\tmSQL connection \t%s\n",msqlGetHostInfo());
                                         printf("\tmSQL server version \t%s\n", msqlGetServerInfo());
                                         printf("\tmSQL protocol version \t%d\n", msqlGetProtoInfo());
                                         if( NULL != getenv("MSQL_TCP_PORT") )
                                         { printf("\tmSQL TCP socket \t%s\n", getenv("MSQL_TCP_PORT"));
                                         }
                                         else
                                         { printf("\tmSQL TCP socket \t%d (default)\n", MSQL_PORT);
                                         }
#ifdef HAVE_SYS_UN_H
                                         printf("\tmSQL UNIX socket \t%s\n", MSQL_UNIX_ADDR);
#endif
#ifndef UNIX
                                                                /*
                                                                 * OS2 & WINNT
                                                                 */
                                         if( NULL != getenv("USER") )
                                         { printf("\tmSQL root user \t\t%s\n", getenv("USER"));
                                         }
                                         else
#endif
                                         { printf("\tmSQL root user \t\t%s\n", ROOT);
                                         }
                                         printf("\tHost Architecture\t%s\n", ARCH);
                                         msqlClose(sock);
                                         exit(0);
                  }
                  usage();
                  msqlClose(sock);
                  exit(1);
}
@


1.3
log
@Moved from <dirent.h> to <direct.h> to support WATCOM.
@
text
@d31 1
a31 5
#    ifdef WINSOCK
#      include <direct.h>
#    else
#      include <sys/dir.h>
#    endif
@


1.2
log
@Removed references to WSAStartUp and WSACleanUp
@
text
@d31 5
a35 1
#    include <sys/dir.h>
d76 1
a76 1
		  }
d80 1
a80 1
		  }
d93 1
a93 1
					 printf("\n\nDropping the database is potentially a very bad ");
d102 1
a102 1
					 {
d106 1
a106 1
					 }
d115 1
a115 1
		  else
d128 1
a128 1
					 c,
d133 1
a133 1
		  int optind;
d136 1
a136 1
		  int optind;
d139 2
a140 2
		  extern  int optind;
		  extern  char *optarg;
d143 1
a143 1
		  msqlHomeDir = (char *)getenv("MSQL_HOME");
d145 1
a145 1
		  {
d154 1
a154 1
		  {
d156 1
a156 1
					 {
d158 1
a158 1
										  if (host)
d167 1
a167 1
													 qFlag++;
d169 1
a169 1
								case '?':
d171 1
a171 1
										  break;
d180 1
a180 1
		  if( 3     < argc                  &&
d182 1
a182 1
		  { host    = argv[2];
d184 1
a184 1
		  }
d195 1
a195 1
		  if ( argc <= optind )
d197 1
a197 1
					 usage();
d206 96
a301 96
					 usage();
					 exit(1);
		  }

		  /*
		  ** If we don't have a hostname have a look at MSQL_HOST
		  */
		  if (!host)
		  {
					 host = (char *)getenv("MSQL_HOST");
		  }

		  if ((sock = msqlConnect(host)) < 0)
		  {
					 fprintf(stderr,"ERROR : %s (%s)\n",msqlErrMsg, host);
					 exit(1);
		  }

		  if (strcmp(argv[optind],"create") == 0)
		  {
					 if (argsLeft != 2)
					 {
								usage();
								msqlClose(sock);
								exit(1);
					 }
					 createDB(sock,argv[optind+1]);
					 msqlClose(sock);
					 exit(0);
		  }
		  if (strcmp(argv[optind],"drop") == 0)
		  {
					 if (argsLeft != 2)
					 {
								usage();
								msqlClose(sock);
								exit(1);
					 }
					 dropDB(sock,argv[optind+1]);
					 msqlClose(sock);
					 exit(0);
		  }
		  if (strcmp(argv[optind],"shutdown") == 0)
		  {
					 if (argsLeft != 1)
					 {
								usage();
								msqlClose(sock);
								exit(1);
					 }
					 if(msqlShutdown(sock) < 0)
					 {
								printf("\nmSQL Command failed!\nServer error = %s\n\n",
										  msqlErrMsg);
								msqlClose(sock);
								exit(1);
					 }
					 exit(0);
		  }
		  if (strcmp(argv[optind],"reload") == 0)
		  {
					 if (argsLeft != 1)
					 {
								usage();
								msqlClose(sock);
								exit(1);
					 }
					 if(msqlReloadAcls(sock) < 0)
					 {
								printf("\nmSQL Command failed!\nServer error = %s\n\n",
										  msqlErrMsg);
								msqlClose(sock);
								exit(1);
					 }
					 msqlClose(sock);
					 exit(0);
		  }
		  if (strcmp(argv[optind],"version") == 0)
		  {
					 if (argsLeft != 1)
					 {
								usage();
								msqlClose(sock);
								exit(1);
					 }
					 printf("\nVersion Details :-\n\n");
					 printf("\tmsqladmin version \t%s\n",SERVER_VERSION);
					 printf("\tmSQL connection \t%s\n",msqlGetHostInfo());
					 printf("\tmSQL server version \t%s\n", msqlGetServerInfo());
					 printf("\tmSQL protocol version \t%d\n", msqlGetProtoInfo());
					 if( NULL != getenv("MSQL_TCP_PORT") )
					 { printf("\tmSQL TCP socket \t%s\n", getenv("MSQL_TCP_PORT"));
					 }
					 else
					 { printf("\tmSQL TCP socket \t%d (default)\n", MSQL_PORT);
					 }
d303 1
a303 1
					 printf("\tmSQL UNIX socket \t%s\n", MSQL_UNIX_ADDR);
d306 7
a312 7
								/*
								 * OS2 & WINNT
								 */
					 if( NULL != getenv("USER") )
					 { printf("\tmSQL root user \t\t%s\n", getenv("USER"));
					 }
					 else
d314 9
a322 9
					 { printf("\tmSQL root user \t\t%s\n", ROOT);
					 }
					 printf("\tHost Architecture\t%s\n", ARCH);
					 msqlClose(sock);
					 exit(0);
		  }
		  usage();
		  msqlClose(sock);
		  exit(1);
@


1.1
log
@Initial revision
@
text
@a34 1
#  include <winsock.h>
d72 1
a72 1
        }
d98 1
a98 1
                {
d111 1
a111 1
        else
d124 1
a124 1
                c,
a137 11
#ifdef WINSOCK
		  WORD wVersionRequired = MAKEWORD(1,1);  /* winsock 1.1 required */
		  WSADATA	wsaData;
		  int nErrorStatus;

		  if (WSAStartup(wVersionRequired, &wsaData) != 0)
		  {
			 printf("msqlConnect : Unable to initialise WINSOCK");
			 exit(1);
		  }
#endif
d150 1
a150 1
        {
d152 1
a152 1
                {
d163 1
a163 1
                                        qFlag++;
d165 1
a165 1
                        case '?':
d176 1
a176 1
        if( 3     < argc                  &&
d178 1
a178 1
        { host    = argv[2];
d191 1
a191 1
        if ( argc <= optind )
d202 1
a202 4
                usage();
#ifdef WINSOCK
					 WSACleanup();
#endif
a216 3
#ifdef WINSOCK
					 WSACleanup();
#endif
a225 3
#ifdef WINSOCK
								WSACleanup();
#endif
d234 2
a235 2
                if (argsLeft != 2)
                {
a237 3
#ifdef WINSOCK
								WSACleanup();
#endif
d239 7
a245 7
                }
                dropDB(sock,argv[optind+1]);
                msqlClose(sock);
                exit(0);
        }
        if (strcmp(argv[optind],"shutdown") == 0)
        {
d247 3
a249 6
                {
                        usage();
                        msqlClose(sock);
#ifdef WINSOCK
								WSACleanup();
#endif
d251 5
a255 5
                }
                if(msqlShutdown(sock) < 0)
                {
                        printf("\nmSQL Command failed!\nServer error = %s\n\n",
                                msqlErrMsg);
a256 3
#ifdef WINSOCK
								WSACleanup();
#endif
d262 11
a272 4
        {
                if (argsLeft != 1)
                {
                        usage();
a273 3
#ifdef WINSOCK
								WSACleanup();
#endif
a275 7
                if(msqlReloadAcls(sock) < 0)
                {
                        printf("\nmSQL Command failed!\nServer error = %s\n\n",
                                msqlErrMsg);
                        msqlClose(sock);
                        exit(1);
                }
a276 3
#ifdef WINSOCK
					 WSACleanup();
#endif
d279 6
a284 9
        if (strcmp(argv[optind],"version") == 0)
        {
                if (argsLeft != 1)
                {
                        usage();
                        msqlClose(sock);
#ifdef WINSOCK
								WSACleanup();
#endif
d291 5
a295 5
                printf("\tmSQL protocol version \t%d\n", msqlGetProtoInfo());
                if( NULL != getenv("MSQL_TCP_PORT") )
                { printf("\tmSQL TCP socket \t%s\n", getenv("MSQL_TCP_PORT"));
                }
                else
d297 1
a297 1
                }
d299 1
a299 1
                printf("\tmSQL UNIX socket \t%s\n", MSQL_UNIX_ADDR);
d302 7
a308 7
                        /*
                         * OS2 & WINNT
                         */
                if( NULL != getenv("USER") )
                { printf("\tmSQL root user \t\t%s\n", getenv("USER"));
                }
                else
a313 3
#ifdef WINSOCK
					 WSACleanup();
#endif
d315 3
a317 6
        }
        usage();
        msqlClose(sock);
#ifdef WINSOCK
		 WSACleanup();
#endif
@
