#include <\code\classes\zwindow.h>


HINSTANCE Main::hInstance = 0;
HINSTANCE Main::hPrevInstance = 0;
int Main::nCmdShow = 0;

int Main::MessageLoop( void )
{
	 MSG msg;

	 while( GetMessage( &msg, NULL, 0, 0 ) )
	 {
		  TranslateMessage( &msg );
        DispatchMessage( &msg );
    }
    return msg.wParam;
}

char ZWindow::szClassName[] = "ZWindow";

BOOL ZWindow::SetMenu(char *_Menu)
{
hMenu=LoadMenu(Main::hInstance,_Menu);
if(hMenu==NULL)
	return FALSE;
return ::SetMenu(hWnd,hMenu);
}

void ZWindow::SetIcon(char* i)
{
hIcon=LoadIcon(Main::hInstance,i);
SetClassWord(hWnd,GCW_HICON,(WORD)hIcon);
}

LRESULT ZWindow::WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam )
{
	 switch (iMessage)
	 {
		  case WM_CREATE:
				break;
		  case WM_COMMAND:
				switch(wParam)	{
					case CM_FILEEXIT:
						DestroyWindow(hWnd);
						break;
					default:
						return 0;
					}
		  case WM_DESTROY:
				PostQuitMessage( 0 );
				break;
		  default:
				return DefWindowProc( hWnd, iMessage, wParam, lParam );
	 }
	 return 0;
}

// If data pointers are near pointers
#if defined(__SMALL__) || defined(__MEDIUM__)
inline Window *GetPointer( HWND hWnd )
{
	 return (Window *) GetWindowWord( hWnd, 0 );
}
inline void SetPointer( HWND hWnd, Window *pWindow )
{
	 SetWindowWord( hWnd, 0, (WORD) pWindow );
}

// else pointers are far
#elif defined(__LARGE__) || defined(__COMPACT__) || defined(__FLAT__)
inline Window *GetPointer( HWND hWnd )
{
	 return (Window *) GetWindowLong( hWnd, 0 );
}
inline void SetPointer( HWND hWnd, Window *pWindow )
{
	 SetWindowLong( hWnd, 0, (LONG) pWindow );
}

#else
	 #error Choose another memory model!
#endif

LRESULT  CALLBACK _export WndProc( HWND hWnd, UINT iMessage, WPARAM wParam,
											LPARAM lParam )
{
	 // Pointer to the (C++ object that is the) window.
	 Window *pWindow = GetPointer( hWnd );

	 // The pointer pWindow will have an invalid value if the WM_CREATE
	 // message has not yet been processed (we respond to the WM_CREATE
	 // message by setting the extra bytes to be a pointer to the
	 // (C++) object corresponding to the Window identified
	 // by hWnd).  The messages that
	 // precede WM_CREATE must be processed without using pWindow so we
	 // pass them to DefWindowProc.
	 // How do we know in general if the pointer pWindow is invalid?
	 // Simple: Windows allocates the window extra bytes using LocalAlloc
	 // which zero initializes memory; thus, pWindow will have a value of
	 // zero before we set the window extra bytes to the 'this' pointer.
	 // Caveat emptor: the fact that LocalAlloc will zero initialize the
	 // window extra bytes is not documented; therefore, it could change
    // in the future.

    if ( pWindow == 0 )
    {
        if ( iMessage == WM_CREATE )
        {
            LPCREATESTRUCT lpcs;

            lpcs = (LPCREATESTRUCT) lParam;
            pWindow = (Window *) lpcs->lpCreateParams;

            // Store a pointer to this object in the window's extra bytes;
            // this will enable us to access this object (and its member
            // functions) in WndProc where we are
            // given only a handle to identify the window.
            SetPointer( hWnd, pWindow );
            // Now let the object perform whatever
				// initialization it needs for WM_CREATE in its own
            // WndProc.
      return pWindow->WndProc( iMessage, wParam, lParam );
        }
        else
            return DefWindowProc( hWnd, iMessage, wParam, lParam );
    }
    else
		  return pWindow->WndProc( iMessage, wParam, lParam );
}



