#==============================================================================
# Site specific configuration (OS/2)
#==============================================================================
## [BEGIN]
#
# option switches
# (do not remove the lines starting with "##" !!!)
#
# language: select the language you prefer
##-LANG_GERMAN=Y
#
# debug mode: select this to enable debugging of the software
##-DEBUG_MODE=Y
#
# dynamic linking: if enabled, linking is dynamic
##+DYNAMIC_LINKING=Y
#
# Top of Minerva install tree (INST_DIR uses '\\', INSTPATH only '\')
##+INST_DIR=\\public\\mSQL
INST_DIR=\\public\\mSQL
##+INSTPATH=\public\mSQL
INSTPATH=\public\mSQL
#
# TCP/IP port number for client-server communication
##+TCPIP_PORT=4333
TCPIP_PORT=4333
#
## [END]
#==============================================================================
# do not change anything below if you are not an expert!
#==============================================================================
#
# compiler, linker, library tools ...
#
ENV      = OS2
CC       = icc
LINK     = $(CC)
CPP      = $(CC)
RANLIB   = lib /nologo /noignorecase /noextdictionary

# compiler-compiler
YACC     = bison
YFLAGS   = -d -o

#
# Specify the language you want for error messages
#
!ifdef LANG_GERMAN
LANG     = GERMAN
!else
LANG     = ENGLISH
!endif

#
# special definitions
#
SIGLIST  =
DIRENT   = /idirect.h
MMAP     =
U_INT    =
ROOT_EXEC=
ROOT     = mSQL

# Directory for pid file
PID_DIR  = $(INST_DIR)\\tmp

# Extra libraries if required
EXTRA_LIB=

# Any other CFlags required
EXTRA_CFLAGS= /D$(ENV) /D$(LANG) /DMSQL_PORT=$(TCPIP_PORT)\
 /DMSQL_UNIX_ADDR="\"$(INST_DIR)\\tmp\\mSQL.sok\""

# dynamic / static linking
!ifdef DYNAMIC_LINKING
LINKING  = /DDYNAMIC_LINKED /Gd
!else
LINKING  = /DSTATIC_LINKED
!endif

# default libraries
LDLIBS   = ..\..\lib\mSQLmisc.lib

# debug mode on / off
!ifdef DEBUG_MODE
DEBUG    = /Ti+
!else
DEBUG    =
!endif

# flags for compiling, DLL and EXE linking
CFLAGS = /C $(LINKING) /Gf /Gi /Gm /Q /Se /Ss+ $(DEBUG) /I..\ $(EXTRA_CFLAGS)
DFLAGS = $(LINKING) /Ge- /Gf /Gi /Gm $(DEBUG) /Fe
LFLAGS = $(LINKING) /Ge+ /Gf /Gi /Gm $(DEBUG) /Fe

#
# EXPRIMENTAL - Don't play with this stuff
#
NEW_DB=
NEW_DB_INC=
NEW_DB_LIB=

#==============================================================================
# end of file
#==============================================================================
