/* cli.h
 *
 * main header of the CLI
 *
 * (c) 1996 by Dirk Ohme - all rights reserved
 */

#ifndef __H_CLI
#define __H_CLI

/*---| basic includes |------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <sqlcli_.h>

/*---| internal constants |--------------------------------------------------*/
#define LOG_LEVEL_DISABLED             0
#define LOG_LEVEL_STANDARD             1
#define LOG_LEVEL_EXTENDED             2

#ifdef DEBUG
#  define LOG_LEVEL_DEFAULT            LOG_LEVEL_EXTENDED
#else
#  define LOG_LEVEL_DEFAULT            LOG_LEVEL_DISABLED
#endif

#define LOG_STATUS                     ' '
#define LOG_ERROR                      '!'
#define LOG_WARNING                    '>'
#define LOG_INPUT                      'i'
#define LOG_OUTPUT                     'o'
#define LOG_SUMMARY                    '+'
#define LOG_RETURNCODE                 '<'

/*---| internal function prototypes |----------------------------------------*/
RETCODE SQL_LOCAL_API LogSetLevel(     int       iLogLevel );

#ifdef OS2
  RETCODE SQL_LOCAL_API LogEntry(      char      cLogType, ... );
#else
  RETCODE SQL_LOCAL_API LogEntry();
#endif

/*---------------------------------------------------------------------------*/
#endif

/*===| end of file |=========================================================*/
