/* 
 * clock.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 * ClockInterrupt: does malloc debugging and then calls event manager
 */

void ClockInterrupt()
{
  extern void clock_ih();
  static int times = 0;
  if (++times % (50 * 60 * 60) == 0) times  = 0;
  if (times % (50 * 10) == 0) {
    extern int debuggingmalloc;
    int btotal, bfree, bwasted;
    if (debuggingmalloc) {
      alloc_stats(&btotal, &bfree, &bwasted);
      printf("Malloc: total %d free %d wasted %d\n", btotal, bfree, bwasted);
      allocTopPCs(2, 10);
    }
  }
  clock_ih();		/* this routine is in the event manger  */
}
