h64445
s 03152/00000/00000
d D 1.1 91/01/10 11:48:28 llp 1 0
c date and time created 91/01/10 11:48:28 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * psync.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "ip.h"
#include "stable_store.h"
#include "psync.h"
#include "psync_internal.h"

#define IMAGINARY 0x42424242
#define  MAXBUF 100

/* global data for PSYNC */
;
Msg             get_message();
void            get_leaves();
MID             get_root();
Node           *get_node();
Msg             node_to_msg();
MID             get_mid();
int             add_node();
int             get_parents();
Node          **prev_nodes();
Node          **next_nodes();
int             get_sender();
void            chk_orphans();
void            print_mid();

/* VARARGS */
void 		printf();
Node 		*new_node();
void 		init_nodes();
#ifdef LOGGING
int             do_log();
#endif LOGGING
Node            *newnode();

extern IPhost   myipaddr;

typedef struct {
  unsigned int    localport;
  IPhost          real;
}               PSYNC_EXID;

struct invtQ {
  struct cnv_id   conv_id;
  unsigned int    port; 
  Msg             msg;       /* First message of the conversation */
  struct invtQ   *next;
}              *invtQ = NULL;  /* Q for all who are invited to the
			        * conversation but are not yet listening */

struct conv_hosts {
  IPhost          host;
  char           *name;
};

/****************************************/
/** Following is a list of known hosts **/
/** Used here to print the message ids **/
/****************************************/

static struct conv_hosts known_hosts[] = {
  {{192, 12, 69, 49}, "kad"},
  {{192, 12, 69, 36}, "fra"},
  {{192, 12, 69, 32}, "jen"},
  {{192, 12, 69, 42}, "ora"},
  {{192, 12, 69, 47}, "cor"},
  {{192, 12, 69, 11}, "aur"},
  {{192, 12, 69, 15}, "yuc"},
  {{192, 12, 69, 16}, "pal"},
  {{192, 12, 69, 19}, "gar"},
  {{192, 12, 69, 27}, "gra"},
  {{192, 12, 69, 24}, "gac"},
  {{192, 12, 69, 45}, "lub"},
  {{192, 12, 69,  8}, "ben"}
};

#define NUM_KNOWN_HOSTS  ( (sizeof (known_hosts)) /\
			  ( sizeof(struct conv_hosts) )    )

#define  MY_STATE  ((Sstate *)(sessn->state))

int rec_own_msg();

#ifdef BROADCAST
IPhost broadcast_addr = {192, 12, 69, 0};
#endif BROADCAST

/*
 * psync_instantiateprotl(self)
 *
 *
 */
psync_instantiateprotl(self)
     XObj self;
{
  Pstate *pstate;
  
  pstate = (Pstate *)malloc(sizeof(Pstate));
  self->state = (char *)pstate;
  pstate->map_openenable = map_create(100, sizeof(PSYNC_EXID));
  pstate->map_conv = map_create(2 * MAX_CONV, sizeof(PSYNC_EXID));
#ifdef LOGGING
  pstate->map_log = map_create(2 * MAX_CONV, sizeof(int));
  pstate->num_sessn = 0;
#endif LOGGING
  pstate->cid = 1;
  InitSemaphore(&(pstate->IPS), 1);
  InitSemaphore(&(pstate->tree), 1);
  init_nodes();
}

/*
 * psync_init(self) 
 *
 * called once at boot time 
 */
psync_init(self)
     XObj self;
{
  Part            part[2];
  Pstate          *pstate;
#ifdef LOGGING
  int             my_logaddr, inq_reply;
  int             logadr, buffSize;
  char            buffer[2 * sizeof(MsgFmt) + sizeof(P_log)], *buffp;
  P_log           plog;
  SS_addr         ssadr;
#endif LOGGING
  
  pstate = (Pstate *)self->state;
  
  pstate->myaddr.protocolnum = 81;
  x_controlprotl(self->down[0], GETMYADDR, (char *)&pstate->myaddr.host, sizeof(IPhost));
  init_partlist(part, 1, IPaddr);
  set_part(part, 0, pstate->myaddr);
  
  if (x_openenable(self, self->down[0], part) < 0) {
    free((char *)pstate);
    return(-1);
  }
  
#ifdef LOGGING
  
  /**********************************************************/
  /* Following is to initialize the logging of psync state  */
  /* If Psync is recovering, the psync state is initialized */
  /* according to the logged state.                         */
  /**********************************************************/
  
  ssadr.a = (int)pstate->myaddr.protocolnum;
  ssadr.b = ((pstate->myaddr).host);
  part[0].address = (char *)&ssadr;
  part[0].length = sizeof(SS_addr);
  part[1].address = (char *)0;
  part[1].length = 0;
  pstate->log_sessn = (XObj)x_open(self, self->down[1], part);
  /*
    printf ("logsessn = %x\n", pstate->log_sessn);
    */
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(int);
  x_controlsessn(pstate->log_sessn, SS_INQUIRE, buffp, buffSize);
  inq_reply = *(int *)(buffp + sizeof(MsgFmt));
  if (inq_reply) {
    /*
      printf ("RESTORING PSYNC PROTOCOL STATE\n");
      */
    get_plog(self);
    /*
      printf("got psync plog\n");
      */
    get_mlog(self);
    /*
      printf("got psync mlog\n");
      printf ("PSYNC PROTOCOL STATE RESTORED\n");
      */
  }
  else {
    buffp = buffer;
    buffSize = 2 * sizeof(MsgFmt);
    ((MsgFmt *)buffp)->varId = P_LOGADDR;
    ((MsgFmt *)buffp)->elempos = 1;
    ((MsgFmt *)buffp)->byteCount = sizeof(P_log);
    ((MsgFmt *)(buffp + sizeof(MsgFmt)))->varId = P_LOGADDR + 1;
    ((MsgFmt *)(buffp + sizeof(MsgFmt)))->elempos = 100;
    ((MsgFmt *)(buffp + sizeof(MsgFmt)))->byteCount = sizeof(Logmap);
    
    x_controlsessn(pstate->log_sessn, SS_INITV, buffp, buffSize);
    
    plog.cid = 1;
    plog.num_sessn = 0;
    
    buffp = buffer;
    buffSize = sizeof(MsgFmt) + sizeof(P_log);
    ((MsgFmt *)buffp)->varId = P_LOGADDR;
    ((MsgFmt *)buffp)->elempos = 0;
    ((MsgFmt *)buffp)->byteCount = 1;
    *(P_log *)(buffp + sizeof(MsgFmt)) = plog;
    x_controlsessn(((Pstate *)self->state)->log_sessn, SS_APPEND, 
		   buffp, buffSize);
  }
  
#endif LOGGING
  return (0);
}


/*
 * psync_open(self, hlp, p) 
 *
 * called by hlp (through xopen() to establish a psync conversation
 * (actively) or called from x_opendone() after hlp has invoked
 * xopenenable() and  the first message has been received from another
 * participant.  
 */
XObj psync_open(self, hlp, p)
	XObj           self, hlp;
	Part           *p;
{
  XObj           s;
  Sstate         *sstate;
  Part           part[3];
  int            i, l, logid;
  struct cnv_id   conv_id, create_conv_id();
  register PSYNCaddr *local_addr, *remote_addr;
  IPaddr         rm_ipaddr;
  
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  
  if (!p) {
    x_errno = BAD_ADDR;
    s = ERR_SESSN;
  } else
    if (p[0].address == NULL) {
      /* this is an active open, invoked by the hlp */
      local_addr = (PSYNCaddr *) p[1].address;
      /* create session (1 per conversation) */
      for (i = 2; p[i].address != NULL; i++);
      s = x_createsession(hlp, self, i-1);
      conv_id = create_conv_id(self, local_addr->host);
      s->binding = map_bind(((Pstate *)self->state)->map_conv, (char *) &conv_id, (int) s);
      s->state = NULL;
      sstate = (Sstate *) calloc(1, sizeof(Sstate));
      if (sstate == NULL)
	printf("***PANIC - NULL malloc in psync_open()!!!\n");
      sstate->map_tree = map_create(2 * MAX_NODES, 6);
      sstate->conv_id = conv_id;
      sstate->root = NULL;
      sstate->next_msg = NULL;
      sstate->last_msg = NULL;
      sstate->part_list[0] = *(PSYNCaddr *)p[1].address;
      sstate->MYPARTNUM = 0;
      sstate->MY_MASK = 1;
      sstate->loopback = NOLOOP;
      sstate->num_orphan_request = 0;
      sstate->me = *((PSYNCaddr *) p[1].address);
      sstate->mid = 1;
      InitSemaphore(&(sstate->Push_exclusion), 1);
#ifdef LOGGING
      sstate->status = ALIVE;
      InitSemaphore(&(sstate->slogex), 1);
      InitSemaphore(&(sstate->vslogex), 1);
      InitSemaphore(&(sstate->chlogex), 1);
#endif LOGGING
      sstate->pushing_mid.id = 0;
      for (i = 2; p[i].address != NULL; i++) {
	/* walk through participant list */
	sstate->part_list[i - 1] = *(PSYNCaddr *) p[i].address;
	sstate->first_msg = FIRST;
	remote_addr = (PSYNCaddr *) p[i].address;
#ifdef BROADCAST
	/* open an IP broadcast session */
	TRACE0(psyncp, 1, "PSYNC open: openning broadcast IP");
	init_partlist(part, 2, IPaddr);
	set_part(part, 0, ((Pstate *)self->state)->myaddr);
	rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
	rm_ipaddr.host = broadcast_addr;
	set_part(part, 1, rm_ipaddr);
	P(&(((Pstate *)self->state)->IPS));
	s->down[0] = x_open(self, self->down[0], part);
	V(&(((Pstate *)self->state)->IPS));
#endif BROADCAST
	if (same_PSYNChost(myipaddr, remote_addr->host))
	  /* process is on same host (local) */
	  printf("***PANIC - more than one participants in the same host!!\n");
	else {
	  /* process is on remote host */
	  /* open an IP session to that host */
	  init_partlist(part, 2, IPaddr);
	  set_part(part, 0, (((Pstate *)self->state)->myaddr));
	  rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
	  rm_ipaddr.host = remote_addr->host;
	  set_part(part, 1, rm_ipaddr);
	  P(&(((Pstate *)self->state)->IPS));	/* open IP session host-host */
	  s->down[i-1] = x_open(self, self->down[0], part);
	  V(&(((Pstate *)self->state)->IPS));
	}
      }
      sstate->numpart = i - 1;
      sstate->NULL_PART_MASK = ~(~0 << sstate->numpart);
      s->state = (char *) sstate;
#ifdef LOGGING
      ((Pstate *)self->state)->num_sessn++;
      map_bind(((Pstate *)self->state)->map_log, (char *)&s, (logid = create_logid(self)));
      init_sessn_log(self, s, logid);
      event_register(do_log, s, LOG_INTERVAL, EV_REPEAT | EV_CREATEPROCESS);
#endif LOGGING
    }
  /*
   * open called by opendone(), 2nd level PSYNC session is already
   * created 
   */
    else s = (XObj) map_resolve(((Pstate *)self->state)->map_conv, p[0].address);
  return (s);
}


/*
 * psync_openenable(hlp,p) 
 *
 * called by hlp to passively open a conversation 
 */
psync_openenable(self, hlp, p)
     XObj           self, hlp;
     Part           *p;
{
  struct invtQ   *s;
  PSYNCaddr      *me;
  Part            part[3];
  PSYNC_EXID      ex_id;
  XObj           sn, sessn;
  Msg             msg;
  PSYNCheader1    header1, *hdr1;
  Sstate     *state;
  int             i, j, k, logid;
  IPaddr      rm_ipaddr;
  
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  
  me = (PSYNCaddr *) p[1].address;
  
  /* check if first message already arrived */
  for (s = invtQ; s != NULL; s = s->next)
    if (s->port == me->port) {
      /* Create the session as the first message has already arrived */
      msg = s->msg;
      hdr1 = (PSYNCheader1 *) msg_top(msg, PSYNCHLEN1);
      if ((sessn = (XObj)x_createsession(hlp, self, hdr1->numpart)) == ERR_SESSN)
	printf("PANIC : CAN'T CREATE SESSION\n");
      state = (Sstate *) calloc (1, sizeof(Sstate));
      if (state == NULL)
	printf("***PANIC: malloc returned NULL in psync_openenable()");
      sessn->state = NULL;
      sessn->binding = map_bind(((Pstate *)self->state)->map_conv, (char *) &hdr1->cid, (int) sessn);
      state->conv_id = hdr1->cid;
      state->map_tree = map_create(2 * MAX_NODES, 6);
      state->first_msg = FIRST;
      state->numpart = hdr1->numpart;
      state->root = NULL;
      state->next_msg = NULL;
      state->last_msg = NULL;
      state->num_orphan_request = 0;
      state->loopback = NOLOOP;
      state->mid = 1;
      InitSemaphore(&(state->Push_exclusion), 1);
#ifdef LOGGING
      state->status = ALIVE;
      InitSemaphore(&(state->slogex), 1);
      InitSemaphore(&(state->vslogex), 1);
      InitSemaphore(&(state->chlogex), 1);
#endif LOGGING
      state->pushing_mid.id = 0;
      for (j = 0; j <= hdr1->numpart; j++)
	state->part_list[j] = hdr1->part_list[j];
#ifdef BROADCAST
      /* open an IP broadcast session */
      TRACE0(psyncp, 1, "PSYNC open: openning broadcast IP");
      init_partlist(part, 2, IPaddr);
      set_part(part, 0,(((Pstate *)self->state)->myaddr));
      rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
      rm_ipaddr.host = broadcast_addr;
      set_part(part, 1, rm_ipaddr);
      
      P(&(((Pstate *)self->state)->IPS));
      sessn->down[0] = x_open(self, self->down[0], part);
      V(&(((Pstate *)self->state)->IPS));
#endif BROADCAST
      for (j = 0; j < hdr1->numpart; j++)
	if (!same_PSYNChost(hdr1->part_list[j].host, myipaddr)) {
	  init_partlist(part, 2, PSYNCaddr);
	  set_part(part, 0,(((Pstate *)self->state)->myaddr));
	  rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
	  rm_ipaddr.host = hdr1->part_list[j].host;
	  set_part(part, 1, (hdr1->part_list[j].host));
	  
	  P(&(((Pstate *)self->state)->IPS));
	  sessn->down[j] = x_open(self, self->down[0], part);
	  V(&(((Pstate *)self->state)->IPS));
	}
	else
	  state->MYPARTNUM = j;
      state->MY_MASK = (part_mask)(1 << state->MYPARTNUM);
      state->NULL_PART_MASK = ~(~0 << state->numpart);
      state->me = *me;
      sessn->state = (char *)state;
#ifdef LOGGING
      ((Pstate *)self->state)->num_sessn++;
      map_bind(((Pstate *)self->state)->map_log, (char *)&sessn, (logid = create_logid(self)));
      init_sessn_log(self, sessn, logid);
      event_register(do_log, sessn, LOG_INTERVAL, EV_REPEAT | EV_CREATEPROCESS);
#endif LOGGING
      part[0].address = (char *) &hdr1->cid;
      part[0].length = 8;
      part[1].address = (char *) &state->me;
      part[1].length = sizeof(PSYNCaddr);
      part[2].address = 0;
      part[2].length = 0;
      x_callopendone(hlp, sessn, part);
      /*
	x_pop(sessn, msg);
	*/
    }
  ex_id.localport = me->port;
  ex_id.real = me->host;
  map_bind(((Pstate *)self->state)->map_openenable, (char *) &ex_id, (int) hlp);
}

/*
 * psync_push(s,msg,rmsg_ptr) 
 *
 * send a message message to llp for every remote host
 */
psync_push(s, msg, rmsg_ptr)
     XObj      s;
     Msg       *rmsg_ptr, msg;
{
  XObj self;
  register Sstate     *sstate;
  register PSYNCheader1   *ph1;
  register PSYNCheader2   *ph2;
  MID             create_mid();
  MID_ARRAY_STR   depend;
  Msg             dg, p_hdrmsg;
  static Msg dg1, tm;
  register int    msk, msg_node, i, j, had_probs;
  REVheader   *rhdr;
  char buf[500];
  
  assert(x_is_session(s));
  
  sstate = (Sstate *) s->state;
  self = s->myprotl;
  /********************************************************************
    Push a msg only if the I am alive
    ********************************************************************/
  msk = 1;
  msk <<= sstate->MYPARTNUM;
  if (sstate->required_part_mask & msk) return(0);
  /******************************************************************** 
    Since multiple processes may be trying to push, lock the push
    before pushing. The lock is released when the message being pushed
    is acknowledged in control_sessn.
    *********************************************************************/
  P(&(sstate->Push_exclusion));
  if (sstate->first_msg == FIRST) {
    /* this is the FIRST message of the conversation */
    msg_save(dg, msg);
    sstate->first_msg = ~FIRST;
    ph1 = (PSYNCheader1 *) msg_push(msg, PSYNCHLEN1);
    ph1->type = FIRST;
    ph1->cid = sstate->conv_id;
    ph1->mid = create_mid(s, myipaddr);
#ifdef LOGGING
    sstate->log.is_fslog = 1;
#endif LOGGING
    ph1->sender = sstate->MYPARTNUM;
    ph1->numpart = sstate->numpart;
    sstate->pushing_mid = ph1->mid;
    
    /* build participant list in message header */
    for (i = 0; i < ph1->numpart; i++)
      ph1->part_list[i] = sstate->part_list[i];
    
#ifdef BROADCAST
    msg_save(msg, msg);
    x_push(s->down[0], msg, (Msg *)0);
#else
    /* push datagram down to llp for every remote host */
    for (msk = 1, i = 0; i < sstate->numpart; msk <<= 1, i++)
      if ((i != sstate->MYPARTNUM) &&(!(sstate->required_part_mask & msk))) {
	if (s->down[i] != (XObj)-1) {
	  msg_save(msg, msg);
	  x_push(s->down[i], msg, (Msg *)0);
	}
      }
#endif BROADCAST
    init_graph(self, s, ph1, dg, 1);
    if (sstate->loopback == LOOP) {
      msg_peek(dg, 0, msg_len(dg), buf);
      msg_make_allstack(dg1, MSG_SSIZE, buf, msg_len(dg));
      CreateKernelProcess(rec_own_msg, 5, 5, s, sstate, &dg1, ph1->mid);
    }
    else {
      msg_node = update_view(self, s, ph1->mid);
      start_stability_check(self, s, ph1->mid);
      V(&(sstate->Push_exclusion));
    }
    msg_free(msg);
    return (msg_node);
  } else {
    /* this is NOT the first message of the conversation */
    msg_save(dg, msg);
    ph2 = (PSYNCheader2 *) msg_push(msg, PSYNCHLEN2);
    ph2->type = REGULAR;
    ph2->cid = sstate->conv_id;
    ph2->mid = create_mid(s, myipaddr);
#ifdef LOGGING
    sstate->log.is_fslog = 1;
#endif LOGGING
    ph2->sender = sstate->MYPARTNUM;
    get_leaves(self, s, &ph2->depend);
    sstate->pushing_mid = ph2->mid;
#ifdef BROADCAST
    msg_save(msg, msg);
    x_push(s->down[0], msg, (Msg *)0);
#else
    /* push datagram down to llp for every remote host */
    for (i = 0, msk = 1; i < sstate->numpart; msk <<= 1, i++)
      if ((i != sstate->MYPARTNUM) && (!(sstate->required_part_mask & msk))) {
	if (s->down[i] != (XObj)-1) {
	  msg_save(msg, msg);
	  x_push(s->down[i], msg, (Msg *)0);
	}
      }
#endif BROADCAST
    had_probs = add_node(self, s, ph2, dg, &depend, 1);	/* update Ih */
    if (had_probs != 0) {
      printf("***PANIC: psync_push(): add_node rtns %d", had_probs);
      print_mid(",mid=", ph2->mid, "\n\n");
    }
    if (sstate->loopback == LOOP) {
      msg_peek(dg, 0, msg_len(dg), buf);
      msg_make_allstack(dg1, MSG_SSIZE, buf, msg_len(dg));
      CreateKernelProcess(rec_own_msg, 5, 5, s, sstate, &dg1, ph2->mid);
    }
    else {
      msg_node = update_view(self, s, ph2->mid);	
      start_stability_check(self, s, ph2->mid);
      V(&(sstate->Push_exclusion));
    }
    msg_free(msg);
    return (msg_node);
  }
}

#ifdef LOGGING

init_sessn_log(self, s, logaddr)
     XObj self, s;
     int logaddr;
{
  Sstate *state;
  Static_log slog;
  FS_dynamiclog fslog;
  P_log plog;
  char *arptr;
  char buffer[4 * sizeof(MsgFmt) + sizeof(Static_log) + sizeof(FS_dynamiclog) + sizeof(Logmap)], *buffp;
  int i, buffSize;
  Logmap lmap;
  
  state = (Sstate *)s->state;
  state->log.is_fslog = 0;
  init_log_nodes(state);
  state->log.fnd = NULL;
  state->log.lnd = &(state->log.log_node[0]);
  
  buffp = buffer;
  buffSize = 3 * sizeof(MsgFmt);
  ((MsgFmt *)buffp)->varId = logaddr;
  ((MsgFmt *)buffp)->elempos = 1;
  ((MsgFmt *)buffp)->byteCount = sizeof(Static_log);
  arptr = buffp + sizeof(MsgFmt);
  ((MsgFmt *)(arptr))->varId = logaddr + 1;
  ((MsgFmt *)(arptr))->elempos = 1;
  ((MsgFmt *)(arptr))->byteCount = sizeof(FS_dynamiclog);
  arptr += sizeof(MsgFmt);
  ((MsgFmt *)(arptr))->varId = logaddr + 2;
  ((MsgFmt *)(arptr))->elempos = 2000;
  ((MsgFmt *)(arptr))->byteCount = sizeof(VS_dynamiclog);
  
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_INITV, 
		 buffp, buffSize);
  
  slog.conv_id = state->conv_id;
  slog.sessn = s;
  slog.numpart = state->numpart;
  for (i = 0; i < MAX_PART; i++) slog.part_list[i] = state->part_list[i];
  slog.me = state->me;
  slog.rec_sessn = state->rec_sessn;
  slog.rec_opcode = state->rec_opcode;
  
  fslog.required_part_mask = state->required_part_mask;
  fslog.mid = state->mid;
  fslog.loopback = state->loopback;
  
  lmap.s = (int)s;
  lmap.logid = logaddr;
  
  buffp = buffer;
  buffSize = 3 * sizeof(MsgFmt) + sizeof(Static_log) + sizeof(FS_dynamiclog) + sizeof(Logmap);
  ((MsgFmt *)buffp)->varId = logaddr;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  *(Static_log *)(buffp + sizeof(MsgFmt)) = slog;
  arptr = buffp + sizeof(MsgFmt) + sizeof(Static_log);
  ((MsgFmt *)(arptr))->varId = logaddr +1;
  ((MsgFmt *)(arptr))->elempos = 0;
  ((MsgFmt *)(arptr))->byteCount = 1;
  arptr += sizeof(MsgFmt);
  *(FS_dynamiclog *)(arptr) = fslog;
  arptr += sizeof(FS_dynamiclog);
  ((MsgFmt *)(arptr))->varId = P_LOGADDR + 1;
  ((MsgFmt *)(arptr))->elempos = 0;
  ((MsgFmt *)(arptr))->byteCount = 1;
  arptr += sizeof(MsgFmt);
  *(Logmap *)(arptr) = lmap;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_APPEND, 
		 buffp, buffSize);
  
  plog.cid = ((Pstate *)self->state)->cid;
  plog.num_sessn = ((Pstate *)self->state)->num_sessn;
  
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(P_log);
  ((MsgFmt *)buffp)->varId = P_LOGADDR;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  *(P_log *)(buffp + sizeof(MsgFmt)) = plog;
  
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_WRITE, buffp, 
		 buffSize);
  
}

ch_mlog(self, s, logid)
     XObj self, s;
     int logid;
{
  char buffer[sizeof(MsgFmt) + sizeof(Logmap)], *buffp;
  int buffSize;
  Logmap mlog;
  
  mlog.s = (int)s;
  mlog.logid = logid;
  
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(Logmap);
  ((MsgFmt *)(buffp))->varId = P_LOGADDR + 1;
  ((MsgFmt *)(buffp))->elempos = 0;
  ((MsgFmt *)(buffp))->byteCount = 1;
  *(Logmap *)(buffp + sizeof(MsgFmt)) = mlog;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_APPEND, 
		 buffp, buffSize);
}

ch_slog(self, s)
     XObj self, s;
{
  Sstate *state;
  Static_log slog;
  char buffer[sizeof(MsgFmt) + sizeof(Static_log)], *buffp;
  int i, buffSize, log_id;
  
  state = (Sstate *)s->state;
  slog.conv_id = state->conv_id;
  slog.sessn = s;
  slog.numpart = state->numpart;
  for (i = 0; i < MAX_PART; i++) slog.part_list[i] = state->part_list[i];
  slog.me = state->me;
  slog.rec_sessn = state->rec_sessn;
  slog.rec_opcode = state->rec_opcode;
  log_id =  map_resolve(((Pstate *)self->state)->map_log, &s);
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(Static_log);
  ((MsgFmt *)buffp)->varId = log_id;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  *(Static_log *)(buffp + sizeof(MsgFmt)) = slog;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_WRITE, 
		 buffp, buffSize);
}

ch_plog(self)
     XObj self;
{
  char buffer[sizeof(MsgFmt) + sizeof(P_log)], *buffp;
  P_log plog;
  int buffSize;
  
  plog.cid = ((Pstate *)self->state)->cid;
  plog.num_sessn = ((Pstate *)self->state)->num_sessn;
  
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(P_log);
  ((MsgFmt *)buffp)->varId = P_LOGADDR;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  *(P_log *)(buffp + sizeof(MsgFmt)) = plog;
  
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_WRITE, 
		 buffp, buffSize);
}

log_vslog(self, s)
     XObj self, s;
{
  Sstate *state;
  char buffer[NUM_LOG_NODES * sizeof(VS_dynamiclog) + sizeof(MsgFmt)], *buffp, *arptr;
  VS_dynamiclog vslog;
  Nd_str *n, *l;
  int buffSize, i, log_id, count;
  
  log_id =  map_resolve(((Pstate *)self->state)->map_log, &s);
  state = (Sstate *)s->state;
  P(&(state->vslogex));
  n = state->log.fnd;
  do {
    count = 0;
    buffp = buffer;
    buffSize = sizeof(MsgFmt);
    ((MsgFmt *)buffp)->varId = log_id + 2;
    ((MsgFmt *)buffp)->elempos = 0;
    ((MsgFmt *)buffp)->byteCount = 0;
    arptr = buffp + sizeof(MsgFmt);
    do {
      vslog.mid = n->nd->mid;
      vslog.sender = n->nd->sender;
      vslog.depend.num_arr = n->nd->num_prev;
      for (i = 0; i < n->nd->num_prev; i++)
        vslog.depend.arr[i] = n->nd->prev[i]->mid;
      vslog.msglen = msg_len(n->nd->message);
      msg_peek(n->nd->message, 0, msg_len(n->nd->message), vslog.msg);
      
      *(VS_dynamiclog *)arptr = vslog;
      buffSize += sizeof(VS_dynamiclog);
      arptr += sizeof(VS_dynamiclog);
      n = n->next;
      ((MsgFmt *)buffp)->byteCount += 1;
      count++;
    } while ((count < NUM_LOG_NODES) && (n != state->log.lnd));
    x_controlsessn(((Pstate *)self->state)->log_sessn, SS_APPEND, 
		   buffp, buffSize);
  } while (n != state->log.lnd);
  state->log.fnd = NULL;
  V(&(state->vslogex));
}

store_log(self, s, n)
     XObj self, s;
     Node *n;
{
  Sstate *state;
  
  state = (Sstate *)(s->state);
  P(&(state->slogex));
  if (state->log.fnd == state->log.lnd) do_log(s);
  P(&(state->vslogex));
  if (state->log.fnd == NULL) state->log.fnd = state->log.lnd;
  state->log.lnd->nd = n;
  state->log.lnd = state->log.lnd->next;
  if (state->log.fnd == NULL) state->log.fnd = state->log.lnd;
  V(&(state->vslogex));
  V(&(state->slogex));
}

log_fslog(self, s)
     XObj self, s;
{
  Sstate *state;
  char buffer[sizeof(MsgFmt) + sizeof(FS_dynamiclog)], *buffp, *arptr;
  FS_dynamiclog fslog;
  int buffSize, log_id;
  
  log_id =  map_resolve(((Pstate *)self->state)->map_log, &s);
  state = (Sstate *)s->state;
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(FS_dynamiclog);
  ((MsgFmt *)buffp)->varId = log_id + 1;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  arptr = buffp + sizeof(MsgFmt);
  
  fslog.required_part_mask = state->required_part_mask;
  fslog.mid = state->mid;
  fslog.loopback = state->loopback;
  *(FS_dynamiclog *)arptr = fslog;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_WRITE, 
		 buffp, buffSize);
}

do_log(s)
     XObj s;
{
  Sstate *state;
  
  state = (Sstate *)s->state;
  
  P(&(state->chlogex));
  /*
    printf("LOGGING PSYNC...\n");
    */
  if (state->log.is_fslog) log_fslog(s->myprotl, s);
  state->log.is_fslog = 0;
  if (state->log.fnd != NULL) log_vslog(s->myprotl, s);
  /*
    printf("LOGGING PSYNC FINISHED\n");
    */
  V(&(state->chlogex));
}

get_plog(self)
     XObj self;
     
{
  char buffer[sizeof(P_log) + sizeof(MsgFmt)], *buffp;
  P_log plog;
  int buffSize;
  
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(P_log);
  ((MsgFmt *)buffp)->varId = P_LOGADDR;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_READ, buffp, buffSize);
  plog = *(P_log *)(buffp + sizeof(MsgFmt));
  ((Pstate *)self->state)->cid = plog.cid;
  ((Pstate *)self->state)->num_sessn = plog.num_sessn;
}

get_mlog(self)
     XObj self;
{
  Logmap *mlog;
  char buffer[sizeof(MsgFmt) + 100*sizeof(Logmap) + sizeof(int)], *buffp, *arptr;
  int size, i, buffSize;
  
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(int) + 100 * sizeof(Logmap);
  ((MsgFmt *)buffp)->varId = P_LOGADDR + 1;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_READALL, 
		 buffp, buffSize);
  
  arptr = buffp + sizeof(MsgFmt) + sizeof(int);
  size  = *(int *)(buffp + sizeof(MsgFmt));
  mlog = (Logmap *)arptr;
  for (i = 0; i < size; i++) {
    map_bind(((Pstate *)self->state)->map_log, (char *)&(mlog->s), mlog->logid);
    arptr += sizeof(Logmap);
    mlog = (Logmap *)arptr;
  }
}

get_slog(self, state, log_id)
     XObj self;
     Sstate *state;
     int log_id;
{
  char buffer[sizeof(Static_log) + sizeof(MsgFmt)], *buffp;
  Static_log *arptr;
  int i, buffSize;
  
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(Static_log);
  ((MsgFmt *)buffp)->varId = log_id;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_READ, buffp, buffSize);
  arptr = (Static_log *)(buffp + sizeof(MsgFmt));
  state->conv_id = arptr->conv_id;
  state->numpart = arptr->numpart;
  for (i = 0; i < state->numpart; i++)
    state->part_list[i] = arptr->part_list[i];
  state->me = arptr->me;
  state->rec_sessn = arptr->rec_sessn;
  state->rec_opcode = arptr->rec_opcode;
}

get_fslog(self, s)
     XObj self, s;
{
  Sstate *state;
  char buffer[sizeof(FS_dynamiclog) + sizeof(MsgFmt)], *buffp;
  int buffSize, log_id;
  FS_dynamiclog *arptr;
  
  log_id =  map_resolve(((Pstate *)self->state)->map_log, &s);
  state = (Sstate *)s->state;
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(FS_dynamiclog);
  ((MsgFmt *)buffp)->varId = log_id + 1;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_READ, buffp, buffSize);
  arptr = (FS_dynamiclog *)(buffp + sizeof(MsgFmt));
  state->required_part_mask = arptr->required_part_mask;
  state->ignore_part_mask = arptr->required_part_mask;
  state->loopback = arptr->loopback;
  state->mid = arptr->mid;
}

get_vslog(self, s, view_mid, num)
     XObj self, s;
     MID view_mid[];
     int num;
{
  Sstate *state;
  char buffer[20*sizeof(VS_dynamiclog) + sizeof(MsgFmt) + sizeof(int)], *buffp, *arptr;
  int count, elempos, fixsize, i, j, k, buffSize, size, log_id;
  Node *n, *node_ptr, **leaves, *parent;
  Msg m, newmesg;
  VS_dynamiclog *msg;
  PSYNCheader2 *newhead;
  MID_ARRAY_STR leaves_mid;
  
  state = (Sstate *)s->state;
  log_id =  map_resolve(((Pstate *)self->state)->map_log, &s);
  buffp = buffer;
  buffSize = sizeof(MsgFmt) + sizeof(int);
  ((MsgFmt *)buffp)->varId = log_id + 2;
  ((MsgFmt *)buffp)->elempos = 0;
  ((MsgFmt *)buffp)->byteCount = 1;
  x_controlsessn(((Pstate *)self->state)->log_sessn, SS_READSIZE, 
		 buffp, buffSize);
  size  = *(int *)(buffp + sizeof(MsgFmt));
  
  if (size) {
    state->first_msg = ~FIRST;
    fixsize = 20;
    elempos = 0;
    
    buffp = buffer;
    ((MsgFmt *)buffp)->varId = log_id + 2;
    if (size > fixsize) {
      buffSize = sizeof(MsgFmt) + fixsize * sizeof(VS_dynamiclog);
      ((MsgFmt *)buffp)->byteCount = fixsize;
      ((MsgFmt *)buffp)->elempos = elempos;
      elempos += fixsize;
      count = fixsize - 1;
    }
    else {
      buffSize = sizeof(MsgFmt) + size * sizeof(VS_dynamiclog);
      ((MsgFmt *)buffp)->byteCount = size;
      ((MsgFmt *)buffp)->elempos = elempos;
      elempos += size;
      count = size - 1;
    }
    x_controlsessn(((Pstate *)self->state)->log_sessn, SS_READ, 
		   buffp, buffSize);
    
    arptr = buffp + sizeof(MsgFmt);
    msg = (VS_dynamiclog *)arptr;
    
    msg_make_allstack(m, MSG_SSIZE, (char *)msg->msg, msg->msglen);
    n = newnode(s, msg->mid, msg->sender, m);
    state->root = n;
    state->num_leaves=0;
    map_bind(state->map_tree, &msg->mid, n);
    if (chk_view(msg->mid, view_mid, &num)) {
      state->view[state->view_leaves] = n;
      state->view_leaves++;
    }
    
    arptr += sizeof(VS_dynamiclog);
    do {
      if (size > fixsize) size -= fixsize;
      else size = 0;
      for (i = 0; i < count; i++) {
        msg = (VS_dynamiclog *)arptr;
        msg_make_allstack(m, MSG_SSIZE, msg->msg, msg->msglen);
        n = newnode(s, msg->mid, msg->sender, m);
        if (chk_view(msg->mid, view_mid, &num)) {
          state->view[state->view_leaves] = n;
          state->view_leaves++;
        }
        for (j = 0; j < msg->depend.num_arr; j++) {
	  node_ptr = get_node(self, s, msg->depend.arr[j]);
	  /* for every node the message depends on */
	  n->prev[j] = node_ptr;
	  node_ptr->next[  node_ptr->num_next++  ] = n;
        }
	
        n->num_prev = j;
        leaves = state->leaves;	/* current Ih leaves */
	
        /* update the Ih's leave pointers */
        /* find those of the message's parents that are leaves */
        for (j = 0; j < n->num_prev; j++) {
	  /* for every one of the message's parents */
  	  parent = n->prev[j];
	  
	  for (k = 0; k < state->num_leaves; k++)
	    /* for every leave of Ih */
	    if (parent == leaves[k]) {
	      /* the parent was a leaf, but not any more */
              leaves[k] = leaves[--state->num_leaves];
	      break;
	    }
        }
	
	/* set a leave pointer to the new message node */
        leaves[state->num_leaves++] = n;
        /* bind message id to our map */
        map_bind(state->map_tree, &msg->mid, n);
        start_stability_check(self, s, msg->mid);
	
        arptr += sizeof(VS_dynamiclog);
      }
      if (size) {
        buffp = buffer;
        ((MsgFmt *)buffp)->varId = log_id + 2;
        if (size > fixsize) {
          buffSize = sizeof(MsgFmt) + fixsize * sizeof(VS_dynamiclog);
          ((MsgFmt *)buffp)->byteCount = fixsize;
          ((MsgFmt *)buffp)->elempos = elempos;
          elempos += fixsize;
          count = fixsize;
        }
        else {
          buffSize = sizeof(MsgFmt) + size * sizeof(VS_dynamiclog);
          ((MsgFmt *)buffp)->byteCount = size;
          ((MsgFmt *)buffp)->elempos = elempos;
          elempos += size;
          count = size;
        }
        x_controlsessn(((Pstate *)self->state)->log_sessn, SS_READ, 
		       buffp, buffSize);
        arptr = buffp + sizeof(MsgFmt);
      }
    } while (size);
  }
  else {
    state->num_leaves = 0;
    state->root = NULL;
  }
  
  leaves_mid.num_arr = state->num_leaves;
  for (i = 0; i < state->num_leaves; i++)
    leaves_mid.arr[i+1] = (state->leaves[i])->mid;
  for (i = 0; i < num; i++) {
    newhead = (PSYNCheader2 *) malloc(sizeof(PSYNCheader2));
    if (newhead == NULL)
      printf("***PANIC - NULL from malloc in retrieve sessn!!!\n");
    newhead->type = RETRANSMIT;
    newhead->cid = state->conv_id;
    newhead->mid = view_mid[i];
    newhead->sender = state->MYPARTNUM;
    leaves_mid.arr[0] = view_mid[i];
    newhead->depend = leaves_mid;
    newhead->len = 0;
    msg_make_allstack(newmesg, MSG_SSIZE, (char *)newhead, sizeof(PSYNCheader2));
    for (j = 0; j < state->numpart; j++)
      if (j != state->MYPARTNUM) {
        if (s->down[j] != (XObj)-1) {
          msg_save(newmesg, newmesg);
          x_push(s->down[j], newmesg, (Msg *)0);
        }
      }
  }
  if (num != 0) {
    get_missing_msgs(self, s, 1, newmesg, num, view_mid);
    P(&(state->Fin_ber));
  }
  state->mid++;
}

get_missing_msgs(self, sessn, strt, msg, num, view_mid)
     XObj self, sessn;
     int strt, num;
     MID view_mid[];
     Msg msg;
{
  static int numm;
  static MID viewm[MAX_PART];
  static Semaphore sm;
  PSYNCheader2 *hdr2;
  Msg msg1;
  int i, had_probs;
  Sstate *ps;
  MID mymid;
  MID_ARRAY_STR leaves;
  Node *n;
  
  if (strt) {
    for (i = 0; i < num; i++)
      viewm[i] = view_mid[i];
    numm = num;
    InitSemaphore(&sm, 1);
    return(1);
  }
  P(&sm);
  ps = (Sstate *)sessn->state;
  msg_save(msg1, msg);
  hdr2 = (PSYNCheader2 *)msg_top(msg1, PSYNCHLEN2);
  mymid = hdr2->mid;
  if (map_resolve(ps->map_tree, &mymid) != -1) {
    msg_free(msg);
    msg_free(msg1);
    V(&sm)
      return(1);
  }
  msg_pop(msg, PSYNCHLEN2);       /* strip off header */
  if ((had_probs = add_node(self, sessn, hdr2, msg, &leaves, 0)) > 0) {
    if (!add_orphan(sessn, msg1))
      msg_free(msg1);
    msg_free(msg);
  }
  else
    if (had_probs == 0) {
      msg_save(msg, msg);
      /* check if any orphans got their parents now */
      msg_free(msg1);
      chk_orphans(self, sessn);
    }
  for (i = 0; i < numm; i++)
    if ((n = (Node *)map_resolve(ps->map_tree, &(viewm[i]))) != (Node *)-1) {
      if(n->sender == ps->MYPARTNUM)
        change_mid(ps, n->mid);
      viewm[i] = viewm[numm - 1];
      i--;
      numm--;
    }
  if (numm == 0) V(&(ps->Fin_ber));
  V(&sm);
}

change_mid(state, mid)
     Sstate *state;
     MID mid;
{
  if (mid.id > state->mid)
    state->mid = mid.id;
}

retrieve_sessn_state(self, hlp, old_s, view_mid, num)
     XObj hlp, self;
     int old_s;
     MID view_mid[];
     int num;
{
  Sstate *state;
  XObj s;
  Part part[3];
  PSYNCaddr *remote_addr;
  IPaddr    rm_ipaddr;
  int i, j, log_id;
  
  state = (Sstate *)calloc(1, sizeof(Sstate));
  if (state == NULL)
    printf("***PANIC - NULL malloc in psync_open()!!!\n");
  state->map_tree = map_create(2 * MAX_NODES, 6);
  state->next_msg = NULL;
  state->last_msg = NULL;
  state->num_orphan_request = 0;
  InitSemaphore(&(state->Push_exclusion), 1);
  InitSemaphore(&(state->slogex), 1);
  InitSemaphore(&(state->vslogex), 1);
  InitSemaphore(&(state->chlogex), 1);
  InitSemaphore(&(state->Fin_ber), 0);
  state->pushing_mid.id = 0;
  log_id =  map_resolve(((Pstate *)self->state)->map_log, &old_s);
  state->log.is_fslog = 0;
  init_log_nodes(state);
  state->log.fnd = NULL;
  state->log.lnd = &(state->log.log_node[0]);
  state->status = BACKWARD_ERROR_RECOVERY;
  state->first_msg = FIRST;
  
  get_slog(self, state, log_id);
  s = x_createsession(hlp, self, state->numpart);
  s->binding = map_bind(((Pstate *)self->state)->map_conv, (char *) &(state->conv_id), (int) s);
  map_bind(((Pstate *)self->state)->map_log, (char *)&s, log_id);
  ch_mlog(self, s, log_id);
  for (i = 0; i < state->numpart; i++) {
    remote_addr = &state->part_list[i];
    if (same_PSYNChost(myipaddr, remote_addr->host)) {
      state->MYPARTNUM = i;
      state->MY_MASK = (part_mask)(1 << state->MYPARTNUM);
      state->NULL_PART_MASK = ~(~0 << state->numpart);
#ifdef BROADCAST
      TRACE0(psyncp, 1, "PSYNC open: openning broadcast IP");
      init_partlist(part, 2, IPaddr);
      set_part(part, 0, ((Pstate *)self->state)->myaddr);
      rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
      rm-ipaddr.host = broadcast_addr;
      set_part(part, 1, rm_ipaddr);
      
      P(&(((Pstate *)self->state)->IPS));
      s->down[0] = x_open(self, self->down[0], part);
      V(&(((Pstate *)self->state)->IPS));
#endif BROADCAST
      for (j = 0; j < state->numpart; j++)
        if (j != i) {
          init_partlist(part, 2, IPaddr);
          set_part(part, 0, ((Pstate *)self->state)->myaddr);
          rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
          rm_ipaddr.host = state->part_list[j].host;
          set_part(part, 1, rm_ipaddr);
	  
          P(&(((Pstate *)self->state)->IPS));
          s->down[j] = x_open(self, self->down[0], part);
          V(&(((Pstate *)self->state)->IPS));
        }
      s->state = (char *)state;
      
    }
  }
  state->NULL_PART_MASK = ~(~0 << state->numpart);
  s->state = (char *) state;
  ch_slog(self, s);
  get_fslog(self, s);
  get_vslog(self, s, view_mid, num);
  event_register(do_log, s, LOG_INTERVAL, EV_REPEAT | EV_CREATEPROCESS);
  /*
    printf("PSYNC SESSN RESTORED\n");
    */
  return((int)s);
}

#endif LOGGING

chk_view(mid, view_mid, num)
     MID mid, view_mid[];
     int *num;
{
  int i;
  
  for (i = 0; i < *num; i++)
    if (same_mid(mid, view_mid[i])) {
      view_mid[i] = view_mid[*num - 1];
      *num -= 1;
      return(1);
    }
  return(0);
}

rec_own_msg(s, state, m, mid)
     XObj s;
     Sstate *state;
     MID mid;
     Msg *m;
     
{
  REVheader *rhdr;
  
  rhdr = (REVheader *)msg_push(*m, sizeof(REVheader));
  rhdr->node_id = (int)map_resolve(state->map_tree, &mid);
  x_demux(s, *m);
}

psync_controlprotl(self, opcode, buf, len)
     XObj self;
     int opcode, len;
     char *buf;
{
  Pstate *ps;
  XObj hlp;
  int old_s, num;
  MID *view_mid;
  
  assert(x_is_protocol(self));
  ps = (Pstate *)self->state;
  
  switch(opcode) {
  case SETDEBUG:
    return(0);
#ifdef LOGGING
  case PSYNC_RESTORESESSN:
    /**** buf = {hlp, old_s, numleaves, leaves} ****/
    /*
      printf("RESTORING PSYNC SESSN...\n");
      */
    hlp = *(XObj *)buf;
    old_s = *(int *)(buf + sizeof(XObj));
    num = *(int *)(buf + 2 * sizeof(XObj));
    view_mid = (MID *)(buf + 2 * sizeof(XObj) + sizeof(int));
    return(retrieve_sessn_state(self, hlp, old_s, view_mid, num));
#endif LOGGING
  default:
    x_errno = INVALID_OPCODE;
    return(-1);
  }
}

/*
 * psync_controlsessn(s,opcode,buf,len) 
 *
 * provides protocol-specific services to the hlp (ACKMESSAGE, FINDROOT,
 * NODETOMSG, SENDER, PREVNODES, OUTSTANDING, STABLE, UNSTABLE) 
 */

psync_controlsessn(s, opcode, buf, len)
     XObj           s;
     int             opcode, *len;
     char           *buf;
{
  XObj       self;
  Sstate     *p;
  Msg             msg;
  int             i, j, k, mlen, node, node1, msk, dis;
  MID             mid;
  Node            *n;
  outstanding_receive *m;
  unsigned char   num_next, numpart;
  PSYNCaddr       pa, *pb;
  Part            part[3];
  IPaddr          rm_ipaddr;
  
  p = (Sstate *) s->state;
  self = s->myprotl;
  switch (opcode) {
    
  case PSYNC_ACKMESSAGE:
    bcopy(buf, &node, 4);
    mid = get_mid(self, s, node);
    if ((update_view(self, s, mid)) == 0) {
      x_errno = UPDATE_FAILED;
      if (p->pushing_mid.id)
	if (same_mid(p->pushing_mid, mid)) {
	  /* acknowledging own message, so release the semaphore */
	  p->pushing_mid.id = 0;
	  V(&(p->Push_exclusion));
	}
      return ((int) NULL);
    }
    start_stability_check(self, s, mid);
    if (p->pushing_mid.id)
      if (same_mid(p->pushing_mid, mid)) {
	p->pushing_mid.id = 0;
	V(&(p->Push_exclusion));
      }
    return (1);
    
  case PSYNC_FINDROOT:
    mid = get_root(self, s);
    return ((int) get_node(self, s, mid));
    
    /************
      case NODETOMSG:
      bcopy(buf, &node, 4);
      return ((int) (&(node_to_msg(self, s, (Node *) node))));
      *************/
    
  case PSYNC_GETHANDLE:
    bcopy(buf, (char *)&mid, sizeof(MID));
    return ((int) get_node(self, s, mid));
    
  case PSYNC_GETMID:
    bcopy(buf, (char *)&node, 4);
    bcopy((char *)&(((Node *)node)->mid), buf, sizeof(MID));
    break;
    
  case PSYNC_SENDER:
    bcopy(buf, (char *)&node, 4);
    mid = get_mid(self, s, (Node *) node);
    pb = &(p->part_list[get_sender(self, s, mid)]);
    bcopy((char *)pb, buf, sizeof(PSYNCaddr));
    return(1);
    
  case PSYNC_PREVNODES:
    if (*len < 4 * MAX_PART+1) {
      return (-1);
    }
    bcopy(buf, (char *)&node, 4);
    bcopy((char *)(&(((Node *)node)->num_prev)), buf, 1);
    bcopy(prev_nodes(self, s, (Node *)node), buf+1, 4 * MAX_PART);
    return (1);
    
  case PSYNC_NEXTNODES:
    if (*len < 4 * MAX_PART + 1)
      return (-1);
    bcopy(buf, &node, 4);
    num_next = 0;
    k = 1;
    for (i = 0; i < ((Node *)node)->num_next; i++) {
      for (j = 0; j < p->view_leaves; j++) {
	if (check_path(((Node *)node)->next[i], p->view[j])) break;
      }
      if (j < p->view_leaves) {
	bcopy((char *)(&(((Node *) node)->next[i])), buf+k, 4);
	k += 4;
	num_next++;
      }
    }
    bcopy((char *)(&(num_next)), buf, 1);
    return (1);
    
  case PSYNC_OUTSTANDING:
    if (p->next_msg == NULL) return (FALSE);
    return (TRUE);
    
  case PSYNC_STABLE:
    bcopy(buf, &node, 4);
    if ((((Node *)node)->outstanding_stable_part_mask) == 0) return (TRUE);
    return (FALSE);
    
  case PSYNC_UNSTABLE:
    bcopy(buf, &node, 4);
    if ((((Node *)node)->outstanding_stable_part_mask) == 0) return (FALSE);
    else {
      numpart = 0;
      dis = 1;
      for (msk = 1, i = 0; i < p->numpart; i++, msk <<= 1)
	if (((((Node *)node)->outstanding_stable_part_mask & msk) & ~(p->required_part_mask))) {
	  numpart++;
	  bcopy((char *)(&(p->part_list[i])), buf+dis, sizeof(PSYNCaddr));
	  dis += sizeof(PSYNCaddr);
	}
      bcopy((char *)(&numpart), buf, 1);
      return (TRUE);
    }
    
  case PSYNC_PRECEDES:
    bcopy(buf, &node, 4);
    bcopy(buf+4,  &node1, 4);
    if (check_path((Node *)node, (Node *)node1)) return(TRUE);
    return(FALSE);
    
  case PSYNC_GETLEAVES:
    if (*len < 4 * MAX_PART) return(-1);
    bcopy((char *)(&(p->view_leaves)), buf, (sizeof(unsigned char)));
    bcopy((char *)p->view, buf+(sizeof(unsigned char)), (4 * MAX_PART));
    return(1);
    
  case PSYNC_MASKIN:
    bcopy(buf, (char *)&pa, sizeof(PSYNCaddr));
    for (msk = 1, i = 0; i < p->numpart; msk <<= 1, i++)
      if (same_PSYNChost(pa.host, p->part_list[i].host)) {
	if ((i != p->MYPARTNUM) && (s->down[i] == (XObj)-1)) {
	  init_partlist(part, 2, IPaddr);
	  set_part(part, 0, ((Pstate *)self->state)->myaddr);
	  rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
	  rm_ipaddr.host = p->part_list[i].host;
	  set_part(part, 1, rm_ipaddr);
	  
	  P(&(((Pstate *)self->state)->IPS));
	  s->down[i] = x_open(self, self->down[0], part);
	  V(&(((Pstate *)self->state)->IPS));
	}
	p->required_part_mask &= ~msk;
	p->ignore_part_mask &= ~msk;
#ifdef LOGGING
	p->log.is_fslog = 1;
#endif LOGGING
	return(1);
      }
    return(0);
    
  case PSYNC_MASKOUT:
    bcopy(buf, (char *)&pa, sizeof(PSYNCaddr));
    for (msk = 1, i = 0; i < p->numpart; msk <<= 1, i++)
      if (same_PSYNChost(pa.host, p->part_list[i].host)) {
	p->required_part_mask |= msk;
	for (j = 0; j < p->view_leaves; j++)
	  start_stability_check(self, s, get_mid(self, s, p->view[j]));
	return(1);
      }
#ifdef LOGGING
    p->log.is_fslog = 1;
#endif LOGGING
    return(0);
    
  case PSYNC_ISALIVE:
    bcopy(buf, (char *)&pa, sizeof(PSYNCaddr));
    for (msk = 1, i = 0; i < p->numpart; msk <<= 1, i++)
      if (same_PSYNChost(pa.host, p->part_list[i].host)) {
	if (p->required_part_mask & msk) {
	  return(0);
	}
	else {
	  return(1);
	}
      }
    break;
  case PSYNC_GETPARTS:
    bcopy((char *)(&(p->numpart)), buf, (sizeof(unsigned char)));
    bcopy((char *)p->part_list, buf+1, ((sizeof(PSYNCaddr)) * MAX_PART));
    return(1);
    
  case PSYNC_LASTMESG:
    bcopy(buf, (char *)&pa, sizeof(PSYNCaddr));
    for (i = 0; i < p->numpart; i++)
      if (same_PSYNChost(pa.host, p->part_list[i].host))
	bcopy((char *)&(p->lastmsg[i]), buf, sizeof(int));
    return(1);
    
#ifdef LOGGING
  case PSYNC_RSTART:
    p->status = FORWARD_ERROR_RECOVERY;
    /*
      printf("PSYNC: SENDING A RESTART MESSAGE\n");
      */
    send_restart_msg(s);
    break;
#endif LOGGING
  case PSYNC_IGNORE:
    bcopy(buf, (char *)&pa, sizeof(PSYNCaddr));
    for (msk = 1, i = 0; i < p->numpart; msk <<= 1, i++)
      if (same_PSYNChost(pa.host, p->part_list[i].host)) {
	p->ignore_part_mask |= msk;
	return(1);
      }
    return(0);
    
  case PSYNC_ISIGNORE:
    bcopy(buf, (char *)&pa, sizeof(PSYNCaddr));
    for (msk = 1, i = 0; i < p->numpart; msk <<= 1, i++)
      if (same_PSYNChost(pa.host, p->part_list[i].host)) {
	if ((p->ignore_part_mask) & (msk)) {
	  return(1);
	}
	else
	  return(0);
      }
    
  case PSYNC_ACCEPT:
    bcopy(buf, (char *)&pa, sizeof(PSYNCaddr));
    for (msk = 1, i = 0; i < p->numpart; msk <<= 1, i++)
      if (same_PSYNChost(pa.host, p->part_list[i].host)) {
	p->ignore_part_mask &= ~msk;
	return(1);
      }
    return(0);
    
  case PSYNC_LOOPBACK: 
    p->loopback = LOOP;
#ifdef LOGGING
    log_fslog(s->myprotl, s);
    p->log.is_fslog = 0;
#endif LOGGING
    return(1);
    
  case PSYNC_SETRECOVERY:
    p->rec_sessn = *(int *)buf;
    p->rec_opcode = *((int *)(buf+4));
    break;
    
  default:
    x_errno = INVALID_OPCODE;
    return (-1);
  }
}

print_refs(msg)
     Msg msg;
{
  printf("msg_stack_ref = %d\n", ((msg.stack)->ref).ref);
}

send_restart_msg(s)
     XObj s;
{
  int i;
  PSYNCheader3 *hdr3;
  Msg msg;
  
  Sstate *ps = (Sstate *)s->state;
  hdr3 = (PSYNCheader3 *)malloc(sizeof(PSYNCheader3));
  hdr3->type = RESTART;
  hdr3->cid = ps->conv_id;
  hdr3->pid = ps->part_list[ps->MYPARTNUM];
  msg_make_allstack(msg, MSG_SSIZE, (char *)hdr3, sizeof(PSYNCheader3));
  for (i = 0; i < ps->numpart; i++)
    if (i != ps->MYPARTNUM) {
      if (s->down[i] != (XObj)-1) {
        msg_save(msg, msg);
        x_push(s->down[i], msg, (Msg *)0);
      }
    }
  msg_free(msg);
}

/*
 * is_openenable(self, me) - returns protocol # if me has done an openenable,
 * else returns -1 
 */
is_openenable(self, me)
     XObj           self;
     PSYNCaddr      *me;
{
  PSYNC_EXID      ex_id;
  
  ex_id.localport = me->port;
  ex_id.real = me->host;
  return (map_resolve(((Pstate *)self->state)->map_openenable, (char *) &ex_id));
}

/*
 * insert_inviteeQ(conv_id,msg) - keep in invitQ the conv_id that has a 
 * participant in the local hos but hasn't done an open_enable. The first
 * message of the conversation is also stored.
 */
insert_inviteeQ(conv_id, port, msg)
     struct cnv_id  *conv_id;
     Msg             msg;
     unsigned int    port;
{
  struct invtQ   *new, *p;
  
  new = (struct invtQ *) malloc(sizeof(struct invtQ));
  if (new == NULL)
    printf("***PANIC: insert_invitee() got NULL from malloc!!!!!\n");
  new->port = port;
  new->conv_id.host = conv_id->host;
  new->conv_id.id = conv_id->id;
  new->msg = msg;
  new->next = NULL;
  if (invtQ == NULL) {
    invtQ = new;
    return;
  }
  for (p = invtQ; p->next != NULL; p = p->next);
  p->next = new;
}


/*
 * create_conv_id(host) - creates and returns a conversation id for host 
 */
struct cnv_id  create_conv_id(self, host)
	XObj self;
	IPhost host;
{
  struct cnv_id   cid;
  
  cid.host = host;
  cid.id = ((Pstate *)(self->state))->cid++;
  return (cid);
}


/*
 * create_mid(host) - creates and returns a message id for host 
 */
MID create_mid(s, host)
	XObj s;
	IPhost          host;
{
  MID             mid;
  
  mid.host = host;
  mid.id = ((Sstate *)(s->state))->mid++;
  return (mid);
}

#ifdef LOGGING

create_logid(self)
     XObj self;
{
  return(P_LOGADDR + NUMLOGS * ((Pstate *)self->state)->num_sessn + 1);
}

#endif LOGGING


/*
 * psync_pop(self, sessn, msg) 
 *
 * receive message from remote participant 
 */
psync_pop(self, sessn, msg)
     XObj           self, sessn;
     Msg             msg;
{
  register Node *n;
  MID_ARRAY_STR leaves /*, parents --if used parents->num_arr must..*/;
  Msg msg1, message, newmesg, p_hdrmsg, data;
  char msg_type;
  register int i, j, k, had_probs, msg_known, count;
  register PSYNCheader2 *hdr2, *newhead;
  PSYNCheader2 header2;
  register PSYNCheader1 *hdr1;
  PSYNCheader1 header1;
  register PSYNCheader3 *hdr3;
  PSYNCheader3 header3;
  XObj send_to;
  MID mymid;
  Sstate *state = (Sstate *)sessn->state;
  PSYNCaddr sender;
  unsigned msk;
  Node *depend[MAX_PART]; 
  REVheader *rhdr;
  int len = 10;
  
  assert(x_is_protocol(self));
  assert(x_is_session(sessn));
  
  hdr3 = (PSYNCheader3 *) msg_top(msg, PSYNCHLEN3);
  msg_type = hdr3->type;
  
  switch (msg_type) {
  case FIRST:
    /* this is the FIRST message of the conversation */
    
    hdr1 = (PSYNCheader1 *) msg_top(msg, PSYNCHLEN1);
    mymid = hdr1->mid;
    /* get a header pointer */
    msg_pop(msg, PSYNCHLEN1);	/* strip off header */
    
    init_graph(self, sessn, hdr1, msg, 0);	/* initialize Ih */
    state->first_msg = ~FIRST;
    msg_save(msg, msg);
    rhdr = (REVheader *)msg_push(msg, sizeof(REVheader));
    rhdr->node_id = (int)map_resolve(state->map_tree, &mymid);
    if (state->loopback == NOLOOP) {
      update_view(self, sessn, mymid);
      start_stability_check(self, sessn, mymid);
    }
    chk_orphans(self, sessn);
    x_demux(sessn, msg);
    break;
    
  case REGULAR:		/* ??? missing messages case not examined */
    msg_save(msg1, msg);
    hdr2 = (PSYNCheader2 *)msg_top(msg, PSYNCHLEN2);
    mymid = hdr2->mid;
    msk = (unsigned)(1 << hdr2->sender);
    if (msk & state->required_part_mask) {
      /*
	printf("MSG FROM FAILED PART\n");
	*/
      break;
    }
    if (msk & state->ignore_part_mask) {
      /*
	printf("MSG FROM IGNORED PART");
	*/
      break;
    }
    msg_pop(msg, PSYNCHLEN2);	/* strip off header */
    
    if (((Sstate *) sessn->state)->root) {
      /* Ih root already exits */
      had_probs = add_node(self, sessn, hdr2, msg, &leaves, 0);
    }
    else
      /*
       * Ih root does not exist, first message hasn't been received 
       */
      had_probs = 1;	/* root doesn't exist ... */
    if (had_probs > 0) {
      /* some of message's parents are missing */
      
      /*
	print_mid("==>psync_pop(): received an orphan, mid=",
	hdr2->mid, "\n");
	*/
      if (add_orphan(sessn, msg1))
	if (had_probs == 1) {
	  newhead = (PSYNCheader2 *) malloc(sizeof(PSYNCheader2));
	  if (newhead == NULL)
	    printf("***PANIC - NULL from malloc in psync_pop()!!!\n");
	  newhead->type = RETRANSMIT;
	  newhead->cid = hdr2->cid;
	  newhead->mid = hdr2->mid;
	  newhead->sender = ((Sstate *)sessn->state)->MYPARTNUM;
	  newhead->depend = leaves;
	  newhead->len = 0;
	  msg_make_allstack(newmesg, MSG_SSIZE, (char *) newhead, sizeof(PSYNCheader2));
	  x_push(sessn->down[hdr2->sender], newmesg, (Msg *)0);
	  if (((Sstate *) sessn->state)->num_orphan_request > ORPHAN_SIZE)
	    ((Sstate *) sessn->state)->num_orphan_request = 0;
	  else
	    ((Sstate *) sessn->state)->num_orphan_request++;
	  msg_free(msg);
	} 
    } else {
      if (had_probs == 0) {
	/* message's parents are known in Ih */
	msg_save(msg, msg);
	msg_free(msg1);
	rhdr = (REVheader *)msg_push(msg, sizeof(REVheader));
	rhdr->node_id = (int)map_resolve(state->map_tree, &mymid);
	if (state->loopback == NOLOOP) {
	  update_view(self, sessn, hdr2->mid);
	  start_stability_check(self, sessn, hdr2->mid);
	}
	chk_orphans(self, sessn);
	x_demux(sessn, msg);
      }
    }
    
    break;
    
  case REPLY:
    /* This message is a reply to a RETRANSMIT request */
#ifdef LOGGING
    if (state->status == BACKWARD_ERROR_RECOVERY) {
      get_missing_msgs(self, sessn, 0, msg, 0, NULL);
      return;
    }
#endif LOGGING
    msg_save(msg1, msg);
    hdr2 = (PSYNCheader2 *)msg_top(msg1, PSYNCHLEN1);
    mymid = hdr2->mid;
    msg_pop(msg, PSYNCHLEN2);	/* strip off header */
    if ((had_probs = add_node(self, sessn, hdr2, msg, &leaves, 0)) > 0) {
      /*
       * some of message's parents are still missing (this is
       * alright, since we can't expect the messages that were sent
       * in response to our RETRANSMIT request are in the right
       * order). 
       */
      add_orphan(sessn, msg1);
      msg_free(msg);	/* we keep a reference to msg! */
    } else {
      if (had_probs == 0) {
	msg_save(msg, msg);
	/* check if any orphans got their parents now */
	msg_free(msg1);
	rhdr = (REVheader *)msg_push(msg, sizeof(REVheader));
	rhdr->node_id = (int)map_resolve(state->map_tree, &mymid);
	if (state->loopback == NOLOOP) {
	  update_view(self, sessn, hdr2->mid);
	  start_stability_check(self, sessn, hdr2->mid);
	}
	chk_orphans(self, sessn);
	x_demux(sessn, msg);
      }
    }
    
    
    break;
    
  case RETRANSMIT:
    /* retransmit request */
    
    /* for now, we assume the 2 host test case and therefore only
     * retransmit immediate parents. Note: When we add code to 
     * retransmit the complete subtree, then we also have to add code 
     * to add_node() to update the Ih leave pointers, otherwise we 
     * retransmit the whole Ih every time ! */
    
    /* If the first mid in depend is same as the orphan mid, then
     * the message corresponding to orphan is also sent. */
    
    /*
      printf("RECEIVED RETRANSMIT REQUEST\n");
      */
    
    hdr2 = (PSYNCheader2 *)msg_top(msg, PSYNCHLEN2);
    mymid = hdr2->mid;
    if ((n = (Node *) map_resolve(MY_STATE->map_tree,
				  &hdr2->mid)) == ((Node *)-1)) {
      printf("psync_pop(): RETRANSMIT: don't know orphan !!");
      break;
    }
    count = 0;
    if (same_mid(mymid, hdr2->depend.arr[0])) {
      for (i = 1; i < hdr2->depend.num_arr + 1 ; i++) {
	if ((depend[count] = get_node(self, sessn, hdr2->depend.arr[i])) != NULL)
	  count++;
      }
      depend[count] = NULL;
    }
    else {
      for (i = 0; i < hdr2->depend.num_arr ; i++) {
	if ((depend[count] = get_node(self, sessn, hdr2->depend.arr[i])) != NULL)
	  count++;
      }
      depend[count] = NULL;
    }
    if (same_mid(mymid, hdr2->depend.arr[0])) {
      do_reply(sessn, depend, n, hdr2, 1);
    }
    else {
      do_reply(sessn, depend, n, hdr2, 0);
    }
    msg_free(msg);
    /* V(&tree); */
    break;
    
  case RESTART:
    hdr3 = (PSYNCheader3 *)msg_top(msg, PSYNCHLEN3);
    for (j = 0; j < MY_STATE->numpart; j++)
      if (same_PSYNChost(MY_STATE->part_list[j].host, hdr3->pid.host)) break;
    for (i = 0; i < MY_STATE->view_leaves; i++)
      do_restart(sessn, hdr3->cid, MY_STATE->view[i], sessn->down[j]);
    /*****************************************
     * set the proper variable to inform the *
     * application that the part is up       *
     ****************************************/
    x_controlsessn(state->rec_sessn, state->rec_opcode, 
		   (char *)&(hdr3->pid), &len);
    msg_free(msg);
    break;            
  }			/* end switch */
}

do_restart(s, cid, n, whom)
     XObj s, whom;
     Node *n;
     struct cnv_id cid;
{
  int j;
  PSYNCheader2 *newhead;
  Msg newmesg, mesg;
  Sstate *ps = (Sstate *)s->state;
  
  if (whom != (XObj)-1) {
    newhead = (PSYNCheader2 *)malloc(PSYNCHLEN2);
    newhead->type = REGULAR;
    newhead->cid = cid;
    newhead->mid = n->mid;
    newhead->sender = n->sender;
    newhead->len = msg_len(n->message);
    for (j=0; j<n->num_prev; j++)
      newhead->depend.arr[j] = n->prev[j]->mid;
    newhead->depend.num_arr = j;
    msg_make_allstack(mesg, MSG_SSIZE, (char *)newhead, PSYNCHLEN2);
    msg_save(n->message, n->message);
    msg_join(newmesg, mesg, n->message);
    x_push(whom, newmesg, (Msg *)0);
  }
}

is_node_sent(sent_nodes, num_sent, n)
     Node *sent_nodes[], *n;
     int *num_sent;
     
{
  int i;
  
  for (i = 0; i < *num_sent; i++)
    if (sent_nodes[i] == n) return(1);
  return(0);
}

typedef struct {
  Node *n;
  int ind;
} Tmp_str;

compute_indegrees(s, depend, nde, ind_map, nd)
     XObj s;
     Node *nde, *depend[];
     Map *ind_map;
     Tmp_str nd[];
     
{
  int qb, qe, i, p;
  Node *n;
  
  map_bind(*ind_map, (char *)&nde, 0);
  qb = qe = 0;
  nd[qe].n = nde;
  nd[qe].ind = 0;
  qe++;
  while (qb != qe) {
    n = nd[qb].n;
    for (i = 0; i < n->num_prev; i++)
      if (no_path(s, n->prev[i], depend)) {
        if ((p = (map_resolve(*ind_map, (char *)&(n->prev[i])))) == -1) {
          map_bind(*ind_map, (char *)&(n->prev[i]), qe);
          nd[qe].n = n->prev[i];
          nd[qe].ind = 1;
          qe++;
          p = map_resolve(*ind_map, (char *)&(n->prev[i]));
          if(qe > 350) {
            printf("Check_path : buffer exceeded\n");
          }
        }
        else {
          nd[p].ind++;
        }
      }
    qb++;
  }
}

do_reply(s, depend, nd, hdr2, own)
     XObj s;
     Node *nd, *depend[];
     PSYNCheader2 *hdr2;
     int own;
     
{
  Map ind_map;
  Tmp_str que[350];
  Node *nque[350], *n;
  int qb, qe, i, p, j;
  PSYNCheader2 *newhead;
  Msg newmesg, p_hdrmsg, mesg;
  Sstate *ps = (Sstate *)s->state;
  
  if (s->down[hdr2->sender] != (XObj)-1) {
    ind_map = map_create(600, 4);
    compute_indegrees(s, depend, nd, &ind_map, que);
    qb = qe = 0;
    nque[qe] = nd;
    qe++;
    do {
      n = nque[qb];
      for (i = 0; i < n->num_prev; i++) {
        if ((p = map_resolve(ind_map, (char *)&(n->prev[i]))) != -1) {
          que[p].ind--;
          if (que[p].ind == 0) {
            nque[qe] = n->prev[i];
            qe++;
          }
        }
      }
      qb++;
    } while(qb != qe);
    for (i = qe-1; i >= 0; i--) {
      n = nque[i];
      if (!((!own) && (n == nd))) {
        newhead = (PSYNCheader2 *)malloc(PSYNCHLEN2);
        newhead->type = REPLY;
        newhead->cid = hdr2->cid;
        newhead->mid = n->mid;
        newhead->sender = n->sender;
        newhead->len = msg_len(n->message);
	
	/*
	  print_mid("RETRANSMIT branch point2, sending mid ", newhead->mid,"\n");
	  */
        for (j=0; j<n->num_prev; j++)
          newhead->depend.arr[j] = n->prev[j]->mid;
        newhead->depend.num_arr = j;
        if (msg_isnull(n->message)) {
          printf ("ERROR: message already removed\n");
          return;
        }
        msg_make_allstack(mesg, MSG_SSIZE, (char *)newhead, PSYNCHLEN2);
        msg_save(n->message, n->message);
        msg_join(newmesg, mesg, n->message);
        x_push(s->down[hdr2->sender], newmesg, (Msg *)0);
      }
    }
    map_close(ind_map);
  }
}

/*
  
do_reply(s, depend, nd, hdr2, own)
     XObj s;
     Node *nd, *depend[];
     PSYNCheader2 *hdr2;
     int own;
     
{
  int qbegin, qend;
  int i, j;
  PSYNCheader2 *newhead;
  Msg newmesg, p_hdrmsg, mesg;
  Sstate *ps = (Sstate *)s->state;
  Node *n, *sent_nodes[500];
  
  if (s->down[hdr2->sender] != (XObj)-1) {
    qbegin = qend = 0;
    if (own) {
      sent_nodes[qend] = nd;
      qend++;
    }
    else
      for (i = 0; i < nd->num_prev; i++)
	if ((no_path(s, nd->prev[i], depend)) && (!is_node_sent(sent_nodes, &qend, nd->prev[i]))) {
	  sent_nodes[qend] = nd->prev[i];
	  qend++;
	}
    while (qbegin != qend) {
      n = sent_nodes[qbegin];
      for (i = 0; i < n->num_prev; i++)
	if ((no_path(s, n->prev[i], depend)) && (!is_node_sent(sent_nodes, &qend, n->prev[i]))) {
	  sent_nodes[qend] = n->prev[i];
	  qend++;
	  if (qend > 300 )
	    printf("buffer exceeded\n");         
	}
      qbegin++;
    }
    for (i = 0; i < qend; i++) {
      n = sent_nodes[i];
      newhead = (PSYNCheader2 *)malloc(PSYNCHLEN2);
      newhead->type = REPLY;
      newhead->cid = hdr2->cid;
      newhead->mid = n->mid;
      newhead->sender = n->sender;
      newhead->len = msg_len(n->message);
      
      print_mid("RETRANSMIT branch point2, sending mid ", newhead->mid,"\n");
      
      for (j=0; j<n->num_prev; j++)
	newhead->depend.arr[j] = n->prev[j]->mid;
      newhead->depend.num_arr = j;
      if (msg_isnull(n->message)) {
	printf ("ERROR: message already removed\n");
	return;
      }
      msg_make_allstack(mesg, MSG_SSIZE, (char *)newhead, PSYNCHLEN2);
      msg_save(n->message, n->message);
      msg_join(newmesg, mesg, n->message);
      x_push(s->down[hdr2->sender], newmesg, (Msg *)0);
    }
  }
}

*/
/*

do_reply(s, depend, n, hdr2, sent_nodes, num_sent)
     XObj s;
     Node *n, *depend[];
     PSYNCheader2 *hdr2;
     Node *sent_nodes[];
     int *num_sent;
{
  int i, j;
  PSYNCheader2 *newhead;
  Msg newmesg, p_hdrmsg, mesg;
  Sstate *ps = (Sstate *)s->state;
  
  if (s->down[hdr2->sender] != (XObj)-1) {
    for (i = 0; i < n->num_prev; i++)
      if ((!is_node_sent(sent_nodes, num_sent, n->prev[i])) && (no_path(s, n->prev[i], depend)))
	do_reply(s, depend, n->prev[i], hdr2, sent_nodes, num_sent);
    newhead = (PSYNCheader2 *)malloc(PSYNCHLEN2);
    newhead->type = REPLY;
    newhead->cid = hdr2->cid;
    newhead->mid = n->mid;
    newhead->sender = n->sender;
    newhead->len = msg_len(n->message);
    
    print_mid("RETRANSMIT branch point2, sending mid ", newhead->mid,"\n");
    
    for (j=0; j<n->num_prev; j++)
      newhead->depend.arr[j] = n->prev[j]->mid;
    newhead->depend.num_arr = j;
    if (msg_isnull(n->message)) {
      printf ("ERROR: message already removed\n");
      return;
    }
    msg_make_allstack(mesg, MSG_SSIZE, (char *)newhead, PSYNCHLEN2);
    msg_save(n->message, n->message);
    msg_join(newmesg, mesg, n->message);
    x_push(s->down[hdr2->sender], newmesg, (Msg *)0);
    sent_nodes[*num_sent] = n;
    *num_sent += 1;
  }
}

*/

no_path(s, n, depend)
     XObj s;
     Node *n, *depend[];
{
  int i;
  
  for(i = 0; depend[i]; i++)
    if (check_path(n, depend[i])){
      return(0);
    }
  return(1);
}

/*
 * add_orphan() put a message on orphan list 
 */
add_orphan(sessn, msg)
     XObj           sessn;
     Msg             msg;
{
  int             i;
  PSYNCheader2    header2, *hdr2, *hdr, header;
  register unsigned char *norp_ptr;
  
  norp_ptr = &(MY_STATE->num_orphans);
  
  if (*norp_ptr >= MAX_ORPHANS) {
    printf("TOO many orphans, orphan not added\n");
    return(0);
  }
  else {
    hdr2 = (PSYNCheader2 *) msg_top(msg, PSYNCHLEN2);
    for (i=0; i< *norp_ptr; i++) {
      hdr = (PSYNCheader2 *) msg_top(
				     MY_STATE->orphans_list[i], PSYNCHLEN2);
      if (same_mid(hdr2->mid, hdr->mid)) {
	return(0);
      }
    }
    MY_STATE->orphans_list[(*norp_ptr)++] = msg;
  }
  return(1);
}



/*
 * chk_orphans() check if any messages on the orphans list got their
 * parents now. if any, add them to graph and pop them to hlps 
 */
void
  chk_orphans(self, sessn)
XObj           self, sessn;
{
  PSYNCheader2    header2, *hdr2;
  Msg             msg1, msg;
  Node           *dummy1[MAX_PART];
  MID_ARRAY_STR   dummy2;
  int             i, j, had_probs;
  register unsigned char  *norp_ptr;
  REVheader *rhdr;
  
  norp_ptr = &(MY_STATE->num_orphans);
  
  for (i = 0; i < *norp_ptr;)  {
    /* walk through orphans list */
    msg= MY_STATE->orphans_list[i];
    msg_save(msg1, msg);
    hdr2 = (PSYNCheader2 *) msg_top(msg1, PSYNCHLEN2);
    if (!chk_parents(sessn, hdr2->depend, dummy1)) {
      /* message has its context now */
      /* remove it from orphan list */
      MY_STATE->orphans_list[i] = 
	MY_STATE->orphans_list[--(*norp_ptr)] ;
      msg_pop(msg, PSYNCHLEN2);
      if ((had_probs = add_node(self, sessn, hdr2, msg, &dummy2, 0)) > 0)
	printf("***PANIC:chk_orphans(): add_node failed !\n");
      
      else if (had_probs == 0) {
	msg_save(msg, msg);
	rhdr = (REVheader *)msg_push(msg, sizeof(REVheader));
	rhdr->node_id = (int)map_resolve(MY_STATE->map_tree, &(hdr2->mid));
	if (MY_STATE->loopback == NOLOOP) {
	  update_view(self, sessn, hdr2->mid);
	  start_stability_check(self, sessn, hdr2->mid);
	}
	x_demux(sessn, msg);
	i = 0;
      }
      msg_free(msg1);
    } else
      i++;
  }
}

/*
 * psync_demux() 
 *
 * takes a message from llp 
 */
psync_demux(self, sn, msg)
     XObj           self, sn;
     Msg             msg;
{
  PSYNCheader1    header1, *hdr1;
  PSYNCheader3    header3, *hdr3;
  Sstate          *state;
  XObj            s, sessn;
  Part	    part[3];
  XObj            hlp;
  int             i, j, k, logid;
  IPaddr          rm_ipaddr;
  
  hdr3 = (PSYNCheader3 *) msg_top(msg, PSYNCHLEN3);
  /* Note: The message could have PSYNCheader1 or 2, but we don't care,
   * since the members cid and sender (those we are interested in here )
   * are identical for both structures.
   */
  
  /* determine receiving conversation */
  
  if ((sessn = (XObj) map_resolve(((Pstate *)self->state)->map_conv, (char *) &hdr3->cid)) != ERR_SESSN) {
    /* pop up message to the psync session that runs the conversation */
    /* this passes control to psync_pop() ! */
    x_pop(self, sessn, msg);
  }
  else {
    /* probably a conversation initiated by a remote participant */
    if (hdr3->type == FIRST) {
      /* check if the local participant has done an open_enable */
      hdr1 = (PSYNCheader1 *)msg_top(msg, PSYNCHLEN1);
      for (i = 0; i < hdr1->numpart; i++)
	if (same_PSYNChost(hdr1->part_list[i].host, myipaddr)){
	  if ((hlp = (XObj) is_openenable(self, &hdr1->part_list[i])) != ERR_XOBJ) {
	    sessn = (XObj)x_createsession(hlp, self, hdr1->numpart);
	    state = (Sstate *) calloc(1, sizeof(Sstate));
	    if (state == NULL)
	      printf("***PANIC: malloc returned NULL in psync_demux()\n");
	    sessn->state = NULL;
	    sessn->binding = map_bind(((Pstate *)self->state)->map_conv, (char *) &hdr1->cid, (int) sessn);
	    state->conv_id = hdr1->cid;
	    state->map_tree = map_create(2 * MAX_NODES, 6);
	    state->first_msg = FIRST;
	    state->numpart = hdr1->numpart;
	    state->root = NULL;
	    state->next_msg = NULL;
	    state->last_msg = NULL;
	    state->me = hdr1->part_list[i];
	    state->MYPARTNUM = i;
	    state->loopback = NOLOOP;
	    state->mid = 1;
	    state->num_orphan_request = 0;
	    InitSemaphore(&(state->Push_exclusion), 1);
#ifdef LOGGING
	    state->status = ALIVE;
	    InitSemaphore(&(state->slogex), 1);
	    InitSemaphore(&(state->vslogex), 1);
	    InitSemaphore(&(state->chlogex), 1);
#endif LOGGING
	    state->pushing_mid.id = 0;
	    state->MY_MASK = (part_mask)(1 << state->MYPARTNUM);
	    state->NULL_PART_MASK = ~(~0 << state->numpart);
	    for (j = 0; j <= hdr1->numpart; j++)
	      state->part_list[j] = hdr1->part_list[j];
#ifdef BROADCAST
	    /* open an IP broadcast session */
	    TRACE0(psyncp, 1, "PSYNC open: openning broadcast IP");
	    init_partlist(part, 2, IPaddr);
	    set_part(part, 0, ((Pstate *)self->state)->myaddr);
	    rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
	    rm-ipaddr.host = broadcast_addr;
	    set_part(part, 1, rm_ipaddr);
	    
	    P(&(((Pstate *)self->state)->IPS));
	    sessn->down[0] = x_open(self, self->down[0], part);
	    V(&(((Pstate *)self->state)->IPS));
#endif BROADCAST
	    for (j = 0; j < hdr1->numpart; j++)
	      if (j != i) {
		init_partlist(part, 2, IPaddr);
		set_part(part, 0, ((Pstate *)self->state)->myaddr);
		rm_ipaddr.protocolnum = ((Pstate *)self->state)->myaddr.protocolnum;
		rm_ipaddr.host = hdr1->part_list[j].host;
		set_part(part, 1, rm_ipaddr);
		
		P(&(((Pstate *)self->state)->IPS));
		sessn->down[j] = x_open(self, self->down[0], part);
		V(&(((Pstate *)self->state)->IPS));
	      }
	    sessn->state = (char *)state;
#ifdef LOGGING
	    ((Pstate *)self->state)->num_sessn++;
	    map_bind(((Pstate *)self->state)->map_log, (char *)&sessn, (logid = create_logid(self)));
	    init_sessn_log(self, sessn, logid);
	    event_register(do_log, sessn, LOG_INTERVAL, EV_REPEAT | EV_CREATEPROCESS);
#endif LOGGING
	    part[0].address = (char *) &hdr1->cid;
	    part[0].length = 8;
	    part[1].address = (char *) &hdr1->part_list[i];
	    part[1].length = sizeof(PSYNCaddr);
	    part[2].address = NULL;
	    part[2].length = 0;
	    x_callopendone(hlp, sessn, part);
	    x_pop(self, sessn, msg);
	  }
	  else {
	    /* local participant has not done an open_enable */
	    /* must store the message for future */
	    msg_save(msg, msg);
	    insert_inviteeQ(&hdr1->cid, hdr1->part_list[i].port, msg);
	  }
	  break;
	}
    }
    else {
      /* This is not the first message of conversation and local participant
       * hasn't done any open_enable. So, ignore the message.
       */
      printf("psync_demux: dropping the message\n");
    }
  }
}

/*
 * newnode() allocate and initialize a new message node 
 */
Node *newnode(s, mid, sender, m)
     XObj           s;
     MID             mid;
     int             sender;
     Msg             m;
{
  register Node  *n;
  int             i;
  unsigned        msk;
  Sstate     *ps;
  
  
  if ((n = new_node() ) == NULL) {
    printf("psync:newnode(): malloc failed\n");
    return (NULL);
  }
  ps = (Sstate *) (s->state);
  n->mid = mid;
  n->sender = sender;
  n->message = m;
  n->recvd = 0;
  n->num_prev = n->num_next = 0;
  n->outstanding_stable_part_mask = ps->NULL_PART_MASK & ~(ps->MY_MASK);
  return n;
}

inc_first_msg(self, s, sender, msg_mid, m, me)
     XObj self, s;
     int sender;
     MID msg_mid;
     Msg m;
     int me;
{
  Node *n;
  Sstate *ps;
  MID mid;
  Msg r;
  
  ps = (Sstate *) (s->state);
  if (map_resolve(ps->map_tree, &msg_mid) != -1) {
    /* just drop the extra copy of the message */
    return (1);
  }
  /* create new message node */
  n = newnode(s, msg_mid, sender, m);
  if (me)
    ps->lastmsg[sender] = n;
  ps->root = n;
  ps->num_leaves=0;
  /* bind message to map */
  map_bind(ps->map_tree, &msg_mid, n);
  ps->first_msg = ~FIRST;
#ifdef LOGGING
  store_log(self, s, n);
#endif LOGGING
  return (1);
}

/*
 * init_graph() called by psync_push() and psync_pop after the first
 * message has been sent / received. Initializes the Graph Ih ?! (yes
 * -llp) 
 */
int
  init_graph(self, s, hdr, m, me)
XObj           self, s;
PSYNCheader1   *hdr;
Msg             m;
int             me;
{
  Node           *n;
  Sstate     *ps;
  MID             mid;
  Msg             r;
  
  P(&(((Pstate *)self->state)->tree));
  ps = (Sstate *) (s->state);
  mid = hdr->mid;
  if (map_resolve(ps->map_tree, &mid) != -1) {
    /* just drop the extra copy of the message */
    V(&(((Pstate *)self->state)->tree));
    return (1);
  }
  /* create new message node */
  n = newnode(s, hdr->mid, hdr->sender, m);
  if (me)
    ps->lastmsg[hdr->sender] = n;
  ps->root = n;
  ps->num_leaves=0;
  /* bind message to map */
  map_bind(ps->map_tree, &hdr->mid, n);
  V(&(((Pstate *)self->state)->tree));
#ifdef LOGGING
  store_log(self, s, n);
#endif LOGGING
  return (1);
}

/*
 * add_node() add message to the ih graph returns 0 if message was
 * sucessfully added, or negative if message is already known. it
 * returns 1 if some of the message's parents are missing and a
 * retransmit request is required. returns 2 if some of message
 * parents are missing and retransmit request is not required. puts
 * into depend the current leaves of ih (type mid[]), message id added,
 * its ancestors are checked for stability, and if stable, they are freed. 
 */
int
  add_node(self, s, hdr, m, depend, me)
XObj           self, s;
PSYNCheader2   *hdr;
Msg             m;
MID_ARRAY_STR  *depend;
int             me;
{
  register int             bit_vect, i, j;
  register Sstate     *ps;
  register Node  *n, *node_ptr;
  MID            *res;
  register MID_ARRAY_STR   prev_list;
  int            sender;
  Node           **leaves, *parent, *prev_nlist[MAX_PART];
  MID             mid;
  int            *id;
  Msg             r;
  
  P(&(((Pstate *)self->state)->tree));
  
  mid = hdr->mid;		/* mid */
  prev_list = hdr->depend; /* list of mids this message depends on */
  sender = hdr->sender;
  if (!prev_list.num_arr) {
    inc_first_msg(self, s, sender, mid, m, me);
    V(&(((Pstate *)self->state)->tree));
    return(0);
  }
  ps = (Sstate *) (s->state);
  
#ifdef LOGGING
  if (ps->status == FORWARD_ERROR_RECOVERY)
    change_mid(ps, mid);
#endif LOGGING
  if (map_resolve(ps->map_tree, &mid) != -1) {
    /* message itself is already known */
    V(&(((Pstate *)self->state)->tree));
    return (-1);
  }
  
  if (bit_vect = chk_parents(s, prev_list, prev_nlist)) {
    if (bit_vect == 1) {
      for (i=0,j=ps->num_leaves; i<j; i++) {
	depend->arr[i] = ps->leaves[i]->mid;
      }
      depend->num_arr = j;
      V(&(((Pstate *)self->state)->tree));
      return (1);
    }
    V(&(((Pstate *)self->state)->tree));
    return (2);
  }
  /* message's parents are known */
  /*
   * prev_nlist[] contains pointers to those nodes of Ih the message
   * depends on (parent nodes) 
   */
  
  n = newnode(s, mid, sender, m);
  if (me) 
    ps->lastmsg[sender] = n;
  /* add message to graph ih */
  for (i = 0; i < hdr->depend.num_arr; i++) {
    node_ptr = prev_nlist[i];
    /* for every node the message depends on */
    n->prev[i] = node_ptr;		/* set reverse link to that node */
    node_ptr->next[  node_ptr->num_next++  ] = n;
  }
  n->num_prev = i;
  
  leaves = ps->leaves;	/* current Ih leaves */
  
  /* update the Ih's leave pointers */
  /* find those of the message's parents that are leaves */
  for (i = 0; i < n->num_prev; i++) {
    /* for every one of the message's parents */
    parent = n->prev[i];
    
    for (j = 0; j < ps->num_leaves; j++)
      /* for every leave of Ih */
      if (parent == leaves[j]) {
	/* the parent was a leaf, but not any more */
	leaves[j] = leaves[--ps->num_leaves];
	break;
      }
  }
  
  /* set a leave pointer to the new message node */
  leaves[ps->num_leaves++] = n;
  /* bind message id to our map */
  map_bind(ps->map_tree, &mid, n);
  V(&(((Pstate *)self->state)->tree));
#ifdef LOGGING
  store_log(self, s, n);
#endif LOGGING
  return (0);
}


/*
 * chk_parents() takes a list of mids of a message's parents (prev_list)
 * returns 0, if all the parents are known. Returns 1, if some parent(s)
 * are not known and a retransmit request is required because some of the
 * missing parents are not present in orphan list or because too many 
 * too many orphans have accumulated (probably because of a loss of some
 * reply message. Returns 2, if some parent(s) are missing but no need for
 * a retransmit request. Returns an array of node pointers of the parents of
 * the message (prev_nlist) if all parents are known.
 */
int
  chk_parents(s, prev_list, prev_nlist)
XObj s;
MID_ARRAY_STR prev_list;
Node *prev_nlist[];

{
  int             flag = 0, i, j;
  MID             mid;
  register Sstate     *ps;
  
  ps = (Sstate *) (s->state);
  
  for (i = 0; i < prev_list.num_arr; i++) {
    /* for every parent message */
    mid = prev_list.arr[i];
    if ((prev_nlist[i] = (Node *) map_resolve(ps->map_tree, &mid)) == (Node *)-1) {
      /*
	print_mid("found mid ", mid, "missing\n");
	printf("  %d prev_list is  ", prev_list.num_arr);
	for (j = 0; j < prev_list.num_arr; j++)
        print_mid("     ", prev_list.arr[j], "\n");
	*/
      flag = 1;
      if (ps->num_orphans == 0)
        return(1);
      else if (!chk_orphan_list(s, mid))
        return(1);
    }
  }
  if (flag) return(2);
  return (0);
}

chk_orphan_list(s, mid)
     XObj s;
     MID mid;
{
  int i;
  PSYNCheader2 *hdr2, header2;
  Sstate *ps = (Sstate *)s->state;
  
  for (i=0; i<ps->num_orphans; i++) {
    hdr2 = (PSYNCheader2 *)msg_top(ps->orphans_list[i], PSYNCHLEN2);
    if (same_mid(hdr2->mid, mid)) return(1); 
  }
  return(0);
}


/*
 * update_view() Change the paticipant's Vp after some message is received
 * (actually only the leaves are being maintained) 
 */
int
  update_view(self, s, mid)
XObj           self, s;
MID            mid;
{
  register Node          **leaves;
  register Node           *parent, *n;
  register int             i, j;
  register Sstate     *ps;
  MID             mmid;
  
  P(&(((Pstate *)self->state)->tree));
  ps = (Sstate *) (s->state);	/* participant's session state */
  
  leaves = ps->view;	/* current Vp leaves */
  if ((n = (Node *) map_resolve(ps->map_tree, &mid)) == (Node *)-1) {
    /* message is not known to Ih */
    V(&(((Pstate *)self->state)->tree));
    return 0;
  }
  /* update the Vp's leave pointers */
  /* find those of the message's parents that are leaves */
  for (i = 0; i < n->num_prev; i++)  {
    /* for every one of the message's parents */
    parent = n->prev[i];
    
    for (j = 0 ; j < ps->view_leaves; j++)
      /* for every leave of Vp */
      if (parent == leaves[j])  {
	/* parent was a leaf, but not any more */
	leaves[j] = leaves[--ps->view_leaves];
	j--;  /* loop will inc, we need to check swapped guy */
      }
  }
  leaves[ps->view_leaves++] = n;
  V(&(((Pstate *)self->state)->tree));
  return ((int)n);
}


/*
 * get_sender() takes a message id and returns the message's sender's
 * PSYNC address or NULL, if message is not known in Ih 
 */
get_sender(self, s, mid)
     XObj           self, s;
     MID            mid;
{
  Node           *n;
  MID             mmid;
  Sstate     *ps;
  
  P(&(((Pstate *)self->state)->tree));
  ps = (Sstate *) (s->state);
  if ((n = (Node *) map_resolve(ps->map_tree, &mid)) == (Node *)-1) {
    V(&(((Pstate *)self->state)->tree));
    return (-1);
  }
  V(&(((Pstate *)self->state)->tree));
  return (n->sender);
}

/*
 * get_parents() takes a message id and returns 0 if the message is not
 * known in Ih, and if it is known it returns non-zero and fills in
 * parents with the message's parents. 
 */
int
  get_parents(self, s, mid, parents)
XObj           self, s;
MID             mid;
MID_ARRAY_STR  *parents;
{
  Node           *n;
  MID             mmid;
  register Sstate     *ps;
  int             i;
  
  
  P(&(((Pstate *)self->state)->tree));
  ps = (Sstate *) (s->state);
  if ((n = (Node *) map_resolve(ps->map_tree, &mid)) == (Node *)-1) {
    V(&(((Pstate *)self->state)->tree));
    return 0;
  }
  for (i = 0; i < n->num_prev; i++)
    parents->arr[i] = n->prev[i]->mid;
  parents->num_arr = i;
  V(&(((Pstate *)self->state)->tree));
  return 1;
}

/*
 * get_message() takes a message id and returns a handle to that message
 * (and increments the reference count); returns NULL if message is not
 * known to Ih 
 */
Msg
  get_message(self, s, mid)
XObj           self, s;
MID             mid;
{
  Node           *n;
  Sstate         *ps;
  Msg            r;
  
  P(&(((Pstate *)self->state)->tree));
  ps = (Sstate *) (s->state);
  if ((n = (Node *) map_resolve(ps->map_tree, &mid)) == (Node *)-1) {
    V(&(((Pstate *)self->state)->tree));
    msg_clear(r);
    return (r);
  }
  V(&(((Pstate *)self->state)->tree));
  msg_save(r, n->message);
  return (n->message);
}

/*
 * node_to_msg() takes a message node and returns a handle to the message
 * (and increments the reference count); 
 */
Msg
  node_to_msg(self, s, n)
XObj           self, s;
Node           *n;
{
  Msg             msg, r;
  
  P(&(((Pstate *)self->state)->tree));
  msg_save(r, n->message);
  V(&(((Pstate *)self->state)->tree));
  return n->message;
}

/*
 * get_mid() takes a message node and returns the message id 
 */
MID
  get_mid(self, s, n)
XObj           self, s;
Node           *n;
{
  MID             mid;
  
  P(&(((Pstate *)self->state)->tree));
  mid = n->mid;
  V(&(((Pstate *)self->state)->tree));
  return (mid);
}

MID
  get_root(self, s)
XObj self, s;
{
  Sstate *ps;
  MID m;
  
  P(&(((Pstate *)self->state)->tree));
  ps = (Sstate *)s->state;
  m = ps->root->mid;
  V(&(((Pstate *)self->state)->tree));
  return(m);
}

/*
 * prev_nodes() takes a message node and returns a pointer to the
 * message's array of parent pointers 
 */
Node          **
  prev_nodes(self, s, n)
XObj           self, s;
Node           *n;
{
  Node          **n1;
  
  P(&(((Pstate *)self->state)->tree));
  n1 = n->prev;
  V(&(((Pstate *)self->state)->tree));
  return (n1);
}

/*
 * next_nodes() takes a message node and returns a pointer to the
 * message's array of children pointers 
 */
Node          **
  next_nodes(self, s, n)
XObj           self, s;
Node           *n;
{
  Node          **n1;
  
  P(&(((Pstate *)self->state)->tree));
  n1 = n->next;
  V(&(((Pstate *)self->state)->tree));
  return (n1);
}

/*
 * get_node() takes a message and returns its message node; returns NULL,
 * if message is unknown in Ih 
 */
Node           *
  get_node(self, s, mid)
XObj           self, s;
MID             mid;
{
  Node           *n;
  Sstate     *ps;
  
  P(&(((Pstate *)self->state)->tree));
  ps = (Sstate *) (s->state);
  if ((n = (Node *) map_resolve(ps->map_tree, &mid)) == (Node *)-1) {
    V(&(((Pstate *)self->state)->tree));
    return NULL;
  }
  V(&(((Pstate *)self->state)->tree));
  return (n);
}


/*
 * get_leaves() builds an array of message ids of all the leaves in the
 * participants local view Vp. Returns the number of leaves 
 * in leaves->num_arr.
 */
void
  get_leaves(self, s, leaves)
XObj           self, s;
register  MID_ARRAY_STR   *leaves;
{
  register Node          **leaf;
  register int             i;
  register unsigned char   nl;
  
  P(&(((Pstate *)self->state)->tree));    
  leaf = ((Sstate *) (s->state))->view;
  nl   = ((Sstate *) (s->state))->view_leaves;
  for (i = 0; i < nl; i++) {
    leaves->arr[i] = leaf[i]->mid;
  }
  leaves->num_arr=nl;
  V(&(((Pstate *)self->state)->tree));
}

check_path(n1, n2)
     Node *n1, *n2;
{
  int i, qb, qe;
  Node *n, *nd[500];
  
  qb = qe = 0;
  nd[qe] = n1;
  qe++;
  while (qb != qe) {
    n = nd[qb];
    if (n == n2) return(1);
    for (i = 0; i < n->num_next; i++)
      if (!is_node_sent(nd, &qe, n->next[i])) {
        nd[qe] = n->next[i];
        qe++;
        if(qe > 300) {
          printf("Check_path : buffer exceeded\n");
        }
      }
    qb++;
  }
  return(0);
}

/*
 * start_stability_check checks the stability of node n on up, and
 * ultimately frees messages for stable nodes 
 */
start_stability_check(self, s, mid)
     XObj           self, s;
     MID             mid;
{
  register Node           *n;
  unsigned        mask;
  
  register Sstate     *ps = (Sstate *) s->state;
  register int             i;
  
  n = get_node(self, s, mid);
  P(&(((Pstate *)self->state)->tree));
  if (n != NULL) {
    /*
     * get the mask for the sender, where the mask is 2**i if sender
     * is part[i] in the converstion's participant list 
     */
    mask = (unsigned)(1 << n->sender);
    /*
     * we don't need to start our check with the current node - its
     * mask should have been initialized to indicate who sent it.
     */
    if (!((n->outstanding_stable_part_mask &= ~mask) & (~ps->required_part_mask))) {
      n->outstanding_stable_part_mask = 0;
#ifdef FREE_STABLE_MESSAGE
      free_ancestor_messages(n);
#endif FREE_STABLE_MESSAGE
      for (i = 0; i < n->num_prev; i++)
	set_stable_ancestor(n->prev[i]);
    }
    else
      for (i = 0; i < n->num_prev; i++)
	check_stability(s, n->prev[i], mask);
  } else {
    print_mid("***PANIC - start_stability_check can't get_node()!!!\n  ==> mid=",
	      mid, ", session=");
    printf("%d\n", s);
  }
  
  V(&(((Pstate *)self->state)->tree));
}


/*
 * check_stability checks stability from n on up, masking in mask (to
 * indicate the arrival of a message from a certain participant) into n's
 * outstanding_stable_part_mask 
 */

check_stability(s, n, m)
     XObj s;
     Node           *n;
     unsigned        m;
{
  register int             i;
  Sstate  *ps = (Sstate *)s->state;
  
  
  /* stop looking at ancestors if n is already stable */
  
  if (n->outstanding_stable_part_mask) {
    /* n is not yet stable */
    if (~(n->outstanding_stable_part_mask) & m)
      /* n already has a message from this sender following it
       * so, its arrival  doesn't make any difference.
       */
      return;
    if (!((n->outstanding_stable_part_mask &= ~m) & ~ps->required_part_mask)) {
      n->outstanding_stable_part_mask = 0;
#ifdef FREE_STABLE_MESSAGE
      free_ancestor_messages(n);
#endif FREE_STABLE_MESSAGE
      for (i = 0; i < n->num_prev; i++)
	set_stable_ancestor(n->prev[i]);
    }
    else {
      /*
       * even after our masking, n is still not yet stable.  We need
       * to go up to n's ancestors and mask in m to indicate the
       * arrival of a message from another participant. 
       */
      
      for (i = 0; i < n->num_prev; i++)  {
	check_stability(s, n->prev[i], m);
      }
    }
  }
}

set_stable_ancestor(n)
     Node           *n;
{
  int i;
  
  if (n->outstanding_stable_part_mask) {
    for (i = 0; i < n->num_prev; i++)
      set_stable_ancestor(n->prev[i]);
    n->outstanding_stable_part_mask = 0;
#ifdef FREE_STABLE_MESSAGE
    free_ancestor_messages(n);
#endif FREE_STABLE_MESSAGE
  }
}

free_ancestor_messages(n)
     Node           *n;
{
  int             i;
  
  msg_free(n->message);
  msg_clear(n->message);
}

/* print out id.host for mid */
void 
  print_mid(prefix, mid, suffix)
MID             mid;
char           *prefix, *suffix;
{
  int             i;
  
  if (mid.id == 0)
    return;
  
  for (i = 0; i < NUM_KNOWN_HOSTS; i++)
    if (same_PSYNChost(mid.host, known_hosts[i].host))
      break;
  printf("%s%d.%s%s", prefix, mid.id,
	 (i < NUM_KNOWN_HOSTS ? known_hosts[i].name : "???"), suffix);
}

typedef struct node_node {
  struct node_node *next;
  Node node;
} OUR_NODE;

static OUR_NODE our_node[NUM_NODES];

static OUR_NODE *ofree= &our_node[0];


Node *new_node()
{
  register OUR_NODE *node_ptr= ofree;
  register Node *n;
  
  if (ofree == NULL) {
    if ((n = (Node *) malloc(sizeof(Node))) == NULL) {
      printf("psync:new_node(): malloc failed\n");
      return (NULL);
    }
    else
      return(n);
  }
  
  else
    {
      ofree= ofree->next;
      return(&(node_ptr->node));
    }
  
}

void init_nodes()
{
  register int i;
  
  for (i=0; i<NUM_NODES; i++)
    our_node[i].next= &our_node[i+1];
  our_node[NUM_NODES-1].next=NULL;
}

#ifdef LOGGING

init_log_nodes(state)
     Sstate *state;
{
  register int i;
  
  for (i=0; i<STORE_LOG_NODES-1; i++)
    state->log.log_node[i].next = &(state->log.log_node[i+1]);
  state->log.log_node[STORE_LOG_NODES-1].next = &(state->log.log_node[0]);
}

#endif LOGGING

/*
 * psync_getproc(p, type)
 *
 */

psync_getproc(p, type)
     XObj p;
     XObjType type;
{
  if (type == Protocol) {
    p->control = psync_controlprotl;
  }
  else {
    p->control = psync_controlsessn;
  }
  p->instantiateprotl = psync_instantiateprotl;
  p->init = psync_init;
  p->close = noop;
  p->push = psync_push;
  p->pop = psync_pop;
  p->open = (Pfi)psync_open;
  p->openenable = psync_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = psync_demux;
  p->getproc = psync_getproc;
}
E 1
