h40854
s 00020/00020/00507
d D 1.2 91/01/10 11:45:21 llp 2 1
c Prepared for 3.1 Distribution
e
s 00527/00000/00000
d D 1.1 90/11/16 10:53:29 menze 1 0
c date and time created 90/11/16 10:53:29 by menze
e
u
U
f e 0
t
T
I 1
/*
 * vchan.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */


#include "xkernel.h"
#include "ip.h"
#include "chan.h"
#include "vchan.h"
#include "vchan_internal.h"


static int increase_concurrency();
static int decrease_concurrency();
static void disp_stack();

int             tracevchanp;



/* instantiateprotl -- Allocate protocol state */

vchan_instantiateprotl(self)	
    XObj            self;
{
    TRACE0(vchanp, 1, "VCHAN instantiateprotl");
    assert(x_is_protocol(self));
    
    self->state = malloc(sizeof(PSTATE));
    
    return 0;
}


/* init -- Initialize protocol state */

vchan_init(self)		
    XObj            self;
{
    XObj	ip;
    PSTATE      *pstate;
    
    TRACE0(vchanp, 1, "VCHAN init");
    assert(x_is_protocol(self));
    
    pstate = (PSTATE *) self->state;
    pstate->active_map = map_create(100, sizeof(ActiveID));
    ip = x_getprotlbyname("ip");
D 2
    x_controlprotl(ip, MYADDR, (char *)&pstate->myCHANaddr.host,
E 2
I 2
    x_controlprotl(ip, GETMYADDR, (char *)&pstate->myCHANaddr.host,
E 2
		   sizeof(IPhost));
    pstate->myCHANaddr.prot = 0;
    
    TRACE0(vchanp, 1, "VCHAN init done");
    return 0;
}


/* open -- create a vchan session (on the client side) */

XObj
vchan_open(self, hlp, p)		
    XObj            self;
    XObj            hlp;
    Part           *p;
{
    ActiveID 		key;  
    XObj 		s;
    session_stack	*sstack;
    PSTATE 		*pstate;
    SSTATE 		*sstate;
    
    TRACE0(vchanp, 3, "VCHAN open");
    assert(x_is_protocol(self));
    assert(x_is_protocol(hlp));
    
    pstate = (PSTATE *) self->state;
    
    key.client = get_part(p, 0, CHANaddr);
    key.server = get_part(p, 1, CHANaddr);
    
    /* Check for already existing session */
    s = (XObj)map_resolve(pstate->active_map, (char *) &key);
    TRACE1(vchanp, 3, "vchan_open looks for existing session, finds %x", s);
    
    if (s != ERR_XOBJ) {
	s->rcnt++;
	increase_concurrency(s, p, 1);
	return s;
    }
    
    /* session did not exist -- create new vchan session */
    TRACE0(vchanp, 3, "vchan creating new session");
    if ((s = x_createsession(hlp, self, 0)) == ERR_XOBJ) {
	TRACE0(vchanp, 1, "vchan_open could not create vchan session");
	return ERR_XOBJ;
    }
    TRACE1(vchanp, 5, "Created new vchan session %x", s);
    
    /* create state for new vchan session */
    s->state = malloc(sizeof(SSTATE));
    TRACE1(vchanp, 5, "address of vchan session state is %x", s->state);
    sstate = (SSTATE *) s->state;
    sstate->myCHANaddr = key.client;
    sstate->peerCHANaddr = key.server;
    InitSemaphore(&sstate->access, 1);
    
    /* Initialize stack of channel sessions */
    sstack = (session_stack *) malloc(sizeof(session_stack));
    sstate->ses_stack = sstack;
    sstack->s = NULL;
    sstack->size = 0;
    sstack->top = 0;
    sstack->bottom = 0;
    InitSemaphore(&sstack->available, 0);

    /* vchan masquerades as the hlp on open (by using the same participant
     * list it was given) so that chan_push puts the appropriate protocol
     * field in its header
     */
    if (increase_concurrency(s, p, 1) == -1) {
	TRACE0(vchanp, 1, "vchan_open could not open CHAN session");
	x_close(s);
	return ERR_XOBJ;
    }
    
    /* Install new session in the active map */
    TRACE0(vchanp, 5, "binding new session");
    s->binding = (Bind)map_bind(pstate->active_map, (char *) &key, s);
    if (s->binding == ERR_BIND) {
	TRACE0(vchanp, 1, "VCHAN could not bind new session");
	x_close(s);
	return ERR_XOBJ;
    }
    
    TRACE1(vchanp, 3, "VCHAN open returns %x", s);
    return s;
}


vchan_controlsessn(s, opcode, buf, len)		
    XObj            s;
    int             opcode, len;
    char           *buf;
{
    SSTATE         *sstate;
    PSTATE         *pstate;
    
    assert(x_is_session(s));
    
    sstate = (SSTATE *) s->state;
    pstate = (PSTATE *) s->myprotl->state;
    
    switch (opcode) {
	
D 2
      case VCHAN_INCREASE_CONCURRENCY:
	checkLen(len, sizeof(int) + sizeof(Part *));
	return increase_concurrency(s, *(Part **)buf,
				    *(int*)(buf + sizeof(Part *)));
	
      case VCHAN_DECREASE_CONCURRENCY:
	checkLen(len, sizeof(int));
	return decrease_concurrency(s, *(int*)buf);
	
      case MYADDR:
E 2
I 2
      case GETMYADDR:
E 2
	/* This is really a protocol control op */
	checkLen(len, sizeof(CHANaddr));
	(*(CHANaddr *)buf) = sstate->myCHANaddr;
	return sizeof(CHANaddr);
	
D 2
      case PEERADDR:
E 2
I 2
      case GETPEERADDR:
E 2
	checkLen(len, sizeof(CHANaddr));
	(*(CHANaddr *)buf) = sstate->peerCHANaddr;
	return sizeof(CHANaddr);

I 2
      case VCHAN_INCCONCURRENCY:
	checkLen(len, sizeof(int) + sizeof(Part *));
	return increase_concurrency(s, *(Part **)buf,
				    *(int*)(buf + sizeof(Part *)));
	
      case VCHAN_DECCONCURRENCY:
	checkLen(len, sizeof(int));
	return decrease_concurrency(s, *(int*)buf);
	
E 2
      default:
	x_errno = INVALID_OPCODE;
	return -1;
    }
}


vchan_controlprotl(self, opcode, buf, len)		
    XObj        self;
    int         opcode, len;
    char        *buf;
{
    PSTATE	*pstate;

    assert(x_is_protocol(self));
    pstate = (PSTATE *)self->state;
    
    switch (opcode) {
	
D 2
      case MYADDR:
E 2
I 2
      case GETMYADDR:
E 2
	checkLen(len, sizeof(IPhost));
	(*(IPhost *)buf) = pstate->myCHANaddr.host;
	break;
	
      default:
	x_errno = INVALID_OPCODE;
	return -1;
    }
    return 0;
}


/* add_session -- insert chan_s in the stack of vchan session s */

static void
add_session(s, chan_s)
    XObj	s, chan_s;
{
    SSTATE *state;
    session_stack *stack;
    
    state = (SSTATE *)s->state;	
    stack = state->ses_stack;
    
    TRACE1(vchanp, 7, "vchan adds channel session %x to map", chan_s);
    
    P(&state->access);
    assert(stack->top < stack->size);
    stack->s[stack->top++] = chan_s;
    V(&stack->available);
    V(&state->access);
}


/* get_session -- Return a channel session from the stack */

static XObj
get_session(s)
    XObj 	s;
{
    SSTATE *state;
    XObj chan_s;
    session_stack *stack;
    
    state = (SSTATE *)s->state;	
    stack = state->ses_stack;
    P(&stack->available);
    P(&state->access);
    
    assert(stack->top > 0);
    assert(stack->top > stack->bottom);
    chan_s = stack->s[--stack->top];
    
    V(&state->access);
    return chan_s;
}


/* increase_concurrency -- Increase the number of "active" channel
 * sessions in the stack by 'n'.  This may involve opening additional
 * channel sessions, for which the participant list 'p' will be used.
 */
static int
increase_concurrency(s, p, n) 
    XObj	s;
    Part	*p;
    int	n;
{
    XObj 		*new_arr;
    SSTATE 		*state;
    session_stack	*stack;
    int 		i;
    XObj		under_s;
    
    state = (SSTATE *)s->state;	
    stack = state->ses_stack;
    
    TRACE3(vchanp, 4, "VCHAN session %x increasing concurrency (%d) by %d",
	   s, stack->size - stack->bottom, n);
    
    /* If bottom > 0, we can reuse the 'trapped' channels, rather than
     * opening new ones
     */
    while (stack->bottom > 0 && n > 0) {
	TRACE0(vchanp, 5, "Freeing trapped channel");
	stack->bottom--;
	n--;
	V(&stack->available);
    }
    if (n == 0) {
	IFTRACE(vchanp, 5) {
	    disp_stack(stack);
	}
	return 0;
    }
    
    /* Create a new array of channel sessions and copy the XObj's from
     * the old array to the new array
     */
    P(&state->access);
    new_arr = (XObj *)malloc((stack->size + n) * sizeof(XObj));
    if (stack->s != NULL) {
	for (i=0; i < stack->top; i++) {
	    new_arr[i] = stack->s[i];
	}
	free(stack->s);
    }
    stack->s = new_arr;
    V(&state->access);

    /* Create and insert new channel sessions */
    TRACE0(vchanp, 7, "Opening new channel sessions");
    for (i=0; i<n; i++) {
	under_s = x_open(s->myprotl, s->myprotl->down[0], p);
	TRACE1(vchanp,7,"got channel session %x", under_s);
	if (under_s == ERR_XOBJ) {
	    TRACE0(vchanp, 1, "vchan could not open low-level session");
	    return -1;
	}
	stack->size += 1;
	add_session(s, under_s);
    }
    IFTRACE(vchanp, 5) {
	disp_stack(stack);
    }
    TRACE0(vchanp, 4, "concurrency increase completed");
    return 0;
}


/* decrease_concurrency -- reduce the number of "active" channels by n.
 * We can't really close channels, so we fake it by raising the stack
 * bottom.
 */
static int
decrease_concurrency(s, n)
    XObj	s;
    int		n;
{
    SSTATE		*state;
    session_stack	*stack;
    
    state = (SSTATE *)s->state;
    stack = state->ses_stack;
    TRACE2(vchanp, 4, "vchan: decreasing concurrency (currently %d) by %d",
	   stack->top - stack->bottom, n);
    if (n > (stack->size - stack->bottom)) {
	/* We can't decrease the concurrency by the requested value.
	 * Give the caller a chance to reconsider rather than removing
	 * all of the available channels.
	 */
	return -1;
    }
    while (n > 0) {
	P(&stack->available);
	stack->bottom++;
	n--;
    }
    IFTRACE(vchanp, 5) {
	disp_stack(stack);
    }
    return 0;
}


static void
disp_stack(s)
    session_stack	*s;
{
    int i;
    
    printf("session stack %x:  size: %d, top: %d, bottom: %d\n", s,
	   s->size, s->top, s->bottom);
    printf("sessions: ");
    for (i=0; i < s->size; i++) {
	printf("  %x", s->s[i]);
    }
    printf("\n");
}     


vchan_openenable(self, hlp, p)	
    XObj            self;
    XObj            hlp;
    Part           *p;
{
    TRACE0(vchanp, 3, "VCHAN open enable");
    assert(x_is_protocol(self));
    assert(x_is_protocol(hlp));
    
    /* openenable the protocol below me as the above protocol */
    x_openenable(hlp, self->down[0], p);
    
    return 0;
}


vchan_closesessn(s)
    XObj            s;
{
    SSTATE		*state;
    session_stack	*stack;
    int			i;
    
    assert(x_is_session(s));
    TRACE1(vchanp, 3, "VCHAN close of session %x", s);

    if (--s->rcnt > 0) {
	TRACE1(vchanp, 5, "Concurrency drops to %d, session not destroyed",
	       s->rcnt);
	decrease_concurrency(s, 1);
	return 0;
    }
    
    state = (SSTATE *)s->state;
    stack = state->ses_stack;

    /* Free all of the channel sessions in the stack */
    for (i=0; i<stack->size; i++) {
	x_close(stack->s[i]);
    }
    
    /* Free the rest of the state associated with this session */
    free((char *)stack->s);
    free((char *)stack);

    x_destroysession(s);
    return 0;
}


vchan_closeprotl(self)		
    XObj            self;
{
    PSTATE         *pstate;
    
    assert(x_is_protocol(self));
    
    if (((self->rcnt)) > 0)
      return;
    
    pstate = (PSTATE *) self->state;
    free((char *) pstate);
}



vchan_push(s, msg, rmsg_ptr)		
D 2
    XObj            s;
    MSG             msg;
    MSG            *rmsg_ptr;
E 2
I 2
    XObj        s;
    Msg		msg;
    Msg		*rmsg_ptr;
E 2
{
    XObj	down_s;
    int	result;
    
    TRACE0(vchanp, 3, "in vchan push");
    assert(x_is_session(s));
    
    down_s = get_session(s);
    result =  x_push(down_s, msg, rmsg_ptr);
    add_session(s, down_s);
    
    return result;
}



vchan_demux(self, transport_s, dg)		
    XObj            self;
    XObj            transport_s;
D 2
    MSG             dg;
E 2
I 2
    Msg             dg;
E 2
{
    assert(x_is_session(transport_s));
    assert(x_is_protocol(self));

    /* This routine should never be called.  vchan should not actively
     * exist on the server side after protocol initialization, and all
     * replies are made to client requests through the reply_message in
     * push.
     */

    TRACE0(vchanp, 0, "VCHAN demux is called!");

    return -1;
}


vchan_pop(s, ds, dg)		
    XObj            s, ds;
D 2
    MSG             dg;
E 2
I 2
    Msg             dg;
E 2
{

    TRACE1(vchanp, 3, "VCHAN pop, length = %d", msg_len(dg));

    /* This routine should never be called */

    TRACE0(vchanp, 0, "VCHAN pop is called!");

    return x_demux(s, dg);
}


vchan_getproc(p, type)	
    XObj            p;
D 2
    XobjType       type;
E 2
I 2
    XObjType       type;
E 2
{
    if (type == Protocol) {
	p->instantiateprotl = vchan_instantiateprotl;
	p->init = vchan_init;
	p->close = vchan_closeprotl;
	p->push = noop;
	p->pop = noop;
	p->control = vchan_controlprotl;
    } else {
	p->push = vchan_push;
	p->pop = vchan_pop;
	p->instantiateprotl = noop;
	p->init = noop;
	p->control = vchan_controlsessn;
	p->close = vchan_closesessn;
    }
    p->open = (Pfi) vchan_open;
    p->openenable = vchan_openenable;
    p->opendone = noop;
    p->closedone = noop;
    p->opendisable = noop;
    p->demux = vchan_demux;
    p->getproc = vchan_getproc;
}
E 1
