/* 
 * blast_internal.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#ifndef blast_internal_h
#define blast_internal_h
 
#define BLASTHLEN  sizeof(BLAST_HDR) 
#define BLASTEXTIDLEN sizeof(EXT_ID);

#define BLAST_SEND 1
#define BLAST_NACK 2
#define BLAST_RETRANSMIT 3
 
#define BLAST_OK 2
#define BLAST_FAIL 2
#define MAX_FRAGS 16
 
typedef struct  {
	unsigned int op;
	IPhost	rec;
	IPhost	send;
	unsigned int prot_id;
	unsigned int seq;
        unsigned short num_frag;
	unsigned short mask;
	unsigned int len;
} BLAST_HDR;

typedef struct {
        unsigned int seq;
	BLAST_HDR send_hdr;
	BLAST_HDR rec_hdr;
	Msg frags[MAX_FRAGS+1];
	unsigned short mask;
	unsigned short old_mask;
	unsigned int wait;
        Bind binding;

        int *state;
        int event;
        int nack_sent;
} MSG_STATE;

typedef struct {
        unsigned int prot_id;
        int client;
        BLAST_HDR short_hdr;
	BLAST_HDR cur_hdr;
        Map send_map;
        Map rec_map;
        MSG_STATE *rec_cache;
        MSG_STATE *send_cache;
  	XObj down_s;
	IPhost send;
	IPhost rec;
	BLASTaddr myBLASTaddr;
	BLASTaddr peerBLASTaddr;
	XObj self;
} BLAST_STATE;

typedef struct {
	Map active_map;
	Map passive_map;
	IPaddr myIPaddr;
	ETHaddr myETHaddr;
	int max_seq;
	Semaphore access;
	Semaphore outstanding_messages;
	int max_outstanding_messages;
} PSTATE;

typedef struct {
	IPhost send;
 	IPhost rec;
        unsigned int prot_id;
} ActiveID;

typedef BLASTaddr PassiveID;
	

#ifndef SPRITE_FLUSH
#define SPRITE_FLUSH
#define flush_msg(m) { if (!msg_isnull(m)) {msg_free(m); msg_clear(m);}}
#define flush_event(e) { if (e) {event_removeevent(e); e=0;}}
#endif

#endif
