h20210
s 00305/00349/00079
d D 1.2 91/01/10 12:11:56 llp 2 1
c Prepared for 3.1 Distribution
e
s 00428/00000/00000
d D 1.1 90/11/16 13:05:57 menze 1 0
c date and time created 90/11/16 13:05:57 by menze
e
u
U
f e 0
t
T
I 1
D 2

E 2
/* 
 * spc_srvr_chan.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2

E 2
#include "xkernel.h"
#include "ip.h"
#include "rpcTypes.h"
#include "spc.h"
#include "spc_internal.h"

D 2






E 2
/*
 * SPC_SRVR_CHAN_DEMUX
 *
 * This includes the channel open functionality for the server end.
 */
I 2

E 2
spc_srvr_chan_demux( ip_sessn, spc_msg, hdr_ptr )
D 2
XObj	ip_sessn;
MSG		spc_msg;
SPChdr*	hdr_ptr;
E 2
I 2
     XObj	ip_sessn;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2
CHAN_KEY	chan_key;
CSTATE*		cstate_ptr;


	TRACE0(spcp,4,"spc_srvr_chan_demux");

	/* debugging: drop specified messages */
	{	
		static	rcvd_msg_cnt = 0;

		/* NOTE: the rcvd_msg_cnt is different from sequence numbers */
		if( FALSE /*4 == rcvd_msg_cnt*/ ){
			TRACE1(spcp,1,"spc_srvr_chan_demux: dropping msg #%d",rcvd_msg_cnt);
			rcvd_msg_cnt++;
			drop_msg( spc_msg );
		}else{
			TRACE1(spcp,1,"spc_srvr_chan_demux: allowing msg #%d",rcvd_msg_cnt);
			rcvd_msg_cnt++;
		}
	}
			

	/* see if there is a chan state for this msg */
	chan_key.remote_host = hdr_ptr->clnt_host;
	chan_key.chan = hdr_ptr->chan;
	cstate_ptr = (CSTATE*) map_resolve( Srvr_chan_map, (char*) &chan_key );
	if( cstate_ptr != ERR_CSTATE_PTR ){
		/* there is a state for this msg's chan */
		TRACE0(spcp,4,"spc_srvr_chan_demux: chan state already exists");
		return( spc_srvr_chan_pop( cstate_ptr, spc_msg, hdr_ptr ) );
	}
	
	/* no chan state for this msg yet,
	 * but there is an implicit universal "openenable" at chan level.
	 */

	/* do a "server version" of a chan open */
	TRACE0(spcp,4,"spc_srvr_chan_demux: opening a new chan state for this msg");

	/* build an initial state for the SPC chan to be created */
	cstate_ptr = (CSTATE*) malloc( sizeof( CSTATE ) );
	cstate_ptr->call_phase = SRVR_AWAITING_REQUEST;
	cstate_ptr->remote_boot_id = hdr_ptr->boot_id;
	cstate_ptr->curr_seq_num = INITL_SRVR_SEQ_NUM;
	cstate_ptr->under_sessn = ip_sessn;
	cstate_ptr->num_sent_frags = MSG_ALREADY_FREED;

	/* save a SPC header template in the SPC chan state */
	cstate_ptr->hdr_template.flags = REPLY;						/*default*/
	cstate_ptr->hdr_template.clnt_host = hdr_ptr->clnt_host;	/*always*/
	cstate_ptr->hdr_template.srvr_host = Local_host;			/*always*/
	cstate_ptr->hdr_template.chan = hdr_ptr->chan;				/*always*/
	cstate_ptr->hdr_template.srvr_prcss = UNKNOWN_SRVR_PRCSS;	/*always*/
	/* seq_num is not initialized */
	cstate_ptr->hdr_template.num_frags = NOT_FRAGMENTED;		/*default*/
	cstate_ptr->hdr_template.frag_mask = NO_FRAG_MASK;			/*default*/
	cstate_ptr->hdr_template.srvrId = NO_SRVR_ERR;		/*default*/
	cstate_ptr->hdr_template.boot_id = Local_boot_id;			/*always*/
	/* data1_sz is not initialized */
	cstate_ptr->hdr_template.data2_sz = 0;						/*default*/
	cstate_ptr->hdr_template.data1_offset = NO_DATA_OFFSET;		/*default*/
	cstate_ptr->hdr_template.data2_offset = NO_DATA_OFFSET;		/*default*/

	/* add the channel state to the Srvr_chan_map */
	cstate_ptr->binding = 
				map_bind( Srvr_chan_map, (char*) &chan_key, (int) cstate_ptr );
	
	/* pop the msg to this new SPC chan psuedo-sessn */
	return( spc_srvr_chan_pop( cstate_ptr, spc_msg, hdr_ptr ) );

E 2
I 2
  CHAN_KEY	chan_key;
  CSTATE*	cstate_ptr;
  
  TRACE0(spcp,4,"spc_srvr_chan_demux");
  
  /* debugging: drop specified messages */
  {	
    static	rcvd_msg_cnt = 0;
    
    /* NOTE: the rcvd_msg_cnt is different from sequence numbers */
    if( FALSE /*4 == rcvd_msg_cnt*/ ){
      TRACE1(spcp,1,"spc_srvr_chan_demux: dropping msg #%d",rcvd_msg_cnt);
      rcvd_msg_cnt++;
      drop_msg( spc_msg );
    }else{
      TRACE1(spcp,1,"spc_srvr_chan_demux: allowing msg #%d",rcvd_msg_cnt);
      rcvd_msg_cnt++;
    }
  }
  
  /* see if there is a chan state for this msg */
  chan_key.remote_host = hdr_ptr->clnt_host;
  chan_key.chan = hdr_ptr->chan;
  cstate_ptr = (CSTATE*) map_resolve( Srvr_chan_map, (char*) &chan_key );
  if( cstate_ptr != ERR_CSTATE_PTR ){
    /* there is a state for this msg's chan */
    TRACE0(spcp,4,"spc_srvr_chan_demux: chan state already exists");
    return( spc_srvr_chan_pop( cstate_ptr, spc_msg, hdr_ptr ) );
  }
  
  /* no chan state for this msg yet,
   * but there is an implicit universal "openenable" at chan level.
   */
  
  /* do a "server version" of a chan open */
  TRACE0(spcp,4,"spc_srvr_chan_demux: opening a new chan state for this msg");
  
  /* build an initial state for the SPC chan to be created */
  cstate_ptr = (CSTATE*) malloc( sizeof( CSTATE ) );
  cstate_ptr->call_phase = SRVR_AWAITING_REQUEST;
  cstate_ptr->remote_boot_id = hdr_ptr->boot_id;
  cstate_ptr->curr_seq_num = INITL_SRVR_SEQ_NUM;
  cstate_ptr->under_sessn = ip_sessn;
  cstate_ptr->num_sent_frags = MSG_ALREADY_FREED;
  
  /* save a SPC header template in the SPC chan state */
  cstate_ptr->hdr_template.flags = REPLY;			/*default*/
  cstate_ptr->hdr_template.clnt_host = hdr_ptr->clnt_host;	/*always*/
  cstate_ptr->hdr_template.srvr_host = Local_host;		/*always*/
  cstate_ptr->hdr_template.chan = hdr_ptr->chan;		/*always*/
  cstate_ptr->hdr_template.srvr_prcss = UNKNOWN_SRVR_PRCSS;	/*always*/
  /* seq_num is not initialized */
  cstate_ptr->hdr_template.num_frags = NOT_FRAGMENTED;		/*default*/
  cstate_ptr->hdr_template.frag_mask = NO_FRAG_MASK;		/*default*/
  cstate_ptr->hdr_template.srvrId = NO_SRVR_ERR;		/*default*/
  cstate_ptr->hdr_template.boot_id = Local_boot_id;		/*always*/
  /* data1_sz is not initialized */
  cstate_ptr->hdr_template.data2_sz = 0;			/*default*/
  cstate_ptr->hdr_template.data1_offset = NO_DATA_OFFSET;	/*default*/
  cstate_ptr->hdr_template.data2_offset = NO_DATA_OFFSET;	/*default*/
  
  /* add the channel state to the Srvr_chan_map */
  cstate_ptr->binding = 
    map_bind( Srvr_chan_map, (char*) &chan_key, (int) cstate_ptr );
  
  /* pop the msg to this new SPC chan psuedo-sessn */
  return( spc_srvr_chan_pop( cstate_ptr, spc_msg, hdr_ptr ) );
  
E 2
} /* end spc_srvr_chan_demux */


D 2





E 2
/*
 * SPC_SRVR_CHAN_POP
 */
I 2

E 2
spc_srvr_chan_pop( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*	cstate_ptr;
MSG		spc_msg;
SPChdr*	hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2

	TRACE0(spcp,3,"spc_srvr_chan_pop: dumping hdr of incoming msg:");
	dump_hdr( hdr_ptr, 3 );

	/* if msg has an out-dated sequence num, drop it */
	/* this is also where we would check boot ids */
	if( hdr_ptr->seq_num < cstate_ptr->curr_seq_num ){
		/* seq_num is out-dated - some old sidetracked duplicate? */
		TRACE1(spcp,1,"spc_srvr_chan_pop: got old seq num %d",
													hdr_ptr->seq_num);
		msg_free( spc_msg );
		return( SUCCESS );
	}


	/* handle based on the call phase of this (server) end of the channel */
	if( cstate_ptr->call_phase == SRVR_AWAITING_REQUEST ){
		return( srvr_awaiting_request_pop( cstate_ptr, spc_msg, hdr_ptr ) );

	}else if( cstate_ptr->call_phase == SRVR_COLLECTING_FRAGS ){
		return( srvr_collecting_frags_pop( cstate_ptr, spc_msg, hdr_ptr ) );

	}else{ 	/* call_phase == SRVR_SERVICE_PROC_RUNNING */
		return( srvr_service_proc_running_pop( cstate_ptr, spc_msg, hdr_ptr ) );
	}

E 2
I 2
  TRACE0(spcp,3,"spc_srvr_chan_pop: dumping hdr of incoming msg:");
  dump_hdr( hdr_ptr, 3 );
  
  /* if msg has an out-dated sequence num, drop it */
  /* this is also where we would check boot ids */
  if( hdr_ptr->seq_num < cstate_ptr->curr_seq_num ){
    /* seq_num is out-dated - some old sidetracked duplicate? */
    TRACE1(spcp,1,"spc_srvr_chan_pop: got old seq num %d",
	   hdr_ptr->seq_num);
    msg_free( spc_msg );
    return( SUCCESS );
  }
  
  /* handle based on the call phase of this (server) end of the channel */
  if( cstate_ptr->call_phase == SRVR_AWAITING_REQUEST ){
    return( srvr_awaiting_request_pop( cstate_ptr, spc_msg, hdr_ptr ) );
    
  }else if( cstate_ptr->call_phase == SRVR_COLLECTING_FRAGS ){
    return( srvr_collecting_frags_pop( cstate_ptr, spc_msg, hdr_ptr ) );
    
  }else{ 	/* call_phase == SRVR_SERVICE_PROC_RUNNING */
    return( srvr_service_proc_running_pop( cstate_ptr, spc_msg, hdr_ptr ) );
  }
  
E 2
} /* end spc_srvr_chan_pop */


D 2





E 2
/*
 * SPC_SRVR_CHAN_PUSH
 */
I 2

E 2
spc_srvr_chan_push( cstate_ptr, higher_level_msg )
D 2
CSTATE*	cstate_ptr;
MSG		higher_level_msg;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	higher_level_msg;
E 2
{
D 2
	int i;

	TRACE0(spcp,4,"spc_srvr_chan_push");

	/* make state transition */
	cstate_ptr->call_phase = SRVR_AWAITING_REQUEST;

	if( msg_data_len( higher_level_msg ) > MAX_SPC_DATA_SZ ){
		return( chan_push_frags( cstate_ptr, higher_level_msg, NO_SRVR_ERR ) );

	}else{
		return( chan_push_whole( cstate_ptr, higher_level_msg, NO_SRVR_ERR ) );
	}

E 2
I 2
  int i;
  
  TRACE0(spcp,4,"spc_srvr_chan_push");
  
  /* make state transition */
  cstate_ptr->call_phase = SRVR_AWAITING_REQUEST;
  
  if( msg_data_len( higher_level_msg ) > MAX_SPC_DATA_SZ ){
    return( chan_push_frags( cstate_ptr, higher_level_msg, NO_SRVR_ERR ) );
    
  }else{
    return( chan_push_whole( cstate_ptr, higher_level_msg, NO_SRVR_ERR ) );
  }
  
E 2
} /* end spc_srvr_chan_push */


D 2




E 2
/*
 * REPLY_NO_SRVR
 *
 * This fills the same niche as spc_srvr_chan_push:
 * it is the reply that completes the call (as far as the server is concerned).
 */
D 2
void
reply_no_srvr( cstate_ptr)
CSTATE*		cstate_ptr;
{
MSG			reply_msg;
SPChdr*		hdr_ptr;
E 2

D 2

	TRACE0(spcp,2,"reply_no_srvr");

	/* make state transition */
	cstate_ptr->call_phase = SRVR_AWAITING_REQUEST;

	/* get a copy of the header template and fill it in */
	msg_make_allstack( reply_msg, SPC_ADDL_STK_SZ,
						(char*) &(cstate_ptr->hdr_template), sizeof( SPChdr ) );
	hdr_ptr = (SPChdr*) msg_top( reply_msg, SPC_HDR_SZ );
	hdr_ptr->srvrId = SRVR_ERR;
	hdr_ptr->seq_num = cstate_ptr->curr_seq_num;
	hdr_ptr->data1_sz = 0;

	/* the header is the whole msg; save for resend */
	msg_save( cstate_ptr->sent_frag[NON_FRAG_MSG_IX], reply_msg );
	cstate_ptr->num_sent_frags = NOT_FRAGMENTED;
	
	x_push( cstate_ptr->under_sessn, reply_msg, NULL_MSG_PTR );
	
E 2
I 2
void  reply_no_srvr( cstate_ptr)
     CSTATE*	cstate_ptr;
{
  Msg		reply_msg;
  SPChdr*	hdr_ptr;
  
  TRACE0(spcp,2,"reply_no_srvr");
  
  /* make state transition */
  cstate_ptr->call_phase = SRVR_AWAITING_REQUEST;
  
  /* get a copy of the header template and fill it in */
  msg_make_allstack( reply_msg, SPC_ADDL_STK_SZ,
		    (char*) &(cstate_ptr->hdr_template), sizeof( SPChdr ) );
  hdr_ptr = (SPChdr*) msg_top( reply_msg, SPC_HDR_SZ );
  hdr_ptr->srvrId = SRVR_ERR;
  hdr_ptr->seq_num = cstate_ptr->curr_seq_num;
  hdr_ptr->data1_sz = 0;
  
  /* the header is the whole msg; save for resend */
  msg_save( cstate_ptr->sent_frag[NON_FRAG_MSG_IX], reply_msg );
  cstate_ptr->num_sent_frags = NOT_FRAGMENTED;
  
  x_push( cstate_ptr->under_sessn, reply_msg, NULL_MSG_PTR );
  
E 2
} /* end reply_no_srvr */


D 2





E 2
/*
 * SRVR_AWAITING_REQUEST_POP
 */
I 2

E 2
srvr_awaiting_request_pop( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*	cstate_ptr;
MSG		spc_msg;
SPChdr*	hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2

	TRACE0(spcp,4,"srvr_awaiting_request_pop");

	if( hdr_ptr->seq_num > cstate_ptr-> curr_seq_num ){

		/* msg has a new sequence num, so it better be a request */
		if( !(hdr_ptr->flags & REQUEST) ){
			/* msg is not a request! */
			TRACE2(spcp,1,"srvr_awaiting_request_pop: got msg with new seq num %d, but is not a REQUEST (flags=%x)",hdr_ptr->seq_num,hdr_ptr->flags);
			drop_msg( spc_msg );
		}

		TRACE1(spcp,3,"srvr_awaiting_request_pop: got new request seq# %d",
													hdr_ptr->seq_num);
		free_sent_msg( cstate_ptr );
		cstate_ptr->curr_seq_num = hdr_ptr->seq_num;

		if( hdr_ptr->num_frags == NOT_FRAGMENTED ){

			/* client may want an ACK (i.e. server missed original request) */
			if( hdr_ptr->flags & ACK_DEMANDED ){
				send_ack( cstate_ptr );
			}

			return( rcv_request( cstate_ptr, spc_msg, hdr_ptr ) );

		}else{			/* msg is a fragment */

			/* make state transition */
			cstate_ptr->call_phase = SRVR_COLLECTING_FRAGS;
			cstate_ptr->curr_seq_num = hdr_ptr->seq_num;
			cstate_ptr->num_rcvd_frags = 0;
			cstate_ptr->rcvd_frag_mask = EMPTY_FRAG_MASK;
			cstate_ptr->curr_seq_num = hdr_ptr->seq_num;
			free_sent_msg( cstate_ptr );

			/* collect this msg, the first fragment of a request */
			/* ignore ret val because request cannot possibly be complete */
			rcv_frag( cstate_ptr, &spc_msg, &hdr_ptr );
			return( SUCCESS );
		}


	}else{		/* seq_num == curr_seq_num */

		/* evidently, client isn't done with previous call */

		if( (hdr_ptr->flags & REQUEST) &&
					( (hdr_ptr->flags & ACK_DEMANDED) ||
					  (hdr_ptr->num_frags != NOT_FRAGMENTED) ) ){

			/* Server already replied to call# seq_num, but hasn't seen
			 * any subsequent calls.  Client must not have gotten last reply
			 * (at least, not in time), so resend last reply.
			 */
			resend_msg( cstate_ptr );
			drop_msg( spc_msg );

		}else if( hdr_ptr->flags & PARTIAL_NAK ){

			/* last reply was fragmented, and not all frags were received */
			cstate_ptr->sent_frag_mask |= hdr_ptr->frag_mask;
			resend_msg( cstate_ptr );
			drop_msg( spc_msg );

		}else{

			/* no legitimate reason for this msg */
			drop_msg( spc_msg );
		}
	}

E 2
I 2
  TRACE0(spcp,4,"srvr_awaiting_request_pop");
  
  if( hdr_ptr->seq_num > cstate_ptr-> curr_seq_num ){
    
    /* msg has a new sequence num, so it better be a request */
    if( !(hdr_ptr->flags & REQUEST) ){
      /* msg is not a request! */
      TRACE2(spcp,1,"srvr_awaiting_request_pop: got msg with new seq num %d, but is not a REQUEST (flags=%x)",hdr_ptr->seq_num,hdr_ptr->flags);
      drop_msg( spc_msg );
    }
    
    TRACE1(spcp,3,"srvr_awaiting_request_pop: got new request seq# %d",
	   hdr_ptr->seq_num);
    free_sent_msg( cstate_ptr );
    cstate_ptr->curr_seq_num = hdr_ptr->seq_num;
    
    if( hdr_ptr->num_frags == NOT_FRAGMENTED ){
      
      /* client may want an ACK (i.e. server missed original request) */
      if( hdr_ptr->flags & ACK_DEMANDED ){
	send_ack( cstate_ptr );
      }
      
      return( rcv_request( cstate_ptr, spc_msg, hdr_ptr ) );
      
    }else{			/* msg is a fragment */
      
      /* make state transition */
      cstate_ptr->call_phase = SRVR_COLLECTING_FRAGS;
      cstate_ptr->curr_seq_num = hdr_ptr->seq_num;
      cstate_ptr->num_rcvd_frags = 0;
      cstate_ptr->rcvd_frag_mask = EMPTY_FRAG_MASK;
      cstate_ptr->curr_seq_num = hdr_ptr->seq_num;
      free_sent_msg( cstate_ptr );
      
      /* collect this msg, the first fragment of a request */
      /* ignore ret val because request cannot possibly be complete */
      rcv_frag( cstate_ptr, &spc_msg, &hdr_ptr );
      return( SUCCESS );
    }
    
  }else{		/* seq_num == curr_seq_num */
    
    /* evidently, client isn't done with previous call */
    
    if( (hdr_ptr->flags & REQUEST) &&
       ( (hdr_ptr->flags & ACK_DEMANDED) ||
	(hdr_ptr->num_frags != NOT_FRAGMENTED) ) ){
      
      /* Server already replied to call# seq_num, but hasn't seen
       * any subsequent calls.  Client must not have gotten last reply
       * (at least, not in time), so resend last reply.
       */
      resend_msg( cstate_ptr );
      drop_msg( spc_msg );
      
    }else if( hdr_ptr->flags & PARTIAL_NAK ){
      
      /* last reply was fragmented, and not all frags were received */
      cstate_ptr->sent_frag_mask |= hdr_ptr->frag_mask;
      resend_msg( cstate_ptr );
      drop_msg( spc_msg );
      
    }else{
      
      /* no legitimate reason for this msg */
      drop_msg( spc_msg );
    }
  }
  
E 2
} /* end srvr_awaiting_request_pop */


D 2





E 2
/*
 * SRVR_COLLECTING_FRAGS_POP
 */
I 2

E 2
srvr_collecting_frags_pop( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*	cstate_ptr;
MSG		spc_msg;
SPChdr*	hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2

	TRACE0(spcp,4,"srvr_collecting_frags_pop");

	/* verify that the msg is about the current call */
	if( hdr_ptr->seq_num != cstate_ptr->curr_seq_num ){
		/* drop this msg from the past or future */
		TRACE2(spcp,1,"srvr_collecting_frags_pop: received seq num %d while working on seq num %d",hdr_ptr->seq_num,cstate_ptr->curr_seq_num);
		drop_msg( spc_msg );
	}

	/* verify that type of msg is REQUEST */
	if( !(hdr_ptr->flags & REQUEST) ){
		/* this msg is not a request! */
		TRACE1(spcp,1,
			"spc_srvrId_running_pop: msg not a request (flags=%x)",
															hdr_ptr->flags);
		drop_msg( spc_msg );
	}

	/* verify that the msg is a fragment */
	if( hdr_ptr->num_frags == NOT_FRAGMENTED ){
		/* msg is a whole request! */
		TRACE0(spcp,1,"spc_srvrId_running_pop: msg not a fragment!");
		drop_msg( spc_msg );
	}

	/* add the fragment to those already received */
	if( rcv_frag( cstate_ptr, &spc_msg, &hdr_ptr ) == STILL_MISSING_FRAGS ){
		return( SUCCESS );

	}else{		/* that frag completed the msg */
		return( rcv_request( cstate_ptr, spc_msg, hdr_ptr ) );
	}

E 2
I 2
  
  TRACE0(spcp,4,"srvr_collecting_frags_pop");
  
  /* verify that the msg is about the current call */
  if( hdr_ptr->seq_num != cstate_ptr->curr_seq_num ){
    /* drop this msg from the past or future */
    TRACE2(spcp,1,"srvr_collecting_frags_pop: received seq num %d while working on seq num %d",hdr_ptr->seq_num,cstate_ptr->curr_seq_num);
    drop_msg( spc_msg );
  }
  
  /* verify that type of msg is REQUEST */
  if( !(hdr_ptr->flags & REQUEST) ){
    /* this msg is not a request! */
    TRACE1(spcp,1,
	   "spc_srvrId_running_pop: msg not a request (flags=%x)",
	   hdr_ptr->flags);
    drop_msg( spc_msg );
  }
  
  /* verify that the msg is a fragment */
  if( hdr_ptr->num_frags == NOT_FRAGMENTED ){
    /* msg is a whole request! */
    TRACE0(spcp,1,"spc_srvrId_running_pop: msg not a fragment!");
    drop_msg( spc_msg );
  }
  
  /* add the fragment to those already received */
  if( rcv_frag( cstate_ptr, &spc_msg, &hdr_ptr ) == STILL_MISSING_FRAGS ){
    return( SUCCESS );
    
  }else{		/* that frag completed the msg */
    return( rcv_request( cstate_ptr, spc_msg, hdr_ptr ) );
  }
  
E 2
} /* end srvr_collecting_frags_pop */


D 2





E 2
/*
 * SRVR_SERVICE_PROC_RUNNING_POP
 */
I 2

E 2
srvr_service_proc_running_pop( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*	cstate_ptr;
MSG		spc_msg;
SPChdr*	hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2


	TRACE0(spcp,4,"srvr_service_proc_running_pop");

	/* the only class of msgs that server cares about now are demands for acks
	 * (or implicit demands for naks) of the current request
	 */
	if( (hdr_ptr->seq_num == cstate_ptr->curr_seq_num) &&
					(hdr_ptr->flags & REQUEST) &&
					(hdr_ptr->flags & ACK_DEMANDED) ){

		TRACE0(spcp,3,"srvr_service_proc_running_pop: acking");
		send_ack( cstate_ptr );
	
	}else if( (hdr_ptr->seq_num == cstate_ptr->curr_seq_num) &&
					(hdr_ptr->flags & REQUEST) &&
					(hdr_ptr->num_frags != NOT_FRAGMENTED) ){

		TRACE0(spcp,3,"srvr_service_proc_running_pop: partial_nak-ing");
		send_partial_nak( cstate_ptr );
	
	}else{
		
		TRACE0(spcp,2,"srvr_service_proc_running_pop: useless msg hdr-dump ");
		dump_hdr( hdr_ptr, 2 );
	}

	drop_msg( spc_msg );

E 2
I 2
  TRACE0(spcp,4,"srvr_service_proc_running_pop");
  
  /* the only class of msgs that server cares about now are demands for acks
   * (or implicit demands for naks) of the current request
   */
  if( (hdr_ptr->seq_num == cstate_ptr->curr_seq_num) &&
     (hdr_ptr->flags & REQUEST) &&
     (hdr_ptr->flags & ACK_DEMANDED) ){
    
    TRACE0(spcp,3,"srvr_service_proc_running_pop: acking");
    send_ack( cstate_ptr );
    
  }else if( (hdr_ptr->seq_num == cstate_ptr->curr_seq_num) &&
	   (hdr_ptr->flags & REQUEST) &&
	   (hdr_ptr->num_frags != NOT_FRAGMENTED) ){
    
    TRACE0(spcp,3,"srvr_service_proc_running_pop: partial_nak-ing");
    send_partial_nak( cstate_ptr );
    
  }else{
    
    TRACE0(spcp,2,"srvr_service_proc_running_pop: useless msg hdr-dump ");
    dump_hdr( hdr_ptr, 2 );
  }
  
  drop_msg( spc_msg );
  
E 2
} /* end srvr_service_proc_running_pop */


D 2




E 2
/*
 * RCV_REQUEST
 */
I 2

E 2
rcv_request( cstate_ptr, spc_msg, hdr_ptr )
D 2
CSTATE*		cstate_ptr;
MSG			spc_msg;
SPChdr*		hdr_ptr;
E 2
I 2
     CSTATE*	cstate_ptr;
     Msg	spc_msg;
     SPChdr*	hdr_ptr;
E 2
{
D 2
SrvrId		srvrId;
MSG			spc_data;


	TRACE0(spcp,3,"rcv_request");

	/* make state transition */
	cstate_ptr->call_phase = SRVR_SERVICE_PROC_RUNNING;

	/* pass up the data */
	srvrId = hdr_ptr->srvrId;
	spc_data = msg_truncateleft( spc_msg, SPC_HDR_LEN );
	TRACE2(spcp,5,"rcv_request: msg sz = %d, spc data sz = %d",
					msg_len( spc_data ), hdr_ptr->data1_sz );
	return( spc_srvr_demux( cstate_ptr, spc_data, srvrId ) );

E 2
I 2
  SrvrId	srvrId;
  Msg		spc_data;
    
  TRACE0(spcp,3,"rcv_request");
  
  /* make state transition */
  cstate_ptr->call_phase = SRVR_SERVICE_PROC_RUNNING;
  
  /* pass up the data */
  srvrId = hdr_ptr->srvrId;
  spc_data = msg_truncateleft( spc_msg, SPC_HDR_LEN );
  TRACE2(spcp,5,"rcv_request: msg sz = %d, spc data sz = %d",
	 msg_len( spc_data ), hdr_ptr->data1_sz );
  return( spc_srvr_demux( cstate_ptr, spc_data, srvrId ) );
  
E 2
} /* end rcv_request */
E 1
