h61296
s 00002/00002/00310
d D 1.2 91/01/10 11:27:23 llp 2 1
c Prepared for 3.1 Distribution
e
s 00312/00000/00000
d D 1.1 90/12/09 00:48:25 menze 1 0
c date and time created 90/12/09 00:48:25 by menze
e
u
U
f e 0
t
T
I 1
/*
 * ethermonitor.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "xkernel.h"
#include "eth.h"
#include "ip.h"
#include "arp.h"
#include "dns.h"
#include "scr.h"

static ETHhost SERVER, CLIENT;
/*static Enet10Address eaddr; changed to mimic timeeth.c 072090 cliff */
D 2
static PROTL ETH, SCR;
E 2
I 2
static Protl ETH, SCR;
E 2

ethequal(a, b)
register ETHhost *a, *b;
{
  return a->high == a->high && a->mid == b->mid && a->low == b->low;
}

typedef struct {
  int sec, usec;
} time;

typedef struct {
  ETHhost src;
  unsigned short type;
  int x, y;
  int ocount, icount;
} Info;

#define MAXINFO ((8 * 6) - 1)
static Info info[MAXINFO];
#define maxwidth 1152
#define width  160
#define height  80
#define space 0
#define halfheight ((height - 2) / 2)
#define S(X) ((((X)+1)/2)>=halfheight ? halfheight : (((X)+1)/2))

static int curx = width + 32, cury = 0, ninfo = 0;
static short mytype = 0x98;
static int s_scr;

static unsigned totalpackets = 0;
static unsigned totallength  = 0;
static unsigned totaltime    = 0;

/*ARGSUSED*/
eventhandler(arg)
int arg;
{
  register int i, c;
  register Info *in;
  char buffer[128];
  int x[2];
  
  totaltime++;

  if (totaltime > 120 * 60) {
    sprintf(buffer, "%6d:%02d:%02d", totaltime / (120*60),
	    (totaltime % (120*60))/120, (totaltime % 120) / 2);
  } else {
    sprintf(buffer, "%9d:%02d", totaltime/120, (totaltime % 120) / 2);
  }
  x[0] = 16; x[1] = 16;
  xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
  xpush(s_scr, buffer, strlen(buffer), 0, 0);
  
  sprintf(buffer, "%12d", totalpackets);
  x[0] = 60; x[1] = 16;
  xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
  xpush(s_scr, buffer, strlen(buffer), 0, 0);
  sprintf(buffer, "%12d", totallength);
  x[0] = 104; x[1] = 16;
  xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
  xpush(s_scr, buffer, strlen(buffer), 0, 0);
  for (i = 0; i < ninfo; i++) {
    in = &info[i];
    do_blt(in->x+8, in->y, in->x, in->y, width-8, height);
    c = S(in->ocount);
    draw_box(in->x+width-8, in->y, in->x+width-1, in->y+halfheight-c, 0);
    if (c)
      draw_box(in->x+width-8, in->y+halfheight-c, in->x+width-1, in->y+halfheight, 1);

    c = S(in->icount);
    draw_box(in->x+width-8, in->y+halfheight+2, in->x+width-1, in->y+halfheight+2+halfheight-c, 0);
    if (c)
      draw_box(in->x+width-8, in->y+halfheight+2+halfheight-c, in->x+width-1, in->y+halfheight+2+halfheight, 1);

    in->ocount = in->icount = 0;
  }
}

client()
{
  int p, s;
  int clientdemux(), null();
  Part whom[3];
  ETHaddr clnt, srvr;  /* added to look like client() in timeeth.c - cliff */
  int true = 1;
  int x[2];

  s = NULL;
  p = xcreateprotl(clientdemux, null, null);
  init_partlist(whom, 0, ETHaddr);
/* replaced by line above 072090 cliff
  whom[0].address = 0;
  whom[0].length = 0;
*/
  s_scr = xopen(p, SCR, whom);

  init_partlist(whom, 2, ETHaddr);
  clnt.type = mytype;
  clnt.host = CLIENT;
  srvr.type = mytype;
  srvr.host = SERVER;
  set_part(whom, 0, clnt);
  set_part(whom, 1, srvr);

  x[0] = 40; x[1] = 32;
  xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
  xpush(s_scr, "Total packets", 13, 0, 0);

  x[0] = 84; x[1] = 32;
  xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
  xpush(s_scr, "Total  length", 13, 0, 0);

  if ((s = xopen(p, ETH, whom)) <= 0) {
    printf("Can't open the ethernet session\n");
    return;
  }
  if (xcontrolsessn(s, ETH_SETPROMISCUOUS, (char *)&true, sizeof true) != sizeof true){
    printf("Can't set promiscuous\n");
    xclose(s);
    return;
  }
  xeventregister(eventhandler, 0, 500, EV_REPEAT);
}
  
user(argc, argv)
int argc;
char **argv;
{
  ETH = xgetprotlbyname("eth");
  SCR = xgetprotlbyname("scr");

D 2
  if (xcontrolprotl(ETH, MYADDR, (char *)&SERVER, 6) != 6) {
E 2
I 2
  if (xcontrolprotl(ETH, GETMYADDR, (char *)&SERVER, 6) != 6) {
E 2
    printf("Cannot get my own enet addr\n");
    return;
  } 
  client();
}

null()
{
}

doname(addr, in)
ETHhost addr;
register Info *in;
{
  int x[2];
  char buffer[256];

  ethtoname(addr, buffer);
  if (*buffer) {
    x[0] = in->y + height + 16;
    x[1] = in->x + width / 2 - (strlen(buffer) * 8) / 2;
    xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
    xpush(s_scr, buffer, strlen(buffer), 0, 0);
#ifdef GOTOLEFT
    x[1] = 0;
    xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
#endif
  }
}

Info *findinfo(addr, type)
char *addr;
unsigned short type;
{
  register int i;
  register Info *in;
  char buffer[256], *buf;
  int x[2];

  for (i = 0; i < ninfo; i++) {
    in = &info[i];
    if (!bcmp((char *)&in->src, addr, 6)) break;
  }
  if (i >= ninfo) {
    if (i >= MAXINFO) return NULL;
    in = &info[i];
    bcopy(addr, (char *)&in->src, 6);
    in->type = type;
    in->x = curx;
    in->y = cury;
    curx += width + 32;
    if (curx >= maxwidth - width) {
      curx = 0;
      cury += height + 32 + space;
    }
    in->icount = in->ocount = 0;
    buf = buffer;
    hexprint(buf, in->src.high, 4);
    buf += 4;
    *buf++ = '.';
    hexprint(buf, in->src.mid, 4);
    buf += 4;
    *buf++ = '.';
    hexprint(buf, in->src.low, 4);
    buf += 4;
#ifdef DOTYPE
    *buf++ = ' ';
    hexprint(buf, in->type, 4);
    buf += 4;
#endif
    x[0] = in->y + height;
    x[1] = in->x + width / 2 - ((buf-buffer) * 8) / 2;
    xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
    xpush(s_scr, buffer, (buf-buffer), 0, 0);
#ifdef GOTOLEFT
    x[1] = 0;
    xcontrolprotl(SCR, SCR_GOTO, (char *)x, 8);
#endif
    xcreateprocess(doname, 5, 3, *(ETHhost *)addr, in);
    ninfo ++;
  }
  return in;
}

/*ARGSUSED*/
clientdemux(s, m, length)
int s, length;
char *m;
{
  register Info *in;
  totalpackets++;
  totallength += length;

  in = findinfo(m, *(unsigned short *)m + 12);
  if (in != NULL) 
    in->icount ++;
  in = findinfo(m+6, *(unsigned short *)m + 12);
  if (in != NULL) 
    in->ocount ++;
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}

printtime(x)
time *x;
{
  int hours, minutes, seconds, micros;
  micros = x->usec;
  seconds = x->sec;
  minutes = seconds / 60;
  seconds = seconds % 60;
  hours = minutes / 60;
  minutes = minutes % 60;
  hours -= 7;
  hours = hours % 24;
  printf("%-2d:%-2d:%-2d ", hours, minutes, seconds);
}

draw_line(x1, y1, x2, y2)
{
  long l[4];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  xcontrolprotl(SCR, SCR_LINE, (char *)l, sizeof l);
}

draw_box(x1, y1, x2, y2, on)
{
  long l[5];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  l[4] = on;
  xcontrolprotl(SCR, SCR_BLT, (char *)l, sizeof l);
}

do_blt(x1, y1, x2, y2, dx, dy)
{
  long l[6];
  l[0] = x1;
  l[1] = y1;
  l[2] = x2;
  l[3] = y2;
  l[4] = dx;
  l[5] = dy;
  xcontrolprotl(SCR, SCR_BITBLT, (char *)l, sizeof l);
}
E 1
