/*
 * blast_util.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.5 $
 * $Date: 1992/02/04 18:04:19 $
 */

#include "blast_internal.h"
 
/* converts mask to integer. 
 *  only works if single bit is turned on
 */

int
blast_mask_to_i(mask)
    u_short mask;
{
    int i;
    xTrace1(blastp, TR_FUNCTIONAL_TRACE, "mask_to_i: called mask =  %x", mask);
    
    for (i=1; i<=16; i++) {
	if (mask == 1) {
	    xTrace1(blastp, TR_DETAILED, "mask_to_i: returns i =  %d", i);
	    return i;
	}
	mask >>= 1;
    }
    xTrace0(blastp, TR_DETAILED, "mask_to_i: returns 0");
    return 0;
}
    

void
blast_mapFlush(m)
    Map m;
{
  /* should remove all entries from map but. noop for now */
}

