/*
 * process.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.16 $
 * $Date: 1992/02/05 18:23:20 $
 */

#include <lwp/lwp.h>
#include <lwp/stackdep.h>
#include <lwp/lwperror.h>

#include <varargs.h>

#include "platform.h"
#include "event.h"
#include "xk_debug.h"
#include "process.h"


int SignalsPossible = 0;

#define MAX_XK_THREADS 45
int xk_current_threads = 0;

int process_enter_monitor0();
int process_enter_monitor1();
int process_enter_monitor2();
int process_enter_monitor3();
int process_enter_monitor4();
int process_enter_monitor5();
int process_enter_monitor6();

Process *Active;


#define STACKCACHES 100

#define MAXARGS 6

mon_t master_monitor;
int total_processes = 0;

void LWP_Init()
{
  thread_t tid;

  (void) pod_setmaxpri(LWP_MAXPRIO);
  lwp_setstkcache(STACKSIZE, STACKCACHES);

  mon_create(&master_monitor);
}


void
xkernel_limit_threads0(prio, stack, r)
     short prio;
     stkalign_t *stack;
     Pfi r;
{
  thread_t tmp_thread;

  if (xk_current_threads > MAX_XK_THREADS && prio < (LWP_MAXPRIO - STD_PRIO)) {
    xTrace0(processcreation, TR_ERRORS, "0Too many threads; dying");
    return;
  }
  if (xk_current_threads > MAX_XK_THREADS)
    xTrace2(processcreation, TR_ERRORS, "0Forcing thread creation past limit %d prio %d", xk_current_threads, prio);
  if (lwp_create(&tmp_thread, process_enter_monitor0, prio, 0, 
		 stack, 1, r) == -1)
    xerror("CreateProcess0 error in lwp_create.");
  else
    xk_current_threads++;
  xTrace1(processcreation, TR_GROSS_EVENTS, "0Created thread %d", tmp_thread.thread_id);
  xTrace1(processswitch, TR_GROSS_EVENTS, "0Created thread %d", tmp_thread.thread_id);

}

void
xkernel_limit_threads1(prio, stack, r, a1)
     short prio;
     stkalign_t *stack;
     Pfi r;
     int a1;
{
  thread_t tmp_thread;

  if (xk_current_threads > MAX_XK_THREADS && prio < (LWP_MAXPRIO - STD_PRIO)) {
    xTrace0(processcreation, TR_ERRORS, "1Too many threads; dying");
    return;
  }
  if (xk_current_threads > MAX_XK_THREADS)
    xTrace2(processcreation, TR_ERRORS, "1Forcing thread creation past limit %dprio %d", xk_current_threads, prio);
  if (lwp_create(&tmp_thread, process_enter_monitor1, prio, 0, 
		 stack, 2, r, a1) == -1)
    xerror("CreateProcess1 error in lwp_create.");
  else
    xk_current_threads++;
  xTrace1(processcreation, TR_GROSS_EVENTS, "Created thread %d", tmp_thread.thread_id);
  xTrace1(processswitch, TR_GROSS_EVENTS, "Created thread %d", tmp_thread.thread_id);

}

void
xkernel_limit_threads2(prio, stack, r, a1, a2)
     short prio;
     stkalign_t *stack;
     Pfi r;
     int a1, a2;
{
  thread_t tmp_thread;

  if (xk_current_threads > MAX_XK_THREADS && prio < (LWP_MAXPRIO - STD_PRIO)) {
    xTrace0(processcreation, TR_ERRORS, "2Too many threads; dying");
    return;
  }
  if (xk_current_threads > MAX_XK_THREADS)
    xTrace2(processcreation, TR_ERRORS, "2Forcing thread creation past limit %dprio %d", xk_current_threads, prio);
  if (lwp_create(&tmp_thread, process_enter_monitor2, prio, 0, 
		 stack, 3, r, a1, a2) == -1)
    xerror("CreateProcess2 error in lwp_create.");
  else
    xk_current_threads++;
  xTrace1(processcreation, TR_GROSS_EVENTS, "2Created thread %d", tmp_thread.thread_id);
  xTrace1(processswitch, TR_GROSS_EVENTS, "2Created thread %d", tmp_thread.thread_id);

}

void
xkernel_limit_threads3(prio, stack, r, a1, a2, a3)
     short prio;
     stkalign_t *stack;
     Pfi r;
     int a1, a2, a3;
{
  thread_t tmp_thread;

  if (xk_current_threads > MAX_XK_THREADS && prio < (LWP_MAXPRIO - STD_PRIO)) {
    xTrace0(processcreation, TR_ERRORS, "3Too many threads; dying");
    return;
  }
  if (xk_current_threads > MAX_XK_THREADS)
    xTrace2(processcreation, TR_ERRORS, "3Forcing thread creation past limit %d%d", xk_current_threads, prio);
  if (lwp_create(&tmp_thread, process_enter_monitor3, prio, 0, 
		 stack, 4, r, a1, a2, a3) == -1)
    xerror("CreateProcess3 error in lwp_create.");
  else
    xk_current_threads++;
  xTrace1(processcreation, TR_GROSS_EVENTS, "3Created thread %d", tmp_thread.thread_id);
  xTrace1(processswitch, TR_GROSS_EVENTS, "3Created thread %d", tmp_thread.thread_id);

}

void
xkernel_limit_threads4(prio, stack, r, a1, a2, a3, a4)
     short prio;
     stkalign_t *stack;
     Pfi r;
     int a1, a2, a3, a4;
{
  thread_t tmp_thread;

  if (xk_current_threads > MAX_XK_THREADS && prio < (LWP_MAXPRIO - STD_PRIO)) {
    xTrace0(processcreation, TR_ERRORS, "4Too many threads; dying");
    return;
  }
  if (xk_current_threads > MAX_XK_THREADS)
    xTrace2(processcreation, TR_ERRORS, "4Forcing thread creation past limit %d %d", xk_current_threads, prio);
  xk_current_threads++;
  if (lwp_create(&tmp_thread, process_enter_monitor4, prio, 0, 
		 stack, 5, r, a1, a2, a3, a4) == -1)
    xerror("CreateProcess4 error in lwp_create.");
  xTrace1(processcreation, TR_GROSS_EVENTS, "4Created thread %d", tmp_thread.thread_id);
  xTrace1(processswitch, TR_GROSS_EVENTS, "4Created thread %d", tmp_thread.thread_id);

}

void
xkernel_limit_threads5(prio, stack, r, a1, a2, a3, a4, a5)
     short prio;
     stkalign_t *stack;
     Pfi r;
     int a1, a2, a3, a4, a5;
{
  thread_t tmp_thread;

  if (xk_current_threads > MAX_XK_THREADS && prio < (LWP_MAXPRIO - STD_PRIO)) {
    xTrace0(processcreation, TR_ERRORS, "5Too many threads; dying");
    return;
  }
  if (xk_current_threads > MAX_XK_THREADS)
    xTrace2(processcreation, TR_ERRORS, "5Forcing thread creation past limit %dprio %d", xk_current_threads, prio);
  if (lwp_create(&tmp_thread, process_enter_monitor5, prio, 0, 
		 stack, 6, r, a1, a2, a3, a4, a5) == -1)
    xerror("CreateProcess5 error in lwp_create.");
  else
    xk_current_threads++;
  xTrace1(processcreation, TR_GROSS_EVENTS, "5Created thread %d", tmp_thread.thread_id);
  xTrace1(processswitch, TR_GROSS_EVENTS, "5Created thread %d", tmp_thread.thread_id);

}

void
xkernel_limit_threads6(prio, stack, r, a1, a2, a3, a4, a5, a6)
     short prio;
     stkalign_t *stack;
     Pfi r;
     int a1, a2, a3, a4, a5, a6;
{
  thread_t tmp_thread;

  if (xk_current_threads > MAX_XK_THREADS && prio < (LWP_MAXPRIO - STD_PRIO)) {
    xTrace0(processcreation, TR_ERRORS, "6Too many threads; dying");
    return;
  }
  if (xk_current_threads > MAX_XK_THREADS)
    xTrace2(processcreation, TR_ERRORS, "6Forcing thread creation past limit %dprio %d", xk_current_threads, prio);
  if (lwp_create(&tmp_thread, process_enter_monitor6, prio, 0, 
		 stack, 7, r, a1, a2, a3, a4, a5, a6) == -1)
    xerror("CreateProcess6 error in lwp_create.");
  else
    xk_current_threads++;
  xTrace1(processcreation, TR_GROSS_EVENTS, "6Created thread %d", tmp_thread.thread_id);
  xTrace1(processswitch, TR_GROSS_EVENTS, "6Created thread %d", tmp_thread.thread_id);
}

CreateProcess0(r, prio)
     Pfi r;
     short prio;
{
  stkalign_t *stack;

  /* xkernel and LWP are switched for priorities */
  prio = LWP_MAXPRIO - prio;

  xTrace2(processcreation, TR_MAJOR_EVENTS, "Sparc CreateProcess0: r %x prio %d", r, prio);

  if ((stack = lwp_newstk()) == 0)
    Kabort("fork: Bad stack allocate.");

  xkernel_limit_threads0(prio, stack, r);
}

CreateProcess1(r, prio, arg1)
     Pfi r;
     short prio;
     int arg1;
{
  stkalign_t *stack;

  /* xkernel and LWP are switched for priorities */
  prio = LWP_MAXPRIO - prio;

  xTrace2(processcreation, TR_MAJOR_EVENTS, "Sparc CreateProcess1: r %x prio %d", r, prio);

  if ((stack = lwp_newstk()) == 0)
    Kabort("fork: Bad stack allocate.");

  xkernel_limit_threads1(prio, stack, r, arg1);
}


CreateProcess2(r, prio, a1, a2)
     Pfi r;
     short prio;
     int a1, a2;
{
  stkalign_t *stack;

  /* xkernel and LWP are switched for priorities */
  prio = LWP_MAXPRIO - prio;

  xTrace2(processcreation, TR_MAJOR_EVENTS, "Sparc CreateProcess2: r %x prio %d", r, prio);

  if ((stack = lwp_newstk()) == 0)
    Kabort("fork: Bad stack allocate.");

  xkernel_limit_threads2(prio, stack, r, a1, a2);
}


CreateProcess3(r, prio, a1, a2, a3)
     Pfi r;
     short prio;
     int a1, a2, a3;
{
  stkalign_t *stack;

  /* xkernel and LWP are switched for priorities */
  prio = LWP_MAXPRIO - prio;

  xTrace2(processcreation, TR_MAJOR_EVENTS, "Sparc CreateProcess3: r %x prio %d", r, prio);

  if ((stack = lwp_newstk()) == 0)
    Kabort("fork: Bad stack allocate.");

  xkernel_limit_threads3(prio, stack, r, a1, a2, a3);
}


CreateProcess4(r, prio, a1, a2, a3, a4)
     Pfi r;
     short prio;
     int a1, a2, a3, a4;
{
  stkalign_t *stack;

  /* xkernel and LWP are switched for priorities */
  prio = LWP_MAXPRIO - prio;

  xTrace2(processcreation, TR_MAJOR_EVENTS, "Sparc CreateProcess0: r %x prio %d", r, prio);

  if ((stack = lwp_newstk()) == 0)
    Kabort("fork: Bad stack allocate.");

  xkernel_limit_threads4(prio, stack, r, a1, a2, a3, a4);
}


CreateProcess5(r, prio, a1, a2, a3, a4, a5)
     Pfi r;
     short prio;
     int a1, a2, a3, a4, a5;
{
  stkalign_t *stack;

  /* xkernel and LWP are switched for priorities */
  prio = LWP_MAXPRIO - prio;

  xTrace2(processcreation, TR_MAJOR_EVENTS, "Sparc CreateProcess5: r %x prio %d", r, prio);

  if ((stack = lwp_newstk()) == 0)
    Kabort("fork: Bad stack allocate.");

  xkernel_limit_threads5(prio, stack, r, a1, a2, a3, a4, a5);
}


CreateProcess6(r, prio, a1, a2, a3, a4, a5, a6)
     Pfi r;
     short prio;
     int a1, a2, a3, a4, a5, a6;
{
  stkalign_t *stack;

  /* xkernel and LWP are switched for priorities */
  prio = LWP_MAXPRIO - prio;

  xTrace2(processcreation, TR_MAJOR_EVENTS, "Sparc CreateProcess6: r %x prio %d", r, prio);

  if ((stack = lwp_newstk()) == 0)
    Kabort("fork: Bad stack allocate.");

  xkernel_limit_threads6(prio, stack, r, a1, a2, a3, a4, a5, a6);
}

#undef CreateKernelProcess
#ifndef MUTS
/*VARARGS3*/
CreateKernelProcess(r, prio, nargs, a1, a2)
Pfi r;
short prio;
int nargs;
int a1, a2;
{

  CreateProcess2(r, (int) prio, a1, a2);
}
#else
/*VARARGS4*/
CreateKernelProcess(r, prio, nargs, a1, a2, a3)
Pfi r;
short prio;
int nargs;
int a1, a2, a3;
{

  CreateProcess3(r, (int) prio, a1, a2, a3);
}

#endif

Yield()
{
  Process *active = Active;

  mon_exit(master_monitor);

  if (lwp_yield(THREADNULL) < 0)
    printf("Error performing lwp_yeild in simul/process.c\n");

  mon_enter(master_monitor);
  Active = active;

}

int delay_state;
struct timeval delay_time;


void
wake_sem( sp )
    VOID **sp;
{
  semSignal((Semaphore *)sp);
}


void
Delay(n)
     int n;
{
  Semaphore s;

  semInit(&s, 0);
  /* event_register(wake_sem, &s , n, EV_ONCE); */
  evDetach( evSchedule(wake_sem, &s, n * 1000) );
  semWait(&s);
}


  

semInit(s, n)
register Semaphore *s;
unsigned n;
{
  s->count = n;
#ifdef ORIGINAL
  Q_INIT(s);
#else	/* -- Robbert van Renesse */
  if (cv_create(&s->cv, master_monitor) < 0) {
    lwp_perror("cv_create");
    xerror("realP: cv_create failed");
  }
#endif
}


realP(s)
register Semaphore *s;
{
  thread_t tmp;
  Process *active = Active;

  xTrace2(processswitch, TR_MAJOR_EVENTS, "P on %#x", s, NULL);
  
  if (s->count < 0) {
    lwp_self(&tmp);
    xTrace2(processswitch, TR_GROSS_EVENTS, "Blocking p on %#x by %d", s, tmp.thread_id);
#ifdef ORIGINAL
    Q_INSERTLAST(s, active);

    mon_exit(master_monitor);

    if (lwp_suspend(SELF) == -1)
      xerror("lwp_suspend error in realP");

    mon_enter(master_monitor);
#else	/* -- Robbert van Renesse */
    if (cv_wait(s->cv) < 0) {
	lwp_perror("cv_wait");
	xerror("realP: cv_wait failed");
    }
    xTrace2(processswitch, TR_GROSS_EVENTS, "Unblocked p on %#x by %d", s, tmp.thread_id);
#endif

    Active = active;

   }
}

realV(s)
register Semaphore *s;
{
  register Process *p;
  xTrace2(processswitch, TR_MAJOR_EVENTS, "V on %#x by %s", s, NULL);

  if (s->count <= 0) {
#ifdef ORIGINAL
    Q_REMOVEFIRST(s, p);
    if (p) {
      lwp_resume(p->lwp);
      xTrace2(processswitch, TR_GROSS_EVENTS, "Unblocking %d by V on %#x", p->lwp.thread_id, s);
    }
#else	/* -- Robbert van Renesse */
    if (cv_notify(s->cv) < 0) {
      lwp_perror("cv_notify");
      xerror("realV: cv_notify failed");
    }
#endif
  }
}

VAll(s)
register Semaphore *s;
{
  register Process *p;
  xTrace2(processswitch, TR_MAJOR_EVENTS, "VAll on %#x by %s", s, NULL);

#ifdef ORIGINAL
  while (s->count < 0) {
    Q_REMOVEFIRST(s, p);
    if (p) {
      lwp_resume(p->lwp);
    }
    s->count ++;
  }
#else	/* -- Robbert van Renesse */
  if (cv_broadcast(s->cv) < 0) {
    lwp_perror("cv_broadcast");
    xerror("VAll: cv_broadcast failed");
  }
  s->count = 0;
#endif
}

#ifndef ORIGINAL	/* -- Robbert van Renesse */

/* InitSema may, and in this case, does allocate resources.  There
 * has to be a routine to release semaphores.  This is it.
 * -- Robbert van Renesse
 */
FreeSema(s)
register Semaphore *s;
{
  if (cv_destroy(s->cv) < 0) {
    lwp_perror("cv_destroy");
    xerror("realP: cv_destroy failed");
  }
}
#endif

extern mon_t master_monitor;


process_enter_monitor0(user_fn)
     Pfi user_fn;
{
  Process *pd;

  MONITOR(master_monitor);

  if ((pd = (Process *)xMalloc(sizeof(Process))) == NULL)
    Kabort("process_enter_monitor0: no memory");

  pd->link = NULL;
  if (lwp_self(&pd->lwp) == -1)
    xerror("process_enter_monitor: Couldn't get self.");

  Active = pd;

  (user_fn)();
  Active = NULL;
  xk_current_threads--;

  xFree(pd);
}

process_enter_monitor1(user_fn, arg1)
     Pfi user_fn;
     int arg1;
{
  Process *pd;

  MONITOR(master_monitor);

  if ((pd = (Process *)xMalloc(sizeof(Process))) == NULL) 
    Kabort("process_enter_monitor1: no memory");

  pd->link = NULL;
  if (lwp_self(&pd->lwp) == -1)
    xerror("process_enter_monitor1: Couldn't get self.");

  Active = pd;
  (user_fn)(arg1);
  Active = NULL;
  xk_current_threads--;

  xFree(pd);
}

process_enter_monitor2(user_fn, arg1, arg2)
     Pfi user_fn;
     int arg1, arg2;
{
  Process *pd;

  MONITOR(master_monitor);

  if ((pd = (Process *)xMalloc(sizeof(Process))) == NULL) 
    Kabort("process_enter_monitor: no memory");

  pd->link = NULL;
  if (lwp_self(&pd->lwp) == -1)
    xerror("process_enter_monitor: Couldn't get self.");

  Active = pd;
  (user_fn)(arg1, arg2);
  Active = NULL;
  xk_current_threads--;

  xFree(pd);
}

process_enter_monitor3(user_fn, arg1, arg2, arg3)
     Pfi user_fn;
     int arg1, arg2, arg3;
{
  Process *pd;

  MONITOR(master_monitor);

  if ((pd = (Process *)xMalloc(sizeof(Process))) == NULL) 
    Kabort("process_enter_monitor: no memory");

  pd->link = NULL;
  if (lwp_self(&pd->lwp) == -1)
    xerror("process_enter_monitor: Couldn't get self.");

  Active = pd;
  (user_fn)(arg1, arg2, arg3);
  Active = NULL;
  xk_current_threads--;

  xFree(pd);
}

process_enter_monitor4(user_fn, arg1, arg2, arg3, arg4)
     Pfi user_fn;
     int arg1, arg2, arg3, arg4;
{
  Process *pd;

  MONITOR(master_monitor);

  if ((pd = (Process *)xMalloc(sizeof(Process))) == NULL) 
    Kabort("process_enter_monitor4: no memory");

  pd->link = NULL;
  if (lwp_self(&pd->lwp) == -1)
    xerror("process_enter_monitor: Couldn't get self.");

  Active = pd;
  (user_fn)(arg1, arg2, arg3, arg4);
  Active = NULL;
  xk_current_threads--;

  xFree(pd);
}

process_enter_monitor5(user_fn, a1, a2, a3, a4, a5)
     Pfi user_fn;
     int a1, a2, a3, a4, a5;
{
  Process *pd;

  MONITOR(master_monitor);

  if ((pd = (Process *)xMalloc(sizeof(Process))) == NULL) 
    Kabort("process_enter_monitor5: no memory");

  pd->link = NULL;
  if (lwp_self(&pd->lwp) == -1)
    xerror("process_enter_monitor: Couldn't get self.");

  Active = pd;
  (user_fn)(a1, a2, a3, a4, a5);
  Active = NULL;
  xk_current_threads--;

  xFree(pd);
}

process_enter_monitor6(user_fn, a1, a2, a3, a4, a5, a6)
     Pfi user_fn;
     int a1, a2, a3, a4, a5, a6;
{
  Process *pd;

  MONITOR(master_monitor);

  if ((pd = (Process *)xMalloc(sizeof(Process))) == NULL) 
    Kabort("process_enter_monitor6: no memory");

  pd->link = NULL;
  if (lwp_self(&pd->lwp) == -1)
    xerror("process_enter_monitor: Couldn't get self.");

  Active = pd;
  (user_fn)(a1, a2, a3, a4, a5, a6);
  Active = NULL;
  xk_current_threads--;

  xFree(pd);
}

/********************************
 debug code
 ********************************/

struct tname {
  int tid;
  char *name;
} tnames[20000];

int tname_idx = 0;  

char *find_thread_name(tid)
     int tid;
{
  int i;
  
  for (i=0; i<20000; i++)
    if (tnames[i].tid == tid)
      return tnames[i].name;
  return NULL;
}


show_lwp(fullp)
     int fullp;
{
  int maxsize = 50, num, i;
  thread_t vec[50];
  statvec_t state;
  extern thread_t event_thread;

  num = lwp_enumerate(vec, maxsize);

  printf("Active Threads: %d\n", num);
  if (fullp) {
    for (i=0; i<num; i++) {
      if (/* vec[i].thread_id == event_thread.thread_id */ 1) {
	printf("==>");
	printf("%d: thread_id: %d  key: %d", i, 
	       (int) vec[i].thread_id, (int) vec[i].thread_key);

	if (lwp_ping(vec[i]) == -1)
	  printf("   DEAD\n");
	else printf("\n");
	if (lwp_getstate(vec[i], &state) == -1)
	  printf("ERROR getting state on process\n");
	printf("Prio: %d, blocked on ", state.stat_prio);
	switch (state.stat_blocked.any_kind) {
	case NO_TYPE:
	  printf("No TYPE\n");
	  break;
	case CV_TYPE:
	  printf("CV TYPE %d\n", state.stat_blocked.any_object.any_cv);
	  break;
	case MON_TYPE:
	  printf("MON TYPE %d\n",state.stat_blocked.any_object.any_mon);
	  break;
	case LWP_TYPE:
	  printf("LWP TYPE %d\n",state.stat_blocked.any_object.any_thread);
	  break;
	default:
	  printf("NO state for client process\n");
	}
      }
    }
    printf("\n");
  }

}

show_mon(label)
     char *label;
{
  thread_t owner;
  thread_t vec[20];
  int n, i;

  /*
  printf("Master Monitor (%s)\n", label);
  n = mon_waiters(master_monitor, &owner, vec, 20);

  printf("N waiting on monitor: %d\n", n);
  printf("Owner: %d\n", owner.thread_id);

  printf("Blocked are: \n");
  for (i=0; i<n; i++)
    printf("%d\n", vec[i].thread_id);
    */
}

  

check_event_thread()
{
  int maxsize = 50, num, i;
  thread_t vec[50];
  statvec_t state;
  extern thread_t event_thread;

  if (lwp_ping(event_thread) == -1)
    printf("Event thread is DEAD\n");
  
  if (lwp_getstate(event_thread, &state) == -1)
    printf("ERROR getting state on process\n");

  switch (state.stat_blocked.any_kind) {
  case NO_TYPE:
    break;
  case CV_TYPE:
    printf("Blocked on CV TYPE %d\n",
	   state.stat_blocked.any_object.any_cv);
    break;
  case MON_TYPE:
    printf("Blocked on MON TYPE %d\n",
	   state.stat_blocked.any_object.any_mon);
    break;
  case LWP_TYPE:
    printf("Blocked on LWP TYPE %d\n",
	   state.stat_blocked.any_object.any_thread);
    break;
  default:
    printf("NO state for client process\n");
  }
}
