/* Copyright (c) 1989  P. A. Buhr */

/*
  Produce the fibonacci numbers in sequence on each call.
  
  No explicit states, communication with argument-parameter
  mechanism between suspend and resume
  
  Demonstrate multiple instances of the same coroutine.
  */

#include <uSystem.h>

void printf( char *, ... );

void fibonacci() {
    int fn, fn1, fn2;

    fn = 1;						/* 1st case */
    fn1 = fn;
    uSuspend(NULL, 0, &fn, sizeof(fn));
    fn = 1;						/* 2nd case */
    fn2 = fn1;
    fn1 = fn;
    uSuspend(NULL, 0, &fn, sizeof(fn));
    for (;;) {						/* general case */
        fn = fn1 + fn2;
        fn2 = fn1;
        fn1 = fn;
	uSuspend(NULL, 0, &fn, sizeof(fn));
    } /* for */
} /* fibonacci */

#define NoOfFibs 10

void uMain() {
    uCoroutine c1, c2;
    int i, fn1, fn2;

    printf("Fibonacci Numbers\n");
    c1 = uCocall(&fn1, sizeof(fn1), fibonacci);		/* two instances of fibonacci */
    c2 = uCocall(&fn2, sizeof(fn2), fibonacci);
    for (i = 1; ; i += 1) {
	printf("%d %d\n", fn1, fn2);
    if (i >= NoOfFibs) break;
        uResume(c1, &fn1, sizeof(fn1), NULL, 0);
        uResume(c2, &fn2, sizeof(fn2), NULL, 0);
    } /* for */
    printf("successful completion\n");
} /* uMain */
