/* Copyright (c) 1989  P. A. Buhr */

/*
  Play a game of cards. The game consists of each player taking a
  number of cards from a deck and passing the deck to the player on
  the left. A player must take at least one card and no more then
  a certain maximum. The player that takes the last cards is the
  winner.
  
  Use a queue of length 1 between the Sender and Receiver.
  */

#include <uSystem.h>

long random( void );

#define QueueSize 1					/* queue size for talk and listen */
#define ElemType int
#include "TalkListen.c"

int RandBetween( int low, int high ) {
    return( random( ) % ( high - low + 1 ) + low );
} /* RandBetween */

#define MinCardsTaken 1
#define MaxCardsTaken 3

int MakePlay( int RemainingCards ) {
    int passing, took;
    
    if ( RemainingCards <= MaxCardsTaken ) {
	took = RemainingCards;
	passing = 0;
    } else {
	took = RandBetween( MinCardsTaken, MaxCardsTaken ); /* random no. between MinCardsTaken & MaxCardsTaken */
	passing = RemainingCards - took;
    } /* if */
    uPrintf( "pid:%x took %d cards from %2d passing %2d to the left\n", uThisTask( ), took, RemainingCards, passing );
    return( passing );
} /* MakePlay */

void player( struct medium *left, struct medium *right, int NoOfPlayers, int NoOfCards, int starter ) {
    int RemainingCards;
    
    if ( starter ) {
	RemainingCards = MakePlay( NoOfCards );		/* make a play */
	talk( left, RemainingCards );			/* pass remaining cards to player on the left */
    } /* if */
    
    for ( ;; ) {
	RemainingCards = listen( right );
	if ( RemainingCards == 0 ) {			/* end of game ? */
	    talk( left, 0 );				/* tell player on left about the end of the game */
	    break;
	} /* exit */
	RemainingCards = MakePlay( RemainingCards );	/* make a play */
	if ( RemainingCards == 0 ) {			/* did I win ? */
	    uPrintf( "pid:%x WON\n", uThisTask( ) );
	    talk( left, 0 );				/* tell player on left about the end of the game */
	    RemainingCards = listen( right );		/* make sure all players heard */
	    uPrintf( "all players ended\n" );
	    break;
	} /* exit */
	talk( left, RemainingCards );			/* pass remaining cards to player on the left */
    } /* for */
    uDie( NULL, 0 );
} /* player */

#define MaxNoPlayers 8
#define MaxNoGames 5
#define MinNoCards 20
#define MaxNoCards 40

void uMain( ) {
    uTask players[MaxNoPlayers];
    struct medium m[MaxNoPlayers];
    int NoOfGames, NoOfPlayers, NoOfCards;
    int i;
    
    for ( NoOfGames = 1; NoOfGames <= MaxNoGames; NoOfGames += 1 ) {
	NoOfPlayers = RandBetween( 2, MaxNoPlayers );	/* random no. between 2 & MaxNoPlayers */
	uPrintf( "The number of players is:%d\n", NoOfPlayers );
	
	NoOfCards = RandBetween( MinNoCards, MaxNoCards ); /* random no. between MinNoCards & MaxNoCards */
	uPrintf( "The number of cards is:%d\n", NoOfCards );
	
	for ( i = 0; i < NoOfPlayers; i += 1 ) {
	    initmedium( &m[i] );			/* initialize communication medium */
	} /* for */
	
	for ( i = 0; i < NoOfPlayers - 1; i += 1 ) {
	    players[i] = uEmit( player, &m[i], &m[i + 1], NoOfPlayers, NoOfCards, 0 ); /* start player */
	} /* for */
	players[i] = uEmit( player, &m[NoOfPlayers - 1], &m[0], NoOfPlayers, NoOfCards, 1 );
	
	for ( i = 0; i < NoOfPlayers; i += 1 ) {
	    uAbsorb( players[i], NULL, 0 );		/* wait for completion of process */
	} /* for */
	uPrintf( "\n\n" );				/* whitespace between games */
    } /* for */
    uPrintf( "successful completion\n" );
} /* uMain */
