*** tm-encore.h	Mon Jul 30 17:14:52 1990
--- new-tm-encore.h	Mon Jul 30 17:08:54 1990
***************
*** 196,198
    else { putc ('$', FILE); output_addr_const (FILE, X); }}
  
  #define PRINT_OPERAND_ADDRESS(FILE, ADDR)  print_operand_address(FILE, ADDR)

--- 196,229 -----
    else { putc ('$', FILE); output_addr_const (FILE, X); }}
  
  #define PRINT_OPERAND_ADDRESS(FILE, ADDR)  print_operand_address(FILE, ADDR)
+ 
+     /* Change the way in which data is allocated and initialized on the
+        encore so that both private and shared data are supported.  Shared data
+        that is initialized must be contained in the ".shrdata" section
+        of the program.  This is accomplished by defining the SHARED_SECTION_ASM_OP
+        macro.  Share data that is simply allocated, and not initialized must
+        be prefixed with the ".shrcomm" or ".shrbss" pseudo op, for common or
+        local data respectively.  This is accomplished by redefining the
+        ASM_OUTPUT_COMMON and ASM_OUTPUT_LOCAL macros. */
+     
+     /* Assember pseudo-op for shared data segment. */
+ 
+ #define SHARED_SECTION_ASM_OP ".shrdata"
+ 
+     /* This says how to output an assembler line
+    to define a shared common symbol. */
+ 
+ #define ASM_OUTPUT_SHARED_COMMON(FILE, NAME, SIZE, ROUNDED) ( \
+     fputs (".shrcomm ", (FILE)), \
+     assemble_name ((FILE), (NAME)), \
+     fprintf ((FILE), ",%d\n", (ROUNDED)) \
+ )
+ 
+ /* This says how to output an assembler line
+    to define a shared local symbol. */
+ 
+ #define ASM_OUTPUT_SHARED_LOCAL(FILE, NAME, SIZE, ROUNDED) ( \
+     fputs ("\t.shrbss ", (FILE)), \
+     assemble_name ((FILE), (NAME)), \
+     fprintf ((FILE), ",%d,%d\n", (SIZE), (ROUNDED)) \
+ )
