/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * sequent-bsd43-ns32k.i -- vendor dependent locking mechanisms
 * 
 * Author           : Richard A. Stroobosscher
 * Created On       : Tue May  8 13:38:55 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:30:34 1990
 * Update Count     : 7
 */

#include <stdarg.h>

#include "configure/vd-sequent.i"
#include "configure/os-bsd43.i"
#include "configure/md-ns32k.i"

#ifdef __U_MULTI__

#define NUM_SEQ_LOCKS 256				/* must be a power of 2 */

extern char *_alm_base;					/* virtual address of mapped alms */

#endif

static inline void uCreateLocks( void ) {
} /* uCreateLocks */

static inline void uDestroyLocks( void ) {
} /* uDestroyLocks */

/*
 * The following function, uAcquireLock(), is derived from page C-7 of
 * "The Guide to Parallel Programming", 2nd. Edition, Sequent Computer Systems.
 */

static inline void uAcquireLock( uLock *mutex ) {

#ifdef __U_MULTI__

    /*
     * Use a simple hash function that uses the address of the software lock to compute the index
     * to a hardware lock.  This function assumes that the software lock is aligned on a 4-byte
     * boundary, and discards the lower 2 bites by shifting.
     */

    char *lock;

    lock = &_alm_base[ (int)(mutex) & ( (NUM_SEQ_LOCKS - 1) << 2 ) ]; /* select a hardware lock */

    for( ;; ) {
	while ( *(mutex) == U_LOCKED ) {		/* wait for lock to be available */
	    /* spin */
	} /* while */

	while ( *lock & 1 ) {				/* grab hardware lock */
	    /* spin */
	} /* while */

      if ( *(mutex) == U_UNLOCKED ) {			/* can race with others trying to get the lock */
	    *(mutex) = U_LOCKED;			/* no race, or won it, so grab the lock */
	    *lock = 0;
	    break;
	} /* exit */

	*lock = 0;					/* lost race, try again */
    } /* for */
    
#endif
    
} /* uAcquireLock */

static inline void uReleaseLock( uLock *mutex ) {

    /*
     * This function causes a task to release a lock.
     */

#ifdef __U_MULTI__

    *mutex = U_UNLOCKED;				/* release the lock */
    
#endif

} /* uReleaseLock */
