/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-i386.i -- Machine dependent uKernel code.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Mar 15 10:50:34 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:30:37 1990
 * Update Count     : 37
 */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    asm volatile ( "movl %0, %%esi" : : "g" (src) : "si" );
    asm volatile ( "movl %0, %%edi" : : "g" (dst) : "di" );
    asm volatile ( "movl %0, %%ecx" : : "g" (len) : "cx" );
    asm volatile ( "cld" );
    asm volatile ( "rep" );
    asm volatile ( "smovb" );
} /* uCopy */

static inline void *uReadStackPointer( void ) {

    void *addr;

    asm volatile ( "movl %%esp, %0" : "=g" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "movl %0, %%esp" : : "g" (addr) : "sp" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {

    void *addr;

    asm volatile ( "movl %%ebp, %0" : "=g" (addr) );
    return( addr );
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "movl %0, %%ebp" : : "g" (addr) : "bp" );
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {

    void *addr;

    asm volatile ( "movl 4(%%ebp), %0" : "=r" (addr) );
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    (*begin)();
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    stack->fp = stack->base;
    stack->sp = stack->fp - U_CEILING( len, sizeof( double ) );
    uCopy( buf, stack->sp, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */

    asm volatile ( "pushl %ebx" );
    asm volatile ( "pushl %esi" );
    asm volatile ( "pushl %edi" );
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     */

    asm volatile ( "popl %edi" );
    asm volatile ( "popl %esi" );
    asm volatile ( "popl %ebx" );
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {

    /*
     * Allocate room on the stack so that
     * the entire state of the floating point
     * system can be saved.
     */
    
    asm volatile ( "leal -108(%esp), %esp" );
    asm volatile ( "fsave (%esp)" );
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {

    /*
     * Restore the floating point system
     * and deallocate the room from the stack.
     */
    
    asm volatile ( "frstor (%esp)" );
    asm volatile ( "leal 108(%esp), %esp" );
} /* uPopFloatRegs */

static inline void uSaveContext( unsigned long* context ) {

    /*
     * must save frame pointer,
     *           stack pointer,
     *           instruction pointer,
     *           and registers which must be saved across procedure calls.
     */

    asm volatile ( "movl %%edi, %0" : "=m" (context[0]) );     /* saved regs. */
    asm volatile ( "movl %%esi, %0" : "=m" (context[1]) );
    asm volatile ( "movl %%ebx, %0" : "=m" (context[2]) );
    asm volatile ( "movl (%%ebp), %%edx" : : : "dx");	       /* old frame pointer */
    asm volatile ( "movl %%edx, %0" : "=m" (context[3]) );
    asm volatile ( "leal 4(%%ebp), %%edx" : : : "dx" );	       /* sp to restore */
    asm volatile ( "movl %%edx, %0" : "=m" (context[4]) );
    asm volatile ( "movl 4(%%ebp), %%edx" : : : "dx" );	       /* return address */
    asm volatile ( "movl %%edx, %0" : "=m" (context[5]) );
} /* uSaveContext */

static inline void uRestoreContext( unsigned long* context ) {
    /*
     * must restore frame pointer,
     *           stack pointer,
     *           and registers which must be saved across procedure calls.
     * the non-zero return value is setup, 
     * followed by a jump to the return address
     */
    asm volatile ( "cld" );
    asm volatile ( "movl %0, %%edi" : : "m" (context[0]) : "di" ); /* saved regs. */
    asm volatile ( "movl %0, %%esi" : : "m" (context[1]) : "si" );
    asm volatile ( "movl %0, %%ebx" : : "m" (context[2]) : "bx" );
    asm volatile ( "movl %0, %%ebp" : : "m" (context[3]) : "bp" ); /* old frame pointer */
    asm volatile ( "movl %0, %%esp" : : "m" (context[4]) : "sp" ); /* old stack pointer */
    asm volatile ( "addl $4, %%esp" : : : "sp" ); /* fixup stack pointer */
    asm volatile ( "movl %0, %%edx" : : "m" (context[5]) : "dx" ); /* get ret address */
    asm volatile ( "movl $1, %%eax" : : : "ax" ); /* setup result */
    asm volatile ( "jmp  *%edx" ); /* jump back */
} /* uRestoreContext */
