/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * os-bsd43.i -- BSD4.3 System Calls
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Mar 13 22:37:36 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Feb 12 15:55:13 1991
 * Update Count     : 32
 */

#define uSigMask( signal ) sigmask( signal )

static inline void uSignal( int sig, int (*func)( int, int, void * ) ) {
    signal( sig, func );
} /* uSignal */

static inline int uSigBlock( int mask ) {
    return sigblock( mask );
} /* uSigBlock */

static inline int uSigSetMask( int mask ) {
    return sigsetmask( mask );
} /* uSigSetMask */

static inline int uSigPause( int mask ) {
    return sigpause( mask );
} /* uSigPause */

static inline int uKillGroup( int group, int signal ) {
    return killpg( group, signal );
} /* uKillGroup */

static inline void uSetAlarm( long msecs ) {

    /*
     * Don't use divide as gcc can generate a library call. Dividing by 1024
     * via shifting is close enough as SIGALRM in not that accurate anyway.
     * This calculation is 100% accurate for all small values (i.e. < 10 seconds)
     */
    
    long secs;
    long usecs;
    struct itimerval it;

    secs = ( msecs + 512 ) >> 10;			/* convert the milliseconds value into seconds */
    /* secs = msecs / 1000; */				/* convert the milliseconds value into seconds */
    usecs = ( msecs % 1000 ) * 1000;			/* and micro seconds */

    it.it_value.tv_sec = secs;				/* fill in the value to the next expiry */
    it.it_value.tv_usec = usecs;
    it.it_interval.tv_sec = 0;				/* fill in the interval to reset the timer with */
    it.it_interval.tv_usec = 0;

    setitimer( ITIMER_REAL, &it, NULL );		/* set the alarm */
} /* uSetAlarm */

static inline int uInUserCode( struct sigcontext *sc ) {

    void uBeginUserCode();
    void uEndUserCode();
    
    return( ( sc->sc_pc > (int) uBeginUserCode ) && ( sc->sc_pc < (int) uEndUserCode ) );
}

static inline int uSigAlrm( int signal, int code, void *vsc ) {

    /*
     * This handler is called when SIGALRM occurs.
     * This alarm will occur as a result of time slicing
     * being enabled, a processor being woken up, or
     * a processor being terminated.
     *
     * This handler will attempt to yield the virtual
     * processor from the current task and select a new
     * task, or terminate the processor.
     */

    struct sigcontext *sc = vsc;

    uSetAlarm( uGetTimeSlice() );			/* reset the alarm for the next time slice. */

    if ( uInUserCode( sc ) ) {				/* only if executing user code */
	uSigSetMask( sc->sc_mask );			/* clear the blocked signal so that more slices may occur */
	uYield();					/* yield the processor to another task */
	sc->sc_mask = uSigBlock( 0 );			/* reset the blocked signal for handler cleanup purposes */
    } /* if */

    return 0;						/* return 0 to make the os happy */
}

static inline int uFork( void (*f)( uProcessor ), uProcessor processor ) {
    return fork();
} /* uFork */
