case $CONFIG in
'')
	if test ! -f config.sh; then
		ln ../config.sh . || \
		ln ../../config.sh . || \
		ln ../../../config.sh . || \
		(echo "Can't find config.sh."; exit 1)
	fi 2>/dev/null
	. ./config.sh
	;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting config.h (with variable substitutions)"
sed <<!GROK!THIS! >config.h -e 's!^#undef!/\*#define!'
/*
 * This file was produced by running the config_h.SH script, which
 * gets its values from config.sh, which is generally produced by
 * running Configure.
 *
 * Feel free to modify any of this as the need arises.  Note, however,
 * that running config.h.SH again will wipe out any changes you've made.
 * For a more permanent change edit config.sh and rerun config.h.SH.
 *
 * \$Id: config_h.SH,v 2.0 1993/02/21 00:01:52 jlf Exp jlf $
 */

/* Configuration time: $cf_time
 * Configured by: $cf_by
 * Target system: $myuname
 */

#ifndef _config_h_
#define _config_h_

/* HASCONST :
 *	This symbol, if defined, indicates that this C compiler knows about
 *	the const type. There is no need to actually test for that symbol
 *	within your programs. The mere use of the "const" keyword will
 *	trigger the necessary tests.
 */
#$d_const HASCONST	/**/
#ifndef HASCONST
#define const
#endif

/* CACHE_AVAIL:
 *     This symbol, if defined, indicates that Modules should cache the
 *     directories in MODULEPATH when doing an avail.
 */
#$d_cacheavail CACHE_AVAIL  /**/

/* CPPSTDIN:
 *	This symbol contains the first part of the string which will invoke
 *	the C preprocessor on the standard input and produce to standard
 *	output.	 Typical value of "cc -E" or "/lib/cpp".
 */
/* CPPMINUS:
 *	This symbol contains the second part of the string which will invoke
 *	the C preprocessor on the standard input and produce to standard
 *	output.  This symbol will have the value "-" if CPPSTDIN needs a minus
 *	to specify standard input, otherwise the value is "".
 */
#define CPPSTDIN "$cppstdin"
#define CPPMINUS "$cppminus"

/* HAS_GETHOSTNAME
 *	This symbol, if defined, indicates that the C program may use the
 *	gethostname() routine to derive the host name.  See also HAS_UNAME
 *	and PHOSTNAME.
 */
/* HAS_UNAME
 *	This symbol, if defined, indicates that the C program may use the
 *	uname() routine to derive the host name.  See also HAS_GETHOSTNAME
 *	and PHOSTNAME.
 */
/* PHOSTNAME:
 *	This symbol, if defined, indicates that the C program may use the
 *	contents of PHOSTNAME as a command to feed to the popen() routine
 *	to derive the host name.  See also HAS_GETHOSTNAME and HAS_UNAME.
 *	Note that the command uses a fully qualified path, so that it is safe
 *	even if used by a process with super-user privileges.
 */
#$d_gethname HAS_GETHOSTNAME	/**/
#$d_uname HAS_UNAME		/**/
#$d_phostname PHOSTNAME "$aphostname"	/* How to get the host name */

/* EVAL_ALIAS:
 *     This symbol, if defined, indicates that Modules should ask the sheel
 *     to evaluate aliases via stdout like other environment changes instead
 *     of opening a file and then asking the shell to source the file and
 *     then remove it.
 */
/* HAS_BOURNE_FUNCS:
 *     This symbol, if defined, indicates that Modules should ask the sheel
 *     to evaluate aliases via stdout like other environment changes instead
 *     of opening a file and then asking the shell to source the file and
 *     then remove it.
 */
#$d_evalalias EVAL_ALIAS  /**/
#$d_bournefunc HAS_BOURNE_FUNCS  /**/

#$d_forcepath      FORCE_PATH	/**/
#$d_forcepath      FORCE_PATHNAME	"$d_forcedpathname"
/* HAS_X11LIBS:
 *     This symbol, if defined, indicates that the C program can use X11
 *     directly.  See also XRDB_PROG.
 */
#$d_x11libs   HAS_X11LIBS    /**/

#endif
!GROK!THIS!
