#ifndef GDGOPHERDIR_H
#define GDGOPHERDIR_H
#include "GSgopherobj.h"

/****************************************************************
** A Gopher directory structure...
** Features dynamic growth among other things...
**
*****************************************************************/

struct g_dir_struct {
     String *Title;
     GopherObj **Gophers;
     
     int Top;
     int maxsize;
};

typedef struct g_dir_struct GopherDirObj;
typedef struct g_dir_struct *GopherDirObjp;

#define GDgetEntry(a,b)    (((a)->Gophers[b]))
#define GDgetTop(a)        ((a)->Top)
#define GDsetTop(a,b)      ((a)->Top=b)
#define GDgetTitle(a)      (STRget((a)->Title))
#define GDsetTitle(a,b)    (STRset((a)->Title,b))
#define GDgetNumitems(a)   ((a)->Top)

/*** Real live functions declared in GDgopherdir.c ***/

GopherDirObj *GDnew();
void         GDdestroy();
void         GDinit();
void         GDaddGS();
void         GDsort();
void         GDtoNet();
void         GDtoNetHTML();
int          GDfromNet();
void         GDgrow();
void         GDfromLink();
void         GDtoLink();
#endif /* GDGOPHERDIR_H */
